package com.icetech.park.service.report.p2r.impl;

import com.icetech.common.utils.JsonUtils;
import com.icetech.common.validator.Validator;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.request.p2r.TicketGotRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.park.service.report.p2r.IRobotEventService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service("p2rTicketGotServiceImpl")
@Slf4j
public class TicketGotServiceImpl implements IRobotEventService {


    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        TicketGotRequest ticketGotRequest = JsonUtils.convert2bean(p2rBaseRequest.getBizContent(), TicketGotRequest.class);

        //参数校验
        if (!Validator.validate(ticketGotRequest)){
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.缺失参数.getCode());
        }
        String orderNum = ticketGotRequest.getOrderNum();
        log.info("<小票领取成功上报> 订单号：{}", orderNum);
        return P2rBaseResponse.success(p2rBaseRequest);

    }
}
