package com.icetech.park.service.report.p2r.impl;

import java.math.BigDecimal;
import java.util.Date;

import com.icetech.park.service.report.p2r.IRobotEventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.RecCashRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.down.p2r.impl.PrintInfoServiceImpl;
import com.icetech.park.handle.CacheHandle;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.MoneyTool;
import com.icetech.common.validator.Validator;
import com.icetech.paycenter.api.IRedpackService;
import com.icetech.paycenter.domain.request.RedpackPreSendRequest;

import lombok.extern.slf4j.Slf4j;

@Service("p2rRecCashServiceImpl")
@Slf4j
public class RecCashServiceImpl implements IRobotEventService {

    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private IRedpackService redpackService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private PrintInfoServiceImpl printInfoService;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        RecCashRequest recCashRequest = JsonUtils.convert2bean(p2rBaseRequest.getBizContent(), RecCashRequest.class);

        //参数校验
        if (!Validator.validate(recCashRequest)){
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.缺失参数.getCode());
        }

        String orderNum = recCashRequest.getOrderNum();
        ObjectResponse<OrderInfo> orderInfoObjectResponse = orderService.findByOrderNum(orderNum);
        if (!ObjectResponse.isSuccess(orderInfoObjectResponse)){
            log.warn("<机器人现金上报> 无效的订单号，订单号：{}", orderNum);
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.非法参数.getCode(), "订单号不存在");
        }
        OrderInfo orderInfo = orderInfoObjectResponse.getData();
        OrderPay orderPay = new OrderPay();
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(PayStatusConstants.PAID);
        orderPay.setParkId(tokenDeviceVo.getParkId());

        QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode());
        if (channelFee == null){
            log.warn("<机器人现金上报> 通道费用已经清空，设备信息：{}", tokenDeviceVo);
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.请求重复.getCode(), "未查询到待缴费");
        }
        float discountPrice = Float.parseFloat(channelFee.getDiscountPrice());
        float unpayPrice = Float.parseFloat(channelFee.getUnpayPrice());
        orderPay.setDiscountPrice(channelFee.getDiscountPrice());
        orderPay.setPaidPrice(channelFee.getUnpayPrice());
        //机器人支付
        orderPay.setPayChannel(8);
        orderPay.setPayTerminal(tokenDeviceVo.getDeviceNo());
        orderPay.setPayTime(channelFee.getQueryTime());
        orderPay.setOrderTime(channelFee.getQueryTime());
        //现金
        orderPay.setPayWay(1);
        float totalPrice = discountPrice + unpayPrice;
        String tradeNo = CodeTools.GenerateTradeNo();
        /*
         * 需要找零时
         */
        float totalCashAmount = Float.parseFloat(recCashRequest.getTotalCashAmount());
        if (unpayPrice < totalCashAmount){
            /*
             * 发放红包
             */
            BigDecimal redpackRet = new BigDecimal(totalCashAmount).subtract(new BigDecimal(unpayPrice)).setScale(2, BigDecimal.ROUND_HALF_DOWN);
            log.info("<机器人现金上报> 订单号：{} 需要找零：{} 元", recCashRequest.getOrderNum(), redpackRet);
            orderPay.setActualCash(recCashRequest.getTotalCashAmount());
            orderPay.setRedpackRet(String.valueOf(redpackRet));
            RedpackPreSendRequest preSendRequest = new RedpackPreSendRequest();
            preSendRequest.setParkCode(tokenDeviceVo.getParkCode());
            preSendRequest.setAmount(Integer.parseInt(MoneyTool.fromYuanToFen(redpackRet.toString())));
            ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(tokenDeviceVo.getParkId());
            ParkConfig parkConfig = parkConfigObjectResponse.getData();
            preSendRequest.setRedpackModel(parkConfig.getRedpackModel());
            preSendRequest.setTradeNo(tradeNo);
            log.info("<机器人现金上报> 请求预发送红包参数：{}", preSendRequest);
            ObjectResponse objectResponse = redpackService.preSendRedpack(preSendRequest);
            log.info("<机器人现金上报> 请求预发送红包响应：{}", objectResponse);
            if (ObjectResponse.isSuccess(objectResponse)){
                String preId = (String)objectResponse.getData();
                ObjectResponse objectResponse1 = printInfoService.downRedpack(tokenDeviceVo.getParkCode(), preId, tokenDeviceVo.getParkId(), tokenDeviceVo.getDeviceNo(), orderNum);
                if (!ObjectResponse.isSuccess(objectResponse1)){
                    log.error("<机器人现金上报> 红包打印下发失败，preId：{}", preId);
                }
            }else{
                log.error("<机器人现金上报> 红包预发放失败，参数：{}，返回：{}", preSendRequest, objectResponse);
            }
        }
        orderPay.setTotalPrice(String.valueOf(totalPrice));
        orderPay.setTradeNo(tradeNo);
        orderPay.setIsSync(1);
        ObjectResponse objectResponse = orderPayService.addOrderPay(orderPay);
        if (ObjectResponse.isSuccess(objectResponse)){
            /*
             * 允许离场
             */
            DataExitRequest exitRequest = new DataExitRequest();
            exitRequest.setOrderNum(recCashRequest.getOrderNum());
            exitRequest.setParkCode(tokenDeviceVo.getParkCode());
            exitRequest.setType(orderInfo.getType());
            exitRequest.setEnterTime(new Date(orderInfo.getEnterTime() * 1000));
            CarExitRequest exit = cacheHandle.getExit(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode());
            exitRequest.setExitTime(exit == null ? new Date() : new Date(exit.getExitTime() * 1000));
            exitRequest.setAisleCode(tokenDeviceVo.getInandoutCode());
            exitRequest.setPlateNum(orderInfo.getPlateNum());
            ObjectResponse<Void> objectResponse1 = manageService.allowExit(exitRequest);
            log.info("<机器人现金上报> 平台操作离场, 参数[{}], 结果[{}]", exitRequest, objectResponse1);
            return P2rBaseResponse.success(p2rBaseRequest);
        }else{
            return P2rBaseResponse.instance(p2rBaseRequest, Integer.parseInt(objectResponse.getCode()));
        }

    }

}
