package com.icetech.park.service.report.p2r.impl;


import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.PayCodeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.common.constants.PayChannelConstants;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.constants.PayWayContants;
import com.icetech.paycenter.domain.PlatformPayType;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.MoneyTool;
import com.icetech.common.validator.Validator;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.normalpay.request.UnifiedOrderRequest;
import com.icetech.paycenter.domain.normalpay.response.UnifiedOrderResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("p2rPayCodeServiceImpl")
@Slf4j
public class PayCodeServiceImpl implements IRobotEventService {

    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private IPayCenterService payCenterService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private OrderService orderService;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        PayCodeRequest payCodeRequest = JsonUtils.convert2bean(p2rBaseRequest.getBizContent(), PayCodeRequest.class);

        //参数校验
        if (!Validator.validate(payCodeRequest)){
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.缺失参数.getCode());
        }
        QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode());
        if (channelFee == null){
            log.warn("<机器人付款码上报> 通道费用已经清空，设备信息：{}", tokenDeviceVo);
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.请求重复.getCode(), "未查询到待缴费");
        }

        String payCode = payCodeRequest.getPayCode();
        String orderNum = payCodeRequest.getOrderNum();

        ObjectResponse<OrderInfo> orderInfoObjectResponse = orderService.findByOrderNum(orderNum);
        if (!ObjectResponse.isSuccess(orderInfoObjectResponse)){
            log.warn("<机器人付款码上报> 无效的订单号，订单号：{}", orderNum);
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.非法参数.getCode(), "订单号不存在");
        }
        OrderInfo orderInfo = orderInfoObjectResponse.getData();

        UnifiedOrderRequest unifiedOrderRequest = new UnifiedOrderRequest();
        int payWay = getWxAliPayCode(payCode);
        //获取车场支持的类型
        ObjectResponse<String> response= parkService.selectGroupPayType(tokenDeviceVo.getParkCode());
        if (ObjectResponse.isSuccess(response) && StringUtils.isNotBlank(response.getData())){
            unifiedOrderRequest.setSelectTradeType(PlatformPayType.getTradeTypeScan(response.getData(),payWay));
        }
        String tradeNo = CodeTools.GenerateTradeNo();
        unifiedOrderRequest.setTradeNo(tradeNo);
        unifiedOrderRequest.setParkCode(tokenDeviceVo.getParkCode());
        unifiedOrderRequest.setPrice(MoneyTool.fromYuanToFen(channelFee.getUnpayPrice()));
        unifiedOrderRequest.setPayCode(payCode);
        unifiedOrderRequest.setParkId(tokenDeviceVo.getParkId());

        String parkName = null;
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(orderInfo.getParkId());
        if (ObjectResponse.isSuccess(parkObjectResponse)) {
            parkName = parkObjectResponse.getData().getParkName();
        }
        String productInfo = unifiedOrderRequest.genProductInfo(parkName, orderInfo.getPlateNum(), "停车费");
        unifiedOrderRequest.setProductInfo(productInfo);
        ObjectResponse<UnifiedOrderResponse> unifiedOrderResponseObjectResponse = payCenterService.doUnifiedOrder(unifiedOrderRequest);
        if (ObjectResponse.isSuccess(unifiedOrderResponseObjectResponse)){
            OrderPay orderPay = new OrderPay();
            orderPay.setOrderNum(orderNum);
            orderPay.setPayStatus(PayStatusConstants.PAID);
            orderPay.setParkId(tokenDeviceVo.getParkId());

            float discountPrice = Float.parseFloat(channelFee.getDiscountPrice());
            float unpayPrice = Float.parseFloat(channelFee.getUnpayPrice());
            orderPay.setDiscountPrice(channelFee.getDiscountPrice());
            orderPay.setPaidPrice(channelFee.getUnpayPrice());
            //机器人支付
            orderPay.setPayChannel(PayChannelConstants.ROBOT);
            orderPay.setPayTerminal(tokenDeviceVo.getDeviceNo());
            orderPay.setPayTime(channelFee.getQueryTime());
            orderPay.setOrderTime(channelFee.getQueryTime());
            orderPay.setPayWay(payWay);
            float totalPrice = discountPrice + unpayPrice;
            orderPay.setTotalPrice(String.valueOf(totalPrice));
            orderPay.setTradeNo(tradeNo);
            orderPay.setIsSync(1);
            orderPay.setPayAisle(PlatformPayType.getPayAisle(response.getData(),payWay));
            orderPayService.addOrderPay(orderPay);
            /*
             * 允许离场
             */
            DataExitRequest exitRequest = new DataExitRequest();
            exitRequest.setOrderNum(orderNum);
            exitRequest.setParkCode(tokenDeviceVo.getParkCode());
            exitRequest.setType(orderInfo.getType());
            exitRequest.setEnterTime(new Date(orderInfo.getEnterTime() * 1000));
            CarExitRequest exit = cacheHandle.getExit(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode());
            exitRequest.setExitTime(exit == null ? new Date() : new Date(exit.getExitTime() * 1000));
            exitRequest.setAisleCode(tokenDeviceVo.getInandoutCode());
            exitRequest.setPlateNum(orderInfo.getPlateNum());
            ObjectResponse<Void> objectResponse1 = manageService.allowExit(exitRequest);
            log.info("<机器人现金上报> 平台操作离场, 参数[{}], 结果[{}]", exitRequest, objectResponse1);
            return P2rBaseResponse.success(p2rBaseRequest);
        }else{
            return P2rBaseResponse.instance(p2rBaseRequest, Integer.parseInt(unifiedOrderResponseObjectResponse.getCode()), unifiedOrderResponseObjectResponse.getMsg());
        }

    }

    /**
     * 根据付款码获取是微信还是支付宝
     * @param payCode
     * @return
     */
    private static int getWxAliPayCode(String payCode) {
        if (payCode.length() == 18 && (
                payCode.startsWith("10") || payCode.startsWith("11") || payCode.startsWith("12") || payCode.startsWith("13")
                        || payCode.startsWith("14") || payCode.startsWith("15")
        )) {
            return PayWayContants.WECHAT;
        } else {
            return PayWayContants.ALIPAY;
        }
    }

}
