package com.icetech.park.service.report.p2r.impl;

import java.util.concurrent.ThreadPoolExecutor;

import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.HeartbeatRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.response.p2r.HeartbeatResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.validator.Validator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2rHeartbeatServiceImpl")
@Slf4j
public class HeartbeatServiceImpl extends AbstractService implements IRobotEventService {
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        HeartbeatRequest heartbeatRequest = JsonUtils.convert2bean(p2rBaseRequest.getBizContent(), HeartbeatRequest.class);
        //参数校验
        if (!Validator.validate(heartbeatRequest)){
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.缺失参数.getCode());
        }
        //更新心跳时间
        redisUtils.hPut(RedisConstants.P2R_HEARTBEAT_TIME, tokenDeviceVo.getDeviceNo(),
                DateTools.unixTimestamp());
        asyncHandle(tokenDeviceVo);
        // 返回结果
        HeartbeatResponse heartbeatResponse = new HeartbeatResponse();
        heartbeatResponse.setCloudTime(String.valueOf(System.currentTimeMillis()));
        return P2rBaseResponse.success(p2rBaseRequest, heartbeatResponse);
    }

    private void asyncHandle(TokenDeviceVo tokenDeviceVo) {
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            //刷新token有效期
            cacheHandle.expireRobotDeviceInfo(tokenDeviceVo.getDeviceNo());
            cacheHandle.setChannelRobot(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode(),
                    tokenDeviceVo.getDeviceNo());
        }));
    }
}
