package com.icetech.park.service.report.p2r.impl;

import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.*;
import com.icetech.common.validator.Validator;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.fee.dao.CashRefundDao;
import com.icetech.fee.domain.entity.CashRefund;
import com.icetech.cloudcenter.domain.request.p2r.ErrorMsgRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.basics.utils.DataConvertTools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

@Service("p2rErrorMsgServiceImpl")
@Slf4j
public class ErrorMsgServiceImpl implements IRobotEventService {

    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CashRefundDao cashRefundDao;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        ErrorMsgRequest errorMsgRequest = JsonUtils.convert2bean(p2rBaseRequest.getBizContent(), ErrorMsgRequest.class);

        //参数校验
        if (!Validator.validate(errorMsgRequest)){
            return P2rBaseResponse.instance(p2rBaseRequest, CodeEnum.缺失参数.getCode());
        }
        String errorCode = errorMsgRequest.getErrorCode();
        String errorMsg = RobotErrorCode.getErrorMsg(errorCode);
        ParkDevice parkDevice = new ParkDevice();
        parkDevice.setParkId(tokenDeviceVo.getParkId());
        parkDevice.setSerialNumber(tokenDeviceVo.getDeviceNo());
        ParkDevice parkDevice1 = parkDeviceDao.selectByParam(parkDevice);

        ObjectResponse objectResponse = parkDeviceService.modifyStatus(tokenDeviceVo.getParkId(), parkDevice1.getDeviceNo(),3,
                errorMsg == null ? "" : (errorMsgRequest.getErrorMsg() == null ? errorMsg : errorMsg + "," + errorMsgRequest.getErrorMsg()), DateTools.unixTimestamp());
        ObjectResponse.notError(objectResponse);

        if (errorCode.equals(RobotErrorCode.R900201.name()) || errorCode.equals(RobotErrorCode.R900202.name()) || errorCode.equals(RobotErrorCode.R900203.name())){
            String cashDetails = errorMsgRequest.getCashDetails();
            if (StringUtils.isNotBlank(cashDetails)){
                Map<String, String> keyValMap = DataConvertTools.convert2Map(cashDetails);
                String totalCashAmount = keyValMap.get("totalCashAmount");
                if (StringUtils.isNotBlank(totalCashAmount) && Double.parseDouble(totalCashAmount) > 0){//实收现金大于0时
                    CashRefund cashRefund = new CashRefund();
                    cashRefund.setParkId(tokenDeviceVo.getParkId());
                    cashRefund.setInandoutName(tokenDeviceVo.getInandoutName());
                    String orderNum = keyValMap.get("orderNum");
                    cashRefund.setOrderNum(orderNum);
                    ObjectResponse<OrderInfo> orderInfoObjectResponse = orderService.findByOrderNum(orderNum);
                    if (ObjectResponse.isSuccess(orderInfoObjectResponse)){
                        OrderInfo orderInfo = orderInfoObjectResponse.getData();
                        cashRefund.setPlateNum(orderInfo.getPlateNum());
                    }

                    cashRefund.setDeviceNo(parkDevice1.getDeviceNo());
                    cashRefund.setActualCash(new BigDecimal(keyValMap.get("totalCashAmount")));
                    cashRefund.setReceiveTime(new Date());
                    cashRefundDao.insert(cashRefund);
                }
            }
        }
        return P2rBaseResponse.success(p2rBaseRequest);

    }
    public enum RobotErrorCode {
        R900201("当前收费信息界面还没有支付成功，就接收到新的支付信息指令，界面展示新的支付信息"),
        R900101("打印机未连接"),
        R900104("打印机切刀未复位"),
        R900105("打印机过热"),
        R900107("打印机纸尽"),
        R900108("打印机纸将尽"),
        R900202("钱箱有收入现金，用户通过其他途径支付成功"),
        R900203("钱箱有收入现金，用户超时未支付"),
        R900241("钞箱满"),
        R900242("钞箱移除"),
        R900243("纸币识别器过钞通道堵塞错误"),
        R900245("恶意入钞"),
        R900246("钱箱设备通讯断开"),
        R90024750("压钞马达故障"),
        R90024751("码盘传感器故障"),
        R90024752("传输马达故障"),
        R90024753("纸币居中马达故障"),
        R90024755("光学传感器故障"),
        R90024756("磁性传感器故障"),
        R90024795("电容传感器故障"),
        ;

        private String errorMsg;

        RobotErrorCode(String errorMsg){
            this.errorMsg = errorMsg;
        }

        public static String getErrorMsg(String errorCode){
            for (RobotErrorCode codeEnum : RobotErrorCode.values()) {
                if (errorCode.equals(codeEnum.name())){
                    return codeEnum.errorMsg;
                }
            }
            return "";
        }
    }
}
