package com.icetech.park.service.report.p2r.impl;

import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.AuthDeviceRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.response.p2r.AuthDeviceResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.common.validator.Validator;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("p2rAuthDeviceServiceImpl")
@Slf4j
public class AuthDeviceServiceImpl implements IRobotEventService {

    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private CacheHandle cacheHandle;
    @Value("${web.url}")
    private String webUrl;

    private static final String KEY = "7c5977ae21302d02fd846f6a02f2dc34";

    public P2rBaseResponse executeEvent(String args, String serialNumber) {
        AuthDeviceRequest authDeviceRequest = JsonUtils.parseObject(args, AuthDeviceRequest.class);
        //返回参数封装
        P2rBaseResponse p2rBaseResponse = new P2rBaseResponse();
        p2rBaseResponse.setMessageId(authDeviceRequest.getMessageId());
        if (!Validator.validate(authDeviceRequest)){
            p2rBaseResponse.setCode(CodeEnum.缺失参数.getCode());
            p2rBaseResponse.setMsg(CodeEnum.缺失参数.getMsg());
            return p2rBaseResponse;
        }

        boolean verifySign = SignTools.verifyMD5Sign(authDeviceRequest, KEY);
        if (!verifySign){
            p2rBaseResponse.setCode(CodeEnum.认证失败.getCode());
            p2rBaseResponse.setMsg(CodeEnum.认证失败.getMsg());
            return p2rBaseResponse;
        }
        String parkCode = authDeviceRequest.getParkCode();
        String channelCode = authDeviceRequest.getChannelCode();

        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess(parkObjectResponse)){
            log.info("[端云机器人授权] parkCode：{}未添加，不允许连接", parkCode);
            p2rBaseResponse.setCode(CodeEnum.非法参数.getCode());
            p2rBaseResponse.setMsg(CodeEnum.非法参数.getMsg());
            return p2rBaseResponse;
        }
        Park park = parkObjectResponse.getData();

        ObjectResponse<ParkInoutdevice> parkInoutdeviceObjectResponse = parkService.getInOutDeviceByCode(park.getId(), channelCode);
        if (!ObjectResponse.isSuccess(parkInoutdeviceObjectResponse)){
            log.info("[端云机器人授权] parkCode：{}，channelCode：{}未添加，不允许连接", parkCode, channelCode);
            p2rBaseResponse.setCode(CodeEnum.非法参数.getCode());
            p2rBaseResponse.setMsg(CodeEnum.非法参数.getMsg());
            return p2rBaseResponse;
        }
        ParkInoutdevice inoutDevice = parkInoutdeviceObjectResponse.getData();
        ObjectResponse<List<ParkDevice>> parkDeviceObjectResponse =
                parkDeviceService.getDeviceByChannel(park.getId(), channelCode, 5);
        if (ObjectResponse.isSuccess(parkDeviceObjectResponse)){
            List<ParkDevice> parkDevices = parkDeviceObjectResponse.getData();
            ParkDevice parkDevice = parkDevices.get(0);
            if (StringUtils.isNotBlank(parkDevice.getSerialNumber())
                    && !parkDevice.getSerialNumber().equals(authDeviceRequest.getDeviceMac())){
                log.warn("[端云机器人授权] 当前通道已经存在机器人：{}", parkDevice);
                p2rBaseResponse.setCode(CodeEnum.非法参数.getCode());
                p2rBaseResponse.setMsg("当前通道已有机器人，不能重复授权");
                return p2rBaseResponse;
            }else if (StringUtils.isBlank(parkDevice.getSerialNumber())){
                //当前设备第一次请求授权，并且已添加机器人，则更新信息
                parkDevice.setSerialNumber(authDeviceRequest.getDeviceMac());
                parkDevice.setIp(authDeviceRequest.getDeviceIp());
                parkDevice.setEndUpdatetime(new Date());
                parkDeviceService.updateDevice(parkDevice);
            }
        }else{
            //当前通道没有添加机器人，添加机器人
            ParkDevice parkDevice = new ParkDevice();
            parkDevice.setParkId(park.getId());
            parkDevice.setSerialNumber(authDeviceRequest.getDeviceMac());
            parkDevice.setChannelId(inoutDevice.getId().intValue());
            parkDevice.setDeviceNo("D" + System.currentTimeMillis() + RandomUtils.nextInt(10, 100));
            parkDevice.setIp(authDeviceRequest.getDeviceIp());
            parkDevice.setType(5);
            parkDevice.setStatus(1);
            parkDevice.setAdder("system");
            parkDevice.setDelFlag(0);
            parkDevice.setEndUpdatetime(new Date());
            parkDeviceService.addDevice(parkDevice);
        }
        //授权设备
        AuthDeviceResponse authDeviceResponse = authDevice(serialNumber, authDeviceRequest, parkCode, park, inoutDevice);
        //响应
        p2rBaseResponse.setCode(CodeEnum.成功.getCode());
        p2rBaseResponse.setMsg(CodeEnum.成功.getMsg());
        p2rBaseResponse.setData(authDeviceResponse);
        p2rBaseResponse.setToken(authDeviceResponse.getToken());
        return p2rBaseResponse;
    }

    /**
     * 授权设备
     * @param serialNumber
     * @param authDeviceRequest
     * @param parkCode
     * @param park
     * @param inoutDevice
     * @return
     */
    private AuthDeviceResponse authDevice(String serialNumber, AuthDeviceRequest authDeviceRequest,
                                          String parkCode, Park park, ParkInoutdevice inoutDevice) {
        String token = null;
        TokenDeviceVo robotDeviceInfo = cacheHandle.getRobotDeviceInfo(serialNumber);
        if (robotDeviceInfo != null) {
            token = robotDeviceInfo.getToken();
        }
        token = StringUtils.isBlank(token) ? UUIDTools.getUuid() : token;

        Integer inandoutType = inoutDevice.getInandoutType();
        ParkConnectedDeviceVo parkConnectedDeviceVo = new ParkConnectedDeviceVo();
        parkConnectedDeviceVo.setDeviceNo(serialNumber);
        parkConnectedDeviceVo.setInandoutCode(inoutDevice.getInandoutCode());
        parkConnectedDeviceVo.setInandoutType(inandoutType);
        parkConnectedDeviceVo.setId(inoutDevice.getId());
        //更新已连接设备列表
        cacheHandle.addParkRobotConnectList(parkCode, parkConnectedDeviceVo);

        TokenDeviceVo tdv = new TokenDeviceVo();
        //车场属性
        tdv.setParkId(park.getId());
        tdv.setParkCode(parkCode);
        //设备属性
        tdv.setDeviceNo(serialNumber);
        tdv.setVersion(authDeviceRequest.getVersion());
        //通道数据
        tdv.setId(inoutDevice.getId());
        tdv.setInandoutName(inoutDevice.getInandoutName());
        tdv.setInandoutCode(inoutDevice.getInandoutCode());
        tdv.setInandoutType(inoutDevice.getInandoutType());
        tdv.setToken(token);
        //存放token对应的相机信息
        cacheHandle.setRobotDeviceInfo(serialNumber, tdv);
        cacheHandle.setChannelRobot(parkCode, inoutDevice.getInandoutCode(), serialNumber);

        AuthDeviceResponse authDeviceResponse = new AuthDeviceResponse();
        authDeviceResponse.setToken(token);
        authDeviceResponse.setCloudTime(String.valueOf(System.currentTimeMillis()));
        authDeviceResponse.setEnexType(inandoutType);
        authDeviceResponse.setHeadMsg("微信扫码电子红包找零");
        authDeviceResponse.setBottomMsg("提示：找零红包请在24小时内领取");
        authDeviceResponse.setRedpackUrlPrefix(webUrl + "/redpack/robot-send");
        return authDeviceResponse;
    }

    /**
     * 不需要实现此方法
     */
    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        return null;
    }
}
