package com.icetech.park.service.report.p2c.impl.exit;

import com.icetech.park.domain.entity.park.ExitIdentify;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author wanggang
 * @create 2024-03-22 15:33
 */
@Component
@Slf4j
public class ExitIdentifyHandler {

    @Autowired
    private MqPushService mqPushService;

    public void exitIdentify(ExitIdentify exitIdentify) {
        log.info("[端云]离场识别发送的请求参数[{}]", JsonUtils.toJson(exitIdentify));
        mqPushService.pushExitIdentify(exitIdentify);
    }
}
