package com.icetech.park.service.report.p2c.impl.exit;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.constants.MorRedisKeyConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.p2c.impl.OfflineRecordServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.flow.p2c.impl.CarExitFlowProcessImpl;
import com.icetech.park.service.report.ReportParamHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

@Component
@Slf4j
public class CarExitHandler extends CarExitBaseHandler{
    @Autowired
    private CarExitFlowProcessImpl carExitFlowProcess;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OfflineRecordServiceImpl offlineRecordService;
    @Autowired
    private RabbitSender rabbitSender;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    //时间与相机比较的偏移量
    private static final Long OFFSET = 10L;
    //触发脱机记录上报的锁
    private static final String OFFLINE_RECORDS_PREFIX = "offline:record:";
    @Value("${custom.repeatEx.enable:false}")
    private boolean customRepeatExEnable;
    @Value("${custom.repeatEx.parkCodes:P}")
    private String customRepeatExParkCodes;
    @Value("${custom.repeatEx.showDevice:1}")
    private Integer customRepeatExShowDevice;

    public P2cBaseResponse<CarEnexResponse> execute(TokenDeviceVo deviceToken,
                                                    P2cBaseRequest<CarExitRequest> baseRequest) {
        CarExitRequest exitRequest = baseRequest.getBizContent();
        String parkCode = exitRequest.getParkCode();
        String inandoutCode = exitRequest.getInandoutCode();
        String deviceNo = deviceToken.getDeviceNo();
        Long parkId = exitRequest.getParkId();

        Long exitTime = exitRequest.getExitTime();
        long now = DateTools.unixTimestamp();
        if (now + OFFSET < exitTime) {
            log.warn("alarmType[{}],keyword1[{}],keyword2[SN:{}, 上报离场时间:{}]",
                    "端云相机时间不同步", parkCode, deviceNo, exitTime);
            exitRequest.setExitTime(now);
        }

        CarEnexResponse carEnexResponse = new CarEnexResponse();
        boolean softTriggerFlag = TriggerTypeEnum.软触发.getVal().equals(exitRequest.getTriggerType());
        if (softTriggerFlag) {
            redisUtils.releaseLock(SoftTriggerServiceImpl.LOCK_KEY + deviceNo);
            String plateNum = exitRequest.getPlateNum();
            if (DataCommonConstants.isNoPlate(plateNum)) {
                return softTrigger(baseRequest, exitRequest, carEnexResponse, parkCode, inandoutCode);
            } else {
                //软触发抓拍到车牌时，先不返回，按正常业务处理
                softTrigger(baseRequest, exitRequest, carEnexResponse, parkCode, inandoutCode);
            }
        }

        //虚假车牌
        if (Integer.valueOf(0).equals(exitRequest.getShamFlag())) {
            ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(parkId);
            ParkConfig parkConfig = parkConfigObjectResponse.getData();
            Integer enableShamPlate = parkConfig.getEnableShamPlate();
            if (Integer.valueOf(1).equals(enableShamPlate)) {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                setCustomShowSay(parkId, exitRequest, carEnexResponse, null, FlowCondition.ResultCode.虚假车牌);

                dealShamPlate(deviceToken, exitRequest, parkCode, inandoutCode, parkId);
                return P2cBaseResponse.success(baseRequest, carEnexResponse);
            }
        }
        //处理上次上报但未正常离场的订单
        lastExitHandle(exitRequest, parkCode, inandoutCode);

        ReportParamHolder paramHolder = new ReportParamHolder(exitRequest.getParkId(), exitRequest.getParkCode(),
                exitRequest.getInandoutCode(), deviceToken.getDeviceNo(), deviceToken.getVersion(),
                exitRequest.getPlateNum(), 2, exitRequest.getOrderNum());
        String plateNum = exitRequest.getPlateNum();
        OrderInfo orderInfo = null;
        if (!DataCommonConstants.isNoPlate(plateNum)){
            //判断车辆是否在场内
            ObjectResponse<OrderInfo> inPark = orderService.findInPark(plateNum, parkCode);
            if (inPark != null && inPark.getCode().equals(CodeConstants.SUCCESS)) {
                orderInfo = inPark.getData();
                //以最新的在场记录的订单号为准
                exitRequest.setOrderNum(orderInfo.getOrderNum());
                setType(deviceToken.getRegionId(), exitRequest, orderInfo);
                paramHolder.setOrderNum(orderInfo.getOrderNum());
            }else{
                // 按模糊规则查询场内车辆
                inPark = orderService.fuzzyPlate(parkId, inandoutCode, plateNum);
                if (inPark != null && inPark.getCode().equals(CodeConstants.SUCCESS)) {
                    orderInfo = inPark.getData();
                    log.info("[端云-离场接口]离场车牌[{}], 模糊匹配到车牌[{}]", plateNum, orderInfo.getPlateNum());
                    //以最新的在场记录的订单号为准
                    exitRequest.setOrderNum(orderInfo.getOrderNum());
                    plateNum = orderInfo.getPlateNum();
                    exitRequest.setPlateNum(plateNum);
                    exitRequest.setFuzzyOrder(true);
                    setType(deviceToken.getRegionId(), exitRequest, orderInfo);
                    paramHolder.setOrderNum(orderInfo.getOrderNum());
                }
            }
        }
        // 如果是脱机数据或者已经开闸
        if (exitRequest.getProperty() == 2 || FlowCondition.YES.equals(exitRequest.getOpenFlag())) {
            Park parkInfo = paramHolder.getParkInfo();
            //场中场脱机记录缓存
            if (exitRequest.getProperty() == 2 && Integer.valueOf(1).equals(parkInfo.getIsInterior())) {
                //缓存记录
                cacheHandle.cacheExitRecords(parkCode, plateNum, exitRequest);
                if (redisUtils.tryLock(OFFLINE_RECORDS_PREFIX + parkCode + "_" + plateNum, parkCode, 4000L)) {
                    //主动触发相机上报该车牌的脱机记录上报
                    offlineRecordService.send(parkId, parkCode, plateNum);
                    //延迟消息处理
                    rabbitSender.sendMessage(MqConstants.Exchange.OFFLINE_RECORDS_DELAYED_EXCHANGE,
                            MqConstants.Routing.OFFLINE_RECORDS_ROUTING, parkCode + "_" + plateNum,
                            20000L);
                }
                return P2cBaseResponse.success(baseRequest, carEnexResponse);
            }
            // 有在场记录时，正常离场；没有在场记录时，保存订单记录和支付记录
            if(orderInfo == null){
                String orderNum = replenishEnter(exitRequest);
                carEnexResponse.setOrderNum(orderNum);
                exitRequest.setOrderNum(orderNum);
                paramHolder.setOrderNum(orderNum);
                //保存交易记录
                dealOfflinePay(exitRequest, orderNum);
            }else{
                //保存交易记录
                dealOfflinePay(exitRequest, orderInfo.getOrderNum());
            }
            if (exitRequest.getProperty() == 1 && FlowCondition.YES.equals(exitRequest.getOpenFlag())){
                //同步屏显语音
                otherDeviceSync(exitRequest, parkCode, inandoutCode, parkId, paramHolder, orderInfo == null ? null : orderInfo.getEnterTime());
            }
            //如果是VIP，需要计算VIP优惠
            if (PlateTypeEnum.VIP车辆.getType().equals(exitRequest.getType()) && orderInfo != null) {
                FlowCondition.FlowRet flowRet = new FlowCondition.FlowRet();
                Map<String, Object> paramMap = new HashMap<>();

                carExitFlowProcess.queryFeeHandle(orderInfo, exitTime, flowRet, paramMap, parkCode, inandoutCode, paramHolder.getParkConfig());
                if (FlowCondition.ResultCode.需缴费.equals(flowRet.getResultCode())) {
                    log.warn("相机已开闸但实际需支付, 参数[{}]", paramMap);
                } else {
                    QueryOrderFeeResponse orderFee = (QueryOrderFeeResponse) paramMap.get("orderFee");
                    if (orderFee != null){
                        double unpayPrice = NumberUtils.toDouble(orderFee.getUnpayPrice());
                        double discountPrice = NumberUtils.toDouble(orderFee.getDiscountPrice());
                        if (unpayPrice + discountPrice > 0){
                            saveDiscountPay(exitRequest.getInandoutName(), inandoutCode, orderFee, unpayPrice, discountPrice);
                        }
                    }
                }
            }
            //离场处理
            return normalExit(baseRequest, paramHolder, carEnexResponse);
        }
        //查询无入场记录的车牌和当前上报的车牌，如果一致，则表示无入场记录的车牌二次识别，仍然按无入场的流程走
        if (orderInfo != null && Integer.valueOf(1).equals(orderInfo.getNoneEnterFlag())) {
            log.info("[端云-离场接口] 疑似无入场记录的车牌二次识别，手动校正orderInfo实体为空，车牌号：{}", plateNum);
            orderInfo = null;
        }
        long parkTime = 0;
        if (orderInfo != null) {
            CarExitRequest cacheExit = cacheHandle.getExit(parkCode, inandoutCode);
            //如果上次识别了车牌，则更新为上次识别时间
            if (cacheExit != null && orderInfo.getOrderNum().equals(cacheExit.getOrderNum())){
                log.info("[端云-离场接口] 连续识别使用上次识别时间, plateNum[{}], lastTime[{}]", plateNum, cacheExit.getExitTime());
                exitRequest.setExitTime(cacheExit.getExitTime());
            }
            parkTime = exitRequest.getExitTime() - orderInfo.getEnterTime();
        }
        if (customRepeatExEnable && customRepeatExParkCodes.contains(parkCode)) {
            if (orderInfo == null) {
                log.info("[定制功能-重复离场] {}", exitRequest);
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                carEnexResponse.setShow(exitRequest.getPlateNum() + "/此车已离场/请勿重复离场/请等待人工确认");
                carEnexResponse.setSay("此车已离场 请勿重复离场");
                carEnexResponse.setShowDeviceType(customRepeatExShowDevice);
                return P2cBaseResponse.success(baseRequest, carEnexResponse);
            }
        }
        try {
            FlowCondition.FlowRet flowRet = carExitFlowProcess.flowHandle(orderInfo, exitRequest, paramHolder);
            return notOpenedFlowHandle(baseRequest, paramHolder, flowRet, parkTime);
        } catch (ResponseBodyException re) {
            log.warn("[端云-离场接口]业务异常, 车牌号[{}]", plateNum, re);
            if (re.getMessage().contains("未配置默认计费规则")) {
                carEnexResponse.setOpenFlag(1);
                carEnexResponse.setOrderNum(orderInfo != null ? orderInfo.getOrderNum() : null);
                setCustomShowSay(parkId, exitRequest, carEnexResponse, null, FlowCondition.ResultCode.无需缴费);
                return normalExit(baseRequest, paramHolder, carEnexResponse);
            }
            return P2cBaseResponse.instance(baseRequest, Integer.parseInt(re.getErrCode()), re.getMessage());
        } catch (Exception e) {
            log.error("[端云-离场接口]服务异常, 车牌号[{}]", plateNum, e);
            return P2cBaseResponse.instance(baseRequest, CodeEnum.服务器异常.getCode());
        }
    }

    private void setType(Long currRegionId, CarExitRequest exitRequest, OrderInfo orderInfo) {
        exitRequest.setType(orderInfo.getType());
        //兼容场中场
        if (orderInfo.getRegionId() != null && !orderInfo.getRegionId().equals(currRegionId)) {
            if (Integer.valueOf(1).equals(orderInfo.getHasSon())) {
                OrderSonInfo orderSonInfo = new OrderSonInfo();
                orderSonInfo.setParkId(exitRequest.getParkId());
                orderSonInfo.setOrderNum(orderInfo.getOrderNum());
                orderSonInfo.setRegionId(currRegionId);
                OrderSonInfo sonInfo = orderSonInfoDao.selectOneByEntity(orderSonInfo);
                if (sonInfo != null) {
                    exitRequest.setType(sonInfo.getType());
                }
            }
        }
    }

    private void lastExitHandle(CarExitRequest exitRequest, String parkCode, String channelCode) {
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            //如果有缓存，则表明上次离场车辆没有正常出场，需要对其异常离场操作
            CarExitRequest cacheExit = cacheHandle.getExit(parkCode, channelCode);
            if (cacheExit != null && !DataCommonConstants.isNoPlate(exitRequest.getPlateNum())
                    && !cacheExit.getPlateNum().equals(exitRequest.getPlateNum())) {
                QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(parkCode, channelCode);
                if (channelFee != null) {
                    cacheExit.setTotalAmount(channelFee.getTotalAmount());
                    cacheExit.setPaidAmount(channelFee.getPaidAmount());
                    cacheExit.setDiscountAmount(channelFee.getDiscountAmount());
                }
                OrderBack orderBack = redisUtils.get(MorRedisKeyConstants.BACK_TAG + cacheExit.getOrderNum(), OrderBack.class);
                if (orderBack != null) {
                    if (Math.abs(cacheExit.getOriginalExitTime() - orderBack.getExitTime()) < 5) {
                        log.info("[端云-离场接口] 当前订单已折返回场，不按欠费[{}]", cacheExit);
                        return;
                    }
                }
                ObjectResponse<Map<String, Object>> response =
                        carOrderExitService.exceptionExit(cacheExit, OrderOddStatusEnum.非正常出场.getVal());
                log.info("[端云-离场接口]上次非正常出场车牌处理, 车牌号[{}], 响应[{}]", cacheExit.getPlateNum(), response);
            }
        }));
    }

    private void otherDeviceSync(CarExitRequest exitRequest, String parkCode, String channelCode,
                                 Long parkId, ReportParamHolder paramHolder, Long enterTime) {
        String robotSn = cacheHandle.getChannelRobot(parkCode, channelCode);
        String itcSn = itcCacheHandle.getSerialNumber(parkCode, channelCode);
        if (robotSn == null && itcSn == null){
            return;
        }
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            //机器人屏显语音下发
            ParkInoutdevice channel = paramHolder.getParkChannel();
            ObjectResponse<PlateTypeDto> plateTypeDtoObjectResponse =
                    orderService.getPlateType(parkId, exitRequest.getPlateNum(), channel.getRegionId());
            PlateTypeDto plateTypeDto = plateTypeDtoObjectResponse.getData();
            exitRequest.setType(plateTypeDto.getPlateTypeEnum().getType());
            FlowCondition.ResultCode resultCode;
            if (plateTypeDto.getPlateTypeEnum().equals(PlateTypeEnum.月卡车)) {
                resultCode = FlowCondition.ResultCode.月卡车;
            } else {
                resultCode = FlowCondition.ResultCode.无需缴费;
            }
            Map<String, Object> para = new HashMap<>();
            para.put("regionId", channel.getRegionId());
            para.put("orderNum", exitRequest.getOrderNum());
            if (enterTime != null) {
                para.put("parkTime", exitRequest.getExitTime() - enterTime);
            }
            String show = null;
            String say = null;
            if (robotSn != null) {
                show = commonShowHandle.exit(parkId, channel.getId(), exitRequest.getPlateNum(),
                        exitRequest.getType(), resultCode, para);
                say = commonSayHandle.exit(parkId, channel.getId(), exitRequest.getPlateNum(),
                        exitRequest.getType(), resultCode, para);
            }
            downOtherDeviceHint(exitRequest, show, say, para, resultCode);
        }));
    }
}
