package com.icetech.park.service.report.p2c.impl.exit;

import com.alibaba.fastjson.TypeReference;
import com.github.pagehelper.util.StringUtil;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.constants.RobotConstants;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.ShamPlate;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.ShamPlateService;
import com.icetech.order.service.OrderTagsService;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.domain.entity.park.ExitIdentify;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.park.mongo.document.ExitRecord;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.ShowTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.request.p2r.ShowPayInfoRequest;
import com.icetech.cloudcenter.domain.response.QueryNotPayResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChannelRulesServiceImpl;
import com.icetech.park.service.down.p2c.impl.FreeSpaceServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.down.p2r.impl.HintServiceImpl;
import com.icetech.park.service.down.p2r.impl.ShowPayInfoServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedSayHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.handle.showsay.ShowSayConstants;
import com.icetech.park.service.order.impl.exit.CarOrderExitServiceImpl;
import com.icetech.park.service.record.ExitRecordService;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.park.service.report.pnc.impl.PncAutopayServiceImpl;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.partner.api.request.ThirdAutoPayRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;

import static com.icetech.park.service.flow.p2c.FlowCondition.ResultCode.*;

/**
 * @author kate
 */
@Component
@RefreshScope
@Slf4j
public class CarExitBaseHandler {
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected CarOrderEnterService carOrderEnterService;
    @Autowired
    protected OrderPayService orderPayService;
    @Autowired
    protected CarOrderExitServiceImpl carOrderExitService;
    @Autowired
    protected HintServiceImpl robotHintService;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected ChannelRulesServiceImpl channelRulesService;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected com.icetech.park.service.down.p2c.impl.HintServiceImpl hintService;
    @Autowired
    protected FreeSpaceServiceImpl freeSpaceService;
    @Autowired
    protected PncAutopayServiceImpl autopayService;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected ShowPayInfoServiceImpl showPayInfoService;
    @Value("${web.url}")
    private String webUrl;
    @Value("${datacenter.exitPayUrl}")
    private String exitPayUrl;
    @Autowired
    protected CommonShowHandle commonShowHandle;
    @Autowired
    protected CommonSayHandle commonSayHandle;
    @Resource
    private ExitRecordService exitRecordService;
    @Autowired
    protected ThirdInfoService thirdInfoService;
    @Autowired
    protected LedShowHandle ledShowHandle;
    @Autowired
    protected ItcCacheHandle itcCacheHandle;
    @Autowired
    protected ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    protected ItcHintServiceImpl itcHintService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private SoftTriggerServiceImpl softTriggerService;
    @Autowired
    private ShamPlateService shamPlateService;
    @Autowired
    private OrderTagsService orderTagsService;
    @Resource
    private RabbitSender rabbitSender;
    @Value("${aisle.exceptionExit.time:600}")
    private Integer aisleExceptionExitTime;

    @Autowired
    private ExitIdentifyHandler exitIdentifyHandler;

    /**
     * 出场软触发处理逻辑
     * @param exitRequest 离场参数
     * @param carEnexResponse 处理结果
     * @param parkCode 车场编号
     * @param inandoutCode 通道编号
     * @return 处理结果
     */
    protected P2cBaseResponse<CarEnexResponse> softTrigger(P2cBaseRequest<CarExitRequest> baseRequest, CarExitRequest exitRequest, CarEnexResponse carEnexResponse, String parkCode, String inandoutCode) {
        String triggerNo = exitRequest.getTriggerNo();
        cacheHandle.setSoftImage(triggerNo, exitRequest.getMaxImage());
        if (exitRequest.getOpenFlag().equals(FlowCondition.YES)){
            cacheHandle.removeExit(parkCode, inandoutCode);
        }
        String orderNum = CodeTools.GenerateOrderNum();
        log.info("[端云-出场事件] 软触发接口返回，triggerNo：{}，响应的orderNum为：{}", triggerNo, orderNum);
        carEnexResponse.setOrderNum(orderNum);
        String messageId = redisUtils.get(RedisConstants.MESSAGE_ID_TRIGGER_NO + triggerNo, String.class);
        if (messageId != null) {
            SendInfoRecord<SoftTriggerRequest> sendInfoRecord = redisUtils.get(RedisKeyConstants.MQ_RECORD_PREFIX + messageId,
                    new TypeReference<SendInfoRecord<SoftTriggerRequest>>(){});
            softTriggerService.notify(triggerNo, exitRequest, sendInfoRecord);
        }
        return P2cBaseResponse.success(baseRequest, carEnexResponse);
    }

    protected void dealShamPlate(TokenDeviceVo deviceToken, CarExitRequest exitRequest, String parkCode, String inandoutCode, Long parkId) {
        ShamPlate shamPlate = new ShamPlate();
        shamPlate.setParkId(parkId);
        shamPlate.setPlateNum(exitRequest.getPlateNum());
        ObjectResponse<PlateTypeDto> objectResponse =
                orderService.getPlateType(parkId, exitRequest.getPlateNum(), deviceToken.getRegionId());
        shamPlate.setType(objectResponse.getData().getPlateTypeEnum().getType());
        shamPlate.setExType(2);
        shamPlate.setCarImage(exitRequest.getMaxImage());
        shamPlate.setAlarmTime(new Date(exitRequest.getExitTime() * 1000));
        shamPlate.setChannelCode(inandoutCode);
        shamPlate.setChannelName(exitRequest.getInandoutName());
        CarExitRequest lastExit = cacheHandle.getExit(parkCode, inandoutCode);
        if (lastExit != null && !exitRequest.getPlateNum().equals(lastExit.getPlateNum())) {
            shamPlate.setRelCarImage(lastExit.getMaxImage());
            shamPlate.setRelPlateNum(lastExit.getPlateNum());
        }
        ObjectResponse<OrderInfo> infoObjectResponse = orderService.findInParkId(exitRequest.getPlateNum(), parkId);
        if (ObjectResponse.isSuccess(infoObjectResponse)) {
            OrderTags orderTags = orderTagsService.getListByOrderNumAndTagId(infoObjectResponse.getData().getOrderNum(), 5, null);
            if (orderTags != null) {
                shamPlate.setOrderNum(orderTags.getOrderNum());
            }
        }
        shamPlateService.addShamPlate(shamPlate);
    }

    /**
     * 补录入场数据
     * @param carExitRequest 离场参数
     * @return 订单号
     */
    protected String replenishEnter(CarExitRequest carExitRequest) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        BeanUtils.copyProperties(carExitRequest, carEnterRequest);
        carEnterRequest.setEnterTime(carExitRequest.getExitTime());
        carEnterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM);
        carEnterRequest.setNoneEnterFlag(true);
        ObjectResponse<CarEnterResult> enterObjectResponse = carOrderEnterService.enter(carEnterRequest);
        if (ObjectResponse.isSuccess(enterObjectResponse)){
            return enterObjectResponse.getData().getOrderNum();
        }else{
            log.info("[端云-脱机补充入场订单] 入场失败，原因：{}", enterObjectResponse.getMsg());
            return null;
        }
    }

    /**
     * 处理脱机线下支付
     * @param exitRequest 离场参数
     * @param orderNum 订单号
     */
    protected void dealOfflinePay(CarExitRequest exitRequest, String orderNum) {
        /*
         * 脱机情况下，相机有支付金额时，保存交易记录
         */
        Integer paidAmountFen = exitRequest.getPaidAmountFen();
        if (exitRequest.getProperty() == 2 && paidAmountFen != null && paidAmountFen > 0){
            PageQuery<OrderPay> pageQuery = new PageQuery<>();
            OrderPay orderPayPara = new OrderPay();
            orderPayPara.setParkId(exitRequest.getParkId());
            orderPayPara.setOrderNum(orderNum);
            orderPayPara.setPayStatus(PayStatusConstants.PAID);
            pageQuery.setParam(orderPayPara);
            ObjectResponse<List<OrderPay>> orderPayListObjectResponse = orderPayService.findList(pageQuery);
            /*
             * 判断是否已经有脱机下的支付记录，如果已经支付，则不处理相机上报的支付金额
             */
            if (ObjectResponse.isSuccess(orderPayListObjectResponse)){
                List<OrderPay> orderPayList = orderPayListObjectResponse.getData();
                for (OrderPay orderPay : orderPayList){
                    if (orderPay.getPayTerminal() != null
                            && orderPay.getPayTerminal().startsWith("脱机")){
                        return;
                    }
                }
            }
            //创建交易记录对象
            OrderPay orderPay = new OrderPay();
            orderPay.setPayStatus(PayStatusConstants.PAID);
            orderPay.setOrderNum(orderNum);
            orderPay.setChannelId(exitRequest.getInandoutCode());
            orderPay.setPayWay(1);
            orderPay.setTradeNo(CodeTools.GenerateTradeNo());
            orderPay.setTotalPrice(String.valueOf((paidAmountFen + exitRequest.getDiscountAmountFen())/100.0));
            orderPay.setPaidPrice(String.valueOf(paidAmountFen/100.0));
            orderPay.setPayTime(exitRequest.getOriginalExitTime());
            orderPay.setOrderTime(exitRequest.getExitTime());
            orderPay.setPayTerminal(exitRequest.getInandoutName());
            orderPay.setPayChannel(10);//遥控器
            orderPay.setDiscountPrice(String.valueOf(exitRequest.getDiscountAmountFen()/100.0));
            orderPay.setIsSync(0);
            //保存
            ObjectResponse<Long> orderPayResponse = orderPayService.addOrderPay(orderPay);
            if (orderPayResponse==null || !CodeConstants.SUCCESS.equals(orderPayResponse.getCode())){
                log.error("[端云-脱机出场事件] 保存交易记录失败,参数=[{}],响应=[{}]", orderPay, orderPayResponse);
            }else{
                log.info("[端云-脱机出场事件] 保存交易记录成功,参数=[{}],响应=[{}]", orderPay, orderPayResponse);
            }
        }
    }

    /**
     * 下发机器人屏显语音
     *
     * @param exitRequest 离场参数
     */
    protected void downOtherDeviceHint(CarExitRequest exitRequest, String show, String say,
                                       Map<String, Object> param, FlowCondition.ResultCode resultCode) {
        Long parkId = exitRequest.getParkId();
        String parkCode = exitRequest.getParkCode();
        String channelCode = exitRequest.getInandoutCode();
        String serialNumber = cacheHandle.getChannelRobot(parkCode, channelCode);
        if (serialNumber != null) {
            RobotHintRequest robotHintRequest = new RobotHintRequest();
            robotHintRequest.setPlateNum(exitRequest.getPlateNum());
            robotHintRequest.setShow(show);
            robotHintRequest.setSay(say);
            robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
        }
        String itcSn = itcCacheHandle.getSerialNumber(parkCode, channelCode);
        if (itcSn != null) {
            ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(parkId, channelCode);
            ParkInoutdevice channel = channelResp.getData();
            com.icetech.cloudcenter.domain.request.itc.HintRequest itcHintRequest = com.icetech.cloudcenter.domain.request.itc.HintRequest.builder()
                    .scene(showSayBaseHandle.getSceneByResultCode(resultCode, 2))
                    .plateNum(exitRequest.getPlateNum())
                    .type(showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), param))
                    .freeSpace(showSayBaseHandle.getFreeSpace(parkId, channel.getId(), param))
                    .remainDaysMc(showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), exitRequest.getPlateNum(), param))
                    .unpayPrice(param.get("fee") == null ? null : (int) (Float.parseFloat((String) param.get("fee")) * 100))
                    .parkTime((Long)param.get("parkTime"))
                    .build();
            if (PlateTypeEnum.VIP车辆.getType().equals(itcHintRequest.getType())) {
                itcHintRequest.setVipTypeName((String) param.get("carDesc"));
            }
            if (ShowSayConstants.QR_RESULT_LIST.contains(resultCode)){
                itcHintRequest.setQrCodeUrl(webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
            }
            itcHintService.execute(parkId, itcSn, itcHintRequest);
        }
    }

    protected P2cBaseResponse<CarEnexResponse> normalExit(P2cBaseRequest<CarExitRequest> baseRequest, ReportParamHolder paramHolder, CarEnexResponse carEnexResponse) {
        CarExitRequest exitRequest = baseRequest.getBizContent();
        String parkCode = paramHolder.getParkCode();
        String channelId = exitRequest.getInandoutCode();
        exitRequest.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM);
        log.info("[端云-出场事件] 准备请求cloudcenter离场服务，参数：{}", exitRequest);
        ObjectResponse<Map<String, Object>> objectResponse = carOrderExitService.exit(exitRequest, paramHolder);
        if (ObjectResponse.isSuccess(objectResponse)) {
            //清除缓存中的上次异常记录
            cacheHandle.removeExit(parkCode, channelId);
            cacheHandle.removeChannelFee(parkCode, channelId);
            //构建返回结果
            Map<String, Object> data = objectResponse.getData();
            carEnexResponse.setOrderNum((String) data.get("orderNum"));

            /*
             * 非自定义语音屏显时的定制功能，显示空车位
             */
            if (paramHolder.getVersionIndex() < P2cVersionEnum.版本3.getIndex()){
                showFreeSpace(exitRequest.getParkId(), parkCode, exitRequest.getPlateNum());
            }
            return P2cBaseResponse.success(baseRequest, carEnexResponse);
        } else {
            log.error("[端云-出场事件] 正常离场服务失败 parkCode[{}],{}", parkCode, objectResponse);
            return P2cBaseResponse.instance(baseRequest, Integer.parseInt(objectResponse.getCode()));
        }
    }


    protected void showFreeSpace(Long parkId, String parkCode, String plateNum) {
        //荣锦苑一号车场
        final String specialParkCode = "P1576060397,P1562641618";
        //得实车场
        String ledSpecialParkCode = "P1574734634";
        /*
         * 定制功能：指定车场四行屏显示空车位
         */
        if (specialParkCode.contains(parkCode) || ledSpecialParkCode.contains(parkCode)){
            log.info("进入定制车场，parkId：{}", parkId);
            ObjectResponse<ParkFreespace> parkFreespaceObjectResponse = parkService.getParkSpace(parkId);
            log.info("查询空车位，parkFreespaceObjectResponse：{}", parkFreespaceObjectResponse);
            if (ObjectResponse.isSuccess(parkFreespaceObjectResponse)) {
                String show = LedShowHandle.complement4Rows("" + parkFreespaceObjectResponse.getData().getFreeSpace());
                HintRequest hintRequest = new HintRequest();
                hintRequest.setShow(show);
                hintRequest.setPlateNum(plateNum);
                ObjectResponse<Void> response = hintService.executeSendEnter(parkId, parkCode, hintRequest);
                if (!ObjectResponse.isSuccess(response)) {
                    log.info("离场更新入口屏显的空车位失败，离场车牌号：{}", plateNum);
                }
            }
        }
    }

    /**
     * 相机未开闸情况下的处理
     * @param baseRequest 离场参数
     * @param flowRet 处理结果
     * @return 返回相机
     */
    public P2cBaseResponse<CarEnexResponse> notOpenedFlowHandle(P2cBaseRequest<CarExitRequest> baseRequest,
                                                                ReportParamHolder paramHolder, FlowCondition.FlowRet flowRet, Long parkTime) {
        CarExitRequest exitRequest = baseRequest.getBizContent();
        String plateNum = exitRequest.getPlateNum();
        Long parkId = exitRequest.getParkId();
        String parkCode = paramHolder.getParkCode();
        String inandoutCode = exitRequest.getInandoutCode();
        String inandoutName = exitRequest.getInandoutName();
        Map<String, Object> para = new HashMap<>();
        para.put("parkTime", parkTime);
        CarEnexResponse carEnexResponse = new CarEnexResponse();
        FlowCondition.ResultCode resultCode = flowRet.getResultCode();
        Map<String, Object> paramMap = flowRet.getPara() == null ? new HashMap<>() : flowRet.getPara();
        QueryOrderFeeResponse queryOrderFeeResponse = (QueryOrderFeeResponse) paramMap.get("orderFee");
        QueryNotPayResponse queryNotPayResponse = paramHolder.queryNotPayFee();
        if (!离场限制.equals(resultCode)
                && NumberUtils.parseDouble(queryNotPayResponse.getTotalNotPayPrice()) > 0) {
            resultCode = 欠费补缴;
        }
        log.info("FlowCondition.ResultCode exit > {} {}", resultCode, plateNum);
        switch (resultCode) {
            case 离场限制:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                asyncExecutor.execute(ThreadUtils.wrapTrace(()->
                        carOrderExitService.sendWebsocketMessage(exitRequest,"1",
                                carEnexResponse.getOpenFlag(),carEnexResponse.getOpenFlag())));
                return P2cBaseResponse.success(baseRequest, carEnexResponse);
            case 月卡车:
            case 内部车辆:
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                }else {
                    carEnexResponse.setShow(plateNum + "/一路顺风");
                    carEnexResponse.setSay("一路顺风");
                }
                break;
            case 特殊车辆免费:
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                exitRequest.setType(PlateTypeEnum.特殊车辆.getType());
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                }else {
                    carEnexResponse.setShow(plateNum + "/一路顺风");
                    carEnexResponse.setSay("一路顺风");
                }
                break;
            case 无需缴费:
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (queryOrderFeeResponse != null){
                    double unpayPrice = NumberUtils.toDouble(queryOrderFeeResponse.getUnpayPrice());
                    double discountPrice = NumberUtils.toDouble(queryOrderFeeResponse.getDiscountPrice());
                    if (unpayPrice + discountPrice > 0){
                        saveDiscountPay(inandoutName, inandoutCode, queryOrderFeeResponse, unpayPrice, discountPrice);
                    }
                }
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                }else {
                    carEnexResponse.setShow(plateNum + "/无需缴费/一路顺风");
                    carEnexResponse.setSay("一路顺风");
                }
                break;
            case 免费时间内:
                //免费时长内，是否自动开闸
                int isreleaseFreetm = (int) paramMap.get("isreleaseFreetm");
                if (isreleaseFreetm == 1){//自动开闸
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                }else{
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                }
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                }else {
                    carEnexResponse.setShow(plateNum + "/无需缴费/一路顺风");
                    carEnexResponse.setSay("一路顺风");
                }
                break;
            case 无入场有全免优惠:
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                }else {
                    carEnexResponse.setShow(plateNum + "/无需缴费/一路顺风");
                    carEnexResponse.setSay("一路顺风");
                }
                break;
            case 预缴费未超时:
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    Object isDo = paramMap.get("isDo");
                    if (isDo != null && (Integer) isDo == 0){
                        carEnexResponse.setOpenFlag(FlowCondition.NO);
                        return P2cBaseResponse.success(baseRequest, carEnexResponse);
                    }
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                }else {
                    carEnexResponse.setShow(plateNum + "/已缴费/一路顺风");
                    carEnexResponse.setSay("一路顺风");
                }
                break;
            case 黑名单车:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    Integer isShow = (Integer) paramMap.get("isShow");
                    para.put("isShow", isShow);
                    if (isShow != null && isShow == 0) {
                        break;
                    } else {
                        setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    }
                }else {
                    carEnexResponse.setShow("限行车辆/禁止通行");
                    carEnexResponse.setSay("限行车辆 、禁止通行");
                }
                break;
            case 需缴费:
                para.put("fee", queryOrderFeeResponse.getUnpayPrice());
                para.put("parkTime", queryOrderFeeResponse.getParkTime());
                // 进入储值卡查询支付流程
                boolean cardPayStatus = enterChargeStoreCard(queryOrderFeeResponse.getOrderNum(),parkId,queryOrderFeeResponse,
                        paramHolder.getChannelCode());
                if(cardPayStatus) {
                    exitRequest.setType(PlateTypeEnum.储值卡车.getType());
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                    resultCode = 无需缴费;
                    if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                        setCustomShowSay(parkId, exitRequest, carEnexResponse, para, 无需缴费);
                    }else {
                        carEnexResponse.setShow(plateNum + "/一路顺风");
                        carEnexResponse.setSay("一路顺风");
                    }
                    break;
                }
                // 请求无感支付
                Map<String, Object> retMap = autoPay(queryOrderFeeResponse, parkCode, parkId,
                        inandoutCode, paramHolder.getParkChannel().getId(), paramHolder.getParkChannel().getInandoutName(),
                        exitRequest.getExitTime() - (parkTime == null ? 0 : parkTime), exitRequest.getType(), exitRequest.getPlateColor());
                boolean autoPayStatus = retMap != null;
                if (autoPayStatus) {
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                    resultCode = 无需缴费;
                    if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                        setCustomShowSay(parkId, exitRequest, carEnexResponse, para, 无需缴费);
                    } else {
                        carEnexResponse.setShow(plateNum + "/一路顺风");
                        carEnexResponse.setSay("一路顺风");
                    }
                    //先离场后付费
                    if (Boolean.TRUE.equals(retMap.get("isAfterPay"))) {
                        exitRequest.setTotalAmount(queryOrderFeeResponse.getTotalAmount());
                        exitRequest.setPaidAmount(queryOrderFeeResponse.getPaidAmount());
                        double dis = 0.00;
                        String discountAmount = queryOrderFeeResponse.getDiscountAmount();
                        String discountPrice1 = queryOrderFeeResponse.getDiscountPrice();
                        if (StringUtil.isNotEmpty(discountAmount)) {
                            double aDouble = Double.parseDouble(discountAmount);
                            dis = dis + aDouble;
                        }
                        if (StringUtil.isNotEmpty(discountPrice1)) {
                            double aDouble = Double.parseDouble(discountPrice1);
                            dis = dis + aDouble;
                        }
                        exitRequest.setDiscountAmount(String.valueOf(dis));
                        exitRequest.setUnpayPrice(queryOrderFeeResponse.getUnpayPrice());
                        exitRequest.setIsAfterPay(1);
                    }
                } else {
                    //不允许开闸
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                        para.put("hasInnerAreaFee", queryOrderFeeResponse.getHasInnerAreaFee());
                        setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    } else {
                        carEnexResponse.setShow(LedShowHandle.needPay(parkCode, plateNum, queryOrderFeeResponse.getParkTime(), queryOrderFeeResponse.getUnpayPrice()));
                        carEnexResponse.setSay(LedSayHandle.needPay(parkCode, plateNum, queryOrderFeeResponse.getUnpayPrice(), queryOrderFeeResponse.getParkTime()));
                    }
                }
                break;
            case 无入场记录:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                }else {
                    carEnexResponse.setShow("无入场信息/请扫码联系管理员");
                    carEnexResponse.setSay("无入场信息，请扫码联系管理员协助");
                }
                break;
            case 固定费用:
                para.put("fee", queryOrderFeeResponse.getUnpayPrice());
                para.put("parkTime", queryOrderFeeResponse.getParkTime());
                float fixedFee = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
                //进入储值卡扣费流程
                if (fixedFee >= 0) {
                    if (fixedFee > 0) {
                        fixedFee = enterChargeStoreCard(queryOrderFeeResponse.getOrderNum(), parkId,
                                queryOrderFeeResponse, paramHolder.getChannelCode()) ? 0 : fixedFee;
                    }
                    if (fixedFee == 0){
                        exitRequest.setType(PlateTypeEnum.储值卡车.getType());
                        carEnexResponse.setOpenFlag(FlowCondition.YES);
                        resultCode = FlowCondition.ResultCode.无需缴费;
                        if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                            setCustomShowSay(parkId, exitRequest, carEnexResponse, para, FlowCondition.ResultCode.无需缴费);
                        } else {
                            carEnexResponse.setShow(plateNum + "/一路顺风");
                            carEnexResponse.setSay("一路顺风");
                        }
                        break;
                    }
                }

                exitRequest.setOrderNum(queryOrderFeeResponse.getOrderNum());
                paramHolder.setOrderNum(queryOrderFeeResponse.getOrderNum());

                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                } else {
                    carEnexResponse.setShow(plateNum + "/请缴费" + queryOrderFeeResponse.getUnpayPrice() + "元");
                    carEnexResponse.setSay(LedSayHandle.needPay(parkCode, plateNum, queryOrderFeeResponse.getUnpayPrice(), queryOrderFeeResponse.getParkTime()));
                }
                break;
            case 无入场VIP全免车:
                //全免VIP, 允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                exitRequest.setType(PlateTypeEnum.VIP车辆.getType());
                para.putAll(paramMap);
                setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                break;
            case 不允许临时车出:
                //不允许临时车出, 不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                exitRequest.setAllowExit(false);
                setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                break;
            case 欠费补缴:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                AssertTools.notNull(queryNotPayResponse, CodeConstants.ERROR_400, "欠费记录为空");
                if (queryOrderFeeResponse == null) {
                    queryOrderFeeResponse = QueryOrderFeeResponse.buildEmptyOrderFee(plateNum, paramHolder.getParkInfo().getParkName(),
                            paramHolder.getParkConfig().getIsfreeAfterpay(15), 1, exitRequest.getOrderNum());
                }
                BigDecimal sumPrice = new BigDecimal(queryOrderFeeResponse.getUnpayPrice())
                        .add(new BigDecimal(queryNotPayResponse.getTotalNotPayPrice()));
                queryOrderFeeResponse.setSumPrice(sumPrice.toString());
                queryOrderFeeResponse.setTotalNotPayPrice(queryNotPayResponse.getTotalNotPayPrice());
                queryOrderFeeResponse.setNotPayDetails(queryNotPayResponse.getNotPayDetails());
                para.put("fee", sumPrice.toString());
                para.put("parkTime", queryOrderFeeResponse.getParkTime());
                setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                break;
            case 无牌车允许进出:
            default:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                }else {
                    carEnexResponse.setShow("请扫二维码缴费后出场");
                    carEnexResponse.setSay("请扫码缴费");
                }
                break;
        }
        boolean setExitCache = true;
        if(carEnexResponse.getOpenFlag().equals(FlowCondition.NO)){
            CarExitRequest cacheExit = cacheHandle.getExit(parkCode, inandoutCode);
            if (cacheExit != null) {
                String cachePlateNum = cacheExit.getPlateNum();
                //当前是无牌车，缓存是有牌车，则不更新缓存
                if (DataCommonConstants.isNoPlate(exitRequest.getPlateNum())
                        && !DataCommonConstants.isNoPlate(cachePlateNum)) {
                    setExitCache = false;
                }
            }
            if (setExitCache) {
                cacheHandle.setExit(parkCode, inandoutCode, exitRequest, queryOrderFeeResponse);
            }
        } else {
            setExitCache = false;
        }

        //异步处理
        asyncHandle(resultCode, exitRequest, carEnexResponse, parkCode, inandoutCode,
                plateNum, parkId, paramHolder, para, setExitCache, queryOrderFeeResponse, inandoutName, parkTime);
        if (StringUtils.isNotBlank(exitRequest.getOrderNum()) && carEnexResponse.getOpenFlag().equals(FlowCondition.YES)) {
            //开闸成功并且有在场记录，按正常离场处理
            return normalExit(baseRequest, paramHolder, carEnexResponse);
        }
        return P2cBaseResponse.success(baseRequest, carEnexResponse);
    }

    private void asyncHandle(FlowCondition.ResultCode resultCode, CarExitRequest exitRequest, CarEnexResponse carEnexResponse,
                             String parkCode, String channelCode, String plateNum, Long parkId, ReportParamHolder paramHolder,
                             Map<String, Object> para, boolean setExitCache, QueryOrderFeeResponse queryOrderFeeResponse, String channelName, Long parkTime) {
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            if (setExitCache) {
                rabbitSender.sendMessage(MqConstants.Exchange.AISLE_DELAYED_EXCHANGE,
                        MqConstants.Routing.AISLE_NEED_PAY_ROUTING, exitRequest, aisleExceptionExitTime * 1000L);
                log.info("[端云-出口] 待支付订单迟延消息发送, [{}]", exitRequest);

                ObjectResponse<ParkConfig> parkConfig = parkService.getParkConfig(exitRequest.getParkId());
                if (ObjectResponse.isSuccess(parkConfig)) {
                    AisleInfoVo aisleInfoVo = AisleInfoVo.builder()
                            .aisleCode(channelCode)
                            .aisleType(2)
                            .parkCode(parkCode)
                            .parkId(exitRequest.getParkId())
                            .orderNum(exitRequest.getOrderNum())
                            .build();
                    if (Objects.nonNull(parkConfig.getData().getCarenexTimelong())
                            && parkConfig.getData().getCarenexTimelong() > 0) {
                        rabbitSender.sendMessage(MqConstants.Exchange.AISLE_DELAYED_EXCHANGE,
                                MqConstants.Routing.AISLE_ALARM_ROUTING, aisleInfoVo,
                                parkConfig.getData().getCarenexTimelong() * 60 * 1000L);
                    }
                }

                // 出场识别推送
                ExitIdentify exitIdentify = ExitIdentify.builder()
                        .parkId(parkId)
                        .parkCode(parkCode)
                        .plateNum(exitRequest.getPlateNum())
                        .type(exitRequest.getType())
                        .parkTime(parkTime)
                        .channelCode(channelCode)
                        .channelName(channelName)
                        .reasonType(resultCode.getCode())
                        .timestamp(exitRequest.getExitTime())
                        .build();
                if (queryOrderFeeResponse != null) {
                    exitIdentify.setOrderNum(queryOrderFeeResponse.getOrderNum());
                    exitIdentify.setTotalAmount(queryOrderFeeResponse.getTotalAmount());
                    exitIdentify.setPaidAmount(queryOrderFeeResponse.getPaidAmount());
                    exitIdentify.setDiscountAmount(queryOrderFeeResponse.getDiscountAmount());
                    exitIdentify.setDiscountPrice(queryOrderFeeResponse.getDiscountPrice());
                    exitIdentify.setUnpayPrice(queryOrderFeeResponse.getUnpayPrice());
                    exitIdentify.setQueryTime(queryOrderFeeResponse.getQueryTime());
                    exitIdentify.setEnterTime(queryOrderFeeResponse.getEnterTime());
                }
                if (ShowSayConstants.QR_RESULT_LIST.contains(resultCode)){
                    exitIdentify.setQrCodeUrl(webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
                }
                exitIdentifyHandler.exitIdentify(exitIdentify);
            }
            carOrderExitService.sendWebsocketMessage(exitRequest, FlowCondition.ResultCode.无入场记录.equals(resultCode)
                            ? "6" : carEnexResponse.getOpenFlag().equals(FlowCondition.YES) ? "2" : "1",
                    FlowCondition.YES, NumberUtils.parseDouble(para.get("fee")) > 0 ? FlowCondition.NO : FlowCondition.YES);
            // 机器人屏显语音下发
            String serialNumber = cacheHandle.getChannelRobot(parkCode, channelCode);
            if (serialNumber != null){
                if (ShowSayConstants.PAY_LIST.contains(resultCode)){
                    ShowPayInfoRequest showPayInfoRequest = new ShowPayInfoRequest();
                    showPayInfoRequest.setOrderNum(exitRequest.getOrderNum());
                    showPayInfoRequest.setNoticeMsg(RobotConstants.PAY_NOTICE_MSG);
                    showPayInfoRequest.setShow(plateNum + "/"+para.get("fee") + "元" +
                            "/" + DateTools.secondToSecondsTime(NumberUtils.parseInteger(para.get("parkTime"))) +
                            "/" + PlateTypeEnum.getName(exitRequest.getType()));
                    showPayInfoRequest.setQrCodeUrl(webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
                    //查询是否存在三方支付二维码
                    String thirdPayUrl = commonShowHandle.getThirdPayUrl(parkId,exitRequest.getParkCode(),exitRequest.getInandoutCode(),exitRequest.getOrderNum(), plateNum, para);
                    if(!TextUtils.isEmpty(thirdPayUrl)){
                        showPayInfoRequest.setQrCodeUrl(thirdPayUrl);
                    }
                    showPayInfoService.executeDown(parkId, serialNumber, showPayInfoRequest);
                    /*
                     * 机器人播报
                     */
                    RobotHintRequest robotHintRequest = new RobotHintRequest();
                    robotHintRequest.setPlateNum(exitRequest.getPlateNum());
                    robotHintRequest.setShow("");
                    String say = carEnexResponse.getSay();
                    robotHintRequest.setSay(say);
                    robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
                }else{
                    String show = carEnexResponse.getShow();
                    String say = carEnexResponse.getSay();
                    RobotHintRequest robotHintRequest = new RobotHintRequest();
                    robotHintRequest.setPlateNum(exitRequest.getPlateNum());
                    robotHintRequest.setShow(show);
                    robotHintRequest.setSay(say);
                    robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
                }
            }
            String itcSn = itcCacheHandle.getSerialNumber(parkCode, channelCode);
            log.debug("对讲立柱SN[{}]", itcSn);
            if (itcSn != null) {
                ParkInoutdevice channel = paramHolder.getParkChannel();
                com.icetech.cloudcenter.domain.request.itc.HintRequest itcHintRequest = com.icetech.cloudcenter.domain.request.itc.HintRequest.builder()
                        .scene(showSayBaseHandle.getSceneByResultCode(resultCode, 2))
                        .plateNum(exitRequest.getPlateNum())
                        .type(showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), para))
                        .freeSpace(showSayBaseHandle.getFreeSpace(parkId, channel.getId(), para))
                        .remainDaysMc(showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), exitRequest.getPlateNum(), para))
                        .unpayPrice(para.get("fee") == null ? null : (int) (Float.parseFloat((String) para.get("fee")) * 100))
                        .parkTime((Long)para.get("parkTime"))
                        .build();
                if (PlateTypeEnum.VIP车辆.getType().equals(itcHintRequest.getType())) {
                    itcHintRequest.setVipTypeName((String) para.get("carDesc"));
                }
                if (ShowSayConstants.QR_RESULT_LIST.contains(resultCode)){
                    itcHintRequest.setQrCodeUrl(webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
                }
                log.debug("对讲立柱下发[{}]", itcHintRequest);
                itcHintService.execute(parkId, itcSn, itcHintRequest);
            }
        }));
    }

    /**
     * 设置自定义语音屏显内容
     * @param parkId 车场ID
     * @param exitRequest 离场参数
     * @param carEnexResponse 响应
     * @param para 公共参数
     * @param resultCode 处理结果
     */
    protected void setCustomShowSay(Long parkId, CarExitRequest exitRequest, CarEnexResponse carEnexResponse, Map<String, Object> para, FlowCondition.ResultCode resultCode) {
        if (para == null) {
            para = new HashMap<>();
        }
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(parkId, exitRequest.getInandoutCode());
        ParkInoutdevice channel = channelResp.getData();
        Integer ledLcdSource = channel.getLedLcdSource();
        carEnexResponse.setShowDeviceType(ledLcdSource);
        para.put("regionId", channelResp.getData().getRegionId());
        para.put("orderNum", exitRequest.getOrderNum());
        String show = commonShowHandle.exit(parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), resultCode, para, ledLcdSource);
        String say = commonSayHandle.exit(parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), resultCode, para, ledLcdSource);
        if (ledLcdSource == 2){
            if (ShowSayConstants.QR_RESULT_LIST.contains(resultCode)) {
                carEnexResponse.setQrCodeUrl(
                        commonShowHandle.replacePara(exitPayUrl, new String[]{exitRequest.getParkCode(), exitRequest.getInandoutCode()})
                );
                //查询是否存在三方支付二维码
                String thirdPayUrl = commonShowHandle.getThirdPayUrl(parkId,exitRequest.getParkCode(),exitRequest.getInandoutCode(),exitRequest.getOrderNum(), exitRequest.getPlateNum(), para);
                if(!TextUtils.isEmpty(thirdPayUrl)){
                    carEnexResponse.setQrCodeUrl(thirdPayUrl);
                }
            }
        }else{
            //设置显示时，即设置了显示类型
            carEnexResponse.setShowTypeByShow(show);
            if (carEnexResponse.getShowType() == ShowTypeEnum.动态二维码.getVal() || carEnexResponse.getShowType() == ShowTypeEnum.文本和二维码.getVal()){
                show = commonShowHandle.replacePara(show, new String[]{exitRequest.getParkCode(), exitRequest.getInandoutCode()});
                //查询是否存在三方支付二维码
                String thirdPayUrl = commonShowHandle.getThirdPayUrl(parkId,exitRequest.getParkCode(),exitRequest.getInandoutCode(),exitRequest.getOrderNum(), exitRequest.getPlateNum(), para);
                if(!TextUtils.isEmpty(thirdPayUrl)){
                    if (carEnexResponse.getShowType() == ShowTypeEnum.文本和二维码.getVal()) {
                        String[] strings = show.split("\\|");
                        strings[1] = thirdPayUrl;
                        show = StringUtils.joinWith("|", (Object[]) strings);
                    }else{
                        show = thirdPayUrl;
                    }
                }
                if (carEnexResponse.getShowType() == ShowTypeEnum.动态二维码.getVal()) {
                    String extendShow = ledShowHandle.generate4LineContent(parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), resultCode, para, LedShow.DisplayTypeEnum.出场显示.type);
                    carEnexResponse.setExtendShow(extendShow);
                }
            }
        }
        carEnexResponse.setShow(show);
        carEnexResponse.setSay(say);

    }
    /**
     * 免密支付
     * @param queryOrderFeeResponse 计费结果
     * @param parkCode 车场编号
     * @param parkId 车场ID
     * @param inandoutCode 通道编号
     * @return 扣费结果
     */
    private Map<String, Object> autoPay(QueryOrderFeeResponse queryOrderFeeResponse, String parkCode, Long parkId,
                                        String inandoutCode, Long channelId, String channelName, Long enterTime,
                                        Integer type, String plateColor) {
        ThirdAutoPayRequest autopayRequest = new ThirdAutoPayRequest();
        autopayRequest.setOrderNum(queryOrderFeeResponse.getOrderNum());
        autopayRequest.setPlateNum(queryOrderFeeResponse.getPlateNum());
        String unpayPrice = queryOrderFeeResponse.getUnpayPrice();
        String discountPrice = queryOrderFeeResponse.getDiscountPrice();
        autopayRequest.setTotalPrice(String.valueOf(NumberUtils.toFloat(unpayPrice) + NumberUtils.toFloat(discountPrice)));
        autopayRequest.setUnpayPrice(unpayPrice);
        autopayRequest.setDiscountPrice(discountPrice);
        autopayRequest.setParkTime(queryOrderFeeResponse.getParkTime().intValue());
        autopayRequest.setPayTime(queryOrderFeeResponse.getQueryTime());
        autopayRequest.setChannelCode(inandoutCode);
        autopayRequest.setChannelId(channelId);
        autopayRequest.setParkId(parkId);
        autopayRequest.setParkCode(parkCode);
        autopayRequest.setEnterTime(enterTime);
        autopayRequest.setType(type);
        autopayRequest.setChannelName(channelName);
        autopayRequest.setPlateColor(plateColor);
        autopayRequest.setTotalAmount(queryOrderFeeResponse.getTotalAmount());
        ObjectResponse<Map<String, Object>> objectResponse = autopayService.report(parkCode, parkId, autopayRequest);
        return objectResponse.getData();
    }



    protected void saveDiscountPay(String inandoutName, String inandoutCode, QueryOrderFeeResponse queryOrderFeeResponse,
                                 double unpayPrice, double discountPrice) {
        //创建交易记录对象
        OrderPay orderPay = new OrderPay();
        orderPay.setPayStatus(PayStatusConstants.PAID);
        orderPay.setOrderNum(queryOrderFeeResponse.getOrderNum());
        orderPay.setChannelId(inandoutCode);
        orderPay.setPayWay(10);
        orderPay.setTradeNo(CodeTools.GenerateTradeNo());
        orderPay.setLastPayTime(queryOrderFeeResponse.getPayTime());
        orderPay.setTotalPrice(String.valueOf(unpayPrice + discountPrice));
        orderPay.setPaidPrice(queryOrderFeeResponse.getUnpayPrice());
        orderPay.setPayTime(System.currentTimeMillis() / 1000);
        orderPay.setOrderTime(queryOrderFeeResponse.getQueryTime());
        orderPay.setPayTerminal(inandoutName);
        orderPay.setPayChannel(1);
        orderPay.setDiscountPrice(queryOrderFeeResponse.getDiscountPrice());
        //保存
        ObjectResponse<Long> orderPayResponse = orderPayService.addOrderPay(orderPay);
        if (orderPayResponse==null || !CodeConstants.SUCCESS.equals(orderPayResponse.getCode())){
            log.error("[端云-出场事件]保存交易记录失败,参数=[{}],响应=[{}]",orderPay,JsonUtils.toString(orderPayResponse));
        }else{
            log.info("[端云-出场事件]保存交易记录成功,参数=[{}],响应=[{}]",orderPay, JsonUtils.toString(orderPayResponse));
        }
    }


    /**
     * 储值卡扣费流程方法
     * @param parkId  车场表 主键 id
     * @param queryOrderFeeResponse  扣费信息
     * @return  扣费结果是否成功
     */
    public boolean enterChargeStoreCard(String orderNum,Long parkId,QueryOrderFeeResponse queryOrderFeeResponse, String channelCode){
        //固定费用车辆存在没有订单详情的情况
        ObjectResponse<StoreCard> objectResponse = orderService.chargeStoreCardComplete(queryOrderFeeResponse,orderNum,parkId, channelCode);
        return null != objectResponse && CodeConstants.SUCCESS.equals(objectResponse.getCode());
    }


    /**
     * 保存出场记录
     * @param exitRequest 离场参数
     */
    public void addExitRecord(CarExitRequest exitRequest) {
        ExitRecord record = new ExitRecord();
        BeanUtils.copyProperties(exitRequest, record);
        record.setExitNo(exitRequest.getInandoutName());
        record.setImage(exitRequest.getMaxImage());
        record.setSmallImage(exitRequest.getSmallImage());
        exitRecordService.saveRecordAsync(record);
    }

}
