package com.icetech.park.service.report.p2c.impl.enter;

import com.google.common.collect.Maps;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryNotPayResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.park.service.down.p2c.impl.OfflineRecordServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.flow.p2c.impl.CarEnterFlowProcessImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.mq.sender.RabbitSender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

import static com.icetech.park.service.flow.p2c.FlowCondition.ResultCode.*;

/**
 * 入场处理流程
 *
 * @author kate
 */
@RefreshScope
@Component
@Slf4j
public class CarEnterHandler extends CarEnterBaseHandler {
    @Autowired
    private CarEnterFlowProcessImpl carEnterFlowProcess;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OfflineRecordServiceImpl offlineRecordService;
    @Autowired
    private RabbitSender rabbitSender;
    //触发脱机记录上报的锁
    private static final String OFFLINE_RECORDS_PREFIX = "offline:record:";
    //时间与相机比较的偏移量
    private static final Long OFFSET = 10L;
    //入场时间的最小时间点
    private static final Long SYS_START_TIME = 1546272000L;
    @Value("${custom.repeatEx.enable:false}")
    private boolean customRepeatExEnable;
    @Value("${custom.repeatEx.parkCodes:P}")
    private String customRepeatExParkCodes;
    @Value("${custom.repeatEx.showDevice:1}")
    private Integer customRepeatExShowDevice;

    public CarEnexResponse execute(CarEnterRequest enterRequest, String deviceNo, String version) {
        CarEnexResponse carEnexResponse = new CarEnexResponse();
        Long parkId = enterRequest.getParkId();
        String parkCode = enterRequest.getParkCode();
        Integer triggerType = enterRequest.getTriggerType();
        String channelCode = enterRequest.getInandoutCode();

        Long enterTime = enterRequest.getEnterTime();
        long now = DateTools.unixTimestamp();
        if (now + OFFSET < enterTime) {
            log.warn("alarmType[{}],keyword1[{}],keyword2[SN:{}, 上报入场时间:{}]", "端云相机时间偏大", parkCode, deviceNo, enterTime);
            enterRequest.setEnterTime(now);
        }
        if (SYS_START_TIME > enterTime) {
            log.warn("alarmType[{}],keyword1[{}],keyword2[SN:{}, 上报入场时间:{}]", "端云相机时间偏小", parkCode, deviceNo, enterTime);
            enterRequest.setEnterTime(now);
        }

        ReportParamHolder paramHolder = new ReportParamHolder(enterRequest.getParkId(), enterRequest.getParkCode(),
                enterRequest.getInandoutCode(), deviceNo, version, enterRequest.getPlateNum(), 1, null);
        if (triggerType.equals(TriggerTypeEnum.软触发.getVal())) {
            redisUtils.releaseLock(SoftTriggerServiceImpl.LOCK_KEY + deviceNo);
            String orderNum = dealSoftTrigger(enterRequest);
            if (enterRequest.getProperty() == 2 || enterRequest.getOpenFlag().equals(FlowCondition.YES)) {
                cacheHandle.removeEntrace(parkCode, channelCode);
            }
            carEnexResponse.setOrderNum(orderNum);

            if (enterRequest.getOpenFlag().equals(FlowCondition.NO)) {
                return carEnexResponse;
            }
        }

        //虚假车牌
        if (Integer.valueOf(0).equals(enterRequest.getShamFlag())) {
            ParkConfig parkConfig = paramHolder.getParkConfig();
            Integer enableShamPlate = parkConfig.getEnableShamPlate();
            if (Integer.valueOf(1).equals(enableShamPlate)) {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                setCustomShowSay(enterRequest, paramHolder, carEnexResponse, null, FlowCondition.ResultCode.虚假车牌);

                dealShamePlate(enterRequest, paramHolder);
                return carEnexResponse;
            }
        }
        //历史数据上报处理：不返回开闸和屏显语音信息
        if (enterRequest.getProperty() == 2) {
            carEnexResponse.setOpenFlag(0);
            carEnexResponse.setShow(null);
            carEnexResponse.setSay(null);
            Park parkInfo = paramHolder.getParkInfo();
            if (Integer.valueOf(1).equals(parkInfo.getIsInterior())) {
                //缓存记录
                cacheHandle.cacheEnterRecords(parkCode, enterRequest.getPlateNum(), enterRequest);
                if (redisUtils.tryLock(OFFLINE_RECORDS_PREFIX + parkCode + "_" + enterRequest.getPlateNum(), parkCode, 4000L)) {
                    //主动触发相机上报该车牌的脱机记录上报
                    offlineRecordService.send(parkId, parkCode, enterRequest.getPlateNum());
                    //延迟消息处理
                    rabbitSender.sendMessage(MqConstants.Exchange.OFFLINE_RECORDS_DELAYED_EXCHANGE,
                            MqConstants.Routing.OFFLINE_RECORDS_ROUTING, parkCode + "_" + enterRequest.getPlateNum(),
                            20000L);
                }
            } else {
                String orderNum = normalEnter(enterRequest, paramHolder, parkCode, channelCode);
                carEnexResponse.setOrderNum(orderNum);
            }
            return carEnexResponse;
        }
        //相机已经开闸
        if (FlowCondition.YES.equals(enterRequest.getOpenFlag())) {
            String robotSn = cacheHandle.getChannelRobot(parkCode, channelCode);
            String itcSn = itcCacheHandle.getSerialNumber(parkCode, channelCode);
            if (robotSn != null || itcSn != null) {
                asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                    ParkInoutdevice channel = paramHolder.getParkChannel();
                    //机器人屏显语音下发
                    ObjectResponse<PlateTypeDto> plateTypeDtoObjectResponse =
                            orderService.getPlateType(parkId, enterRequest.getPlateNum(), channel.getRegionId());
                    PlateTypeDto plateTypeDto = plateTypeDtoObjectResponse.getData();
                    enterRequest.setType(plateTypeDto.getPlateTypeEnum().getType());
                    Map<String, Object> para = Maps.newHashMap();
                    FlowCondition.ResultCode resultCode;
                    PlateTypeEnum plateTypeEnum = plateTypeDto.getPlateTypeEnum();
                    switch (plateTypeEnum) {
                        case VIP车辆:
                            String carDesc = plateTypeDto.getCarDesc();
                            if (carDesc != null) {
                                para.put("carDesc", carDesc);
                            }
                            resultCode = VIP车辆;
                            break;
                        case 月卡车:
                            resultCode = 月卡车;
                            break;
                        default:
                            resultCode = 有牌车允许临时车进入;
                            break;
                    }
                    para.put("regionId", channel.getRegionId());
                    para.put("enexType", 1);
                    para.put("channelCode", channel.getInandoutCode());
                    String show = null;
                    String say = null;
                    if (robotSn != null) {
                        show = commonShowHandle.enter(parkId, channel.getId(), enterRequest.getPlateNum(), plateTypeDto.getPlateTypeEnum().getType(), resultCode, para);
                        say = commonSayHandle.enter(parkId, channel.getId(), enterRequest.getPlateNum(), plateTypeDto.getPlateTypeEnum().getType(), resultCode, para);
                    }
                    downOtherDeviceHint(enterRequest, show, say, para, resultCode);
                }));
            }
            String orderNum = normalEnter(enterRequest, paramHolder, parkCode, channelCode);
            carEnexResponse.setOrderNum(orderNum);

            //定制功能-空车位数下发
            spaceDown(enterRequest, carEnexResponse, paramHolder);
            return carEnexResponse;
        }

        if (customRepeatExEnable && customRepeatExParkCodes.contains(parkCode)) {
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setParkId(parkId);
            orderInfo.setPlateNum(enterRequest.getPlateNum());
            ObjectResponse<OrderInfo> infoObjectResponse = orderService.findByOrderInfo(orderInfo);
            if (ObjectResponse.isSuccess(infoObjectResponse)
                    && infoObjectResponse.getData().getServiceStatus() == OrderStatusConstants.IN_PARK) {
                log.info("[定制功能-重复入场] {}", enterRequest);
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/此车已入场/请勿重复入场/请等待人工确认");
                carEnexResponse.setSay("此车已入场 请勿重复入场");
                carEnexResponse.setShowDeviceType(customRepeatExShowDevice);
                return carEnexResponse;
            }
        }
        FlowCondition.FlowRet flowRet = carEnterFlowProcess.flowHandle(enterRequest, paramHolder);
        FlowCondition.ResultCode resultCode = flowRet.getResultCode();
        log.info("FlowCondition.ResultCode enter > {} {}", resultCode, enterRequest.getPlateNum());
        Map<String, Object> param = flowRet.getPara() == null ? new HashMap<>() : flowRet.getPara();
        switch (resultCode) {
            case 入场限制:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                //本地坐席消息发布
                asyncExecutor.execute(ThreadUtils.wrapTrace(() -> carOrderEnterService.sendWebsocketMessage(enterRequest, FlowCondition.NO)));
                return carEnexResponse;
            case 月卡车:
                //允许开闸
                enterRequest.setType(PlateTypeEnum.月卡车.getType());
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/月租车");
                    carEnexResponse.setSay("欢迎光临");
                }
                break;
            case 过期卡:
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                Boolean isMonth = (Boolean) param.get("isMonth");
                if (isMonth != null && isMonth) {
                    enterRequest.setType(PlateTypeEnum.月卡车.getType());
                } else {
                    enterRequest.setType(PlateTypeEnum.临时车.getType());
                }
                setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                break;
            case 内部车辆:
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                enterRequest.setType(PlateTypeEnum.VIP车辆.getType());
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/欢迎光临");
                carEnexResponse.setSay("欢迎光临");
            case VIP车辆:
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                enterRequest.setType(PlateTypeEnum.VIP车辆.getType());
                setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                break;
            case 有牌车允许临时车进入:
                //DZ002定制需求
                if (DingZhiFuncConstants.DZ002_PARKS.contains(parkCode) && enterRequest.getPlateNum().contains("鄂")) {
                    //平台正常入场
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/请等待人工确认");
                    carEnexResponse.setSay(enterRequest.getPlateNum() + "、请等待人工确认");
                    break;
                }
                enterRequest.setType(PlateTypeEnum.临时车.getType());
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/欢迎光临");
                    carEnexResponse.setSay("欢迎光临");
                }
                break;
            case 储值卡车允许进入:
                //DZ002定制需求
                if (DingZhiFuncConstants.DZ002_PARKS.contains(parkCode) && enterRequest.getPlateNum().contains("鄂")) {
                    //平台正常入场
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/请等待人工确认");
                    carEnexResponse.setSay(enterRequest.getPlateNum() + "、请等待人工确认");
                    break;
                }
                enterRequest.setType(PlateTypeEnum.储值卡车.getType());
                //允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/欢迎光临");
                    carEnexResponse.setSay("欢迎光临");
                }
                break;
            case 有牌车不允许临时车进入:
                //DZ002定制需求
                if (DingZhiFuncConstants.DZ002_PARKS.contains(parkCode) && enterRequest.getPlateNum().contains("鄂")) {
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/请等待人工确认");
                    carEnexResponse.setSay(enterRequest.getPlateNum() + "、请等待人工确认");
                    break;
                }
                if (DingZhiFuncConstants.DZ004_PARKS.contains(parkCode) && enterRequest.getPlateColor().contains("绿")) {
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                    resultCode = 有牌车允许临时车进入;
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/禁止通行");
                    carEnexResponse.setSay("临时车、禁止通行");
                }
                break;
            case 储值卡车禁止进入:
                //DZ002定制需求
                if (DingZhiFuncConstants.DZ002_PARKS.contains(parkCode) && enterRequest.getPlateNum().contains("鄂")) {
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/请等待人工确认");
                    carEnexResponse.setSay(enterRequest.getPlateNum() + "、请等待人工确认");
                    break;
                }
                enterRequest.setType(PlateTypeEnum.储值卡车.getType());
                if (DingZhiFuncConstants.DZ004_PARKS.contains(parkCode) && enterRequest.getPlateColor().contains("绿")) {
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                    resultCode = 有牌车允许临时车进入;
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/禁止通行");
                    carEnexResponse.setSay("临时车、禁止通行");
                }
                break;
            case 黑名单车:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    Integer isShow = (Integer) param.get("isShow");
                    if (isShow != null && isShow == 0) {
                        break;
                    }
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/禁止通行");
                    carEnexResponse.setSay("限行车辆 、禁止通行");
                }
                break;
            case 无牌车允许进出:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow("请扫二维码进场");
                    carEnexResponse.setSay("请扫码进场");
                }
                break;

            case 车位已满禁止入场:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (param.get("type") != null) {
                    enterRequest.setType((Integer) param.get("type"));
                }
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow("车位已满/禁止通行");
                    carEnexResponse.setSay("车位已满 、禁止通行");
                }
                break;
            case 黄牌车禁止入场:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow("黄牌车/禁止通行");
                    carEnexResponse.setSay("黄牌车 、禁止通行");
                }
                break;
            case 访客车:
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                enterRequest.setType(PlateTypeEnum.访客车辆.getType());
                setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                break;
            case 欠费补缴:
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                QueryNotPayResponse queryNotPayResponse = (QueryNotPayResponse) param.get("notPayFee");
                AssertTools.notNull(queryNotPayResponse, CodeConstants.ERROR_400, "欠费记录为空");
                QueryOrderFeeResponse queryOrderFeeResponse = QueryOrderFeeResponse.buildEmptyOrderFee(enterRequest.getPlateNum(), paramHolder.getParkInfo().getParkName(),
                        paramHolder.getParkConfig().getIsfreeAfterpay(15), enterRequest.getCarType(), enterRequest.getOrderNum());

                BigDecimal sumPrice = new BigDecimal(queryOrderFeeResponse.getUnpayPrice())
                        .add(new BigDecimal(queryNotPayResponse.getTotalNotPayPrice()));
                queryOrderFeeResponse.setSumPrice(sumPrice.toString());
                queryOrderFeeResponse.setTotalNotPayPrice(queryNotPayResponse.getTotalNotPayPrice());
                queryOrderFeeResponse.setNotPayDetails(queryNotPayResponse.getNotPayDetails());
                param.put("fee", sumPrice.toString());
                param.put("parkTime", queryOrderFeeResponse.getParkTime());
                param.put("orderFee", queryOrderFeeResponse);
                //缓存费用
                cacheHandle.setChannelFee(parkCode, enterRequest.getInandoutCode(), queryOrderFeeResponse);
                setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                break;
            default:
                //不允许开闸
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex(version) >= P2cVersionEnum.版本3.getIndex()) {
                    setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                } else {
                    carEnexResponse.setShow("无牌车/禁止通行");
                    carEnexResponse.setSay("禁止通行");
                }
                break;
        }
        //机器人屏显语音下发
        String show = carEnexResponse.getShow();
        String say = carEnexResponse.getSay();
        downOtherDeviceHint(enterRequest, show, say, param, resultCode);

        //如果不允许放行，则单独保存入场记录
        if (carEnexResponse.getOpenFlag().equals(FlowCondition.YES)) {
            String orderNum = normalEnter(enterRequest, paramHolder, parkCode, channelCode);
            carEnexResponse.setOrderNum(orderNum);
        } else {
            if (NumberUtils.toPrimitive(paramHolder.getParkConfig().getDeniedAddOrder()) == 1) {
                if (!DataCommonConstants.isNoPlate(enterRequest.getPlateNum())) {
                    String orderNum = normalEnter(enterRequest, paramHolder, parkCode, channelCode);
                    if (StringUtils.isNotBlank(orderNum)) {
                        enterRequest.setAddedOrder(true);
                        enterRequest.setOrderNum(orderNum);
                    }
                    log.info("[端云-入场事件] 无权限车辆保存入场记录, 参数[{}]", enterRequest);
                }
            } else {
                log.info("[端云-入场事件] 单独保存入场记录至缓存, 参数[{}]", enterRequest);
                carEnexResponse.setOrderNum(enterRequest.getOrderNum());
            }
            cacheHandle.setEntrance(parkCode, channelCode, enterRequest);
        }
        //本地坐席消息发布,不允许抬杆的在此处理，允许抬杆的在cloudcenter
        if (carEnexResponse.getOpenFlag().equals(FlowCondition.NO)) {
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> carOrderEnterService.sendWebsocketMessage(enterRequest, carEnexResponse.getOpenFlag())));
        }
        //定制功能-空车位数下发
        spaceDown(enterRequest, carEnexResponse, paramHolder);
        return carEnexResponse;
    }
}
