package com.icetech.park.service.report.p2c.impl.enter;

import com.alibaba.fastjson.TypeReference;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.park.domain.entity.ShamPlate;
import com.icetech.order.service.ShamPlateService;
import com.icetech.park.domain.dto.TagsDto;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.park.mongo.document.EnterRecord;
import com.icetech.park.service.order.impl.enter.CarOrderEnterServiceImpl;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.ShowTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChannelRulesServiceImpl;
import com.icetech.park.service.down.p2c.impl.FreeSpaceServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.down.p2r.impl.HintServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.handle.showsay.ShowSayConstants;
import com.icetech.park.service.record.EnterRecordService;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 通用入场处理流程
 */
@Component
@Slf4j
public class CarEnterBaseHandler extends FlowCondition{

    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected CommonShowHandle commonShowHandle;
    @Autowired
    protected CommonSayHandle commonSayHandle;
    @Autowired
    protected HintServiceImpl robotHintService;
    @Autowired
    protected CarOrderEnterServiceImpl carOrderEnterService;
    @Autowired
    protected ChannelRulesServiceImpl channelRulesService;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected FreeSpaceServiceImpl freeSpaceService;
    @Autowired
    protected ParkService parkService;
    @Value("${web.url}")
    private String webUrl;
    @Resource
    private EnterRecordService enterRecordService;
    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    protected ItcCacheHandle itcCacheHandle;
    @Autowired
    protected ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    protected ItcHintServiceImpl itcHintService;
    @Autowired
    private SoftTriggerServiceImpl softTriggerService;
    @Autowired
    private ShamPlateService shamPlateService;

    /**
     * 保存入场记录
     * @param enterRequest 入场参数
     */
    public void addEnterRecord(CarEnterRequest enterRequest) {
        EnterRecord record = new EnterRecord();
        BeanUtils.copyProperties(enterRequest, record);
        record.setChannelId(enterRequest.getInandoutCode());
        record.setEnterNo(enterRequest.getInandoutName());
        record.setImage(enterRequest.getMaxImage());
        enterRecordService.saveRecordAsync(record);
    }

    /**
     * 软触发处理
     *
     * @param enterRequest 入场参数
     * @return 订单号
     */
    protected String dealSoftTrigger(CarEnterRequest enterRequest) {
        String triggerNo = enterRequest.getTriggerNo();
        enterRequest.setOrderNum(enterRequest.getOrderNum());
        cacheHandle.setSoftImage(triggerNo, enterRequest.getMaxImage());
        String messageId = redisUtils.get(RedisConstants.MESSAGE_ID_TRIGGER_NO + triggerNo, String.class);
        if (messageId != null) {
            SendInfoRecord<SoftTriggerRequest> sendInfoRecord = redisUtils.get(RedisKeyConstants.MQ_RECORD_PREFIX + messageId,
                    new TypeReference<SendInfoRecord<SoftTriggerRequest>>(){});
            softTriggerService.notify(triggerNo, enterRequest, sendInfoRecord);
        }
        log.info("[端云-入场事件] 软触发接口返回，triggerNo：{}，响应的orderNum为：{}", triggerNo, enterRequest.getOrderNum());
        return enterRequest.getOrderNum();
    }

    protected void dealShamePlate(CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        if (DataCommonConstants.isNoPlate(enterRequest.getPlateNum())) {
            return;
        }
        Long parkId = enterRequest.getParkId();
        String channelCode = enterRequest.getInandoutCode();
        String parkCode = enterRequest.getParkCode();
        ShamPlate shamPlate = new ShamPlate();
        shamPlate.setParkId(parkId);
        shamPlate.setPlateNum(enterRequest.getPlateNum());
        ObjectResponse<PlateTypeDto> objectResponse =
                orderService.getPlateType(parkId, enterRequest.getPlateNum(), paramHolder.getParkChannel().getRegionId());
        shamPlate.setType(objectResponse.getData().getPlateTypeEnum().getType());
        enterRequest.setType(objectResponse.getData().getPlateTypeEnum().getType());
        shamPlate.setExType(1);
        shamPlate.setCarImage(enterRequest.getMaxImage());
        shamPlate.setAlarmTime(new Date(enterRequest.getEnterTime() * 1000));
        shamPlate.setChannelCode(enterRequest.getInandoutCode());
        shamPlate.setChannelName(enterRequest.getInandoutName());
        shamPlate.setOrderNum(enterRequest.getOrderNum());
        CarEnterRequest lastEntrance = cacheHandle.getEntrance(parkCode, channelCode);
        if (lastEntrance != null && !enterRequest.getPlateNum().equals(lastEntrance.getPlateNum())) {
            shamPlate.setRelCarImage(lastEntrance.getMaxImage());
            shamPlate.setRelPlateNum(lastEntrance.getPlateNum());
        }
        if (NumberUtils.toPrimitive(paramHolder.getParkConfig().getDeniedAddOrder()) == 1) {
            List<TagsDto> tagsDtos = new ArrayList<>();
            TagsDto tagsDto = TagsDto.builder().tagId(OrderTags.TagIdEnum.SHAM_PLATE.getType()).build();
            tagsDtos.add(tagsDto);
            enterRequest.setTags(tagsDtos);
            String orderNum = normalEnter(enterRequest, paramHolder, enterRequest.getParkCode(), channelCode);
            if (StringUtils.isNotBlank(orderNum)) {
                enterRequest.setAddedOrder(true);
            }
        }
        shamPlateService.addShamPlate(shamPlate);
    }

    /**
     * 下发其他设备屏显语音
     *
     * @param enterRequest 入场参数
     * @param resultCode 处理结果
     */
    @Async
    protected void downOtherDeviceHint(CarEnterRequest enterRequest, String show, String say,
                                       Map<String, Object> param, ResultCode resultCode) {
        Long parkId = enterRequest.getParkId();
        String parkCode = enterRequest.getParkCode();
        String channelCode = enterRequest.getInandoutCode();
        String serialNumber = cacheHandle.getChannelRobot(parkCode, channelCode);
        if (serialNumber != null) {
            RobotHintRequest robotHintRequest = new RobotHintRequest();
            robotHintRequest.setPlateNum(enterRequest.getPlateNum());
            robotHintRequest.setShow(show);
            robotHintRequest.setSay(say);
            robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
        }
        String itcSn = itcCacheHandle.getSerialNumber(parkCode, channelCode);
        if (itcSn != null) {
            ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(parkId, channelCode);
            ParkInoutdevice channel = channelResp.getData();
            HintRequest itcHintRequest = HintRequest.builder()
                    .scene(showSayBaseHandle.getSceneByResultCode(resultCode, 1))
                    .plateNum(enterRequest.getPlateNum())
                    .type(showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), enterRequest.getPlateNum(), enterRequest.getType(), param))
                    .freeSpace(showSayBaseHandle.getFreeSpace(parkId, channel.getId(), param))
                    .remainDaysMc(showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), enterRequest.getPlateNum(), param))
                    .build();
            if (PlateTypeEnum.VIP车辆.getType().equals(itcHintRequest.getType())) {
                itcHintRequest.setVipTypeName((String) param.get("carDesc"));
            }
            if (HintRequest.Scene.NO_PLATE_ENTER.getVal() == itcHintRequest.getScene()
                    || HintRequest.Scene.NEED_PAY_EXIT.getVal() == itcHintRequest.getScene()) {
                itcHintRequest.setQrCodeUrl(webUrl + "/noplate/enter/index?parkCode=" + parkCode + "&channelId=" + channelCode);
            }
            itcHintService.execute(parkId, itcSn, itcHintRequest);
        }
    }
    /**
     * 下发空车位
     *
     * @param enterRequest 入场参数
     */
    @Async
    protected void spaceDown(CarEnterRequest enterRequest,CarEnexResponse carEnexResponse, ReportParamHolder paramHolder) {
        String parkCode = enterRequest.getParkCode();
        Integer triggerType = enterRequest.getTriggerType();
        if (paramHolder.getVersionIndex() < P2cVersionEnum.版本3.getIndex()){

            //定制车场：荣锦苑一号和得实车场
            String specialParkCode = "P1576060397,P1562641618";
            String ledSpecialParkCode = "P1574734634";
            /*
             * 定制功能处理，第四行显示空车位
             */
            if ((specialParkCode.contains(parkCode) || ledSpecialParkCode.contains(parkCode)) && !triggerType.equals(TriggerTypeEnum.软触发.getVal())) {
                /*
                 * 如果相机已经开闸，第一行显示车牌号
                 */
                String show = carEnexResponse.getShow();
                if (enterRequest.getOpenFlag().equals(FlowCondition.YES)) {
                    show = enterRequest.getPlateNum();
                }
                ParkFreespace parkFreespace = paramHolder.getParkFreeSpace();
                if (parkFreespace != null) {
                    show = LedShowHandle.complement4Rows(show, "" + parkFreespace.getFreeSpace());
                    carEnexResponse.setShow(show);
                }
            }
        }
    }

    /**
     * 普通入场流程
     *
     * @param enterRequest 入场参数
     * @param parkCode 车场编号
     * @param channelId 通道编号
     * @return 订单号
     */
    public String normalEnter(CarEnterRequest enterRequest, ReportParamHolder paramHolder, String parkCode, String channelId) {
        enterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM);
        ObjectResponse<CarEnterResult> objectResponse = carOrderEnterService.enter(enterRequest, paramHolder);
        if (objectResponse != null && objectResponse.getCode().equals(CodeConstants.SUCCESS)) {
            //清除缓存中的上次异常记录
            cacheHandle.removeEntrace(parkCode, channelId);
            //构建返回结果
            CarEnterResult data = objectResponse.getData();
            return data.getOrderNum();
        } else {
            return null;
        }
    }

    /**
     * 设置自定义语音屏显内容
     *
     * @param enterRequest 入场请求参数
     * @param paramHolder 公共参数集合
     * @param carEnexResponse 响应
     * @param para 参数map
     * @param resultCode 处理结果
     */
    protected void setCustomShowSay(CarEnterRequest enterRequest, ReportParamHolder paramHolder, CarEnexResponse carEnexResponse, Map<String, Object> para, FlowCondition.ResultCode resultCode) {
        Long parkId = enterRequest.getParkId();
        ParkInoutdevice parkChannel = paramHolder.getParkChannel();
        Integer ledLcdSource = parkChannel.getLedLcdSource();
        carEnexResponse.setShowDeviceType(ledLcdSource);

        if (para == null){
            para = new HashMap<>();
        }
        ParkInoutdevice channel = paramHolder.getParkChannel();
        para.put("regionId", channel.getRegionId());
        para.put("enexType", 1);
        para.put("channelCode", enterRequest.getInandoutCode());
        String show = commonShowHandle.enter(parkId, channel.getId(), enterRequest.getPlateNum(), enterRequest.getType(), resultCode, para, ledLcdSource);
        String say = commonSayHandle.enter(parkId, channel.getId(), enterRequest.getPlateNum(), enterRequest.getType(), resultCode, para, ledLcdSource);
        carEnexResponse.setShow(show);
        carEnexResponse.setSay(say);
        // LCD
        if (ledLcdSource == 2) {
            if (ShowSayConstants.ENTER_QR_RESULT_LIST.contains(resultCode)) {
                String qrCodeUr = webUrl + "/noplate/enter/index?parkCode=" + enterRequest.getParkCode() + "&channelId=" + enterRequest.getInandoutCode();
                carEnexResponse.setQrCodeUrl(qrCodeUr);
            }
        }else {
            // LED
            carEnexResponse.setShowTypeByShow(show);
            if (carEnexResponse.getShowType() == ShowTypeEnum.动态二维码.getVal() || carEnexResponse.getShowType() == ShowTypeEnum.文本和二维码.getVal()){
                show = commonShowHandle.replacePara(show, new String[]{enterRequest.getParkCode(), enterRequest.getInandoutCode()});
                carEnexResponse.setShow(show);

                if (carEnexResponse.getShowType() == ShowTypeEnum.动态二维码.getVal()) {
                    String extendShow = ledShowHandle.generate4LineContent(parkId, channel.getId(), enterRequest.getPlateNum(), enterRequest.getType(), resultCode, para, LedShow.DisplayTypeEnum.入场显示.type);
                    carEnexResponse.setExtendShow(extendShow);
                }
            }
        }
    }

}
