package com.icetech.park.service.report.p2c.impl;

import java.util.concurrent.ThreadPoolExecutor;

import com.alibaba.fastjson.JSONObject;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.oss.OssService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service("p2cUploadFileServiceImpl")
public class UploadFileServiceImpl extends AbstractService implements CallService<JSONObject, Object> {
    @Autowired
    private OssService ossService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    @Override
    public P2cBaseResponse<Object> execute(TokenDeviceVo deviceToken, P2cBaseRequest<JSONObject> baseRequest) {
        JSONObject bizContent = baseRequest.getBizContent();
        Integer fileStatus = bizContent.getInteger("fileStatus");
        if (fileStatus == 1) {
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                String fileName = bizContent.getString("fileName");
                ossService.uploadBase64(bizContent.getString("base64Str"), fileName);
                log.info("<端云-文件上传接口> 文件上传完成，文件名：{}", fileName);
            }));
        }
        return P2cBaseResponse.success(baseRequest);
    }
}
