package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.domain.request.RetentionCarRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2cRetentionCarServiceImpl")
@Slf4j
public class RetentionCarServiceImpl extends AbstractService implements CallService<RetentionCarRequest, Void> {

    @Autowired
    private AlarmService alarmService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RetentionCarRequest> baseRequest) {
        RetentionCarRequest retentionCarRequest = baseRequest.getBizContent();

        //参数校验
        verifyParams(retentionCarRequest);

        AisleInfoVo aisleInfoVo = new AisleInfoVo();
        aisleInfoVo.setParkCode(deviceToken.getParkCode());
        aisleInfoVo.setParkId(deviceToken.getParkId());
        aisleInfoVo.setAisleType(deviceToken.getInandoutType());
        aisleInfoVo.setAisleCode(deviceToken.getInandoutCode());
        alarmService.aisleDurationAlarm(aisleInfoVo);

        return P2cBaseResponse.success(baseRequest);
    }
}
