package com.icetech.park.service.report.p2c.impl;

import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.cloudcenter.domain.request.RetentionCarLeaveRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service("p2cRetentionCarLeaveServiceImpl")
@Slf4j
public class RetentionCarLeaveServiceImpl extends AbstractService implements CallService<RetentionCarLeaveRequest, Void> {

    @Resource
    private ChannelAlarmDao channelAlarmDao;
    @Resource
    private CacheHandle cacheHandle;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RetentionCarLeaveRequest> baseRequest) {
        RetentionCarLeaveRequest retentionCarLeaveRequest = baseRequest.getBizContent();

        //参数校验
        verifyParams(retentionCarLeaveRequest);

        ChannelAlarm channelAlarm = new ChannelAlarm();
        channelAlarm.setParkId(deviceToken.getParkId());
        channelAlarm.setChannelCode(deviceToken.getInandoutCode());
        channelAlarm.setStatus(ChannelAlarm.Status.已处理.getStatus());
        channelAlarmDao.update(channelAlarm);

        //清除缓存中的上次异常记录
        cacheHandle.removeExit(deviceToken.getParkCode(), deviceToken.getInandoutCode());
        cacheHandle.removeChannelFee(deviceToken.getParkCode(), deviceToken.getInandoutCode());

        return P2cBaseResponse.success(baseRequest);
    }
}
