package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.dao.RemotePayDao;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.park.domain.entity.RemotePay;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteExitRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.report.CallService;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service("p2cRemoteExitServiceImpl")
public class RemoteExitServiceImpl extends AbstractService implements CallService<RemoteExitRequest, Void> {

    @Autowired
    private CarOrderExitService carOrderExitService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private HintServiceImpl hintService;
    @Autowired
    private RemotePayDao remotePayDao;
    private static final String specialParkCode = "P1562641618";
    private static final String EXIT_MONEY_OPEN = "exit_money_open";
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ItcHintServiceImpl itcHintService;
    @Autowired
    private com.icetech.park.service.down.p2r.impl.HintServiceImpl robotHintService;
    @Autowired
    private CommonSayHandle commonSayHandle;
    @Autowired
    private CommonShowHandle commonShowHandle;
    @Autowired
    private RedisUtils redisUtils;

    private static final String REDIS_KEY_LOCK_PREFIX = "camera:report:remotexit:";
    private static final long REDIS_KEY_LOCK_TIMEOUT = 10000;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RemoteExitRequest> baseRequest) {
        Long parkId = deviceToken.getParkId();
        String parkCode = deviceToken.getParkCode();
        String inandoutCode = deviceToken.getInandoutCode();
        String inandoutName = deviceToken.getInandoutName();
        String sn = deviceToken.getDeviceNo();
        RemoteExitRequest remoteExitRequest = baseRequest.getBizContent();

        //参数校验
        verifyParams(remoteExitRequest);
        //扩展参数设置
        remoteExitRequest.setParkId(parkId);
        remoteExitRequest.setParkCode(parkCode);
        remoteExitRequest.setInandoutCode(inandoutCode);
        remoteExitRequest.setInandoutName(inandoutName);

        String lockKey = REDIS_KEY_LOCK_PREFIX + deviceToken.getInandoutCode();
        boolean lock = redisUtils.tryLock(lockKey, baseRequest.getMessageId(), REDIS_KEY_LOCK_TIMEOUT);
        if (!lock) {
            P2cBaseResponse<Void> p2cBaseResponse = new P2cBaseResponse<>();
            p2cBaseResponse.setMessageId(baseRequest.getMessageId());
            p2cBaseResponse.setCmd(baseRequest.getCmd() + CMD_SUFFIX);
            p2cBaseResponse.setCode(CodeEnum.请求重复.getCode());
            p2cBaseResponse.setMsg("正在处理中");
            return p2cBaseResponse;
        }
        try {
            String plateNum = remoteExitRequest.getPlateNum();
            CarExitRequest cacheExit = cacheHandle.getExit(parkCode, inandoutCode);
            boolean hasCache = cacheExit != null;
            cacheExit = (hasCache ? cacheExit : new CarExitRequest());
            //如果上报的大图为空，则使用云平台缓存中的大图，缓存中没有大图时，用实时图片
            if (StringUtils.isBlank(remoteExitRequest.getMaxImage())) {
                String cacheMaxImage = hasCache ? cacheExit.getMaxImage() : null;
                remoteExitRequest.setMaxImage(cacheMaxImage == null ? remoteExitRequest.getRealImage() : cacheExit.getMaxImage());
            }
            //不管有没有缓存，先把订单号赋给当前参数实体，可避免重复记录出场记录
            remoteExitRequest.setOrderNum(cacheExit.getOrderNum());
            OrderInfo orderInfo = null;
            boolean currPlateNum = true;
            //如果当前车牌无效，则取缓存中车牌
            if (DataCommonConstants.isNoPlate(plateNum)) {
                if (hasCache && !DataCommonConstants.isNoPlate(cacheExit.getPlateNum())) {
                    plateNum = cacheExit.getPlateNum();
                    currPlateNum = false;
                }
            }
            if (!DataCommonConstants.isNoPlate(plateNum)) {
                orderInfo = findOrder(parkCode, parkId, inandoutCode, plateNum, cacheExit, hasCache);
                if (orderInfo != null) {
                    remoteExitRequest.setOrderNum(orderInfo.getOrderNum());
                    remoteExitRequest.setPlateNum(orderInfo.getPlateNum());
                    remoteExitRequest.setType(orderInfo.getType());
                    carExit(parkId, parkCode, inandoutCode, remoteExitRequest, plateNum, orderInfo, currPlateNum,
                            cacheExit, inandoutName, sn);
                }
            }
            cacheHandle.removeExit(parkCode, inandoutCode);
            //记录遥控器开闸记录
            OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
            openingDtoRequest.setRecordType(2);
            openingDtoRequest.setParkCode(parkCode);
            openingDtoRequest.setPlateNum(plateNum);
            openingDtoRequest.setExecuteTime(remoteExitRequest.getOpenTime());
            openingDtoRequest.setImgUrl((cacheExit.getMaxImage() == null ? "" : (cacheExit.getMaxImage() + ",")) + remoteExitRequest.getRealImage());
            openingDtoRequest.setAisleCode(inandoutCode);
            int oddStatus = OrderOddStatusEnum.其他.getVal();
            if (!EXIT_MONEY_OPEN.equals(remoteExitRequest.getRemoteCode()) && orderInfo != null
                    && NumberUtils.toPrimitive(orderInfo.getNoneEnterFlag()) == 1) {
                oddStatus = OrderOddStatusEnum.未找到入场记录.getVal();
            }
            if (orderInfo == null && hasCache) {
                oddStatus = OrderOddStatusEnum.未找到入场记录.getVal();
            }
            openingDtoRequest.setReasonType(oddStatus);
            openingDtoRequest.setSourcegate(3);
            openingDtoRequest.setOrderNum(orderInfo == null ? null : orderInfo.getOrderNum());
            ObjectResponse<Integer> objectResponse = parkService.saveOpeningRecord(openingDtoRequest);
            if (!ObjectResponse.isSuccess(objectResponse)) {
                log.info("<遥控器出场开闸> 保存开闸记录失败，原因：{}", objectResponse.getMsg());
            }
            return P2cBaseResponse.success(baseRequest);
        } finally {
            redisUtils.releaseLock(lockKey);
        }
    }

    private OrderInfo findOrder(String parkCode, Long parkId, String inandoutCode, String plateNum, CarExitRequest cacheExit, boolean hasCache) {
        OrderInfo orderInfo = null;
        //判断车辆是否在场内
        ObjectResponse<OrderInfo> inPark = orderService.findInPark(plateNum, parkCode);
        if (ObjectResponse.isSuccess(inPark)) {
            orderInfo = inPark.getData();
        } else {
            if (hasCache) {
                ObjectResponse<OrderInfo> infoObjectResponse = orderService.findByOrderNum(cacheExit.getOrderNum());
                if (ObjectResponse.isSuccess(infoObjectResponse)) {
                    orderInfo = infoObjectResponse.getData();
                }
            } else {
                //按模糊规则查询场内车辆
                inPark = orderService.fuzzyPlate(parkId, inandoutCode, plateNum);
                if (ObjectResponse.isSuccess(inPark)) {
                    orderInfo = inPark.getData();
                    log.info("离场车牌：{}, 模糊匹配到车牌：{}", plateNum, orderInfo.getPlateNum());
                }
            }
        }
        return orderInfo;
    }

    private void carExit(Long parkId, String parkCode, String inandoutCode, RemoteExitRequest remoteExitRequest, String plateNum, OrderInfo orderInfo,
                         boolean currPlateNum, CarExitRequest cacheExit, String inandoutName, String sn) {
        if (orderInfo == null) {
            throw new ResponseBodyException(CodeConstants.ERROR_400, "订单不能为空");
        }
        QueryOrderFeeResponse orderFee = cacheHandle.getChannelFee(parkCode, inandoutCode);
        log.info("<缓存获取费用>车场：{}，车牌号：{}，费用：{}", parkCode, plateNum, orderFee);
        if (orderFee == null || !orderFee.getPlateNum().equals(plateNum)) {
            log.info("<重新计费>车场：{}，车牌号：{}", parkCode, plateNum);
            QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
            queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
            queryOrderFeeRequest.setParkCode(parkCode);
            queryOrderFeeRequest.setPlateNum(plateNum);
            ObjectResponse<QueryOrderFeeResponse> queryOrderFeeResponseObjectResponse = orderService.p2cQueryFee(queryOrderFeeRequest);

            if (ObjectResponse.isSuccess(queryOrderFeeResponseObjectResponse)) {
                orderFee = queryOrderFeeResponseObjectResponse.getData();
            }
        }
        boolean isException = false;
        Integer oddStatus = OrderOddStatusEnum.其他.getVal();
        if (orderFee != null) {
            float unpayPrice = Float.parseFloat(orderFee.getUnpayPrice());
            //现金缴费抬杆
            if (unpayPrice > 0) {
                if (EXIT_MONEY_OPEN.equals(remoteExitRequest.getRemoteCode())) {
                    OrderPay orderPay = new OrderPay();
                    orderPay.setParkId(parkId);
                    orderPay.setOrderNum(orderInfo.getOrderNum());
                    orderPay.setTradeNo(CodeTools.GenerateTradeNo());
                    orderPay.setPayDate(new Date());
                    orderPay.setPayTime(DateTools.unixTimestamp());
                    orderPay.setOrderTime(cacheExit != null && cacheExit.getExitTime() != null ? cacheExit.getExitTime() : DateTools.unixTimestamp());
                    orderPay.setTotalPrice(NumberUtils.decimalAdd(orderFee.getUnpayPrice(), orderFee.getDiscountPrice()).toString());
                    orderPay.setPaidPrice(orderFee.getUnpayPrice());
                    orderPay.setDiscountPrice(orderFee.getDiscountPrice());
                    orderPay.setPayChannel(10);//遥控器缴费
                    orderPay.setPayTerminal(inandoutName);
                    orderPay.setPayWay(1);
                    orderPay.setChannelId(inandoutCode);
                    orderPay.setIsSync(0);
                    orderPay.setPayStatus(2);
                    ObjectResponse<Long> objectResponse = orderPayService.addOrderPay(orderPay);
                    if (!ObjectResponse.isSuccess(objectResponse)) {
                        log.info("<遥控器出口开闸> 保存现金交易失败，参数：{}，返回：{}", orderPay, objectResponse);
                    }
                    //记录现金缴费记录
                    RemotePay remotePay = new RemotePay();
                    BeanUtils.copyProperties(orderPay, remotePay);
                    remotePayDao.insert(remotePay);
                } else {
                    isException = true;
                    if (NumberUtils.toPrimitive(orderInfo.getNoneEnterFlag()) == 1) {
                        oddStatus = OrderOddStatusEnum.未找到入场记录.getVal();
                    }
                }
            }
        }
        //离场操作
        CarExitRequest carExitRequest = new CarExitRequest();
        if (currPlateNum) {
            BeanUtils.copyProperties(remoteExitRequest, carExitRequest);
            carExitRequest.setExitTime(remoteExitRequest.getOpenTime());
        } else {
            if (cacheExit != null && cacheExit.getPlateNum() != null) {
                BeanUtils.copyProperties(cacheExit, carExitRequest);
            } else {
                BeanUtils.copyProperties(remoteExitRequest, carExitRequest);
                carExitRequest.setExitTime(remoteExitRequest.getOpenTime());
            }
        }
        if (isException) {
            carExitRequest.setTotalAmount(orderFee.getTotalAmount());
            carExitRequest.setPaidAmount(orderFee.getPaidAmount());
            //String discountPrice = NumberUtils.decimalAdd(orderFee.getDiscountPrice(), orderFee.getDiscountAmount()).toString();
            carExitRequest.setDiscountAmount(orderFee.getDiscountAmount());
        }
        normalExit(carExitRequest, parkCode, inandoutCode, isException, cacheExit, oddStatus);
        /*
         * 机器人屏显语音下发
         */
        String robotSerialNumber = cacheHandle.getChannelRobot(parkCode, inandoutCode);
        String itcSn = itcCacheHandle.getSerialNumber(parkCode, inandoutCode);
        if (robotSerialNumber != null || itcSn != null) {
            TokenDeviceVo robotDeviceInfo = cacheHandle.getRobotDeviceInfo(robotSerialNumber);
            ObjectResponse<PlateTypeDto> plateTypeDtoObjectResponse =
                    orderService.getPlateType(parkId, plateNum, robotDeviceInfo == null ? null : robotDeviceInfo.getRegionId());
            PlateTypeDto plateTypeDto = plateTypeDtoObjectResponse.getData();
            remoteExitRequest.setType(plateTypeDto.getPlateTypeEnum().getType());
            FlowCondition.ResultCode resultCode;
            if (plateTypeDto.getPlateTypeEnum().equals(PlateTypeEnum.月卡车)) {
                resultCode = FlowCondition.ResultCode.月卡车;
            } else {
                resultCode = FlowCondition.ResultCode.无需缴费;
            }
            TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(sn);
            Map<String, Object> para = new HashMap<>();
            para.put("orderNum", orderInfo.getOrderNum());
            if (tokenDeviceVo != null) {
                para.put("regionId", tokenDeviceVo.getRegionId());
            }
            ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(parkId, inandoutCode);
            ParkInoutdevice channel = channelResp.getData();
            if (robotSerialNumber != null) {
                String show = commonShowHandle.exit(parkId, channel.getId(), plateNum, orderInfo.getType(), resultCode, para);
                String say = commonSayHandle.exit(parkId, channel.getId(), plateNum, orderInfo.getType(), resultCode, para);
                RobotHintRequest robotHintRequest = new RobotHintRequest();
                robotHintRequest.setPlateNum(plateNum);
                robotHintRequest.setShow(show);
                robotHintRequest.setSay(say);
                robotHintService.executeDown(parkId, robotSerialNumber, robotHintRequest);
            }
            if (itcSn != null) {
                com.icetech.cloudcenter.domain.request.itc.HintRequest itcHintRequest =
                        com.icetech.cloudcenter.domain.request.itc.HintRequest.builder()
                        .scene(showSayBaseHandle.getSceneByResultCode(resultCode, 2))
                        .plateNum(plateNum)
                        .type(showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), plateNum, remoteExitRequest.getType(), para))
                        .freeSpace(showSayBaseHandle.getFreeSpace(parkId, channel.getId(), para))
                        .remainDaysMc(showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), plateNum, para))
                        .unpayPrice(para.get("fee") == null ? null : (int) (Float.parseFloat((String) para.get("fee")) * 100))
                        .parkTime(para.get("parkTime") == null
                                ? remoteExitRequest.getOpenTime() - orderInfo.getEnterTime() : (Long)para.get("parkTime"))
                        .build();
                if (PlateTypeEnum.VIP车辆.getType().equals(itcHintRequest.getType())) {
                    itcHintRequest.setVipTypeName((String) para.get("carDesc"));
                }
                itcHintService.execute(parkId, itcSn, itcHintRequest);
            }
        }

    }

    private void showFreeSpace(Long parkId, String parkCode, String plateNum) {
        /*
         * 定制功能：指定车场四行屏显示空车位
         */
        if (specialParkCode.contains(parkCode)) {
            log.info("进入定制车场，parkId：{}", parkId);
            ObjectResponse<ParkFreespace> parkFreespaceObjectResponse = parkService.getParkSpace(parkId);
            log.info("查询空车位，parkFreespaceObjectResponse：{}", parkFreespaceObjectResponse);
            if (ObjectResponse.isSuccess(parkFreespaceObjectResponse)) {
                String show = LedShowHandle.complement4Rows("" + parkFreespaceObjectResponse.getData().getFreeSpace());
                HintRequest hintRequest = new HintRequest();
                hintRequest.setShow(show);
                hintRequest.setPlateNum(plateNum);
                ObjectResponse<Void> response = hintService.executeSendEnter(parkId, parkCode, hintRequest);
                if (!ObjectResponse.isSuccess(response)) {
                    log.info("离场更新入口屏显的空车位失败，离场车牌号：{}", plateNum);
                }
            }
        }
    }

    public void normalExit(CarExitRequest exitRequest, String parkCode, String channelId, boolean isException, CarExitRequest cacheExit, Integer oddStatus) {
        ObjectResponse<Map<String, Object>> objectResponse;
        exitRequest.setOpenFlag(1);
        exitRequest.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_REMOTE_CONTROL);
        if (cacheExit != null && cacheExit.getExitTime() != null) {
            exitRequest.setExitTime(cacheExit.getExitTime());
        }
        if (isException) {
            objectResponse = carOrderExitService.exceptionExit(exitRequest, oddStatus);
        } else {
            objectResponse = carOrderExitService.exit(exitRequest);
        }
        if (ObjectResponse.isSuccess(objectResponse)) {
            //清除缓存中的上次异常记录
            cacheHandle.removeExit(parkCode, channelId);
            cacheHandle.removeChannelFee(parkCode, channelId);

            //定制功能，显示空车位
            showFreeSpace(exitRequest.getParkId(), parkCode, exitRequest.getPlateNum());
        } else {
            log.info("<遥控器出口开闸> 离场失败，参数：{}，返回：{}", exitRequest, objectResponse);
        }
    }

}
