package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteEnterRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.report.CallService;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service("p2cRemoteEnterServiceImpl")
@Slf4j
public class RemoteEnterServiceImpl extends AbstractService implements CallService<RemoteEnterRequest, Void> {
    @Autowired
    private CarOrderEnterService carOrderEnterService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private HintServiceImpl hintService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ItcHintServiceImpl itcHintService;
    @Autowired
    private RedisUtils redisUtils;
    private static final String REDIS_KEY_LOCK_PREFIX = "camera:report:remotenter:";
    private static final long REDIS_KEY_LOCK_TIMEOUT = 10000;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RemoteEnterRequest> baseRequest) {
        Long parkId = deviceToken.getParkId();
        String parkCode = deviceToken.getParkCode();
        String serialNumber = deviceToken.getDeviceNo();
        String inandoutCode = deviceToken.getInandoutCode();
        String inandoutName = deviceToken.getInandoutName();
        RemoteEnterRequest remoteEnterRequest = baseRequest.getBizContent();

        //参数校验
        verifyParams(remoteEnterRequest);

        String lockKey = REDIS_KEY_LOCK_PREFIX + deviceToken.getInandoutCode();
        boolean lock = redisUtils.tryLock(lockKey, baseRequest.getMessageId(), REDIS_KEY_LOCK_TIMEOUT);
        if (!lock) {
            P2cBaseResponse<Void> p2cBaseResponse = new P2cBaseResponse<>();
            p2cBaseResponse.setMessageId(baseRequest.getMessageId());
            p2cBaseResponse.setCmd(baseRequest.getCmd() + CMD_SUFFIX);
            p2cBaseResponse.setCode(CodeEnum.请求重复.getCode());
            p2cBaseResponse.setMsg("正在处理中");
            return p2cBaseResponse;
        }
        try {
            //扩展参数设置
            remoteEnterRequest.setParkId(parkId);
            remoteEnterRequest.setParkCode(parkCode);
            remoteEnterRequest.setInandoutCode(inandoutCode);
            remoteEnterRequest.setInandoutName(inandoutName);

            String plateNum = remoteEnterRequest.getPlateNum();
            CarEnterRequest entrace = cacheHandle.getEntrance(parkCode, inandoutCode);
            boolean hasCache = entrace != null;
            entrace = (hasCache ? entrace : new CarEnterRequest());
            String orderNum = entrace.getOrderNum();
            //如果上报的大图为空，则使用云平台缓存中的大图，缓存中没有大图时，用实时图片
            if (StringUtils.isBlank(remoteEnterRequest.getMaxImage())) {
                String cacheMaxImage = entrace.getMaxImage();
                remoteEnterRequest.setMaxImage(cacheMaxImage == null ? remoteEnterRequest.getRealImage() : cacheMaxImage);
            }
            //不管有没有缓存，先把订单号赋给当前参数实体，可避免重复记录入场记录
            remoteEnterRequest.setOrderNum(entrace.getOrderNum());

            if (!DataCommonConstants.isNoPlate(plateNum)) {//当前开闸车牌有效
                CarEnterRequest carEnterRequest = new CarEnterRequest();
                BeanUtils.copyProperties(remoteEnterRequest, carEnterRequest);
                carEnterRequest.setEnterTime(remoteEnterRequest.getOpenTime());
                orderNum = normalEnter(carEnterRequest, parkCode, inandoutCode);
            } else {
                //缓存车牌是否有效
                boolean isCachePlateValid = false;
                if (hasCache) {
                    String cachePlateNum = entrace.getPlateNum();
                    if (!DataCommonConstants.isNoPlate(cachePlateNum)) {//缓存中的车牌有效，则按缓存信息入场
                        isCachePlateValid = true;
                        plateNum = entrace.getPlateNum();
                        orderNum = normalEnter(entrace, parkCode, inandoutCode);
                    }
                }
                if (!isCachePlateValid) {
                    //缓存中车牌也无效或无缓存，则按当前车牌信息入场
                    CarEnterRequest carEnterRequest = new CarEnterRequest();
                    BeanUtils.copyProperties(remoteEnterRequest, carEnterRequest);
                    carEnterRequest.setEnterTime(remoteEnterRequest.getOpenTime());
                    orderNum = normalEnter(carEnterRequest, parkCode, inandoutCode);
                }
            }
            cacheHandle.removeEntrace(parkCode, inandoutCode);
            //记录遥控器开闸记录
            OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
            openingDtoRequest.setRecordType(1);
            openingDtoRequest.setParkCode(parkCode);
            openingDtoRequest.setPlateNum(plateNum);
            openingDtoRequest.setExecuteTime(remoteEnterRequest.getOpenTime());
            openingDtoRequest.setImgUrl((entrace.getMaxImage() == null ? "" : (entrace.getMaxImage() + ",")) + remoteEnterRequest.getRealImage());
            openingDtoRequest.setAisleCode(inandoutCode);
            openingDtoRequest.setReasonType(99);
            openingDtoRequest.setSourcegate(3);
            openingDtoRequest.setOrderNum(orderNum);
            ObjectResponse<Integer> objectResponse = parkService.saveOpeningRecord(openingDtoRequest);
            if (!ObjectResponse.isSuccess(objectResponse)) {
                log.info("<遥控器入场开闸> 保存开闸记录失败，原因：{}", objectResponse.getMsg());
            }

            String specialParkCode = "P1562641618";
            /*
             * 定制功能处理，第四行显示空车位
             */
            if (specialParkCode.contains(parkCode)) {
                /*
                 * 如果相机已经开闸，第一行显示车牌号
                 */
                String show = DataCommonConstants.isNoPlate(plateNum) ? null : plateNum;
                ObjectResponse<ParkFreespace> parkFreespaceObjectResponse = parkService.getParkSpace(parkId);
                if (ObjectResponse.isSuccess(parkFreespaceObjectResponse)) {
                    show = LedShowHandle.complement4Rows(show == null ? "欢迎光临" : show + "/欢迎光临", "" + parkFreespaceObjectResponse.getData().getFreeSpace());
                    HintRequest hintRequest = new HintRequest();
                    hintRequest.setShow(show);
                    hintRequest.setPlateNum(plateNum);
                    hintService.showAndSay(parkId, parkCode, serialNumber, hintRequest);
                    log.info("<遥控器入场开闸> 屏显更新为：{}", show);
                }
            }
            /*
             * 屏显语音下发
             */
            String robotSerialNumber = cacheHandle.getChannelRobot(parkCode, inandoutCode);
            String itcSn = itcCacheHandle.getSerialNumber(parkCode, inandoutCode);
            if (robotSerialNumber != null || itcSn != null) {
                ObjectResponse<PlateTypeDto> plateTypeDtoObjectResponse = orderService.getPlateType(parkId, plateNum, deviceToken.getRegionId());
                PlateTypeDto plateTypeDto = plateTypeDtoObjectResponse.getData();
                remoteEnterRequest.setType(plateTypeDto.getPlateTypeEnum().getType());
                Map<String, Object> para = new HashMap<>();
                para.put("regionId", deviceToken.getRegionId());
                para.put("channelCode", inandoutCode);
                para.put("enexType", 1);
                FlowCondition.ResultCode resultCode;
                if (plateTypeDto.getPlateTypeEnum().equals(PlateTypeEnum.VIP车辆)) {
                    String carDesc = plateTypeDto.getCarDesc();
                    if (carDesc != null) {
                        para.put("carDesc", carDesc);
                    }
                    resultCode = FlowCondition.ResultCode.VIP车辆;
                } else if (plateTypeDto.getPlateTypeEnum().equals(PlateTypeEnum.月卡车)) {
                    resultCode = FlowCondition.ResultCode.月卡车;
                } else if (plateTypeDto.getPlateTypeEnum().equals(PlateTypeEnum.访客车辆)) {
                    resultCode = FlowCondition.ResultCode.访客车;
                } else {
                    resultCode = FlowCondition.ResultCode.有牌车允许临时车进入;
                }
                ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(parkId, inandoutCode);
                ParkInoutdevice channel = channelResp.getData();
                if (robotSerialNumber != null) {
                    String show = commonShowHandle.enter(parkId, channel.getId(), plateNum, plateTypeDto.getPlateTypeEnum().getType(), resultCode, para);
                    String say = commonSayHandle.enter(parkId, channel.getId(), plateNum, plateTypeDto.getPlateTypeEnum().getType(), resultCode, para);
                    RobotHintRequest robotHintRequest = new RobotHintRequest();
                    robotHintRequest.setPlateNum(plateNum);
                    robotHintRequest.setShow(show);
                    robotHintRequest.setSay(say);
                    robotHintService.executeDown(parkId, robotSerialNumber, robotHintRequest);
                }
                if (itcSn != null) {
                    com.icetech.cloudcenter.domain.request.itc.HintRequest itcHintRequest = com.icetech.cloudcenter.domain.request.itc.HintRequest.builder()
                            .scene(showSayBaseHandle.getSceneByResultCode(resultCode, 1))
                            .plateNum(plateNum)
                            .type(showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), plateNum, remoteEnterRequest.getType(), para))
                            .freeSpace(showSayBaseHandle.getFreeSpace(parkId, channel.getId(), para))
                            .remainDaysMc(showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), plateNum, para))
                            .build();
                    if (PlateTypeEnum.VIP车辆.getType().equals(itcHintRequest.getType())) {
                        itcHintRequest.setVipTypeName((String) para.get("carDesc"));
                    }
                    itcHintService.execute(parkId, itcSn, itcHintRequest);
                }
            }
            return P2cBaseResponse.success(baseRequest);
        } finally {
            redisUtils.releaseLock(lockKey);
        }
    }

    @Autowired
    private com.icetech.park.service.down.p2r.impl.HintServiceImpl robotHintService;
    @Autowired
    private CommonSayHandle commonSayHandle;
    @Autowired
    private CommonShowHandle commonShowHandle;
    @Autowired
    private OrderService orderService;

    /**
     * 普通入场
     *
     * @param enterRequest
     * @param parkCode
     * @param channelId
     * @return
     */
    public String normalEnter(CarEnterRequest enterRequest, String parkCode, String channelId) {
        enterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_REMOTE_CONTROL);
        enterRequest.setOpenFlag(1);
        ObjectResponse<CarEnterResult> objectResponse = carOrderEnterService.enter(enterRequest);
        if (ObjectResponse.isSuccess(objectResponse)) {
            //清除缓存中的上次异常记录
            cacheHandle.removeEntrace(parkCode, channelId);

            //构建返回结果
            CarEnterResult data = objectResponse.getData();
            return data.getOrderNum();

        } else {
            log.info("<遥控器入场开闸> 入场失败，请求参数：{}，返回：{}", enterRequest, objectResponse);
            return null;
        }
    }

}
