package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.dao.RemoteCloseDao;
import com.icetech.park.domain.entity.RemoteClose;
import com.icetech.cloudcenter.domain.request.p2c.RemoteCloseRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2cRemoteCloseServiceImpl")
public class RemoteCloseServiceImpl extends AbstractService implements CallService<RemoteCloseRequest, Void> {
    @Autowired
    private RemoteCloseDao remoteCloseDao;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RemoteCloseRequest> baseRequest) {
        RemoteCloseRequest remoteCloseRequest = baseRequest.getBizContent();
        //参数校验
        verifyParams(remoteCloseRequest);
        RemoteClose remoteClose = new RemoteClose();
        remoteClose.setCloseTime(remoteCloseRequest.getCloseTime());
        remoteClose.setCloseType(remoteCloseRequest.getCloseType());
        remoteClose.setParkId(deviceToken.getParkId());
        remoteClose.setInandoutCode(deviceToken.getInandoutCode());
        remoteCloseDao.insert(remoteClose);
        return P2cBaseResponse.success(baseRequest);
    }

}
