package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.domain.request.p2c.P2cDeviceStatusRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2cDeviceStatusServiceImpl")
public class DeviceStatusServiceImpl extends AbstractService implements CallService<P2cDeviceStatusRequest, Void> {
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkDeviceDao parkDeviceDao;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<P2cDeviceStatusRequest> baseRequest) {
        P2cDeviceStatusRequest deviceStatusRequest = baseRequest.getBizContent();
        //参数校验
        verifyParams(deviceStatusRequest);

        Integer workStatus = deviceStatusRequest.getWorkStatus();
        if (workStatus == 2) {
            //对应数据库故障3
            workStatus = 3;
        }
        ParkDevice parkDevice = new ParkDevice();
        parkDevice.setParkId(deviceToken.getParkId());
        parkDevice.setSerialNumber(deviceToken.getDeviceNo());
        parkDevice.setType(1);
        ParkDevice parkDevice1 = parkDeviceDao.selectByParam(parkDevice);

        ObjectResponse<Void> objectResponse = parkDeviceService.modifyStatus(deviceToken.getParkId(), parkDevice1.getDeviceNo(), workStatus, deviceStatusRequest.getExceptionCause(), null);
        ObjectResponse.notError(objectResponse);

        return P2cBaseResponse.success(baseRequest);
    }
}
