package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.park.service.down.p2c.impl.*;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.cloudcenter.domain.request.p2c.ApplyConfigRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.concurrent.ThreadPoolExecutor;

@Service("p2cApplyConfigServiceImpl")
@Slf4j
public class ApplyConfigServiceImpl extends AbstractService implements CallService<ApplyConfigRequest, Void> {

    @Autowired
    private OssConfigServiceImpl ossConfigService;
    @Autowired
    private ChannelRulesServiceImpl channelRulesService;
    @Autowired
    private KeyValueServiceImpl keyValueService;
    @Autowired
    private ChargeRuleServiceImpl chargeRuleService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private LedsoundConfigServiceImpl ledsoundConfigService;
    @Autowired
    private LcdConfigServiceImpl lcdConfigService;
    @Autowired
    private VipTypeServiceImpl vipTypeService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private P2cParkRegionServiceImpl parkRegionService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<ApplyConfigRequest> baseRequest) {
    	ApplyConfigRequest applyConfigRequest = baseRequest.getBizContent();
        //参数校验
        verifyParams(applyConfigRequest);
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            asyncHandle(deviceToken.getParkCode(), deviceToken.getParkId(), deviceToken.getDeviceNo(), deviceToken.getVersion(), applyConfigRequest);
        }));
        return P2cBaseResponse.success(baseRequest);
    }

    private void asyncHandle(String parkCode, Long parkId, String serialNumber, String version, ApplyConfigRequest applyConfigRequest) {
        try {
            String configTypes = applyConfigRequest.getConfigTypes();
            String[] types = configTypes.split(",");
            Arrays.stream(types).forEach(type -> {
                if (Integer.parseInt(type) == 1) {
                    channelRulesService.send(parkCode, serialNumber);
                } else if (Integer.parseInt(type) == 2) {
                    ObjectResponse<ParkDevice> deviceResp = parkDeviceService.getDeviceBySerialNumber(serialNumber);
                    ObjectResponse.notError(deviceResp);
                    ParkDevice device = deviceResp.getData();
                    ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(device.getChannelId().longValue());
                    ObjectResponse.notError(channelResp);
                    ParkInoutdevice channel = channelResp.getData();
                    Integer ledLcdSource = channel.getLedLcdSource();
                    if (NumberUtils.toPrimitive(ledLcdSource) == 2) {
                        lcdConfigService.send(parkCode, channel, serialNumber);
                    } else {
                        ledsoundConfigService.send(parkCode, channel, serialNumber, version);
                    }
                } else if (Integer.parseInt(type) == 3) {
                    //oss配置下发
                    ossConfigService.send(parkCode, serialNumber);
                } else if (Integer.parseInt(type) == 4) {
                    //遥控器键值对下发
                    keyValueService.send(parkCode, serialNumber);
                } else if (Integer.parseInt(type) == 5) {
                    chargeRuleService.send(parkCode, serialNumber, version);
                } else if (Integer.parseInt(type) == 6) {
                    vipTypeService.send(parkId, parkCode, serialNumber, version, applyConfigRequest.getFilter());
                } else if (Integer.parseInt(type) == 7) {
                    parkRegionService.send(parkId, parkCode, serialNumber);
                }
            });
        } catch (ResponseBodyException e) {
            log.warn("[配置下发]被动下发配置失败：{}", e.getMessage());
        }
    }
}
