package com.icetech.park.service.report.p2c.impl;

import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.request.p2c.AckRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.domain.request.P2cBaseRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2cAckServiceImpl")
public class AckServiceImpl extends AbstractService implements CallService<AckRequest, Void> {
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<AckRequest> baseRequest) {
        //保存确认消息10秒
        redisUtils.set(RedisConstants.ACK_PROFILE + baseRequest.getMessageId(), baseRequest.getBizContent(), 10L);
        return null;
    }
}
