package com.icetech.park.service.report.mor.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.icetech.cloudcenter.domain.request.p2c.ApplyConfigRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.Slf4jUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.mor.impl.MorOssConfigServiceImpl;
import com.icetech.park.service.report.CallService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;

@Component
@Slf4j
public class MorApplyConfigServiceImpl extends AbstractService implements CallService<ApplyConfigRequest, Void> {

    @Autowired
    private MorOssConfigServiceImpl ossConfigService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<ApplyConfigRequest> baseRequest) {
    	ApplyConfigRequest applyConfigRequest = baseRequest.getBizContent();
        //参数校验
        verifyParams(applyConfigRequest);

        String traceId = Slf4jUtils.getTraceId();
        ThreadUtil.execute(() -> {
            Slf4jUtils.putTraceIdIfAbsent(traceId);
            asyncHandle(deviceToken.getParkCode(), deviceToken.getDeviceNo(), applyConfigRequest);
        });
        return P2cBaseResponse.success(baseRequest);
    }

    private void asyncHandle(String parkCode, String serialNumber, ApplyConfigRequest applyConfigRequest) {
        try {
            String configTypes = applyConfigRequest.getConfigTypes();
            String[] types = configTypes.split(",");
            Arrays.stream(types).forEach(type ->{
                if (Integer.parseInt(type) == 1){
                    //oss配置下发
                    ossConfigService.send(parkCode, serialNumber);
                }
            });
        }catch (ResponseBodyException e){
            log.warn("[配置下发]被动下发配置失败：", e);
        }
    }
}
