package com.icetech.park.service.report.itc.impl;

import com.icetech.cloudcenter.api.paycode.PayCodePrePayService;
import com.icetech.cloudcenter.api.third.ThirdParkService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.itc.PayCodeRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.validator.Validator;
import com.icetech.sdk.request.itc.ItcPayCodeNotifyRequest;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.domain.enums.PushServiceEnum;
import com.icetech.third.service.SendOpenMsgService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("itcPayCodeServiceImpl")
@Slf4j
public class PayCodeServiceImpl extends AbstractService implements CallService<PayCodeRequest, Void> {
    @Autowired
    private PayCodePrePayService payCodePrePayService;

    @Resource
    private ThirdParkService thirdParkService;
    
    @Autowired
    private SendOpenMsgService sendOpenMsgService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<PayCodeRequest> baseRequest) {
        PayCodeRequest payCodeRequest = baseRequest.getBizContent();
        //参数校验
        Validator.validate(payCodeRequest);
        /*List<ThirdInfo> thirdInfos = thirdParkService.selectThirdByParkIdAndService(deviceToken.getParkId(), PushServiceEnum.对讲柱支付码.getServiceName());
        if (CollectionUtils.isEmpty(thirdInfos)) {*/
            ObjectResponse<Void> response = payCodePrePayService.prePay(deviceToken.getParkCode(), deviceToken.getDeviceNo(), deviceToken.getInandoutCode(), payCodeRequest.getPayCode());
            if (!ObjectResponse.isSuccess(response)) {
                return P2cBaseResponse.instance(baseRequest, CodeEnum.非法参数.getCode(), response.getMsg());
            }
            return P2cBaseResponse.success(baseRequest);
        //}
        /*thirdInfos.forEach(t -> {
            ItcPayCodeNotifyRequest itcPayCodeNotifyRequest = new ItcPayCodeNotifyRequest();
            itcPayCodeNotifyRequest.setSn(deviceToken.getDeviceNo());
            itcPayCodeNotifyRequest.setPayCode(payCodeRequest.getPayCode());
            itcPayCodeNotifyRequest.setScanTime(payCodeRequest.getScanTime());
            sendOpenMsgService.sendCommonOpenPlatformMsg(t, itcPayCodeNotifyRequest);
        });*/
        //return P2cBaseResponse.success(baseRequest);
    }

}
