package com.icetech.park.service.report.itc.impl;

import com.icetech.cloudcenter.domain.request.itc.NmvExitRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service("itcNmvExitServiceImpl")
@Slf4j
public class NmvExitServiceImpl extends AbstractService implements CallService<NmvExitRequest, Void> {

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<NmvExitRequest> baseRequest) {
        log.info("离场处理参数: token: {}", deviceToken);
        NmvExitRequest exitRequest = baseRequest.getBizContent();
        return P2cBaseResponse.success(baseRequest);
    }
}
