package com.icetech.park.service.report.itc.impl;

import com.icetech.cloudcenter.domain.request.itc.NmvEnterRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service("itcNmvEnterServiceImpl")
@Slf4j
public class NmvEnterServiceImpl extends AbstractService implements CallService<NmvEnterRequest, Void> {

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<NmvEnterRequest> baseRequest) {
        NmvEnterRequest enterRequest = baseRequest.getBizContent();

        //参数校验
        verifyParams(enterRequest);
        return P2cBaseResponse.success(baseRequest);
    }
}
