package com.icetech.park.service.report.itc.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.icetech.cloudcenter.domain.request.p2c.ApplyConfigRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.itc.impl.ItcOssConfigServiceImpl;
import com.icetech.park.service.report.CallService;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.exception.ResponseBodyException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;

@Service("itcApplyConfigServiceImpl")
@Slf4j
public class ApplyConfigServiceImpl extends AbstractService implements CallService<ApplyConfigRequest, Void> {

    @Autowired
    private ItcOssConfigServiceImpl ossConfigService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<ApplyConfigRequest> baseRequest) {
    	ApplyConfigRequest applyConfigRequest = baseRequest.getBizContent();
        //参数校验
        verifyParams(applyConfigRequest);
        ThreadUtil.execute(() -> {
            asyncHandle(deviceToken.getParkCode(), deviceToken.getDeviceNo(), applyConfigRequest);
        });
        return P2cBaseResponse.success(baseRequest);
    }

    private void asyncHandle(String parkCode, String serialNumber, ApplyConfigRequest applyConfigRequest) {
        try {
            String configTypes = applyConfigRequest.getConfigTypes();
            String[] types = configTypes.split(",");
            Arrays.stream(types).forEach(type ->{
                if (Integer.parseInt(type) == 1){
                    //oss配置下发
                    ossConfigService.send(parkCode, serialNumber);
                }
            });
        }catch (ResponseBodyException e){
            log.warn("[配置下发]被动下发配置失败：", e);
        }
    }
}
