package com.icetech.park.service.report.full.impl;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.Base64Tools;
import com.icetech.park.domain.vo.full.UpSnapshotVO;
import com.icetech.park.service.down.full.impl.FullCloudSnapShotServiceImpl;
import com.icetech.park.service.report.full.FullUpSnapshotService;
import com.icetech.third.utils.RedisUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 处理图片
 *
 * @author wgq
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FullUpSnapshotServiceImpl implements FullUpSnapshotService {

    private final RedisUtils redisUtils;

    private final FullCloudSnapShotServiceImpl fullCloudSnapShotService;

    private final static String KEY_PREFIX_SNAPSHOT_SN = "snapshot:sn:";

    @Override
    public ObjectResponse<?> executeSnapshot(UpSnapshotVO upSnapshotVO, String sn) {
        String redisKey = KEY_PREFIX_SNAPSHOT_SN + sn;
        String imgPath = ExtractContentAfterDomain.extractContentAfterDomain(Base64Tools.decodeBase64String(upSnapshotVO.getImgPath()), "aliyuncs.com/");
        String messageId = redisUtils.get(redisKey);
        log.info("获取秒图抓拍的Key：{},MessageId:{},秒图地址：{}", redisKey, messageId, imgPath);
        fullCloudSnapShotService.notify(messageId, imgPath, sn);
        return ObjectResponse.success();
    }


}
