package com.icetech.park.service.report.full.impl;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.response.p2c.HeartbeatResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.request.HeartbeatRequest;
import com.icetech.park.domain.vo.full.KeepAliveVo;
import com.icetech.park.service.handle.P2cOperHandle;
import com.icetech.park.service.report.full.FullHeartbeatService;
import com.icetech.park.service.report.p2c.impl.HeartbeatServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 纯云设备心跳
 *
 * @author wgq
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FullHeartbeatServiceImpl implements FullHeartbeatService {

    private final HeartbeatServiceImpl heartbeatService;

    private final P2cOperHandle p2cOperHandle;

    @Override
    public ObjectResponse<?> heartbeat(KeepAliveVo keepAliveVo, String sn) {
        TokenDeviceVo deviceToken = p2cOperHandle.getAndCacheDevice(sn, TokenDeviceVo.ProtocolTypeEnum.MQTT);
        HeartbeatRequest heartbeatRequest = new HeartbeatRequest();
        heartbeatRequest.setVersion(P2cVersionEnum.版本20.getVersion());
        heartbeatRequest.setDeviceTime(keepAliveVo.getTimestamp());
        P2cBaseRequest<HeartbeatRequest> request = new P2cBaseRequest<>();
        request.setBizContent(heartbeatRequest);
        P2cBaseResponse<HeartbeatResponse> response = heartbeatService.execute(deviceToken, request);
        if (response.getCode().equals(CodeEnum.成功.getCode())) {
            return ObjectResponse.success();
        } else {
            return ObjectResponse.failed();
        }
    }
}
