package com.icetech.park.service.report;

import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.utils.SpringUtils;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.month.MonthProductService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.api.user.VehicleService;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.response.*;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.order.service.OrderTagsService;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.service.monthcar.MonthCarServiceBase;
import com.icetech.park.service.park.ParkRecoveryService;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Getter
@Setter
@ToString
@Slf4j
public class ReportParamHolder {
    private ParkService parkService;
    private ParkDeviceService parkDeviceService;
    private LcdService lcdService;
    private LedService ledService;
    private BlacklistService blacklistService;
    private OrderService orderService;
    private MonthCarService monthCarService;
    private MonthProductService monthProductService;
    private VipCarService vipCarService;
    private ParkVisitService parkVisitService;
    private VehicleService vehicleService;
    private StoreCardService storeCardService;
    private OrderTagsService orderTagsService;
    private MonthRegionDao monthRegionDao;
    private VipRegionService vipRegionService;

    protected Long parkId;
    protected String parkCode;
    protected String serialNumber;
    protected String channelCode;
    protected String version;
    protected Integer versionIndex;
    protected String plateNum;
    protected String orderNum;
    protected Integer enexType;
    /**
     * 1：外区，2：内区
     */
    protected Integer regionType;

    /**
     * 新能源车在场车辆数
     */
    protected Integer chargeLiveCount;

    /**
     * 燃油车在场车辆数
     */
    protected Integer oilLiveCount;
    protected Map<String, Object> displayParamMap;

    protected ParkDevice parkDevice;
    protected ParkRegion parkRegion;
    protected ParkInoutdevice parkChannel;
    protected Park parkInfo;
    protected ParkConfig parkConfig;
    protected ParkFreespace parkFreeSpace;
    protected OrderNotpayService orderNotpayService;
    protected ObjectResponse<LedConfig> ledConfigResp;
    protected ObjectResponse<LcdConfig> lcdConfigResp;
    protected ObjectResponse<OrderInfo> fuzzyInOrder;
    protected ObjectResponse<OrderInfo> fuzzyOutOrder;
    protected ObjectResponse<Blacklist> blacklistResp;
    protected MonthDetailDto monthDetail;
    protected MonthDetailDto otherRegionMonthDetail;
    protected ObjectResponse<VipType> vipTypeResp;
    protected VipDetailDto otherRegionVipDetailDto;
    protected ObjectResponse<ParkVisit> parkVisitResp;
    protected ObjectResponse<VehiclePlate> vehiclePlateResp;
    protected ObjectResponse<StoreCard> storeCardResp;
    protected QueryNotPayResponse queryNotPayResponse;
    protected OrderInfo replenishOrder;
    protected List<OrderSonInfo> orderSonInfos;
    protected ParkRecoveryService parkRecoveryService;

    public ReportParamHolder(Long parkId, String parkCode, String channelCode,
                             String serialNumber, String version, String plateNum,
                             Integer enexType, String orderNum) {
        this.parkId = parkId;
        this.parkCode = parkCode;
        this.channelCode = channelCode;
        this.serialNumber = serialNumber;
        this.version = version;
        this.versionIndex = P2cVersionEnum.getIndex(version);
        this.plateNum = plateNum;
        this.enexType = enexType;
        this.orderNum = orderNum;
        this.displayParamMap = new HashMap<>();

        this.parkService = SpringUtils.getBean(ParkService.class);
        this.parkDeviceService = SpringUtils.getBean(ParkDeviceService.class);
        this.lcdService = SpringUtils.getBean(LcdService.class);
        this.ledService = SpringUtils.getBean(LedService.class);
        this.blacklistService = SpringUtils.getBean(BlacklistService.class);
        this.orderService = SpringUtils.getBean(OrderService.class);
        this.monthCarService = SpringUtils.getBean(MonthCarService.class);
        this.monthProductService = SpringUtils.getBean(MonthProductService.class);
        this.vipCarService = SpringUtils.getBean(VipCarService.class);
        this.parkVisitService = SpringUtils.getBean(ParkVisitService.class);
        this.vehicleService = SpringUtils.getBean(VehicleService.class);
        this.storeCardService = SpringUtils.getBean(StoreCardService.class);
        this.orderTagsService = SpringUtils.getBean(OrderTagsService.class);
        this.monthRegionDao = SpringUtils.getBean(MonthRegionDao.class);
        this.vipRegionService = SpringUtils.getBean(VipRegionService.class);
        this.orderNotpayService = SpringUtils.getBean(OrderNotpayService.class);
        this.parkRecoveryService = SpringUtils.getBean(ParkRecoveryService.class);
    }

    public Integer getChargeLiveCount() {
        if (chargeLiveCount == null) {
            chargeLiveCount = orderService.getChargeLiveCount(getParkId());
        }
        return chargeLiveCount;
    }
    public Integer getOilLiveCount() {
        if (oilLiveCount == null) {
            oilLiveCount = orderService.getOilLiveCount(getParkId());
        }
        return oilLiveCount;
    }

    public ParkDevice getParkDevice() {
        if (parkDevice == null) {
            ObjectResponse<ParkDevice> deviceResp = parkDeviceService.getDeviceBySerialNumber(getSerialNumber());
            ObjectResponse.notError(deviceResp);
            parkDevice = deviceResp.getData();
        }
        return parkDevice;
    }

    public ParkInoutdevice getParkChannel() {
        if (parkChannel == null) {
            ObjectResponse<ParkInoutdevice> channelInfoResp = parkService.getInOutDeviceByCode(getParkId(), getChannelCode());
            ObjectResponse.notError(channelInfoResp);
            parkChannel = channelInfoResp.getData();
        }
        return parkChannel;
    }

    public Park getParkInfo() {
        if (parkInfo == null) {
            ObjectResponse<Park> parkResp = parkService.findByParkId(getParkId());
            ObjectResponse.notError(parkResp);
            parkInfo = parkResp.getData();
        }
        return parkInfo;
    }

    public ParkConfig getParkConfig() {
        if (parkConfig == null) {
            ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(getParkId());
            ObjectResponse.notError(parkConfigObjectResponse);
            parkConfig = parkConfigObjectResponse.getData();
        }
        return parkConfig;
    }

    public ParkFreespace getParkFreeSpace() {
        if (parkFreeSpace == null) {
            Park park = getParkInfo();
            if (park.getIsInterior() == null || Integer.valueOf(0).equals(park.getIsInterior())) {
                ObjectResponse<ParkFreespace> spaceResp = parkService.getParkSpace(parkId);
                if (!ObjectResponse.isSuccess(spaceResp)) {
                    return null;
                }
                parkFreeSpace = spaceResp.getData();
            } else {
                ParkRegion parkRegion = getParkRegion();
                if (parkRegion != null) {
                    parkFreeSpace = new ParkFreespace();
                    parkFreeSpace.setFreeSpace(parkRegion.getFreePark());
                    parkFreeSpace.setRealFreeSpace(parkRegion.getRealFreePark());
                    parkFreeSpace.setTotalNum(parkRegion.getRegionPark());
                    parkFreeSpace.setParkId(parkRegion.getParkId());
                }

            }
        }
        return parkFreeSpace;
    }
    public ParkRegion getParkRegion() {
        if (parkRegion == null) {
            Long regionId = getParkChannel().getRegionId();
            if (regionId == null) {
                return null;
            }
            ObjectResponse<ParkRegion> regionObjectResponse = parkService.getParkRegionById(regionId);
            if (!ObjectResponse.isSuccess(regionObjectResponse)) {
                return null;
            }
            parkRegion = regionObjectResponse.getData();
        }
        return parkRegion;
    }

    public ObjectResponse<LedConfig> getLedConfigResp() {
        if (ledConfigResp == null) {
            ledConfigResp = ledService.getLedConfigByChannel(getParkChannel().getId());
        }
        return ledConfigResp;
    }

    public ObjectResponse<LcdConfig> getLcdConfigResp() {
        if (lcdConfigResp == null) {
            lcdConfigResp = lcdService.getLcdConfigByChannel(getParkChannel().getId());
        }
        return lcdConfigResp;
    }

    public ObjectResponse<OrderInfo> getFuzzyInOrder() {
        if (fuzzyInOrder == null) {
            ParkInoutdevice parkChannel = getParkChannel();
            if (parkChannel.getIsOpenVaguetype() != null && parkChannel.getIsOpenVaguetype() == 1) {
                fuzzyInOrder = orderService.fuzzyOrderPlate(getParkId(), getPlateNum(), OrderStatusConstants.IN_PARK, parkChannel.getVaguetype());
            } else {
                fuzzyInOrder = ObjectResponse.returnNotFoundIfNull(null);
            }
        }

        return fuzzyInOrder;
    }

    public ObjectResponse<OrderInfo> getFuzzyOutOrder() {
        if (fuzzyOutOrder == null) {
            ParkInoutdevice parkChannel = getParkChannel();
            if (parkChannel.getIsOpenVaguetype() != null && parkChannel.getIsOpenVaguetype() == 1) {
                fuzzyOutOrder = orderService.fuzzyOutPlate(getParkId(), getPlateNum());
            } else {
                fuzzyOutOrder = ObjectResponse.returnNotFoundIfNull(null);
            }
        }

        return fuzzyOutOrder;
    }

    public ObjectResponse<Blacklist> getBlacklistResp() {
        if (blacklistResp == null) {
            blacklistResp = blacklistService.getValidByPlate(getParkId(), getPlateNum());
        }

        return blacklistResp;
    }

    public MonthDetailDto getOtherRegionMonthDetail() {
        if (otherRegionMonthDetail != null) {
            return otherRegionMonthDetail;
        }
        otherRegionMonthDetail = new MonthDetailDto();
        otherRegionMonthDetail.setMonthType(MonthDetailDto.MonthType.非月卡车);
        Park park = getParkInfo();
        if (park.getIsInterior() == null || park.getIsInterior() == 0) {
            return otherRegionMonthDetail;
        }
        ParkInoutdevice channel = getParkChannel();
        //子通道不处理
        if (Integer.valueOf(0).equals(channel.getIsMaster())) {
            return otherRegionMonthDetail;
        }
        ParkRegion parkRegion = getParkRegion();
        if (parkRegion == null) {
            return otherRegionMonthDetail;
        }
        //半嵌套内区域的主通道不让外区域的月卡车进
        if (parkRegion.getFatherRelationId() != null
                && !Long.valueOf(0).equals(parkRegion.getFatherRelationId())) {
            return otherRegionMonthDetail;
        }
        ObjectResponse<MonthInfo> monthInfoResp = monthCarService.getMonthInfo(parkId, plateNum, MonthCarServiceBase.VALID_CARD, null);
        if (ObjectResponse.isSuccess(monthInfoResp)) {
            MonthInfo monthInfo = monthInfoResp.getData();

            List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfo.getId());
            if (!CollectionUtils.isEmpty(monthRegions)) {
                Optional<MonthRegion> any = monthRegions.stream()
                        .filter(monthRegion -> !Long.valueOf(0).equals(monthRegion.getRegionId())
                                && !parkRegion.getId().equals(monthRegion.getRegionId())).findAny();
                if (!any.isPresent()) {
                    return otherRegionMonthDetail;
                }
                otherRegionMonthDetail.setMonthInfo(monthInfo);
                otherRegionMonthDetail.setMonthType(MonthDetailDto.MonthType.月卡车);
                MonthProduct monthProduct = monthProductService.selectMonthProductById(monthInfo.getProductId());
                otherRegionMonthDetail.setMonthProduct(monthProduct);

                MonthRegion monthRegion = any.get();
                ObjectResponse<ParkRegion> objectResponse = parkService.getParkRegionById(monthRegion.getRegionId());
                otherRegionMonthDetail.setParkRegion(objectResponse.getData());
            }
        } else {
            monthInfoResp = monthCarService.getMonthInfo(parkId, plateNum, MonthCarServiceBase.TIMEOUT_CARD, null);
            if (ObjectResponse.isSuccess(monthInfoResp)) {
                MonthInfo monthInfo = monthInfoResp.getData();
                List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfo.getId());
                if (!CollectionUtils.isEmpty(monthRegions)) {
                    Optional<MonthRegion> any = monthRegions.stream()
                            .filter(monthRegion -> !Long.valueOf(0).equals(monthRegion.getRegionId())
                                    && !parkRegion.getId().equals(monthRegion.getRegionId())).findAny();
                    if (!any.isPresent()) {
                        return otherRegionMonthDetail;
                    }
                    MonthRegion monthRegion = any.get();
                    ObjectResponse<ParkRegion> objectResponse = parkService.getParkRegionById(monthRegion.getRegionId());
                    otherRegionMonthDetail.setParkRegion(objectResponse.getData());
                }
                otherRegionMonthDetail.setMonthType(MonthDetailDto.MonthType.过期临时车);
                otherRegionMonthDetail.setMonthInfo(monthInfo);
                ParkConfig parkConfig = getParkConfig();
                //过期多少天按过期卡
                Integer expireMcDays = 0;
                Integer expireDaysMonth = 0;
                if (parkConfig != null){
                    expireMcDays = parkConfig.getExpireMcDays();
                    expireDaysMonth = parkConfig.getIsExpireMc();
                }
                // 过期天数
                if (NumberUtils.toPrimitive(expireDaysMonth) == 1) {
                    MonthProduct monthProduct = monthProductService.selectMonthProductById(monthInfo.getProductId());
                    otherRegionMonthDetail.setMonthProduct(monthProduct);
                    if (otherRegionMonthDetail.getExpiredDays() <= NumberUtils.toPrimitive(expireMcDays)) {
                        otherRegionMonthDetail.setMonthType(MonthDetailDto.MonthType.过期月卡车);
                    }
                }
            }
        }
        return otherRegionMonthDetail;
    }
    public MonthDetailDto getMonthDetail() {
        if (monthDetail != null) {
            return monthDetail;
        }
        monthDetail = new MonthDetailDto();
        monthDetail.setMonthType(MonthDetailDto.MonthType.非月卡车);
        Park park = getParkInfo();
        ParkInoutdevice channel = getParkChannel();
        //场中场的区域ID
        Long innerRegionId = park.getIsInterior() != null && park.getIsInterior() == 1 ? channel.getRegionId() : null;
        ObjectResponse<MonthInfo> monthInfoResp = monthCarService.getMonthInfo(parkId, plateNum, MonthCarServiceBase.VALID_CARD, innerRegionId);
        if (ObjectResponse.isSuccess(monthInfoResp)) {
            MonthInfo monthInfo = monthInfoResp.getData();
            monthDetail.setMonthInfo(monthInfo);
            monthDetail.setMonthType(MonthDetailDto.MonthType.月卡车);
            if (enexType == 1) {
                //集团月卡标识
                if (monthInfo.getMoreMonthType()!= null && monthInfo.getMoreMonthType() ==  1){
                    log.info("进入集团月卡的处理逻辑 {},{}", monthInfo, plateNum);
                    //集团多位多车
                    ObjectResponse<MonthAbDto> monthAbDtoObjectResponse = monthCarService.groupAbMonthCar(plateNum, monthInfo.getId(), monthInfo.getPlotCount());
                    if (ObjectResponse.isSuccess(monthAbDtoObjectResponse)) {
                        MonthAbDto monthAbDto = monthAbDtoObjectResponse.getData();
                        if (!monthAbDto.getMonthCar() && monthAbDto.getAbCar()) {
                            monthDetail.setMonthType(MonthDetailDto.MonthType.多位多车占用);
                            monthDetail.setMonthAbDto(monthAbDto);
                        }
                    }
                }else {
                    //普通多位多车
                    ObjectResponse<MonthAbDto> monthAbDtoObjectResponse = monthCarService.abMonthCar(parkId, plateNum, monthInfo.getId(), monthInfo.getPlotCount(), channel.getRegionId());
                    if (ObjectResponse.isSuccess(monthAbDtoObjectResponse)) {
                        MonthAbDto monthAbDto = monthAbDtoObjectResponse.getData();
                        if (!monthAbDto.getMonthCar() && monthAbDto.getAbCar()) {
                            monthDetail.setMonthType(MonthDetailDto.MonthType.多位多车占用);
                            monthDetail.setMonthAbDto(monthAbDto);
                        }
                    }
                }

            } else {
                if (StringUtils.isNotBlank(orderNum)) {
                    OrderTags orderTags = orderTagsService.getListByOrderNumAndTagId(orderNum, 1, innerRegionId);
                    if (orderTags != null) {
                        monthDetail.setMonthType(MonthDetailDto.MonthType.多位多车占用);
                    }
                }
            }
            MonthProduct monthProduct = monthProductService.selectMonthProductById(monthInfo.getProductId());
            monthDetail.setMonthProduct(monthProduct);
        } else {
            monthInfoResp = monthCarService.getMonthInfo(parkId, plateNum, MonthCarServiceBase.TIMEOUT_CARD, innerRegionId);
            if (ObjectResponse.isSuccess(monthInfoResp)) {
                MonthInfo monthInfo = monthInfoResp.getData();
                monthDetail.setMonthType(MonthDetailDto.MonthType.过期临时车);
                monthDetail.setMonthInfo(monthInfo);
                ParkConfig parkConfig = getParkConfig();
                //过期多少天按过期卡
                Integer expireMcDays = 0;
                Integer expireDaysMonth = 0;
                if (parkConfig != null){
                    expireMcDays = parkConfig.getExpireMcDays();
                    expireDaysMonth = parkConfig.getIsExpireMc();
                }
                // 过期天数
                if (expireDaysMonth != null && expireDaysMonth == 1) {
                    if (monthDetail.getExpiredDays() <= NumberUtils.toPrimitive(expireMcDays)) {
                        MonthProduct monthProduct = monthProductService.selectMonthProductById(monthInfo.getProductId());
                        monthDetail.setMonthProduct(monthProduct);
                        monthDetail.setMonthType(MonthDetailDto.MonthType.过期月卡车);
                        if (enexType == 1) {
                            ObjectResponse<MonthAbDto> monthAbDtoObjectResponse =
                                    monthCarService.abMonthCar(parkId, plateNum, monthInfo.getId(), monthInfo.getPlotCount(), innerRegionId);
                            if (ObjectResponse.isSuccess(monthAbDtoObjectResponse)) {
                                MonthAbDto monthAbDto = monthAbDtoObjectResponse.getData();
                                if (!monthAbDto.getMonthCar() && monthAbDto.getAbCar()) {
                                    monthDetail.setMonthType(MonthDetailDto.MonthType.多位多车占用);
                                    monthDetail.setMonthAbDto(monthAbDto);
                                }
                            }
                        } else {
                            if (StringUtils.isNotBlank(orderNum)) {
                                OrderTags orderTags = orderTagsService.getListByOrderNumAndTagId(orderNum, 1, innerRegionId);
                                if (orderTags != null) {
                                    monthDetail.setMonthType(MonthDetailDto.MonthType.多位多车占用);
                                }
                            }
                        }
                    }
                }
            }
        }
        return monthDetail;
    }

    public ObjectResponse<VipType> getVipTypeResp() {
        if (vipTypeResp != null) {
            return vipTypeResp;
        }
        Park park = getParkInfo();
        ParkInoutdevice parkChannel = getParkChannel();
        //场中场的区域ID
        Long regionId = park.getIsInterior() != null && park.getIsInterior() == 1 ? parkChannel.getRegionId() : null;
        vipTypeResp = vipCarService.getValidVipCar(getParkId(), getPlateNum(), regionId);
        return vipTypeResp;
    }

    public VipDetailDto getOtherRegionVipDetailDto() {
        if (otherRegionVipDetailDto != null) {
            return otherRegionVipDetailDto;
        }

        Park parkInfo = getParkInfo();
        if (parkInfo.getIsInterior() == null || parkInfo.getIsInterior() == 0) {
            return null;
        }
        ParkInoutdevice parkChannel = getParkChannel();
        //子通道不处理
        if (Integer.valueOf(0).equals(parkChannel.getIsMaster())) {
            return null;
        }
        if (parkChannel.getRegionId() == null) {
            return null;
        }
        ObjectResponse<ParkRegion> regionObjectResponse = parkService.getParkRegionById(parkChannel.getRegionId());
        if (!ObjectResponse.isSuccess(regionObjectResponse)) {
            return null;
        }
        //半嵌套内区域的主通道不让外区域的VIP车进
        if (regionObjectResponse.getData().getFatherRelationId() != null
                && !Long.valueOf(0).equals(regionObjectResponse.getData().getFatherRelationId())) {
            return null;
        }
        //场中场的区域ID
        ObjectResponse<VipType> vipTypeResp = vipCarService.getValidVipCar(getParkId(), getPlateNum(), null);
        if (!ObjectResponse.isSuccess(vipTypeResp)) {
            return null;
        }
        VipType vipType = vipTypeResp.getData();
        List<VipRegion> vipRegionList = vipRegionService.getVipRegionsListByVipTypeId(vipType.getId());
        if (CollectionUtils.isNotEmpty(vipRegionList)) {
            VipRegion vipRegion = vipRegionList.stream()
                    .filter(v -> v.getRegionId() != 0)
                    .filter(vr -> !vr.getRegionId().equals(parkChannel.getRegionId()))
                    .findFirst().orElse(null);
            // 不是全车场并且不是当前区域VIP
            if (vipRegion != null) {
                ObjectResponse<ParkRegion> objectResponse = parkService.getParkRegionById(vipRegion.getRegionId());
                otherRegionVipDetailDto = new VipDetailDto();
                otherRegionVipDetailDto.setVipType(vipType);
                otherRegionVipDetailDto.setParkRegion(objectResponse.getData());
                ObjectResponse<List<ParkInoutdevice>> listObjectResponse =
                        parkService.getInOutDevicesByRegionId(vipRegion.getRegionId(), 1);
                if (ObjectResponse.isSuccess(listObjectResponse)) {
                    List<ParkInoutdevice> collect = listObjectResponse.getData().stream()
                            .filter(parkInoutdevice -> Integer.valueOf(0).equals(parkInoutdevice.getIsMaster()))
                            .collect(Collectors.toList());
                    otherRegionVipDetailDto.setEntranceChannelList(collect);
                }
                return otherRegionVipDetailDto;
            }
        }
        return null;
    }

    public ObjectResponse<ParkVisit> getParkVisitResp() {
        if (parkVisitResp == null) {
            parkVisitResp = parkVisitService.checkVisitPlate(getParkId(), getPlateNum());
        }
        return parkVisitResp;
    }

    public ObjectResponse<VehiclePlate> getVehiclePlateResp() {
        if (vehiclePlateResp == null) {
            vehiclePlateResp = vehicleService.selectVip(getParkId(), getPlateNum());
        }
        return vehiclePlateResp;
    }

    public ObjectResponse<StoreCard> getStoreCardResp() {
        if (storeCardResp == null) {
            storeCardResp = storeCardService.getValidStoreCards(getPlateNum(), getParkId());
        }
        return storeCardResp;
    }

    public Object putDisplayParam(String name, Object value) {
        return displayParamMap.put(name, value);
    }

    public Object getDisplayParam(String name) {
        return displayParamMap.get(name);
    }

    public Integer getRegionType() {
        if (this.regionType != null) {
            return regionType;
        }
        ParkRegion parkRegion = getParkRegion();
        if (parkRegion != null) {
            this.regionType = Long.valueOf(0).equals(parkRegion.getFatherRelationId()) ? 1 : 2;
        } else {
            this.regionType = 1;
        }
        return regionType;
    }

    public QueryNotPayResponse queryNotPayFee() {
        if (queryNotPayResponse != null) {
            return queryNotPayResponse;
        }
        List<ParkRecoveryVo> recoverys = parkRecoveryService.getOpenParkRecoveryByParkIds(Collections.singletonList(parkId));
        if (CollectionUtils.isEmpty(recoverys)) {
            queryNotPayResponse = new QueryNotPayResponse();
            return queryNotPayResponse;
        }
        List<OrderNotpay> orderNotPays = orderNotpayService.queryNotPayFee(parkId, getPlateNum(), enexType, getParkConfig());
        if (CollectionUtils.isEmpty(orderNotPays)) {
            queryNotPayResponse = new QueryNotPayResponse();
            return queryNotPayResponse;
        }
        List<NotPayDetail> notPayDetails = new ArrayList<>();
        BigDecimal sumPrice = new BigDecimal(0);
        queryNotPayResponse = new QueryNotPayResponse();
        for (OrderNotpay orderNotPay : orderNotPays) {
            if (orderNotPay.getOrderNum().equals(getOrderNum())) {
                continue;
            }
            NotPayDetail notPayDetail = NotPayDetail.builder()
                    .parkId(orderNotPay.getParkId())
                    .orderNum(orderNotPay.getOrderNum())
                    .enterTime(orderNotPay.getEnterTime())
                    .exitTime(orderNotPay.getExitTime())
                    .totalPrice(orderNotPay.getTotalPrice().toString())
                    .discountPrice(orderNotPay.getDiscountPrice().toString())
                    .unPayPrice(orderNotPay.getTotalPrice().toString())
                    .parkTime(orderNotPay.getEnterTime() == null
                            ? null : (orderNotPay.getExitTime() - orderNotPay.getEnterTime()))
                    .orderSource(orderNotPay.getOrderSource())
                    .build();
            notPayDetails.add(notPayDetail);
            sumPrice = sumPrice.add(orderNotPay.getTotalPrice());
        }
        queryNotPayResponse.setNotPayDetails(notPayDetails);
        queryNotPayResponse.setTotalNotPayPrice(sumPrice.toString());
        return queryNotPayResponse;
    }
}
