package com.icetech.park.service.report;

import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.utils.ReflectUtils;

import java.lang.reflect.Type;

/**
 * 统一调用接口
 */
public interface CallService<T, R> {
    /**
     * 执行
     *
     * @param deviceToken
     * @param baseRequest
     * @return
     */
    P2cBaseResponse<R> execute(TokenDeviceVo deviceToken, P2cBaseRequest<T> baseRequest);

    default Type getGenericType() {
        return ReflectUtils.getInterfaceFirstGenericTypeWrapper(CallService.class, this, P2cBaseRequest.class);
    }
}
