package com.icetech.park.service.redpack;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.redpack.RedpackOperService;
import com.icetech.fee.dao.redpack.RedpackInfoDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.fee.domain.entity.RedpackInfo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Slf4j
public class RedpackOperServiceImpl implements RedpackOperService {

    @Autowired
    private ParkService parkService;
    @Autowired
    private RedpackInfoDao redpackInfoDao;

    @Override
    public ObjectResponse<Integer> queryBalance(String parkCode) {
        Park park = parkService.findByParkCode(parkCode).getData();
        RedpackInfo redpackInfo = redpackInfoDao.selectByParkId(park.getId());
        if (redpackInfo == null){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            return ObjectResponse.success(redpackInfo.getBalance());
        }
    }

    @Transactional
    @Override
    public ObjectResponse deduct(String parkCode, Integer amount) {
        Park park = parkService.findByParkCode(parkCode).getData();
        RedpackInfo redpackInfo = redpackInfoDao.selectByParkId(park.getId());
        if (redpackInfo == null){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            int newBalance = redpackInfo.getBalance() - amount;
            redpackInfo.setBalance(newBalance);
            redpackInfoDao.updateByParkId(redpackInfo);
            return ObjectResponse.success();
        }
    }

    @Transactional
    @Override
    public ObjectResponse refund(String parkCode, Integer amount) {
        Park park = parkService.findByParkCode(parkCode).getData();
        RedpackInfo redpackInfo = redpackInfoDao.selectByParkId(park.getId());
        if (redpackInfo == null){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            int newBalance = redpackInfo.getBalance() + amount;
            redpackInfo.setBalance(newBalance);
            redpackInfoDao.updateByParkId(redpackInfo);
            return ObjectResponse.success();
        }
    }
}
