package com.icetech.park.service.record.impl;

import javax.annotation.Resource;

import com.icetech.park.mongo.dao.ExitRecordDao;
import com.icetech.park.mongo.document.ExitRecord;
import com.icetech.third.anno.AsyncMethod;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.park.service.record.ExitRecordService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service("exitRecordService")
public class ExitRecordServiceImpl implements ExitRecordService {
    /*@Resource
    private ExitRecordDao exitRecordDao;*/

    @Override
    public ObjectResponse<String> saveRecord(ExitRecord record) {
        if (StringUtils.isBlank(record.getOrderNum())) {
            record.setOrderNum(CodeTools.GenerateOrderNum());
        }
        record.setRecordType(2);
        //record = exitRecordDao.insert(record);
        return ObjectResponse.success(record.getOrderNum());
    }

    @Override
    //@AsyncMethod
    public void saveRecordAsync(ExitRecord record) {
        //saveRecord(record);
        //log.info("[离场记录]异步保存结束: {}. plateNum[{}], exitTime[{}], orderNum[{}]", record.getId(), record.getPlateNum(), record.getExitTime(), record.getOrderNum());
    }

    @Override
    //@AsyncMethod
    public void saveRecordAsync(CarExitRequest request) {
        /*ExitRecord record = new ExitRecord();
        BeanUtils.copyProperties(request, record);
        record.setExitNo(request.getInandoutName());
        record.setImage(request.getMaxImage());
        record.setSmallImage(request.getSmallImage());
        saveRecordAsync(record);*/
    }
}
