package com.icetech.park.service.record.impl;

import javax.annotation.Resource;

import com.icetech.park.mongo.dao.EnterRecordDao;
import com.icetech.park.mongo.document.EnterRecord;
import com.icetech.third.anno.AsyncMethod;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.EnterRequest;
import com.icetech.park.service.record.EnterRecordService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service("enterRecordService")
public class EnterRecordServiceImpl implements EnterRecordService {
    /*@Resource
    private EnterRecordDao enterRecordDao;*/

    @Override
    public ObjectResponse<String> saveRecord(EnterRecord record) {
        if (StringUtils.isBlank(record.getOrderNum())) {
            record.setOrderNum(CodeTools.GenerateOrderNum());
        }
        record.setRecordType(1);
        //record = enterRecordDao.insert(record);
        return ObjectResponse.success(record.getOrderNum());
    }

    @Override
    //@AsyncMethod
    public void saveRecordAsync(EnterRecord record) {
        //saveRecord(record);
        //log.info("[入场记录]异步保存结束: {}. plateNum[{}], enterTime[{}], orderNum[{}]", record.getId(), record.getPlateNum(), record.getEnterTime(), record.getOrderNum());
    }

    @Override
    //@AsyncMethod
    public void saveRecordAsync(CarEnterRequest request) {
        /*EnterRecord record = new EnterRecord();
        BeanUtils.copyProperties(request, record);
        record.setChannelId(request.getInandoutCode());
        record.setEnterNo(request.getInandoutName());
        record.setImage(request.getMaxImage());
        this.saveRecordAsync(record);*/
    }

    @Override
    public void saveRecordAsync(EnterRequest request) {
        /*EnterRecord record = new EnterRecord();
        BeanUtils.copyProperties(request, record);
        record.setOrderNum(request.getOrderId());
        record.setImage(request.getEnterImage());
        record.setSmallImage(request.getSmallImage());
        this.saveRecordAsync(record);*/
    }
}
