package com.icetech.park.service.queryfee.multipleareachain;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.merchant.DiscountDayDao;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.dao.OrderAuthDao;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.domain.entity.OrderAuthInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.service.discount.ParkDiscountUserchargeService;
import com.icetech.park.service.queryfee.DiscountOverHandle;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
public class TotalFeeHandleChain extends MultipleAreaQueryFeeChainAbstract {
    @Autowired
    private DiscountDayDao discountDayDao;
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private DiscountOverHandle discountOverHandle;
    //未使用状态
    private static final Integer STATUS = 0;
    @Autowired
    private ParkDiscountUserchargeService parkDiscountUserchargeService;
    @Autowired
    private OrderAuthDao orderAuthDao;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        return queryFeeObject(feeParamHolder);
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        BigDecimal surplusfee = feeParamHolder.getSurplusfee();
        QueryOrderFeeResponse queryOrderFeeResponse = feeParamHolder.getQueryOrderFeeResponse();
        QueryOrderFeeResponse innerOrderFeeResponse = feeParamHolder.getInnerQueryOrderFeeResponse();
        //有内场查费结果
        boolean hasInnerFee = innerOrderFeeResponse != null && innerOrderFeeResponse.getUnpayPrice() != null;

        boolean isResetStatus = false;
        if (hasInnerFee) {
            //获取总优惠
            BigDecimal allDiscountPrice = new BigDecimal(innerOrderFeeResponse.getDiscountPrice())
                    .add(new BigDecimal(queryOrderFeeResponse.getDiscountPrice()));
            //获取总实收
            BigDecimal allUnPayPrice = new BigDecimal(innerOrderFeeResponse.getUnpayPrice())
                    .add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));

            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(allUnPayPrice));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(allDiscountPrice));
            //获取总应收：外区域和内区域的本次应缴费和 + 已经产生的应缴费
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(allDiscountPrice.add(allUnPayPrice)
                    .add(new BigDecimal(queryOrderFeeResponse.getPaidAmount()))
                    .add(new BigDecimal(queryOrderFeeResponse.getDiscountAmount()))));
            if (NumberUtils.parseFloat(innerOrderFeeResponse.getUnpayPrice()) > 0) {
                queryOrderFeeResponse.setHasInnerAreaFee(true);
            }
            isResetStatus = true;
        }

        //优惠券处理
        float thisFee = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
        float totalAmount = Float.parseFloat(queryOrderFeeResponse.getTotalAmount());
        Float unPayPrice = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
        float sourceUnpayPrice = unPayPrice;
        unPayPrice = couponHandle(feeParamHolder, feeParamHolder.getPark().getId(),
                feeParamHolder.getOrderSumFeeDto(), thisFee, feeParamHolder.getParkChargeConfig(),
                feeParamHolder.getOrderInfo(), unPayPrice);
        boolean hasCoupon = sourceUnpayPrice != unPayPrice;
        if (hasCoupon) {
            float substractValue = sourceUnpayPrice - unPayPrice;
            BigDecimal addDiscountPrice = new BigDecimal(queryOrderFeeResponse.getDiscountPrice())
                    .add(new BigDecimal(substractValue)).setScale(2, BigDecimal.ROUND_HALF_UP);
            //重新设置金额
            queryOrderFeeResponse.setDiscountPrice(addDiscountPrice.toString());
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(unPayPrice));
        }

        //总优惠
        Float allDiscountPrice = Float.parseFloat(queryOrderFeeResponse.getDiscountPrice());
        Float totalAmountPrice =  Float.parseFloat(queryOrderFeeResponse.getTotalAmount());
        if (innerOrderFeeResponse == null) {
            innerOrderFeeResponse = new QueryOrderFeeResponse();
        }
        Float innerTotalPrice = NumberUtils.parseFloat(innerOrderFeeResponse.getTotalAmount());
        Float outTotalPrice = totalAmountPrice - innerTotalPrice;
        log.debug("[叠加优惠-小场修改] alldiscountPrice {} outTotalPrice {} innerTotalPrice {}",allDiscountPrice,outTotalPrice,innerTotalPrice);
        if (hasCoupon && allDiscountPrice >= outTotalPrice) {
            Float innerDiscountPrice = allDiscountPrice - outTotalPrice;
            if (innerDiscountPrice > innerTotalPrice){
                innerDiscountPrice = innerTotalPrice;
            }
            Float innerUnPaidPrice = innerTotalPrice - innerDiscountPrice;
            innerOrderFeeResponse.setDiscountPrice(FORMAT.format(innerDiscountPrice));
            innerOrderFeeResponse.setUnpayPrice(FORMAT.format(innerUnPaidPrice));
        }
        log.debug("[叠加优惠-小场修改] innerOrderFeeResponse {} ",innerOrderFeeResponse);
        log.debug("[叠加优惠-小场修改] queryFee {} inner {}",queryOrderFeeResponse,innerOrderFeeResponse);
        //缓存保存小场优惠的信息
        redisUtils.set("sub:" + queryOrderFeeResponse.getOrderNum(), innerOrderFeeResponse, 1L, TimeUnit.DAYS);

        String unpayPrice = queryOrderFeeResponse.getUnpayPrice();
        float aFloat = Float.parseFloat(unpayPrice);
        //应收如果大于剩余额度, 减去剩余额度后就是应收金额
        if(surplusfee != null && aFloat > surplusfee.floatValue()){
            isResetStatus = true;
            updateUnpayPrice(queryOrderFeeResponse, innerOrderFeeResponse, aFloat, surplusfee.floatValue());
            log.info("[查费-修改费用模块] 最大收费逻辑处理后待缴费[{}]", queryOrderFeeResponse.getUnpayPrice());
        }

        //判断有没有授权修改需缴费，如果有修改，则设置新的需缴费
        OrderAuthInfo orderAuthInfo = orderAuthDao.selectByOrderNum(queryOrderFeeResponse.getOrderNum(), 1);
        if (orderAuthInfo != null && orderAuthInfo.getAuthStatus().equals(1)){
            isResetStatus = true;
            updateUnpayPrice(queryOrderFeeResponse, innerOrderFeeResponse, aFloat, NumberUtils.toFloat(orderAuthInfo.getUpPrice()));
            log.info("[查费-修改费用模块]订单号[{}]有授权过修改金额, before[{}], after[{}]",
                    queryOrderFeeResponse.getOrderNum(),
                    queryOrderFeeResponse.getUnpayPrice(),
                    orderAuthInfo.getUpPrice());
        }

        if (isResetStatus) {
            totalAmount = NumberUtils.toFloat(queryOrderFeeResponse.getTotalAmount());
            Float paidAmount = Float.parseFloat(queryOrderFeeResponse.getPaidAmount());
            Float discountAmount = Float.parseFloat(queryOrderFeeResponse.getDiscountAmount());
            Float finallyUnPayPrice = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
            Float discountPrice = Float.parseFloat(queryOrderFeeResponse.getDiscountPrice());
            Integer status = getFeeStatus(paidAmount, finallyUnPayPrice, discountPrice, discountAmount, totalAmount);
            queryOrderFeeResponse.setStatus(status);
        }

        return queryOrderFeeResponse;
    }

    /**
     * 计算总的优惠
     * @param feeParamHolder feeParamHolder
     * @param parkId 车场ID
     * @param orderSumFeeDto 订单汇总
     * @param thisFee 应收
     * @param parkChargeconfig 计费配置
     * @param orderInfo 订单信息
     * @param unPayPrice 未支付金额
     * @return 优惠金额
     */
    private float couponHandle(MultipleAreaFeeParamHolder feeParamHolder, Long parkId, OrderSumFeeDto orderSumFeeDto, float thisFee,
                               ParkChargeconfig parkChargeconfig, OrderInfo orderInfo, float unPayPrice) {
        log.debug("[叠加优惠-优惠计算开始] parkChargeconfig {},orderInfo {}",parkChargeconfig,orderInfo);
        if (unPayPrice <= 0){
            return 0;
        }
        //查询优惠列表
        List<OrderDiscount> orderDiscounts = orderDiscountDao.selectByOrderNum(orderInfo.getOrderNum(), STATUS);

        if (CollectionUtils.isEmpty(orderDiscounts)) {
            orderDiscounts = Lists.newArrayList();
            log.debug("[叠加优惠] 暂无优惠信息 orderNum {}", orderInfo.getOrderNum());
            //是否有按天优免
            DiscountDay discountDay = discountDayDao.selectLastByPlateNum(orderInfo.getPlateNum(), parkId);
            if (discountDay != null && discountDay.getEndTime().getTime() >= System.currentTimeMillis()){
                OrderDiscount orderDiscount = orderDiscountDao.selectOne(Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getDiscountNo, discountDay.getDiscountNo())
                        .eq(OrderDiscount::getDelFlag,0).last(SqlConstant.LIMIT_ONE));
                if (Objects.nonNull(orderDiscount)){
                    orderDiscounts.add(orderDiscount);
                }
            }else {
                //没有优惠信息
                return unPayPrice;
            }
        }
        log.debug("[叠加优惠] 获取优惠信息 orderDiscounts {}", JsonUtils.toString(orderDiscounts));
        //获取车场优惠配置
        ParkDiscountUsercharge parkDiscountUsercharge = parkDiscountUserchargeService.getParkDiscountUserchargeByParkId(parkId);
        if (Objects.isNull(parkDiscountUsercharge)){
            // 设置默认值
            parkDiscountUsercharge = new ParkDiscountUsercharge();
            parkDiscountUsercharge.setParkId(parkId);
            parkDiscountUsercharge.setPlateGetCoupons(1);
            parkDiscountUsercharge.setSupportStackeUsage(2);
            parkDiscountUsercharge.setThirdpartyStackeUsage(1);
            parkDiscountUsercharge.setUserMultipleTimes(2);
        }
        //判断当前订单是否已经使用过优惠券
        List<OrderDiscount> orderDiscountsUsed = orderDiscountDao.selectList(
                Wrappers.lambdaQuery(OrderDiscount.class)
                        .eq(OrderDiscount::getOrderNum, orderInfo.getOrderNum())
                        .eq(OrderDiscount::getStatus,1)
                        .eq(OrderDiscount::getFrom, 1));
        if (parkDiscountUsercharge.getUserMultipleTimes() == 1 && CollectionUtils.isNotEmpty(orderDiscountsUsed)){
            log.info("[订单已经使用过优惠不能继续使用] orderNum {}",orderInfo.getOrderNum());
            return unPayPrice;
        }
        //叠加优惠
        DiscountOverHandle.DiscountInfo discount = discountOverHandle.getDiscount(feeParamHolder, parkChargeconfig, orderInfo, orderSumFeeDto, parkDiscountUsercharge, orderDiscounts, feeParamHolder.getParkTime(), BigDecimal.valueOf(unPayPrice), BigDecimal.valueOf(thisFee),Boolean.TRUE);
        BigDecimal discountPrice = discount.getDiscountPrice();
        unPayPrice = thisFee - discountPrice.floatValue();
        if (unPayPrice < 0) {
            unPayPrice = 0;
        }
        //标记本次计费使用的优惠券
        if (CollectionUtils.isNotEmpty(discount.getDiscountNos())){
            redisUtils.set(RedisDiscountKeyConstant.DISCOUNT_USE_PRE +parkId+":"+orderInfo.getOrderNum(), StrUtil.join(",",discount.getDiscountNos()),60*60*24);
        }
        if (discount.getMerchantDiscountPrice() != null) {
            redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(),
                    "1", discount.getMerchantCouponsInfo(), 60*60*24);
        }
        if (discount.getThirdDiscountPrice() != null) {
            redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(),
                    "2", discount.getThirdCouponsInfo(), 60*60*24);
        }
        log.info("[优惠券-标准优惠] 车牌号[{}], 优惠[{}],优惠之后[{}]", orderInfo.getPlateNum(), discountPrice, unPayPrice);
        return unPayPrice;
    }
    private void updateUnpayPrice(QueryOrderFeeResponse queryOrderFeeResponse,
                                  QueryOrderFeeResponse innerOrderFeeResponse, float aFloat, float upPrice) {
        float v = aFloat - upPrice;
        if (innerOrderFeeResponse != null && NumberUtils.parseFloat(innerOrderFeeResponse.getUnpayPrice()) > 0) {
            float innerUnpayPrice = NumberUtils.parseFloat(innerOrderFeeResponse.getUnpayPrice());
            if (innerUnpayPrice > upPrice) {
                float totalAmountF = NumberUtils.toFloat(innerOrderFeeResponse.getTotalAmount());
                innerOrderFeeResponse.setUnpayPrice(String.valueOf(upPrice));
                innerOrderFeeResponse.setTotalAmount(String.valueOf(totalAmountF - v));
                //缓存保存小场优惠的信息
                redisUtils.set("sub:" + queryOrderFeeResponse.getOrderNum(), innerOrderFeeResponse, 1L, TimeUnit.DAYS);
            }
        }
        float totalAmount = NumberUtils.toFloat(queryOrderFeeResponse.getTotalAmount());
        queryOrderFeeResponse.setTotalAmount(String.valueOf(totalAmount- v));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(upPrice));
    }

}
