package com.icetech.park.service.queryfee.multipleareachain;

import cn.hutool.core.date.DateUtil;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.vo.ParkChargeRuleVO;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.MonthFeeDto;
import com.icetech.park.service.queryfee.MonthFeeHandle;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Slf4j
@Service
public class OutAreaPreFeeHandleChain extends MultipleAreaQueryFeeChainAbstract {

    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private MonthFeeHandle monthFeeHandle;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private MonthRegionDao monthRegionDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private InnerAreaPreFeeHandleChain innerAreaPreFeeHandleChain;
    //下一个责任类
    private final OutAreaComputeFeeHandleChain nextChain;
    @Autowired
    public OutAreaPreFeeHandleChain(OutAreaComputeFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = queryFeeObject(feeParamHolder);
        feeParamHolder.setQueryOrderFeeResponse(queryOrderFeeResponse);
        if (!feeParamHolder.isBreak()) {
            if (nextChain != null) {
                return nextChain.queryFee(feeParamHolder);
            }
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {

        QueryOrderFeeRequest queryOrderFeeRequest = feeParamHolder.getQueryOrderFeeRequest();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        Park park = feeParamHolder.getPark();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();

        Long parkId = park.getId();

        //用参数中的车型来查询费用
        Integer carType = queryOrderFeeRequest.getCarType();
        if (carType != null) {
            orderInfo.setCarType(carType);
        }

        //进停车场的区域ID
        Long regionId = orderInfo.getRegionId();
        /*ParkRegion parkRegion = parkRegionDao.selectById(regionId);
        if (parkRegion != null && !Long.valueOf(0).equals(parkRegion.getFatherRelationId())) {
            regionId = parkRegion.getFatherRelationId();
        }*/
        feeParamHolder.setRegionId(regionId);
        OrderSonInfo orderSonInfoParam = new OrderSonInfo();
        orderSonInfoParam.setOrderNum(orderInfo.getOrderNum());
        orderSonInfoParam.setParkId(parkId);
        List<OrderSonInfo> orderSonInfos = orderSonInfoDao.selectList(orderSonInfoParam);
        AssertTools.notNull(CollectionUtils.isNotEmpty(orderSonInfos) ? orderSonInfos : null , CodeConstants.ERROR_400, "缺少子订单");
        //内场子订单（根据订单表的区域ID是主订单的规则，该子订单就是另外一个区的子订单）
        OrderSonInfo innerOrderSonInfo = null;
        for (OrderSonInfo orderSonInfo : orderSonInfos) {
            if (!regionId.equals(orderSonInfo.getRegionId())) {
                innerOrderSonInfo = orderSonInfo;
                break;
            }
        }
        if (innerOrderSonInfo == null) {
            throw new ResponseBodyException(CodeConstants.ERROR_400, "不存在内场子订单");
        }

        Long startTime = orderInfo.getEnterTime();
        Long endTime = feeParamHolder.getEndTime();
        //计费结束时间
        if (endTime == null) {
            endTime = DateTools.unixTimestamp();
        }
        if (innerOrderSonInfo.getExitTime() == null) {
            if ((PlateTypeEnum.月卡车.getType().equals(innerOrderSonInfo.getType())
                    || PlateTypeEnum.VIP车辆.getType().equals(innerOrderSonInfo.getType()))) {
                log.info("月卡/vip车内场出口未识别, 补出场时间为外区出场时间, plateNum[{}]", innerOrderSonInfo.getPlateNum());
                innerOrderSonInfo.setExitTime(endTime);
            } else {
                if (queryOrderFeeRequest.getChannelId() == null) {
                    innerOrderSonInfo.setExitTime(endTime);
                } else {
                    innerOrderSonInfo.setExitTime(innerOrderSonInfo.getEnterTime());
                    boolean flag = false;
                    ObjectResponse<ParkInoutdevice> inOutDeviceByCode = parkService.getInOutDeviceByCode(parkId, queryOrderFeeRequest.getChannelId());
                    if (ObjectResponse.isSuccess(inOutDeviceByCode)) {
                        if (innerOrderSonInfo.getRegionId().equals(inOutDeviceByCode.getData().getRegionId())) {
                            innerOrderSonInfo.setExitTime(endTime);
                            flag = true;
                        }
                    }
                    if (!flag) {
                        MonthInfo monthInfo = monthFeeHandle.getMonthInfo(parkId, orderInfo.getPlateNum(), innerOrderSonInfo.getRegionId(), parkConfig);
                        if (monthInfo != null) {
                            log.info("月卡车内场出口未识别, 补出场时间为外区出场时间, plateNum[{}]", innerOrderSonInfo.getPlateNum());
                            innerOrderSonInfo.setExitTime(endTime);
                        } else {
                            ObjectResponse<VipType> objectResponse = vipCarService.getValidVipCar(parkId, orderInfo.getPlateNum(), innerOrderSonInfo.getRegionId());
                            if (ObjectResponse.isSuccess(objectResponse)) {
                                log.info("vip车内场出口未识别, 补出场时间为外区出场时间, plateNum[{}]", innerOrderSonInfo.getPlateNum());
                                innerOrderSonInfo.setExitTime(endTime);
                            }
                        }
                    }
                }
            }
        }
        feeParamHolder.setInnerOrderSonInfo(innerOrderSonInfo);

        //总停车时长，计费结束时间 - 入场时间
        long parkTime = endTime - startTime;

        //查询已缴费汇总信息
        OrderSumFeeDto feeDto = getPaidFee(orderInfo.getOrderNum(), parkId);

        //判断新能源车 首次免费时长
        try {
            Integer batteryCarFreeTime = getBatteryCarForFree(orderInfo, feeDto, parkConfig, parkId, endTime - startTime);
            startTime = startTime + batteryCarFreeTime;
            orderInfo.setEnterTime(startTime);
        } catch (Exception e) {
            log.error("处理失败: {}. queryOrderFeeRequest[{}], orderInfo[{}], park[{}], parkConfig[{}]",
                    e.getMessage(), queryOrderFeeRequest, orderInfo, park, parkConfig, e);
        }

        //缴费后的免费时长
        int freeTimeAfterPay = NumberUtils.toPrimitive(parkConfig.getIsfreeAfterpay(15));

        //公务车是否免费
        if (NumberUtils.toPrimitive(parkConfig.getFreeOfficialCars()) == 1
                && PlateTypeDto.officialCar(orderInfo.getPlateNum())){
            QueryOrderFeeResponse freeRet = getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime,
                    freeTimeAfterPay, park.getParkName());
            log.info("公务车无需缴费返回，车牌号：{}", orderInfo.getPlateNum());
            feeParamHolder.setBreak(true);
            return freeRet;
        }

        Long newStartTime = null;
        Long newEndTime = null;
        //判断月卡类型
        MonthFeeDto monthFeeDto = monthFeeHandle.getMonthFeeParam(feeParamHolder, parkId, orderInfo,
                startTime, endTime, parkConfig, 1);
        if (monthFeeDto != null) {
            if (monthFeeDto.isMonthRet()) {
                QueryOrderFeeResponse monthCarRet = getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime,
                        freeTimeAfterPay, park.getParkName());
                int monthType = getMonthType(monthFeeDto.getMonthInfo());
                if (monthType == 0) {
                    feeParamHolder.setBreak(true);
                } else {
                    feeParamHolder.setOutContinue(true);
                }
                return monthCarRet;
            } else {
                if (monthFeeDto.getNewStartTime() != null) {
                    newStartTime = monthFeeDto.getNewStartTime();
                }
                if (monthFeeDto.getNewEndTime() != null) {
                    newEndTime = monthFeeDto.getNewEndTime();
                }
                feeParamHolder.setCsFeeType(monthFeeDto.getCsFeeType());
                feeParamHolder.setCsMonthCarFee(monthFeeDto.isCsMonthCarFee());
                feeParamHolder.setCsStartTime(monthFeeDto.getCsStartTime());
                feeParamHolder.setCsEndTime(monthFeeDto.getCsEndTime());
                feeParamHolder.setCsSwitchTime(monthFeeDto.getCsSwitchTime());
                feeParamHolder.setBillIdList(monthFeeDto.getBillIdList());
            }
        }

        //预约车判断
        Integer type = orderInfo.getType();
        if (PlateTypeEnum.访客车辆.getType().equals(type)) {
            //判断是否收费
            Integer visitIscharge = parkConfig.getVisitIscharge();
            if (visitIscharge != null && visitIscharge == 0) {
                QueryOrderFeeResponse monthCarRet = getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime,
                        freeTimeAfterPay, park.getParkName());
                log.info("预约车无需缴费返回，车牌号：{}", orderInfo.getPlateNum());
                feeParamHolder.setBreak(true);
                return monthCarRet;
            }
        }

        //外场停车时长
        long outParkTime = getOutParkTime(newStartTime, newEndTime, startTime, endTime, innerOrderSonInfo,
                feeDto != null ? feeDto.getLastPayTime() : null);

        feeParamHolder.setParkTime(parkTime);
        feeParamHolder.setOutParkTime(outParkTime);
        feeParamHolder.setStartTime(startTime);
        feeParamHolder.setEndTime(endTime);
        feeParamHolder.setOrderSumFeeDto(feeDto);

        return new QueryOrderFeeResponse();
    }

    private int getMonthType(MonthInfo monthInfo) {
        if (monthInfo == null) {
            return 1;
        }
        int monthType = 0;
        List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfo.getId());
        if (CollectionUtils.isNotEmpty(monthRegions)) {
            Optional<MonthRegion> optional = monthRegions.stream()
                    .filter(monthRegion -> Long.valueOf(0).equals(monthRegion.getRegionId())).findAny();
            if (!optional.isPresent()) {
                monthType = 1;
            }
        }
        return monthType;
    }

    /**
     * 新能源车 减时长
     *
     * @param orderInfo 订单信息
     * @param parkId 车场ID
     * @return 减时长
     */
    private Integer getBatteryCarForFree(OrderInfo orderInfo, OrderSumFeeDto feeDto,
                                         ParkConfig parkConfig, Long parkId,Long parkTime) {
        boolean isOpenFlag = Integer.valueOf(1).equals(parkConfig.getIsNewenergyCharge());
        if (!isOpenFlag || feeDto != null) {
            return 0;
        }
        OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
        if (carInfo == null) {
            return 0;
        }
        //车牌颜色
        String plateColor = carInfo.getPlateColor();
        if (StringUtils.isEmpty(plateColor) || !plateColor.contains("绿")) {
            return 0;
        }


        //入场当天 出场记录
        Long startTimeForMatch = DateUtil.beginOfDay(DateUtil.date()).getTime() / 1000;

        Long endTimeForMatch = DateUtil.endOfDay(DateUtil.date()).getTime() / 1000;
        Integer count = orderInfoDao.countRecentExitByEnterTime(parkId, orderInfo.getPlateNum(), startTimeForMatch, endTimeForMatch);
        //走配置项
        Integer newEnergyDiscountMinutes = parkConfig.getNewEnergyDiscountMinutes();
        //查询计费规则的免费时长
        ParkChargeRuleVO freeTimeLocal = parkService.getFreeTimeLocal(parkId, orderInfo.getRegionId());
        if (freeTimeLocal == null) {
            return 0;
        }
        int BATTERY_FREEDOM_SECONDS = Math.max(newEnergyDiscountMinutes*60 - freeTimeLocal.getFreeTime()*60,0);
        Integer TWO_HOUR_SECONDS = newEnergyDiscountMinutes * 60;
        Long newFreeParkTime = count<=0 ? (parkTime > TWO_HOUR_SECONDS) ? BATTERY_FREEDOM_SECONDS : parkTime - 1 : 0;
        log.info("运算新能源首免结果, platenum[{}], parkTime[{}],  freeParkTime[{}]",orderInfo.getPlateNum(), parkTime, newFreeParkTime);
        return newFreeParkTime.intValue();
    }

    private long getOutParkTime(Long newStartTime, Long newEndTime, Long startTime, Long endTime,
                                OrderSonInfo innerOrderSonInfo, Long lastPayTime) {
        Long innerAreaParkTime = innerAreaPreFeeHandleChain.getNewInnerAreaParkTime(innerOrderSonInfo);
        if (innerAreaParkTime != null) {
            long parkTime = endTime - startTime - innerAreaParkTime;
            return parkTime < 0 ? 0 : parkTime;
        }
        Long innerOrderSonExitTime = innerOrderSonInfo.getExitTime();
        Long innerOrderSonEnterTime = innerOrderSonInfo.getEnterTime();
        if (lastPayTime != null) {
            newStartTime = lastPayTime;
        }
        if (newStartTime != null && newEndTime == null) {
            if (newStartTime >= innerOrderSonExitTime) {
                return endTime - newStartTime;
            } else if (newStartTime >= innerOrderSonEnterTime) {
                return endTime - innerOrderSonExitTime;
            } else if (newStartTime >= startTime) {
                return innerOrderSonEnterTime - newStartTime;
            }
        }
        if (newEndTime != null && newStartTime == null) {
            if (newEndTime >= innerOrderSonExitTime) {
                return newEndTime - innerOrderSonExitTime;
            } else if (newEndTime >= innerOrderSonEnterTime) {
                return innerOrderSonEnterTime - startTime;
            } else if (newEndTime >= startTime) {
                return newEndTime - startTime;
            }
        }
        if (newEndTime != null && newStartTime != null) {
            startTime = newStartTime;
            endTime = newEndTime;
        }
        Long firstTime = innerOrderSonEnterTime - startTime;
        Long secondTime = endTime - innerOrderSonExitTime;
        return (firstTime + secondTime) < 0 ? 0 : (firstTime + secondTime);
    }

}
