package com.icetech.park.service.queryfee.multipleareachain;

import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.common.utils.DateUtils;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.basics.domain.dto.ChargeConfigDTO;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.order.SumPayByOrderNumDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@Service
public class OutAreaComputeFeeHandleChain extends MultipleAreaQueryFeeChainAbstract {

    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private ChargeService chargeService;
    //最大收费判断，免费时的返回值
    private static final BigDecimal FREE_VALUE = BigDecimal.ZERO;
    //下一个责任类
    private MultipleAreaQueryFeeChainAbstract nextChain;

    @Autowired
    private VipRegionService vipRegionService;

    @Autowired
    public OutAreaComputeFeeHandleChain(OutAreaDiscountFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        if (feeParamHolder.isOutContinue()) {
            if (nextChain != null) {
                return nextChain.queryFee(feeParamHolder);
            }
        }
        QueryOrderFeeResponse queryOrderFeeResponse = queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak()) {
            if (nextChain != null) {
                return nextChain.queryFee(feeParamHolder);
            }
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();
        Long startTime = feeParamHolder.getStartTime();
        Long endTime = feeParamHolder.getEndTime();
        Long parkTime = feeParamHolder.getParkTime();
        Integer freeTimeAfterPay = parkConfig.getIsfreeAfterpay(15);
        Long parkId = park.getId();


        Long regionId = feeParamHolder.getRegionId();
        OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
        Integer billId = CollectionUtils.isEmpty(feeParamHolder.getBillIdList()) || feeParamHolder.getBillIdList().stream().anyMatch(Objects::isNull)
                ? null : feeParamHolder.getBillIdList().stream().filter(Objects::nonNull).findFirst().orElse(null) ;
        //判断入场的时候是否为VIP车辆
        if (PlateTypeEnum.VIP车辆.getType().equals(orderInfo.getType())) {
            //获取该车辆最近的VIP配置信息
            ObjectResponse<VipType> recentVipCar = vipCarService.getRecentVipCar(parkId, orderInfo.getPlateNum(), null);
            if (ObjectResponse.isSuccess(recentVipCar)){
                //获取vip计费规则
                billId = getVipOutBillIdAndSetInnerVip(feeParamHolder, regionId, innerOrderSonInfo, recentVipCar.getData());
            }
        }else {
            //出场判断是否为VIP车辆
            ObjectResponse<VipType> validVipCar = vipCarService.getValidVipCar(parkId, orderInfo.getPlateNum(), null);
            if (ObjectResponse.isSuccess(validVipCar)){
                //获取vip计费规则
                billId = getVipOutBillIdAndSetInnerVip(feeParamHolder, regionId, innerOrderSonInfo, validVipCar.getData());
            }
        }

        ParkChargeconfig parkChargeconfig;
        //根据车牌颜色获取计费规则
        if (billId == null){
            parkChargeconfig = chargeService.getParkChargeConfigByPlateColor(regionId, orderInfo.getOrderNum(),
                    orderInfo.getPlateNum(), park.getId());
            if (Objects.isNull(parkChargeconfig)) {
                log.warn("[查费-计算模块] 车场未配置默认的计费规则，parkId：{}", parkId);
                throw new ResponseBodyException(CodeConstants.ERROR_3001, "未配置默认计费规则");
            }
            billId = parkChargeconfig.getId();
        } else {
            parkChargeconfig = parkChargeconfigDao.selectByPrimaryKey(billId);
            AssertTools.notNull(parkChargeconfig, CodeConstants.ERROR_3001, "vip计费规则数据不完整");
        }
        feeParamHolder.putParkChargeConfig(billId, parkChargeconfig);

        ChargeConfigDTO chargeConfigDTO = parkService.getChargeByBillId(parkChargeconfig, orderInfo.getCarType());
        //剩余最大收费金额
        BigDecimal surplusfee = maxFee(feeParamHolder, chargeConfigDTO, orderInfo, parkTime);
        //已经达到最大配置限额直接放行
        if (surplusfee != null) {
            if(new BigDecimal(0).compareTo(surplusfee) == 0) {
                QueryOrderFeeResponse freeRet = getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
                feeParamHolder.setBreak(true);
                return freeRet;
            }
            if(surplusfee.compareTo(BigDecimal.valueOf(0)) > 0) {
                feeParamHolder.setSurplusfee(surplusfee);
            }
        }

        //查询已缴费汇总信息
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        //已支付标识
        boolean isPaid = feeDto != null;
        //超时计费起始时间1末次缴费时间 2车辆入场时间
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        //缴费后超时时间
        long timeoutTime = 0;
        //是否有小场出口缴费
        boolean hasSmallParkExitPay = feeParamHolder.hasExitPay(orderInfo.getOrderNum());
        //外场是否缴费：内场出场时间小于上次支付时间
        boolean isOutPay = isPaid && innerOrderSonInfo.getExitTime() < feeDto.getLastPayTime();
        if (isPaid && !hasSmallParkExitPay){//如果不是在小场出口缴费
            if (isOutPay){//在外场支付，则判断是否超预留时间
                Long lastPayTime = feeDto.getLastPayTime();
                //实际结束时间 - 上次支付时间 等于超时时间
                timeoutTime = endTime - lastPayTime;
                startTime = lastPayTime;
                log.info("大场预缴费后，超时时间为：{}", timeoutTime);
            }else{
                //小场支付过了大场前半段的费用，则当前只计费后半段费用，即从小场出场开始计费
                startTime = innerOrderSonInfo.getExitTime();
                log.info("小场预缴费后，开始时间为小场离场时间：{}", startTime);
            }
        }

        //免费停车时长(秒)
        Integer isFreetimeOnce = chargeConfigDTO.getIsFreetimeOnce();
        int freeTime = chargeConfigDTO.getFreeTime() * 60;

        boolean isUseFreetime = true;
        if (freeTime > 0 && isFreetimeOnce != null) {
            if (isFreetimeOnce < 0) {
                isUseFreetime = true;
            } if (isFreetimeOnce == 0) {    // 无免费次数
                freeTime = 0;
                isUseFreetime = false;
            } else {
                LocalDate today = LocalDate.now();
                long begin = DateUtils.toEpochSecond(today.atStartOfDay());
                long end = DateUtils.toEpochSecond(today.plusDays(1).atStartOfDay()) - 1;
                int count = orderInfoDao.countEnexTimesByEnterTime(parkId, orderInfo.getPlateNum(), begin, end);
                if (count > isFreetimeOnce) {   // 入场次数大于限制次数
                    log.info("[查费-计算模块] 当日免费时长使用次数已用完|{}|{}|{}", orderInfo.getPlateNum(), count, isFreetimeOnce);
                    isUseFreetime = false;
                } else {
                    isUseFreetime = true;
                }
            }
        }

        Long bigParkTime = feeParamHolder.getOutParkTime();

        feeParamHolder.setUseFreetime(isUseFreetime);
        feeParamHolder.setStartTime(startTime);
        feeParamHolder.setOutEndTime(startTime + bigParkTime);

        //已产生的应缴费用，不含本次应缴费
        float totalPrice = isPaid ? feeDto.getTotalPrice() : 0;
        //本次应缴费，默认为0
        float thisFee = 0;
        long freeSwitchTime = NumberUtils.toPrimitive(park.getSwitchFeeTime()) * 60L;
        //首次缴费，停车时长大于免费时长
        boolean firstPay = bigParkTime > freeTime && bigParkTime - freeSwitchTime > 0 && timeoutTime == 0;
        //二次缴费超时时长大于缴费后预留时长
        boolean secondPay = timeoutTime > 0 && timeoutTime > freeTimeAfterPay * 60;
        //在外场支付，判断是否超预留时间
        boolean isOutPayAndNoTimeOut = isOutPay && timeoutTime <= freeTimeAfterPay * 60L;
        if (!isOutPayAndNoTimeOut && (firstPay || secondPay)) {
            List<BaseFeeParamHolder.ExtraComputeFeePara> computeFeeParaList = feeParamHolder.getExtraComputeFeeParaList();
            if (!feeParamHolder.isMonthCarFee() && CollectionUtils.isEmpty(computeFeeParaList))
                computeFeeParaList = resolveHolsFeeParams(feeParamHolder.getOrderInfo(), startTime, startTime + bigParkTime);
            if (CollectionUtils.isEmpty(feeParamHolder.getExtraComputeFeeParaList())) {
                thisFee = chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), (int)(startTime + bigParkTime),
                        0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                        feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                        feeParamHolder.getCsSwitchTime(), isUseFreetime);
            } else {
                boolean currentIsUseFreetime = isUseFreetime;
                for (BaseFeeParamHolder.ExtraComputeFeePara touComputeFeePara : computeFeeParaList) {
                    thisFee = thisFee +  chargeFee(feeParamHolder, parkId, touComputeFeePara.getBillId() == null ? billId : touComputeFeePara.getBillId(),
                            touComputeFeePara.getStartTime().intValue(), touComputeFeePara.getEndTime().intValue(),
                            0, isPaid, orderInfo.getCarType(), touComputeFeePara.isCsMonthCarFee(),
                            touComputeFeePara.getCsFeeType(), touComputeFeePara.getCsStartTime(), touComputeFeePara.getCsEndTime(),
                            touComputeFeePara.getCsSwitchTime(), currentIsUseFreetime);
                    currentIsUseFreetime = false;
                }
            }
            log.info("[查费-计算模块] 车牌号[{}], 应收金额[{}]", orderInfo.getPlateNum(), thisFee);

            //超时缴费时，按入场时间计费，再减去已算费金额，就是需补缴金额
            if (isPaid && overtimeBillType == 2){
                thisFee = thisFee - totalPrice;
                log.info("[查费-计算模块] 超时缴费车牌号[{}], 减去已算费金额后应缴[{}]",
                        orderInfo.getPlateNum(), thisFee);
            }
            feeParamHolder.setThisFee(thisFee);
        }

        return feeParamHolder.getQueryOrderFeeResponse();
    }

    private Integer getVipOutBillIdAndSetInnerVip(MultipleAreaFeeParamHolder feeParamHolder, Long regionId, OrderSonInfo innerOrderSonInfo, VipType vipType) {
        Integer billId = null;
        List<VipRegion> vipRegionList = vipRegionService.getVipRegionsListByVipTypeId(vipType.getId());
        if (CollectionUtils.isNotEmpty(vipRegionList)) {
            VipRegion vipRegion = vipRegionList.stream()
                    .filter(vr -> Long.valueOf(0).equals(vr.getRegionId()))
                    .findFirst().orElse(null);
            if (vipRegion != null) {
                billId = vipRegion.getBillId();
                feeParamHolder.setInnerVipBillId(billId);
                feeParamHolder.setInnerVipType(vipType);
                feeParamHolder.setVipType(vipType);
            } else {
                for (VipRegion region : vipRegionList) {
                    if (region.getRegionId().equals(regionId)) {
                        billId = region.getBillId();
                        feeParamHolder.setVipType(vipType);
                    }
                    if (region.getRegionId().equals(innerOrderSonInfo.getRegionId())) {
                        feeParamHolder.setInnerVipBillId(region.getBillId());
                        feeParamHolder.setInnerVipType(vipType);
                    }
                }
            }
        }
        return billId;
    }

    /**
     *
     * @param chargeConfigDTO
     * @param orderInfo
     * @param parkTime
     * @return 0:已缴过最大小费，此单免费; null: 未使用最大收费; 大于0时：最大收费剩余金额
     */
    private BigDecimal maxFee(MultipleAreaFeeParamHolder feeParamHolder, ChargeConfigDTO chargeConfigDTO,
                              OrderInfo orderInfo, long parkTime){
        log.info("[查费-计算模块] 最大缴费逻辑判断, 车牌号[{}], 计费规则配置[{}]", orderInfo.getPlateNum(), chargeConfigDTO);
        if (chargeConfigDTO == null) {
            return null;
        }
        if(Integer.valueOf(1).equals(chargeConfigDTO.getDaynightmaxfeeusing())
                && Objects.nonNull(chargeConfigDTO.getDaynightmaxfee())) {
            return isFee(feeParamHolder, orderInfo, chargeConfigDTO, parkTime);
        }
        return null;
    }

    /**
     * 订单是否达到最大限额
     * @param orderInfo
     * @param feeParamHolder
     * @param chargeConfigDTO
     * @param parkTime
     * @return
     */
    private BigDecimal isFee(MultipleAreaFeeParamHolder feeParamHolder, OrderInfo orderInfo,
                             ChargeConfigDTO chargeConfigDTO, long parkTime){
        Integer billId = chargeConfigDTO.getBillId();
        Integer maxFeeType = chargeConfigDTO.getMaxFeeType();
        Integer countType = chargeConfigDTO.getCountType();
        Date startDate = new Date(feeParamHolder.getStartTime() * 1000);
        Date endDate = new Date(feeParamHolder.getEndTime() * 1000);

        Calendar calendar = Calendar.getInstance();
        //单天单次
        if (maxFeeType == null || maxFeeType == 1) {
            long diffDays = getDiffDays(startDate, endDate);
            //最大收费
            float maxFee = chargeConfigDTO.getDaynightmaxfee() * (diffDays == 0 ? 1 : diffDays);
            calendar.setTime(endDate);
            calendar.set(Calendar.HOUR_OF_DAY, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
            calendar.set(Calendar.MILLISECOND, 0);
            Date dayStart = calendar.getTime();
            long time = dayStart.getTime() / 1000;
            if (time > orderInfo.getEnterTime()) {
                return null;
            }
            //入场时间
            Long enterTime = orderInfo.getEnterTime();
            BigDecimal paidPrice = orderPayDao.sumPalteProOrderPay(orderInfo.getParkId(),
                    orderInfo.getPlateNum(), enterTime);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[查费-计算模块] 无需缴费车辆超过单次最大缴费额度，车牌号：{}，场内已缴费:{},最大缴费额度：{}",
                        orderInfo.getPlateNum(), paidPrice, maxFee);
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            //剩余金额
            return max.subtract(paidPrice);
        }
        //单天多次
        if (maxFeeType == 2) {
            long diffDays = getDiffDays(startDate, endDate);
            //最大收费
            float maxFee = chargeConfigDTO.getDaynightmaxfee() * (diffDays == 0 ? 1 : diffDays);
            if (Integer.valueOf(1).equals(countType)) {
                calendar.setTime(startDate);
            } else if (Integer.valueOf(2).equals(countType)) {
                calendar.setTime(endDate);
            } else {
                calendar.setTime(startDate);
            }
            calendar.set(Calendar.HOUR_OF_DAY, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
            calendar.set(Calendar.MILLISECOND, 0);
            Date dayStart = calendar.getTime();
            BigDecimal paidPrice = getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, dayStart, maxFee);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[查费-计算模块] 无需缴费车辆超过单天最大缴费额度，车牌号：{}，当天已缴费:{},最大缴费额度：{}",
                        orderInfo.getPlateNum(), paidPrice, maxFee);
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            //剩余金额
            return max.subtract(paidPrice);
        }
        //24小时内
        if (maxFeeType == 3) {
            //停车天数：小于1天时按1天；parkTime为0时，停车0天
            long diffDays = parkTime / (24 * 3600) + ((parkTime % (24 * 3600) > 0) ? 1 : 0);
            //最大收费
            float maxFee = chargeConfigDTO.getDaynightmaxfee() * (diffDays == 0 ? 1 : diffDays);
            if (Objects.nonNull(countType) && countType == 3) {
                Date enterDate = new Date(orderInfo.getEnterTime() * 1000);
                calendar.setTime(enterDate);
                calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 24);
                Date btime = calendar.getTime();
                BigDecimal maxFeePara = getMaxFeePara(feeParamHolder, orderInfo, billId, endDate, btime, chargeConfigDTO.getDaynightmaxfee());
                if (maxFeePara == null) {
                    return maxFeePara;
                }
                log.info("[新版本24小时按入场最大收费] 当前订单最大收费[{}], 24小时最大收费{}", maxFee, maxFeePara);
                return maxFeePara.compareTo(new BigDecimal(maxFee)) > 0 ? new BigDecimal(maxFee) : maxFeePara;
            }
            BigDecimal paidPrice = BigDecimal.ZERO;
            if (Objects.nonNull(countType) && countType == 1) {
                Date enterDate = new Date(orderInfo.getEnterTime() * 1000);
                calendar.setTime(enterDate);
                calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 24);
                Date btime = calendar.getTime();
                paidPrice = getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, btime, maxFee);
            } else if (Objects.nonNull(countType) && countType == 2) {
                calendar.setTime(endDate);
                calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 24);
                Date btime = calendar.getTime();
                paidPrice = getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, btime, maxFee);
            }
            log.info("[查费-计算模块] 24小时已支付金额[{}]", paidPrice);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[查费-计算模块] 无需缴费车辆超过24小时最大缴费额度，车牌号：{}，24小时内已缴费:{},最大缴费额度：{}",
                        orderInfo.getPlateNum(), paidPrice, maxFee);
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            return max.subtract(paidPrice);
        }
        return null;
    }

    private BigDecimal getPaidFeeForMaxFee(MultipleAreaFeeParamHolder feeParamHolder, OrderInfo orderInfo, Integer billId,
                                           Date endDate, Date beginTime, float maxFee) {
        BigDecimal paidPrice = BigDecimal.ZERO;
        List<SumPayByOrderNumDto> sumPayByOrderNumDtos = orderPayDao.sumPaidPriceByPlateNum(
                orderInfo.getParkId(), orderInfo.getPlateNum(), beginTime.getTime() / 1000, endDate.getTime() / 1000);
        if (CollectionUtils.isEmpty(sumPayByOrderNumDtos)) {
            return paidPrice;
        }
        log.info("[查费-计算模块] 获取近24小时已收费用, 24小时范围内支付记录[{}]", sumPayByOrderNumDtos);
        //最早入场记录的支付记录
        SumPayByOrderNumDto sumPayByOrderNumDto = sumPayByOrderNumDtos.get(0);
        Long enterTime = sumPayByOrderNumDto.getEnterTime();

        double paidPriceSum = sumPayByOrderNumDtos.stream().collect(
                Collectors.summarizingDouble(orderNumPay -> orderNumPay.getPaidPrice().doubleValue())).getSum();
        //如果最早入场在定长时间段
        if (enterTime >= beginTime.getTime() / 1000) {
            paidPrice = new BigDecimal(paidPriceSum);
            log.info("[查费-计算模块] 获取近24小时已收费用, 最早支付订单的入场时间在24小时范围内,实收总金额为[{}]", paidPriceSum);
        } else {
            log.info("[查费-计算模块] 获取近24小时已收费用, 最早支付订单的入场时间在24小时范围外,开始计算范围内的实收,plateNum[{}]", orderInfo.getPlateNum());
            if (new BigDecimal(paidPriceSum).subtract(sumPayByOrderNumDto.getPaidPrice()).compareTo(new BigDecimal(maxFee)) >= 0
                    || sumPayByOrderNumDto.getPaidPrice().compareTo(new BigDecimal(0)) == 0) {
                paidPrice = new BigDecimal(paidPriceSum);
                log.info("[查费-计算模块] 获取近24小时已收费用, 总实收减跨时间点订单的实收后仍然大于等于最大收费,或订单实时为0,实收总金额为[{}]", paidPriceSum);
            } else {
                //计算从入场到定长时间点的费用
                float prefixFee = chargeFee(feeParamHolder, orderInfo.getParkId(), billId, enterTime.intValue(), (int) (beginTime.getTime() / 1000),
                        0, false, orderInfo.getCarType(), false, 0,
                        null, null, null, true);
                //计算从入场到定长时间点的费用
                float totalFee = chargeFee(feeParamHolder, orderInfo.getParkId(), billId, enterTime.intValue(), sumPayByOrderNumDto.getExitTime().intValue(),
                        0, false, orderInfo.getCarType(), false, 0,
                        null, null, null, true);
                BigDecimal paidPriceBd = sumPayByOrderNumDto.getPaidPrice();
                BigDecimal suffixFee = BigDecimal.valueOf(totalFee).subtract(new BigDecimal(prefixFee));

                if (suffixFee.compareTo(new BigDecimal(0)) < 0) {
                    suffixFee = new BigDecimal(0);
                }
                paidPrice = new BigDecimal(paidPriceSum).subtract(paidPriceBd).add(suffixFee);
                if (paidPrice.compareTo(new BigDecimal(paidPriceSum)) > 0) {
                    log.info("应收{}大于实收{}时，以实收为准", paidPrice, paidPriceSum);
                    paidPrice = new BigDecimal(paidPriceSum);
                }
            }
        }
        return paidPrice;
    }

    public static long getDiffDays(Date start, Date end) {
        LocalDate startTime = LocalDateTime.ofInstant(start.toInstant(), ZoneOffset.of("+8")).toLocalDate();
        LocalDate endTime = LocalDateTime.ofInstant(end.toInstant(), ZoneOffset.of("+8")).toLocalDate();
        if (startTime.isAfter(endTime)) {
            return 0;
        }
        if (startTime.isEqual(endTime)) {
            return 0;
        }
        return endTime.toEpochDay() - startTime.toEpochDay() + 1;
    }

}
