package com.icetech.park.service.queryfee.multipleareachain;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.order.dao.OrderTrackMapper;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.park.service.queryfee.MonthFeeDto;
import com.icetech.park.service.queryfee.MonthFeeHandle;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Slf4j
@Service
@RefreshScope
public class InnerAreaPreFeeHandleChain extends MultipleAreaQueryFeeChainAbstract {

    @Autowired
    private MonthFeeHandle monthFeeHandle;
    @Autowired
    private OrderTrackMapper orderTrackMapper;
    @Value("${innerArea.parkTime.parkIds:0}")
    private String innerAreaParkTimeParkIds;
    //下一个责任类
    private final InnerAreaComputeFeeHandleChain nextChain;
    @Autowired
    public InnerAreaPreFeeHandleChain(InnerAreaComputeFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        if (feeParamHolder.isInnerContinue()) {
            return nextChain.queryFee(feeParamHolder);
        }
        QueryOrderFeeResponse queryOrderFeeResponse = queryFeeObject(feeParamHolder);
        feeParamHolder.setInnerQueryOrderFeeResponse(queryOrderFeeResponse);
        return nextChain.queryFee(feeParamHolder);
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {

        QueryOrderFeeRequest queryOrderFeeRequest = feeParamHolder.getQueryOrderFeeRequest();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        Park park = feeParamHolder.getPark();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();

        OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
        Long parkId = park.getId();
        //内场区域ID
        Long regionId = innerOrderSonInfo.getRegionId();
        //用参数中的车型来查询费用
        Integer carType = queryOrderFeeRequest.getCarType();
        if (carType != null) {
            orderInfo.setCarType(carType);
        }

        //小场出口识别
        boolean isInnerExitRec = true;
        //内场离场时间为空时，离场时间设置为小场的入场时间，全部按大场计费
        if (innerOrderSonInfo.getExitTime() == null){
            isInnerExitRec = false;
            innerOrderSonInfo.setExitTime(innerOrderSonInfo.getEnterTime());
        }
        //查询已缴费汇总信息
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        //已支付标识
        boolean isPaid = feeDto != null;
        //是否有小场出口缴费
        boolean hasSmallParkExitPay = feeParamHolder.hasExitPay(orderInfo.getOrderNum());
        //外场是否缴费：内场出场时间小于上次支付时间
        boolean isOutPay = isPaid && innerOrderSonInfo.getExitTime() < feeDto.getLastPayTime();

        //缴费后的免费时长
        int freeTimeAfterPay = NumberUtils.toPrimitive(parkConfig.getIsfreeAfterpay(15));

        Long startTime = innerOrderSonInfo.getEnterTime();
        Long endTime = innerOrderSonInfo.getExitTime();
        //停车时长，计费结束时间 - 入场时间
        Long parkTime = getNewInnerAreaParkTime(innerOrderSonInfo);
        parkTime = parkTime == null ? endTime - startTime : parkTime;

        log.info("hasSmallParkExitPay : {}, isOutPay : {}, isInnerExitRec : {}, innerOrderSonInfo : {}",
                hasSmallParkExitPay, isOutPay, isInnerExitRec, innerOrderSonInfo);
        //内出口有缴费或者有外场预缴费或者内场出口未识别到，小场不计费
        if (hasSmallParkExitPay || isOutPay || !isInnerExitRec){
            feeParamHolder.setInnerContinue(true);
            QueryOrderFeeResponse freeCarRet = getFreeRet(innerOrderSonInfo, feeParamHolder.getQueryTime(), parkTime,
                    freeTimeAfterPay, park.getParkName());
            feeParamHolder.setInnerContinue(true);
            return freeCarRet;
        }
        //外区域计费了（如果有肯定会用到优惠），则小场只能使用剩余优惠
        feeParamHolder.setInnerUseDiscount(feeParamHolder.getThisFee() == 0);

        //判断月卡类型
        MonthFeeDto monthFeeDto = monthFeeHandle.getMonthFeeParam(feeParamHolder, parkId, innerOrderSonInfo,
                startTime, endTime, parkConfig, 2);
        if (monthFeeDto != null) {
            if (monthFeeDto.isMonthRet()) {
                QueryOrderFeeResponse monthCarRet = getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime,
                        freeTimeAfterPay, park.getParkName());
                feeParamHolder.setInnerContinue(true);
                return monthCarRet;
            } else {
                if (monthFeeDto.getNewStartTime() != null) {
                    startTime = monthFeeDto.getNewStartTime();
                }
                if (monthFeeDto.getNewEndTime() != null) {
                    endTime = monthFeeDto.getNewEndTime();
                }
                feeParamHolder.setInnerCsFeeType(monthFeeDto.getCsFeeType());
                feeParamHolder.setInnerCsMonthCarFee(monthFeeDto.isCsMonthCarFee());
                feeParamHolder.setInnerCsStartTime(monthFeeDto.getCsStartTime());
                feeParamHolder.setInnerCsEndTime(monthFeeDto.getCsEndTime());
                feeParamHolder.setInnerCsSwitchTime(monthFeeDto.getCsSwitchTime());
                feeParamHolder.setInnerBillIdList(monthFeeDto.getBillIdList());
            }
        }

        //预约车判断
        Integer type = orderInfo.getType();
        if (PlateTypeEnum.访客车辆.getType().equals(type)) {
            //判断是否收费
            Integer visitIscharge = parkConfig.getVisitIscharge();
            if (visitIscharge != null && visitIscharge == 0) {
                QueryOrderFeeResponse monthCarRet = getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime,
                        freeTimeAfterPay, park.getParkName());
                log.info("预约车无需缴费返回，车牌号：{}", orderInfo.getPlateNum());
                feeParamHolder.setInnerContinue(true);
                return monthCarRet;
            }
        }
        feeParamHolder.setInnerParkTime(parkTime);
        feeParamHolder.setInnerStartTime(startTime);
        feeParamHolder.setInnerEndTime(endTime);
        return new QueryOrderFeeResponse();
    }

    public Long getNewInnerAreaParkTime(OrderSonInfo innerOrderSonInfo) {
        if (Arrays.asList(innerAreaParkTimeParkIds.split(",")).contains(innerOrderSonInfo.getParkId().toString())) {
            List<OrderTrack> orderTracks = orderTrackMapper.selectList(Wrappers.lambdaQuery(OrderTrack.class)
                    .eq(OrderTrack::getOrderNum, innerOrderSonInfo.getOrderNum())
                    .eq(OrderTrack::getRegionId, innerOrderSonInfo.getRegionId())
                    .orderByAsc(OrderTrack::getEnexTime));
            if (orderTracks.isEmpty()) {
                return null;
            }
            long parkTime = 0;
            OrderTrack lastOne = null;
            for (OrderTrack orderTrack : orderTracks) {
                if (lastOne != null) {
                    if (orderTrack.getRecordType().equals(2) && lastOne.getRecordType().equals(1)) {
                        parkTime += (orderTrack.getEnexTime() - lastOne.getEnexTime());
                        log.info("[小场停车时长新统计方式] 车牌号[{}], 入场时间[{}]，离场时间[{}]", innerOrderSonInfo.getPlateNum(),
                                lastOne.getEnexTime(), orderTrack.getEnexTime());
                    }
                }
                lastOne = orderTrack;
            }
            log.info("[小场停车时长新统计方式] 车牌号[{}], 停车时长[{}]", innerOrderSonInfo.getPlateNum(), parkTime);
            return parkTime;
        }
        return null;
    }
}
