package com.icetech.park.service.queryfee.multipleareachain;

import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.utils.NumberUtils;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Slf4j
@Service
public class InnerAreaDiscountFeeHandleChain extends MultipleAreaQueryFeeChainAbstract {

    //下一个责任类
    private MultipleAreaQueryFeeChainAbstract nextChain;

    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    public InnerAreaDiscountFeeHandleChain(TotalFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        if (feeParamHolder.isInnerContinue()) {
            return nextChain.queryFee(feeParamHolder);
        }
        QueryOrderFeeResponse queryOrderFeeResponse = queryFeeObject(feeParamHolder);
        feeParamHolder.setInnerQueryOrderFeeResponse(queryOrderFeeResponse);
        return nextChain.queryFee(feeParamHolder);
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {

        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();

        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        //设置基本参数
        setBasePara(orderInfo, queryOrderFeeResponse, feeParamHolder.getParkTime(),
                parkConfig.getIsfreeAfterpay(15), park.getParkName(), feeParamHolder.getQueryTime());

        //设置费用信息
        setQueryFeeInfo(feeParamHolder, queryOrderFeeResponse, park.getId(), orderInfo.getCarType());

        return queryOrderFeeResponse;
    }

    /**
     * 设置费用信息
     * @param feeParamHolder
     * @param queryOrderFeeResponse
     * @param parkId
     */
    private void setQueryFeeInfo(MultipleAreaFeeParamHolder feeParamHolder, QueryOrderFeeResponse queryOrderFeeResponse,
                                                  Long parkId, int carType) {
        OrderSumFeeDto orderSumFeeDto = feeParamHolder.getOrderSumFeeDto();
        VipType vipType = feeParamHolder.getInnerVipType();
        float thisFee = feeParamHolder.getInnerThisFee();

        float totalPrice = orderSumFeeDto != null ? orderSumFeeDto.getTotalPrice() : 0;
        ParkChargeconfig parkChargeconfig = feeParamHolder.getInnerParkChargeconfig();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        //总应收
        float totalAmount = totalPrice + thisFee;
        //VIP优惠处理
        float unPayPrice = vipDiscountHandle(feeParamHolder, parkId, orderSumFeeDto,
                vipType, thisFee, parkChargeconfig.getId(), orderInfo);
        //VIP优惠金额
        float vipDiscountPrice = thisFee - unPayPrice;

        //本次优惠
        float discountPrice = thisFee - unPayPrice;
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        if (feeDto == null){
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(0));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(0));
        }else{
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(feeDto.getPaidPrice()));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(feeDto.getDiscountPrice()));
            //此处的payTime时间就是下单时间
            queryOrderFeeResponse.setPayTime(feeDto.getLastOrderTime() == null ? feeDto.getLastPayTime() : feeDto.getLastOrderTime());
        }
        Float paidAmount = Float.parseFloat(queryOrderFeeResponse.getPaidAmount());
        Float discountAmount = Float.parseFloat(queryOrderFeeResponse.getDiscountAmount());
        Integer status = getFeeStatus(paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount);
        queryOrderFeeResponse.setStatus(status);
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(unPayPrice));
        queryOrderFeeResponse.setTotalAmount(FORMAT.format(totalAmount));
        if (vipDiscountPrice > 0) {
            queryOrderFeeResponse.setVipDiscountPrice(FORMAT.format(vipDiscountPrice));

            OrderPayDiscount.VipCouponsInfo vipCouponsInfo = redisUtils.hGet(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(),
                    OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc(), OrderPayDiscount.VipCouponsInfo.class);
            if (vipCouponsInfo != null) {
                vipCouponsInfo.addTypeId(vipType.getType());
                vipCouponsInfo.addDiscountType(vipType.getType());
                vipCouponsInfo.addDiscountPrice(BigDecimal.valueOf(vipDiscountPrice));
            } else {
                vipCouponsInfo = new OrderPayDiscount.VipCouponsInfo();
                vipCouponsInfo.setDiscountType(vipType.getType().toString());
                vipCouponsInfo.setTypeId(vipType.getId().toString());
                vipCouponsInfo.setDiscountPrice(BigDecimal.valueOf(vipDiscountPrice));
            }
            redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(),
                    OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc(), vipCouponsInfo, 60*60*24);
        }
   }


    private float vipDiscountHandle(MultipleAreaFeeParamHolder feeParamHolder, Long parkId,
                                    OrderSumFeeDto orderSumFeeDto, VipType vipType,
                                    float thisFee, Integer billId, OrderInfo orderInfo) {
        if (vipType == null) {
            return thisFee;
        }
        float vipDiscount = 0;
        Integer type = vipType.getType();
        //全免
        if (DiscountTypeEnum.全免.getType().equals(type)) {
            vipDiscount = thisFee;
        }
        //减免金额
        if (DiscountTypeEnum.减免金额.getType().equals(type)) {
            if (feeParamHolder.isInnerUseAllVipDiscount()) {
                vipDiscount = NumberUtils.toFloat(vipType.getAmount());
            } else {
                vipDiscount = feeParamHolder.getSurplusVipPrice();
            }
        }
        //减免时间(转换成金额)
        if (DiscountTypeEnum.减免时间.getType().equals(type)) {
            int vipMinutesDiscount = NumberUtils.toInt(vipType.getAmount());
            if (!feeParamHolder.isInnerUseAllVipDiscount()) {
                vipMinutesDiscount = feeParamHolder.getSurplusVipTime();
            }
            if (vipMinutesDiscount > 0) {
                vipDiscount = thisFee - chargeFee(feeParamHolder, parkId, billId,
                        feeParamHolder.getInnerStartTime().intValue(), feeParamHolder.getInnerEndTime().intValue(),
                        vipMinutesDiscount, orderSumFeeDto != null, orderInfo.getCarType(),
                        feeParamHolder.isInnerCsMonthCarFee(), feeParamHolder.getInnerCsFeeType(), feeParamHolder.getInnerCsStartTime(),
                        feeParamHolder.getInnerCsEndTime(), feeParamHolder.getInnerCsSwitchTime(),
                        feeParamHolder.isUseFreetime(), feeParamHolder.getInnerParkChargeconfig(), 2);
            }
        }
        //减免折扣
        if (DiscountTypeEnum.折扣.getType().equals(type)) {
            //计费-减免折扣金额;
            float vipRateNum = NumberUtils.toFloat(vipType.getAmount());
            vipDiscount = BigDecimal.valueOf(thisFee)
                    .subtract(BigDecimal.valueOf(thisFee)
                            .multiply(BigDecimal.valueOf(vipRateNum))
                            .multiply(BigDecimal.valueOf(0.1f)))
                    .setScale(2, BigDecimal.ROUND_HALF_UP)
                    .floatValue();
        }

        float unPayPrice = thisFee - vipDiscount;
        if (unPayPrice < 0){
            unPayPrice = 0;
        }
        log.info("[VIP车辆计费优惠] 车牌号[{}], 优惠[{}],优惠之后[{}]", orderInfo.getPlateNum(), vipDiscount, unPayPrice);
        return unPayPrice;
    }

}
