package com.icetech.park.service.queryfee.multipleareachain;

import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.common.utils.DateUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.domain.dto.ChargeConfigDTO;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.park.service.queryfee.MultipleAreaQueryFeeChainAbstract;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class InnerAreaComputeFeeHandleChain extends MultipleAreaQueryFeeChainAbstract {

    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private ChargeService chargeService;
    //下一个责任类
    private MultipleAreaQueryFeeChainAbstract nextChain;

    @Autowired
    public InnerAreaComputeFeeHandleChain(InnerAreaDiscountFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(MultipleAreaFeeParamHolder feeParamHolder) {
        if (feeParamHolder.isInnerContinue()) {
            return nextChain.queryFee(feeParamHolder);
        }
        QueryOrderFeeResponse queryOrderFeeResponse = queryFeeObject(feeParamHolder);
        feeParamHolder.setInnerQueryOrderFeeResponse(queryOrderFeeResponse);
        return nextChain.queryFee(feeParamHolder);
    }

    public QueryOrderFeeResponse queryFeeObject(MultipleAreaFeeParamHolder feeParamHolder) {
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();
        Long innerParkTime = feeParamHolder.getInnerParkTime();
        Integer freeTimeAfterPay = parkConfig.getIsfreeAfterpay(15);
        Long parkId = park.getId();


        OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
        Long regionId = innerOrderSonInfo.getRegionId();
        Long startTime = feeParamHolder.getInnerStartTime();
        Long endTime = feeParamHolder.getInnerEndTime();
        //计费规则ID
        Integer billId = feeParamHolder.getInnerVipBillId();
        //月卡计费规则
        Integer monthBillId = CollectionUtils.isEmpty(feeParamHolder.getInnerBillIdList()) || feeParamHolder.getInnerBillIdList().stream().anyMatch(Objects::isNull)
                ? null : feeParamHolder.getInnerBillIdList().stream().filter(Objects::nonNull).findFirst().orElse(null);
        billId = billId != null ? billId : monthBillId;

        ParkChargeconfig parkChargeconfig;
        //根据车牌颜色获取计费规则
        if (billId == null){
            parkChargeconfig = chargeService.getParkChargeConfigByPlateColor(regionId, orderInfo.getOrderNum(),
                    orderInfo.getPlateNum(), park.getId());
            if (Objects.isNull(parkChargeconfig)) {
                log.warn("[查费-计算模块] 车场未配置默认的计费规则，parkId：{}", parkId);
                throw new ResponseBodyException(CodeConstants.ERROR_3001, "未配置默认计费规则");
            }
            billId = parkChargeconfig.getId();
        }else{
            parkChargeconfig = parkChargeconfigDao.selectByPrimaryKey(billId);
            AssertTools.notNull(parkChargeconfig, CodeConstants.ERROR_3001, "vip计费规则数据不完整");
        }
        feeParamHolder.putParkChargeConfig(billId, parkChargeconfig);
        feeParamHolder.setInnerParkChargeconfig(parkChargeconfig);

        ChargeConfigDTO chargeConfigDTO = parkService.getChargeByBillId(parkChargeconfig, orderInfo.getCarType());

        //免费停车时长(秒)
        int freeTime = chargeConfigDTO.getFreeTime() * 60;
        //小场费用汇总
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        boolean isInnerPaid = feeDto != null && feeDto.getLastPayTime() < innerOrderSonInfo.getExitTime();

        //超时计费起始时间1末次缴费时间 2车辆入场时间
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        //缴费后超时时间
        long timeoutTime = 0;
        //是否有小场出口缴费
        if (isInnerPaid){//如果没有过出口缴费，则判断预留时间，否则走外场计费
            Long lastPayTime = feeDto.getLastPayTime();
            timeoutTime = endTime - lastPayTime;
            startTime = endTime - timeoutTime;
            log.info("[小场计费] 小场预缴费后，超时时长为：{}，新的计费开始时间为：{}", timeoutTime, startTime);
        }
        //免费停车时长(秒)
        Integer isFreetimeOnce = chargeConfigDTO.getIsFreetimeOnce();
        boolean isUseFreetime = true;
        if (freeTime > 0 && isFreetimeOnce != null) {
            if (isFreetimeOnce < 0) {
                isUseFreetime = true;
            } if (isFreetimeOnce == 0) {    // 无免费次数
                freeTime = 0;
                isUseFreetime = false;
            } else {
                LocalDate today = LocalDate.now();
                long begin = DateUtils.toEpochSecond(today.atStartOfDay());
                long end = DateUtils.toEpochSecond(today.plusDays(1).atStartOfDay()) - 1;
                int count = orderInfoDao.countEnexTimesByEnterTime(parkId, orderInfo.getPlateNum(), begin, end);
                if (count > isFreetimeOnce) {   // 入场次数大于限制次数
                    log.info("[查费-计算模块] 当日免费时长使用次数已用完|{}|{}|{}", orderInfo.getPlateNum(), count, isFreetimeOnce);
                    isUseFreetime = false;
                } else {
                    isUseFreetime = true;
                }
            }
        }

        feeParamHolder.setInnerStartTime(startTime);
        //已支付标识
        boolean isPaid = feeDto != null;
        //已产生的应缴费用，不含本次应缴费
        float totalPrice = isPaid ? feeDto.getTotalPrice() : 0;
        //本次应缴费，默认为0
        float thisFee = 0;
        //首次缴费，停车时长大于免费时长
        boolean firstPay = innerParkTime > freeTime && timeoutTime == 0;
        //二次缴费超时时长大于缴费后预留时长
        boolean secondPay = timeoutTime > 0 && timeoutTime > freeTimeAfterPay * 60;
        if (firstPay || secondPay) {
            List<BaseFeeParamHolder.ExtraComputeFeePara> computeFeeParaList = feeParamHolder.getExtraComputeFeeParaList();
            int countFeeParkTime = endTime.intValue() - startTime.intValue();
            if (feeParamHolder.getInnerParkTime() != null) {
                countFeeParkTime = Math.min(countFeeParkTime, feeParamHolder.getInnerParkTime().intValue());
            }
            if (!feeParamHolder.isMonthCarFee() && CollectionUtils.isEmpty(computeFeeParaList))
                computeFeeParaList = resolveHolsFeeParams(feeParamHolder.getInnerOrderSonInfo(), startTime, startTime.intValue() + countFeeParkTime);
            if (CollectionUtils.isEmpty(feeParamHolder.getExtraComputeFeeParaList())) {
                log.info("[小场计费] 车牌号[{}], 实际计费时长[{}]", orderInfo.getPlateNum(), countFeeParkTime);
                thisFee = chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), startTime.intValue() + countFeeParkTime,
                        0, isPaid, orderInfo.getCarType(), feeParamHolder.isInnerCsMonthCarFee(),
                        feeParamHolder.getInnerCsFeeType(), feeParamHolder.getInnerCsStartTime(), feeParamHolder.getInnerCsEndTime(),
                        feeParamHolder.getInnerCsSwitchTime(), isUseFreetime, parkChargeconfig, 2);
            } else {
                boolean currentIsUseFreetime = isUseFreetime;
                for (BaseFeeParamHolder.ExtraComputeFeePara touComputeFeePara : computeFeeParaList) {
                    Integer thisBillId = touComputeFeePara.getBillId() == null ? billId : touComputeFeePara.getBillId();
                    thisFee = thisFee +  chargeFee(feeParamHolder, parkId, thisBillId,
                            touComputeFeePara.getStartTime().intValue(), touComputeFeePara.getEndTime().intValue(),
                            0, isPaid, orderInfo.getCarType(), touComputeFeePara.isCsMonthCarFee(),
                            touComputeFeePara.getCsFeeType(), touComputeFeePara.getCsStartTime(), touComputeFeePara.getCsEndTime(),
                            touComputeFeePara.getCsSwitchTime(), currentIsUseFreetime, feeParamHolder.getParkChargeConfig(thisBillId), 2);
                    currentIsUseFreetime = false;
                }
            }
            log.info("[内场查费-计算模块] 车牌号[{}], 应收金额[{}]", orderInfo.getPlateNum(), thisFee);

            //超时缴费时，按入场时间计费，再减去已算费金额，就是需补缴金额
            if (isPaid && overtimeBillType == 2){
                thisFee = thisFee - totalPrice;
                log.info("[内场查费-计算模块] 超时缴费车牌号[{}], 减去已算费金额后应缴[{}]",
                        orderInfo.getPlateNum(), thisFee);
            }
            feeParamHolder.setInnerThisFee(thisFee);
        } else {
            log.info("内场未计费, 停车时长[{}], 免费时长[{}], 缴费后超时时长[{}]", innerParkTime, freeTime, timeoutTime);
        }

        return feeParamHolder.getInnerQueryOrderFeeResponse();
    }

}
