package com.icetech.park.service.queryfee.impl;

import com.icetech.cloudcenter.api.fee.TestFeeService;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.request.TestFeeRequest;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.park.service.runso.Clibrary;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

@Service("testFeeService")
@Slf4j
public class TestFeeServiceImpl implements TestFeeService {
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;

    private static DecimalFormat FORMAT = new DecimalFormat("###.##");

    @Override
    public ObjectResponse<Map<String, Object>> testFee(TestFeeRequest testFeeRequest) {
        ObjectResponse<ParkConfig> objectResponse = parkService.getParkConfig(testFeeRequest.getParkId());
        if (!ObjectResponse.isSuccess(objectResponse)){
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        ParkConfig data = objectResponse.getData();

        String csStartTime = testFeeRequest.getCsStartTime();
        String csEndTime = testFeeRequest.getCsEndTime();
        Long billId = testFeeRequest.getBillId();
        if (billId == null){
            ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectDefaultBill(testFeeRequest.getParkId());
            if (parkChargeconfig == null){
                return ObjectResponse.failed(CodeConstants.ERROR_402, "未配置默认计费规则");
            }
            billId = parkChargeconfig.getId().longValue();
        }
        ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectByPrimaryKey(billId.intValue());
        FeeParamHolder feeParamHolder = new FeeParamHolder(data, parkChargeconfig);

        float fee = chargeFee(feeParamHolder, testFeeRequest.getParkId(), testFeeRequest.getStartTime().intValue(), testFeeRequest.getEndTime().intValue(),
                    testFeeRequest.getDiscountTime(), testFeeRequest.getChargeFlag(), testFeeRequest.getCarType(), csStartTime, csEndTime, data.getIsnotgetsmallchange());
        Map<String, Object> feeMap = new HashMap<>();
        feeMap.put("fee", String.valueOf(FORMAT.format(fee)));
        return ObjectResponse.success(feeMap);
    }

    /**
     * 错时计费
     * @param parkId
     * @param startTime
     * @param tmExit
     * @param discountMinutes
     * @param carType
     * @return
     */
    private float chargeFee(FeeParamHolder feeParamHolder, Long parkId, int startTime, int tmExit,
                            int discountMinutes, Integer chargeFlag, Integer carType,
                            String csStartTime, String csEndTime, Integer isnotgetsmallchange) {
        //调取so查询费用
        Clibrary instantce = Clibrary.INSTANTCE;
        float fee;
        int useFreeTime = 0;
        String sChargeConfigCfg = feeParamHolder.getSChargeConfigCfg(feeParamHolder.getParkConfig());
        String sChargeRule = feeParamHolder.getSChargeRule(feeParamHolder.getParkChargeConfig());
        log.info("[计费测试] startTime:{},tmExit:{},discountMinutes:{},chargeFlag:{},carType:{},parkId:{},{},{},{},{},{}",
                startTime, tmExit, discountMinutes, chargeFlag, carType, parkId,
                csStartTime, csEndTime, 0, 0, useFreeTime);
        if (StringUtils.isNotBlank(csStartTime) && StringUtils.isNotBlank(csEndTime)) {
            fee = instantce.chargeinterface_time_json(startTime, tmExit, discountMinutes, chargeFlag,
                    carType, sChargeConfigCfg, sChargeRule, csStartTime, csEndTime,
                    0, 0, useFreeTime);
        }else {
            fee = instantce.chargeinterface_json(startTime, tmExit, discountMinutes, chargeFlag, carType,
                    sChargeConfigCfg, sChargeRule, useFreeTime);
        }
        log.info("[计费测试] 调用so获取费用：{}元",fee);
        if (fee < 0){
            log.warn("[计费测试] 调用so获取费用失败");
            throw new ResponseBodyException(CodeConstants.ERROR_3001, "so计费失败");
        }
        if (isnotgetsmallchange != null && isnotgetsmallchange == 1){
            float ys = fee % 1;
            if (ys >= 0.5){
                fee = ((int) fee) + 0.5F;
            }else{
                fee = (int) fee;
            }
        }
        return fee;
    }
}
