package com.icetech.park.service.queryfee.impl;

import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.cloudcenter.api.QueryExitPlateNumService;
import com.icetech.cloudcenter.domain.response.QueryExitPlateNumResponse;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.TimeUnit;

//@Component
@Deprecated
@Slf4j
public class SubChannelQueryFeeHandler extends BaseQueryFeeTools{

    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private QueryExitPlateNumService queryExitPlateNumService;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;

    /**
     *
     * @param queryOrderFeeRequest 请求参数
     * @param isUseDiscount 是否内场出口计费
     * @param regionId 区域ID
     * @param parkConfig 高级配置
     * @param park 车场信息
     * @return QueryOrderFeeResponse
     */
    public QueryOrderFeeResponse queryOrderFee(QueryOrderFeeRequest queryOrderFeeRequest, boolean isUseDiscount,
                                               Long regionId, ParkConfig parkConfig, Park park, int surplusMinutes, double surplusPrice){
        OrderSonInfo orderSonInfo = new OrderSonInfo();
        log.info("[小场计费] 剩余优惠分钟数：{}，剩余优惠金额：{}", surplusMinutes, surplusPrice);
        if (orderSonInfo.getId() == null){
            /*
             * 出口支付，获取车辆信息
             */
            ObjectResponse<QueryExitPlateNumResponse> queryResponse = queryExitPlateNumService.query(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
            ObjectResponse.notError(queryResponse);
            QueryExitPlateNumResponse data = queryResponse.getData();
            QueryOrderFeeResponse cacheFee = data.getCacheFee();
            if (cacheFee != null){
                log.info("[小场计费] 直接从出口缓存获取费用，cacheFee：{}",cacheFee);
                return cacheFee;
            }
            String orderNum = data.getOrderNum();
            Long exitTime = data.getExitTime();
            orderSonInfo = new OrderSonInfo();
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setParkId(park.getId());
            orderSonInfo = orderSonInfoDao.selectOneByEntity(orderSonInfo);
            orderSonInfo.setExitTime(exitTime);
        }else{
            /*
             * 异常离场的订单，再次请求计费时，计费结束时间不应该按异常离场的时间，还应该按当前时间，
             */
            if (orderSonInfo.getServiceStatus().equals(OrderStatusConstants.EXCEPTION)){
                orderSonInfo.setExitTime(DateTools.unixTimestamp());
            }
        }
        //设置默认参数
        if (orderSonInfo.getExitTime() == null){
            orderSonInfo.setExitTime(DateTools.unixTimestamp());
        }
        //用参数中的车型来查询费用
        Integer carType = queryOrderFeeRequest.getCarType();
        if (carType != null){
            orderSonInfo.setCarType(carType);
        }
        Long startTime = orderSonInfo.getEnterTime();
        Long endTime = orderSonInfo.getExitTime();
        Long parkTime = endTime - startTime;
        //封装返回信息
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();

        //判断是否是小场月卡车
        Boolean isManthCard = isMonthCard(orderSonInfo,regionId);
        if (isManthCard){
            return getFreeRet(orderSonInfo, parkTime, parkConfig.getIsfreeAfterpay(15), park.getParkName(), endTime);
        }
        //预约车处理
        Integer type = orderSonInfo.getType();
        if (PlateTypeEnum.访客车辆.getType().equals(type)){
            //判断是否收费
            Integer visitIscharge = parkConfig.getVisitIscharge();
            if (visitIscharge != null && visitIscharge == 0){
                QueryOrderFeeResponse monthCarRet = getFreeRet(orderSonInfo, parkTime, parkConfig.getIsfreeAfterpay(15), park.getParkName(), endTime);
                log.info("[小场计费] 预约车无需缴费返回，车牌号：{}", orderSonInfo.getPlateNum());
                return monthCarRet;
            }
        }
        //获取vip的计费规则
        Long billId = getBillIdByVip(orderSonInfo, null);//todo
        boolean isVip = false;
        VipType vipType = null;
        //根据车牌颜色获取计费规则
        if (billId == null){
            billId = getBillIdByPlateColor(regionId, orderSonInfo.getOrderNum(), orderSonInfo.getPlateNum(), park.getId());
        }else {
            //todo regionId
            ObjectResponse<VipType> validVipCar = vipCarService.getValidVipCar(orderSonInfo.getParkId(), orderSonInfo.getPlateNum(), null);
            vipType = validVipCar.getData();
            isVip = true;
        }
        //免费停车时长(秒)
        int freeTime = parkService.getFreeTimeByBillId(billId.intValue()) * 60;
        //小场费用汇总
        OrderSumFeeDto feeDto = getPaidFee(orderSonInfo.getOrderNum(), orderSonInfo.getParkId());
        boolean isInnerPaid = feeDto != null && feeDto.getLastPayTime() < orderSonInfo.getExitTime();

        //超时计费起始时间1末次缴费时间 2车辆入场时间
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        //缴费后超时时间
        long timeoutTime = 0;
        //是否有小场出口缴费
        if (isInnerPaid){//如果没有过出口缴费，则判断预留时间，否则走外场计费
            Long lastPayTime = feeDto.getLastPayTime();
            timeoutTime = endTime - lastPayTime;
            startTime = endTime - timeoutTime;
            log.info("[小场计费] 小场预缴费后，超时时长为：{}，新的计费开始时间为：{}", timeoutTime, startTime);
        }
        //缴费后的免费时长
        int freeTimeAfterPay = parkConfig.getIsfreeAfterpay(15);

        //应缴费用
        float fee;
        //优惠券时间优惠
        float minutesDiscount = 0;
        //VIP车时间优惠
        float vipMinutesDiscount = 0;
        /*
         * 如果首次缴费停车时长大于免费时长，或者二次缴费超时时长大于缴费后预留时长时才计费
         */
        if ((parkTime > freeTime && timeoutTime == 0)
                || (timeoutTime > 0 && timeoutTime > freeTimeAfterPay * 60L)) {
            //查询优惠列表
            List<OrderDiscount> orderDiscounts = orderDiscountDao.selectByOrderNum(orderSonInfo.getOrderNum(), STATUS);
            int discountMinutes = isUseDiscount ? getDiscountMinutes(orderDiscounts) : surplusMinutes;
            //拉取费用
            fee = chargeFee(park.getId(), Math.toIntExact(billId), startTime.intValue(), endTime.intValue(), 0, feeDto, orderSonInfo.getCarType(), false, 0, null, null, orderSonInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
            //小场使用优惠时，并且应缴费大于0
            if (fee > 0 && discountMinutes > 0) {
                minutesDiscount = fee - chargeFee(park.getId(), Math.toIntExact(billId), startTime.intValue(), endTime.intValue(), discountMinutes, feeDto, orderSonInfo.getCarType(), false, 0, null, null, orderSonInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                log.info("[小场计费] 优惠券车辆减免时间 车牌号{},减免时间之后的金额{}", orderSonInfo.getPlateNum(), minutesDiscount);
            }
            if (isVip && fee > 0 && fee - minutesDiscount > 0) {//如果费用大于0且分钟优惠后的金额大于0
                if (vipType.getType().equals(DiscountTypeEnum.减免时间.getType())) {
                    vipMinutesDiscount = fee - chargeFee(park.getId(), Math.toIntExact(billId), startTime.intValue(), endTime.intValue(), Integer.parseInt(vipType.getAmount()), feeDto, orderSonInfo.getCarType(), false, 0, null, null, orderSonInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                }
                //超时缴费时，按入场时间计费，再减去已算费金额，就是需补缴金额
                if (isInnerPaid && overtimeBillType == 2) {
                    //这种情况VIP只能在场内使用 不能超时缴费使用
                    vipType = null;
                }
            }
            //设置基本参数
            setBasePara(orderSonInfo, queryOrderFeeResponse, parkTime, parkConfig.getIsfreeAfterpay(15), feeDto, park.getParkName(), endTime);

            queryOrderFeeResponse.setUnpayPrice(String.valueOf(fee));
            //vip优惠信息
            if (isVip && vipType != null) {
                vipDiscount(fee, vipMinutesDiscount, orderSonInfo, queryOrderFeeResponse, vipType);
            }
            if (isUseDiscount) {
                discountDeal(billId, fee, minutesDiscount, orderDiscounts, queryOrderFeeResponse, orderSonInfo, parkConfig);
            } else {
                subChannelDiscountDeal(billId, fee, minutesDiscount, orderDiscounts, queryOrderFeeResponse, orderSonInfo, parkConfig);
            }

            BigDecimal discountPrice = new BigDecimal(queryOrderFeeResponse.getDiscountPrice()).add(BigDecimal.valueOf(surplusPrice));
            discountPrice = discountPrice.floatValue() > fee ? new BigDecimal(fee) : discountPrice;
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(new BigDecimal(fee).subtract(discountPrice)));

            queryOrderFeeResponse.setTotalAmount(NumberUtils.decimalAdd(fee, queryOrderFeeResponse.getTotalAmount()).toString());
            Integer status = getFeeStatus(Float.parseFloat(queryOrderFeeResponse.getPaidAmount()),
                    Float.parseFloat(queryOrderFeeResponse.getUnpayPrice()),
                    Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()),
                    Float.parseFloat(queryOrderFeeResponse.getDiscountAmount()),
                    Float.parseFloat(queryOrderFeeResponse.getTotalAmount()));
            queryOrderFeeResponse.setStatus(status);
            //缓存保存小场优惠的信息
            redisUtils.set("sub:"+orderSonInfo.getOrderNum(), queryOrderFeeResponse, 1L, TimeUnit.DAYS);
            return queryOrderFeeResponse;
        } else {
            log.info("[小场计费] 免费时长内或缴费后未超时，无需缴费返回，车牌号：{}", orderSonInfo.getPlateNum());
            return getFreeRet(orderSonInfo, parkTime, parkConfig.getIsfreeAfterpay(15), park.getParkName(), endTime);
        }
    }
}
