package com.icetech.park.service.queryfee.impl;

import com.icetech.cloudcenter.api.QueryFeeService;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.cloudcenter.domain.request.QueryFeeRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class PncQueryFeeServiceImpl {
    @Autowired
    private QueryFeeService queryFeeService;

    /**
     * 端网云查询费用
     * @param queryOrderFeeRequest
     * @param orderInfo
     * @param park
     * @return
     */
    public ObjectResponse<Void> queryFee(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, Park park) {
        if (orderInfo == null) {
            orderInfo = new OrderInfo();
        }
        //请求计费系统
        QueryFeeRequest queryFeeRequest = new QueryFeeRequest();
        queryFeeRequest.setPlateNum(queryOrderFeeRequest.getPlateNum());
        queryFeeRequest.setParkId(park.getId());
        queryFeeRequest.setOrderId(orderInfo.getLocalOrderNum());
        queryFeeRequest.setChannelId(queryOrderFeeRequest.getChannelId());
        queryFeeRequest.setParkCode(park.getParkCode());
        queryFeeRequest.setKey(park.getKey());
        queryFeeRequest.setCarType(queryOrderFeeRequest.getCarType() == null ? orderInfo.getCarType() : queryOrderFeeRequest.getCarType());
        queryFeeRequest.setTopic(queryOrderFeeRequest.getTopic());
        queryFeeRequest.setExtraInfo(queryOrderFeeRequest.getExtraInfo());
        return queryFeeService.queryFee(queryFeeRequest);
    }

}
