package com.icetech.park.service.queryfee.impl;

import com.icetech.cloudcenter.api.QueryExitPlateNumService;
import com.icetech.park.service.queryfee.multipleareachain.OutAreaPreFeeHandleChain;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryExitPlateNumResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.park.service.queryfee.MultipleAreaFeeParamHolder;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 主通道计费
 */
//@Component
@Deprecated
@Slf4j
public class MasterChannelQueryFeeHandler extends BaseQueryFeeTools{
    @Autowired
    private QueryExitPlateNumService queryExitPlateNumService;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OutAreaPreFeeHandleChain preFeeChainHandleChain;

    /**
     * 主订单计费
     * @return QueryOrderFeeResponse
     */
    public QueryOrderFeeResponse queryOrderFee(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, ParkConfig parkConfig, Park park){
        log.info("场中场车场计费：{}", queryOrderFeeRequest);
        if (orderInfo.getId() == null){
            /*
             * 出口支付，获取车辆信息
             */
            ObjectResponse<QueryExitPlateNumResponse> queryResponse =
                    queryExitPlateNumService.query(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
            ObjectResponse.notError(queryResponse, "当前通道未找到车辆");
            QueryExitPlateNumResponse data = queryResponse.getData();
            QueryOrderFeeResponse cacheFee = data.getCacheFee();
            if (cacheFee != null){
                log.info("直接从出口缓存获取费用，cacheFee：{}",cacheFee);
                return cacheFee;
            }
            String orderNum = data.getOrderNum();
            Long exitTime = data.getExitTime();
            orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(park.getId());
            orderInfo = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
            orderInfo.setExitTime(exitTime);
        } else {
            /*
             * 异常离场的订单，再次请求计费时，计费结束时间不应该按异常离场的时间，还应该按当前时间，
             * 所以先设置为空，；
             */
            if (!orderInfo.getServiceStatus().equals(OrderStatusConstants.IN_PARK)) {
                orderInfo.setExitTime(DateTools.unixTimestamp());
            }
        }
        //用参数中的车型来查询费用
        Integer carType = queryOrderFeeRequest.getCarType();
        if (carType != null){
            orderInfo.setCarType(carType);
        }
        return preFeeChainHandleChain.queryFee(new MultipleAreaFeeParamHolder(queryOrderFeeRequest, orderInfo, parkConfig, park));
/*
        //小场出口识别
        boolean isInnerExitRec = true;
        //内场离场时间为空时，离场时间设置为小场的入场时间，全部按大场计费
        if (orderSonInfo.getExitTime() == null){
            isInnerExitRec = false;
            orderSonInfo.setExitTime(orderSonInfo.getEnterTime());
        }
        //封装返回信息
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        //计算开始时间
        Long startTime = orderInfo.getEnterTime();
        Long endTime = orderInfo.getExitTime() == null ? DateTools.unixTimestamp() : orderInfo.getExitTime();
        Long firstTime = orderSonInfo.getEnterTime() - startTime;
        Long sendTime = endTime - orderSonInfo.getExitTime();
        long freeSwitchTime = NumberUtils.toPrimitive(park.getSwitchFeeTime()) * 60L;
        long bigParkTime = firstTime + sendTime;
        //大场计费结束时间
        long bigParkEndTime = startTime + bigParkTime;
        long parkTime = endTime - startTime;
        log.info("场中场切换免费时长：{}秒，大场停车时长为：{}秒", freeSwitchTime, bigParkTime);
        //判断是否是外场月卡车
        Boolean isBigParkMonthCard = isMonthCard(orderInfo, orderInfo.getRegionId());
        //预约车处理
        Integer type = orderInfo.getType();
        if (PlateTypeEnum.访客车辆.getType().equals(type)){
            //判断是否收费
            Integer visitIscharge = parkConfig.getVisitIscharge();
            if (visitIscharge != null && visitIscharge == 0){
                QueryOrderFeeResponse monthCarRet =
                        getFreeRet(orderInfo, parkTime, parkConfig.getIsfreeAfterpay(15), park.getParkName(), endTime);
                log.info("预约车无需缴费返回，车牌号：{}", orderInfo.getPlateNum());
                return monthCarRet;
            }
        }

        //获取vip的计费规则
        Long billId = getBillIdByVip(orderInfo, null);
        boolean isVip = false;
        VipType vipType = null;
        //根据车牌颜色获取计费规则
        if (billId == null){
            billId = getBillIdByPlateColor(orderInfo.getRegionId(), orderInfo.getOrderNum(), orderInfo.getPlateNum(), park.getId());
        }else {
            //todo regionId
            ObjectResponse<VipType> validVipCar = vipCarService.getValidVipCar(orderInfo.getParkId(), orderInfo.getPlateNum(), null);
            vipType = validVipCar.getData();
            isVip = true;
        }
        //查询已缴费汇总信息
        OrderSumFeeDto feeDto = getPaidFee(orderInfo.getOrderNum(), orderInfo.getParkId());
        //已支付标识
        boolean isPaid = feeDto != null;
        //免费停车时长(秒)
        int bigParkFreeTime = parkService.getFreeTimeByBillId(billId.intValue()) * 60;
        //超时计费起始时间1末次缴费时间 2车辆入场时间
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        //缴费后超时时间
        long timeoutTime = 0;
        //是否有小场出口缴费
        boolean hasSmallParkExitPay = hasExitPay(orderInfo.getOrderNum());
        //外场是否缴费：内场出场时间小于上次支付时间
        boolean isOutPay = isPaid && orderSonInfo.getExitTime() < feeDto.getLastPayTime();
        if (isPaid && !hasSmallParkExitPay){//如果不是在小场出口缴费
            if (isOutPay){//在外场支付，则判断是否超预留时间
                Long lastPayTime = feeDto.getLastPayTime();
                //实际结束时间 - 上次支付时间 等于超时时间
                timeoutTime = endTime - lastPayTime;
                startTime = lastPayTime;
                log.info("大场预缴费后，超时时间为：{}", timeoutTime);
            }else{
                //小场支付过了大场前半段的费用，则当前只计费后半段费用，即从小场出场开始计费
                startTime = orderSonInfo.getExitTime();
                log.info("小场预缴费后，开始时间为小场离场时间：{}", startTime);
            }
        }
        //缴费后的免费时长
        int freeTimeAfterPay = parkConfig.getIsfreeAfterpay(15);
        //在外场支付，则判断是否超预留时间
        if (isOutPay && timeoutTime <= freeTimeAfterPay * 60L){
            log.info("外场预缴费后未超时，车牌号：{}", orderInfo.getPlateNum());
            //设置基本参数
            setBasePara(orderInfo, queryOrderFeeResponse, parkTime, parkConfig.getIsfreeAfterpay(15), feeDto, park.getParkName(), endTime);
            return queryOrderFeeResponse;
        }

        //应缴费用
        float fee = 0;
        //优惠券时间优惠
        float minutesDiscount = 0;
        //VIP车时间优惠
        float vipMinutesDiscount = 0;
        //大场未使用的优惠
        float surplusPrice = 0;
        //剩余优惠时长
        int surplusMinutes = 0;
        //是否在大场计费了，如果计费了，就只能在小场使用剩余优惠分钟和金额了，否则（大场免费时长等）将所有优惠都使用在小场
        boolean isOutFee = false;

        //设置基本参数
        setBasePara(orderInfo, queryOrderFeeResponse, parkTime, parkConfig.getIsfreeAfterpay(15), feeDto, park.getParkName(), endTime);

        if (!isBigParkMonthCard && bigParkTime - freeSwitchTime > 0){//非外场月卡且大场停车时长大于0时才计费
            *//*
             * 如果首次缴费停车时长大于免费时长，或者二次缴费超时时长大于缴费后预留时长时才计费
             *//*
            if ((bigParkTime > bigParkFreeTime && timeoutTime == 0)
                    || (timeoutTime > 0 && timeoutTime > freeTimeAfterPay * 60L)) {
                //查询优惠列表
                List<OrderDiscount> orderDiscounts = orderDiscountDao.selectByOrderNum(orderInfo.getOrderNum(), STATUS);
                Integer discountMinutes = getDiscountMinutes(orderDiscounts);
                //拉取费用
                fee = chargeFee(park.getId(),Math.toIntExact(billId), startTime.intValue(), (int) bigParkEndTime, 0,
                        feeDto, orderInfo.getCarType(), false, 0, null, null,
                        orderInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                if (fee > 0){
                    isOutFee = true;
                }
                if (fee >0 && discountMinutes > 0){
                    if (bigParkTime < discountMinutes * 60){
                        surplusMinutes = (int) (discountMinutes * 60 - bigParkTime);
                    }
                    minutesDiscount =  fee - chargeFee(park.getId(), Math.toIntExact(billId), startTime.intValue(), (int) bigParkEndTime,
                            discountMinutes, feeDto, orderInfo.getCarType(), false, 0, null, null,
                            orderInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                    log.info("[优惠券车辆减免时间] 车牌号{},减免时间之后的金额{}",orderInfo.getPlateNum(),minutesDiscount);
                }
                if (fee >0 && fee - minutesDiscount > 0 &&  isVip){//如果费用大于0且分钟优惠后的金额大于0
                    if (vipType.getType().equals(DiscountTypeEnum.减免时间.getType())){
                        vipMinutesDiscount = fee - chargeFee(park.getId(), Math.toIntExact(billId), startTime.intValue(), (int) bigParkEndTime,
                                Integer.parseInt(vipType.getAmount()), feeDto, orderInfo.getCarType(), false, 0,
                                null, null, orderInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                    }
                    //超时缴费时，按入场时间计费，再减去已算费金额，就是需补缴金额
                    if (isPaid && overtimeBillType == 2){
                        //这种情况VIP只能在场内使用 不能超时缴费使用
                        vipType = null;
                    }
                }
                queryOrderFeeResponse.setUnpayPrice(String.valueOf(fee));
                //vip优惠信息
                if (isVip && vipType != null){
                    vipDiscount(fee, vipMinutesDiscount,orderInfo, queryOrderFeeResponse, vipType);
                }
                surplusPrice = discountDeal(billId, fee, minutesDiscount, orderDiscounts, queryOrderFeeResponse, orderInfo, parkConfig);
            }
        }

        //内出口没有缴费或者没有外场预缴费并且内场出口识别到了，则计算内场费用
        if ((!hasSmallParkExitPay || !isOutPay) && isInnerExitRec){
            //没有小场出口缴费信息 计算小场费用
            QueryOrderFeeResponse subQueryOrderFee;
            if (isOutFee){//外区域计费了（如果有肯定会用到优惠），则小场只能使用剩余优惠
                subQueryOrderFee = subChannelQueryFeeHandler.queryOrderFee(queryOrderFeeRequest, orderSonInfo, false,
                        orderSonInfo.getRegionId(), parkConfig, park, surplusMinutes, surplusPrice);
            }else{
                subQueryOrderFee = subChannelQueryFeeHandler.queryOrderFee(queryOrderFeeRequest, orderSonInfo, true,
                        orderSonInfo.getRegionId(), parkConfig, park, surplusMinutes, surplusPrice);
            }
            //获取总优惠
            BigDecimal allDiscountPrice = new BigDecimal(subQueryOrderFee.getDiscountPrice())
                    .add(new BigDecimal(queryOrderFeeResponse.getDiscountPrice()));
            //获取总实收
            BigDecimal allUnPayPrice = new BigDecimal(subQueryOrderFee.getUnpayPrice())
                    .add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));

            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(allUnPayPrice));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(allDiscountPrice));
            //获取总应收：外区域和内区域的本次应缴费和 + 已经产生的应缴费
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(allDiscountPrice.add(allUnPayPrice)
                    .add(new BigDecimal(queryOrderFeeResponse.getTotalAmount()))));

        }else{
            //获取总应收：外区域的本次应缴费 + 已经产生的应缴费
            queryOrderFeeResponse.setTotalAmount(NumberUtils.decimalAdd(fee, queryOrderFeeResponse.getTotalAmount()).toString());
        }
        Integer status = getFeeStatus(Float.parseFloat(queryOrderFeeResponse.getPaidAmount()),
                Float.parseFloat(queryOrderFeeResponse.getUnpayPrice()),
                Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()),
                Float.parseFloat(queryOrderFeeResponse.getDiscountAmount()),
                Float.parseFloat(queryOrderFeeResponse.getTotalAmount()));
        queryOrderFeeResponse.setStatus(status);
        return queryOrderFeeResponse;*/
    }
}
