package com.icetech.park.service.queryfee.impl;

import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.fee.dao.merchant.DiscountDayDao;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.RegionChargeconfigDao;
import com.icetech.fee.dao.storecard.StoreCardDao;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.park.config.JdbcProperties;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.park.service.runso.Clibrary;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.constants.PlateColorEnum;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.ToolsUtil;
import com.icetech.common.utils.UUIDTools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Slf4j
public class BaseQueryFeeTools {
    @Resource
    protected OrderCarInfoDao orderCarInfoDao;
    @Autowired
    protected ChargeService chargeService;
    @Autowired
    protected ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    protected ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    protected RegionChargeconfigDao regionChargeconfigDao;
    @Autowired
    protected VipCarService vipCarService;
    @Autowired
    protected OrderDiscountDao orderDiscountDao;
    @Autowired
    protected DiscountDayDao discountDayDao;
    @Autowired
    protected MonthCarServiceImpl monthCarService;
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    protected ParkServiceImpl parkService;
    @Autowired
    protected StoreCardDao storeCardDao;
    @Autowired
    private JdbcProperties jdbcProperties;

    protected static DecimalFormat FORMAT = new DecimalFormat("###.##");
    //优惠券未使用状态
    protected static final Integer STATUS = 0;

    @Autowired
    private VipRegionService vipRegionService;

    /**
     * 根据车牌颜色获取计费规则
     */
    public Long getBillIdByPlateColor(Long regionId, String orderNum, String plateNum, Long parkId){
        ParkChargeconfig parkChargeconfig = getParkChargeConfigByPlateColor(regionId, orderNum, plateNum, parkId);
        if (Objects.isNull(parkChargeconfig)) {
            log.info("车场未配置默认的计费规则，parkId：{}", parkId);
            throw new ResponseBodyException(CodeConstants.ERROR_3001, "未配置默认计费规则");
        }
        return Long.valueOf(parkChargeconfig.getId());
    }

    /**
     * 根据车牌颜色获取计费规则
     */
    public ParkChargeconfig getParkChargeConfigByPlateColor(Long regionId, String orderNum, String plateNum, Long parkId){
        log.info("获取计费规则，参数：regionId：{}, orderNum：{}, plateNum：{}, parkId：{}", regionId, orderNum, plateNum, parkId);
        if (plateNum != null){
            StoreCard storeCard = storeCardDao.selectValidateCard(parkId, plateNum);
            if (storeCard != null && regionId != null && regionId != 0){
                //获取储值卡的计费规则
                RegionChargeconfig regionChargeconfig = regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, 6);
                if (Objects.nonNull(regionChargeconfig)){
                    ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectByParkIdAndBillCode(parkId,regionChargeconfig.getBilltypecode());
                    if (Objects.nonNull(parkChargeconfig)){
                        log.info("使用储值卡车计费规则，orderNum：{}，parkChargeconfig：{}", orderNum, parkChargeconfig);
                        return parkChargeconfig;
                    }
                }
            }
        }
        //获取区域信息
        OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderNum);
        Long billId = null;
        if (carInfo != null && regionId != null && regionId != 0){
            String plateColor = carInfo.getPlateColor();
            if (PlateColorEnum.BULE.getDesc().equals(plateColor)){
                //获取蓝牌的计费规则
                RegionChargeconfig regionChargeconfig = regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, 3);
                if (Objects.nonNull(regionChargeconfig)){
                    ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectByParkIdAndBillCode(parkId,regionChargeconfig.getBilltypecode());
                    if (Objects.nonNull(parkChargeconfig)){
                        log.info("使用蓝牌车计费规则，orderNum：{}，parkChargeconfig：{}", orderNum, parkChargeconfig);
                        return parkChargeconfig;
                    }
                }
            }
            if (PlateColorEnum.YELLOW.getDesc().equals(plateColor)){
                //获取黄牌的计费规则
                RegionChargeconfig regionChargeconfig = regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, 4);
                if (Objects.nonNull(regionChargeconfig)){
                    ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectByParkIdAndBillCode(parkId,regionChargeconfig.getBilltypecode());
                    if (Objects.nonNull(parkChargeconfig)){
                        log.info("使用黄牌车计费规则，orderNum：{}，parkChargeconfig：{}", orderNum, parkChargeconfig);
                        return parkChargeconfig;
                    }
                }
            }
            if (PlateColorEnum.GREEN.getDesc().equals(plateColor) || PlateColorEnum.YELLOW_GREEN.getDesc().equals(plateColor) ){
                //获取新能源的计费规则
                RegionChargeconfig regionChargeconfig = regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, 1);
                if (Objects.nonNull(regionChargeconfig)){
                    ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectByParkIdAndBillCode(parkId,regionChargeconfig.getBilltypecode());
                    if (Objects.nonNull(parkChargeconfig)){
                        log.info("使用新能源车计费规则，orderNum：{}，parkChargeconfig：{}", orderNum, parkChargeconfig);
                        return parkChargeconfig;
                    }
                }
            }
            if (billId == null){
                //获取区域的默认规则
                RegionChargeconfig regionChargeconfig = regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, 0);
                if (Objects.nonNull(regionChargeconfig)){
                    ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectByParkIdAndBillCode(parkId,regionChargeconfig.getBilltypecode());
                    if (Objects.nonNull(parkChargeconfig)){
                        log.info("使用区域默认计费规则，orderNum：{}，parkChargeconfig：{}", orderNum, parkChargeconfig);
                        return parkChargeconfig;
                    }
                }
            }
            //获取车场默认的计费规则
            ObjectResponse<ParkChargeconfig> parkChargeconfig = chargeService.selectDefaultBill(parkId);
            log.info("使用车场默认计费规则，orderNum：{}，parkChargeconfig：{}", orderNum, parkChargeconfig);
            return parkChargeconfig.getData();
        }else {
            if (regionId != null && regionId != 0) {//没有车牌颜色
                //获取区域的默认规则
                RegionChargeconfig regionChargeconfig = regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, 0);
                if (Objects.nonNull(regionChargeconfig)) {
                    ObjectResponse<ParkChargeconfig> parkChargeconfig = chargeService.getConfigsBycode(parkId, regionChargeconfig.getBilltypecode());
                    if (ObjectResponse.isSuccess(parkChargeconfig)) {
                        log.info("使用区域默认计费规则，orderNum：{}，parkChargeconfig：{}", orderNum, parkChargeconfig.getData());
                        return parkChargeconfig.getData();
                    }
                }
            }
            //获取车场的默认计费规则
            ObjectResponse<ParkChargeconfig> parkChargeconfig = chargeService.selectDefaultBill(parkId);
            log.info("使用车场默认计费规则，orderNum：{}，parkChargeconfig：{}", orderNum, parkChargeconfig);
            return parkChargeconfig.getData();
        }
    }


    /**
     * 获取vip车辆的计费规则
     */
    public Long getBillIdByVip(OrderInfo orderInfo, Long regionId){
        //判断入场的时候是否为VIP车辆
        Long billId = null;
        if (PlateTypeEnum.VIP车辆.getType().equals(orderInfo.getType())){
            //获取该车辆最近的VIP配置信息
            ObjectResponse<VipType> recentVipCar = vipCarService.getRecentVipCar(orderInfo.getParkId(), orderInfo.getPlateNum(), regionId);
            if (ObjectResponse.isSuccess(recentVipCar)){
                VipRegion vipRegion = vipRegionService.getOneByVipTypeIdAndRegionId(recentVipCar.getData().getId(), 0L);
                if (vipRegion != null && vipRegion.getBillId() != null) {
                    billId = Long.valueOf(vipRegion.getBillId());
                }
            }
        } else {
            //出场判断是否为VIP车辆
            ObjectResponse<VipType> validVipCar = vipCarService.getValidVipCar(orderInfo.getParkId(), orderInfo.getPlateNum(), regionId);
            if (ObjectResponse.isSuccess(validVipCar)){
                //获取vip计费规则
                VipRegion vipRegion = vipRegionService.getOneByVipTypeIdAndRegionId(validVipCar.getData().getId(), 0L);
                if (vipRegion != null && vipRegion.getBillId() != null) {
                    billId = Long.valueOf(vipRegion.getBillId());
                }
            }
        }
        return billId;
    }

    /**
     * 获取免费封装信息
     * @param orderInfo
     * @param parkTime
     * @param freeTimeAfterPay
     * @param parkName
     * @return
     */
    public QueryOrderFeeResponse getFreeRet(OrderInfo orderInfo, Long parkTime, int freeTimeAfterPay, String parkName, Long endTime){
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        setBasePara(orderInfo, queryOrderFeeResponse, parkTime, freeTimeAfterPay,null, parkName, endTime);
        queryOrderFeeResponse.setStatus(1);
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0));
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0));
        queryOrderFeeResponse.setTotalAmount(FORMAT.format(0));
        return queryOrderFeeResponse;
    }

    /**
     * 月卡判断
     */
    public Boolean isMonthCard(OrderInfo orderInfo,Long regionId){
        MonthInfo monthInfo = monthCarService.findMonthInfo(orderInfo.getParkId(), orderInfo.getPlateNum(), regionId, 1);
        return monthInfo == null;
    }

    /**
     * vip的计算优惠
     */
    public void vipDiscount(float thisFee, float vipDiscount, OrderInfo orderInfo, QueryOrderFeeResponse queryOrderFeeResponse, VipType vipType) {
        if (vipType != null) {
            log.info("[VIP车辆计费优惠开始] 车牌号{},初始费用{}", orderInfo.getPlateNum(), thisFee);
            Integer type = vipType.getType();
            //全免
            if (DiscountTypeEnum.全免.getType().equals(type)) {
                vipDiscount = thisFee;
                log.info("[VIP车辆计费优惠-减免时间] 车牌号{}.优惠{},优惠之后{}", orderInfo.getPlateNum(), vipDiscount, thisFee - vipDiscount);
            } else if (DiscountTypeEnum.减免金额.getType().equals(type)) {
                float vip = ToolsUtil.parseFloat(vipType.getAmount());
                vipDiscount = vip;
                log.info("[VIP车辆计费优惠-减免金额] 车牌号{}.优惠{},优惠之后{}", orderInfo.getPlateNum(), vipDiscount, thisFee - vipDiscount);

            } else if (DiscountTypeEnum.减免时间.getType().equals(type)) {
                log.info("[VIP车辆计费优惠-减免时间] 车牌号{}.优惠{},优惠之后{}", orderInfo.getPlateNum(), vipDiscount, thisFee - vipDiscount);
            } else if (DiscountTypeEnum.折扣.getType().equals(type)) {
                //计费-减免折扣金额;
                float vipRateNum = ToolsUtil.parseFloat(vipType.getAmount());
                float discountFee = thisFee * vipRateNum * 0.1f;
                vipDiscount = thisFee - discountFee;
                log.info("[VIP车辆计费优惠-折扣] 车牌号{}.优惠{},优惠之后{}", orderInfo.getPlateNum(), vipDiscount, thisFee - vipDiscount);
            }
        }
        if (vipDiscount > thisFee) {
            vipDiscount = thisFee;
        }
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(vipDiscount));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(thisFee - vipDiscount));
    }

    /**
     * 优惠处理
     *
     * @param thisFee 本次应缴费
     * @param billId
     * @param minutesDiscount
     * @param orderDiscounts 优惠列表
     * @param queryOrderFeeResponse
     * @param orderInfo
     * @return
     */
    public float discountDeal(Long billId, float thisFee, float minutesDiscount, List<OrderDiscount> orderDiscounts, QueryOrderFeeResponse queryOrderFeeResponse, OrderInfo orderInfo, ParkConfig parkConfig){
        return discountDeal(billId, thisFee, minutesDiscount, orderDiscounts, queryOrderFeeResponse, orderInfo, parkConfig, true);
    }
    public float discountDeal(Long billId, float thisFee, float minutesDiscount, List<OrderDiscount> orderDiscounts, QueryOrderFeeResponse queryOrderFeeResponse, OrderInfo orderInfo, ParkConfig parkConfig, boolean isUseFreetime){
        //剩余优惠
        float noUseDiscount = 0f;

        float unPayPrice = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
        float discountPrice = Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()) + minutesDiscount;
        //否有按天优免
        DiscountDay discountDay = discountDayDao.selectLastByPlateNum(queryOrderFeeResponse.getPlateNum(), orderInfo.getParkId());
        if (discountDay != null){
            Date validStart = discountDay.getStartTime();
            Date validEnd = discountDay.getEndTime();
            Date startDate = new Date(queryOrderFeeResponse.getEnterTime() * 1000);
            Date endDate = new Date(queryOrderFeeResponse.getQueryTime() * 1000);
            //计费结束时间如果在优惠有效期内，则全免
            if (endDate.compareTo(validStart) == 1 && validEnd.compareTo(endDate) == 1){
                unPayPrice = 0;
                discountPrice = thisFee;
                log.info("[优惠券-按天优免全免] 车牌号{}.优惠{},优惠之后{}", queryOrderFeeResponse.getPlateNum(), discountPrice,unPayPrice);
            }else{
                //计费结束时间如果在优惠有效期之后，并且车辆是在有效期结束之前进的场，则计算有效期结束后的费用，即计费开始时间为有效期结束时间
                if (endDate.compareTo(validEnd) == 1 && validEnd.compareTo(startDate) == 1){
                    int startTime = (int)(validEnd.getTime()/1000);
                    float newFee = chargeFee(orderInfo.getParkId(), Math.toIntExact(billId), startTime, queryOrderFeeResponse.getQueryTime().intValue(), 0, null, orderInfo.getCarType(), false, 0, null, null, orderInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange(), isUseFreetime);
                    unPayPrice = newFee - discountPrice;
                    discountPrice = thisFee - unPayPrice;
                    log.info("[优惠券-按天优免部分计费] 车牌号{}.优惠{},优惠之后{}",queryOrderFeeResponse.getPlateNum(),discountPrice,unPayPrice);
                }
            }
        }
        if (orderDiscounts != null && orderDiscounts.size() > 0) {
            //是否全免
            if (hasDiscountFree(orderDiscounts)) {
                unPayPrice = 0;
                discountPrice = thisFee;
                log.info("[优惠券-全免] 车牌号{}.优惠{},优惠之后{}",queryOrderFeeResponse.getPlateNum(),discountPrice,unPayPrice);
            } else {
                //获取金额优惠
                float discountPriceNum = getDiscount(orderDiscounts, DiscountTypeEnum.减免金额.getType());
                log.info("[优惠券-金额优惠] 车牌号{}.金额{}",queryOrderFeeResponse.getPlateNum(),discountPriceNum);
                //获取折扣优惠
                float discountRateNum = getDiscount(orderDiscounts, DiscountTypeEnum.折扣.getType());
                log.info("[优惠券-折扣优惠] 车牌号{}.折扣{}",queryOrderFeeResponse.getPlateNum(),discountRateNum);
                /**
                 * 有金额优惠时
                 */
                if (discountPriceNum > 0) {
                    discountPrice = discountPrice + discountPriceNum;
                    unPayPrice = thisFee - discountPrice;
                    if (unPayPrice <= 0) {
                        discountPrice = thisFee;
                    }
                    noUseDiscount = discountPriceNum - thisFee;
                }


                /**
                 * 有折扣优惠时
                 */
                if (discountRateNum > 0) {
                    unPayPrice = unPayPrice * discountRateNum * 0.1f;
                    if (unPayPrice <= 0) {
                        discountPrice = thisFee;
                    } else {
                        discountPrice = thisFee - unPayPrice;
                    }
                }
            }
        }
        if (discountPrice > thisFee){
            noUseDiscount = discountPrice - thisFee;
            discountPrice = thisFee;
        }
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(thisFee - discountPrice));
        if (noUseDiscount < 0){
            noUseDiscount = 0;
        }
        return noUseDiscount;
    }
    /**
     * 子通道优惠处理-只处理按天优免、全免、折扣优惠
     *
     * @param thisFee 本次应缴费
     * @param minutesDiscount
     * @param orderDiscounts 优惠列表
     * @param queryOrderFeeResponse
     * @return
     */
    public void subChannelDiscountDeal(Long billId, float thisFee, float minutesDiscount, List<OrderDiscount> orderDiscounts, QueryOrderFeeResponse queryOrderFeeResponse, OrderInfo orderInfo, ParkConfig parkConfig){

        float unPayPrice = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
        float discountPrice = Float.parseFloat(queryOrderFeeResponse.getDiscountPrice()) + minutesDiscount;

        //否有按天优免
        DiscountDay discountDay = discountDayDao.selectLastByPlateNum(queryOrderFeeResponse.getPlateNum(), orderInfo.getParkId());
        if (discountDay != null){
            Date validStart = discountDay.getStartTime();
            Date validEnd = discountDay.getEndTime();
            Date startDate = new Date(queryOrderFeeResponse.getEnterTime() * 1000);
            Date endDate = new Date(queryOrderFeeResponse.getQueryTime() * 1000);
            //计费结束时间如果在优惠有效期内，则全免
            if (endDate.compareTo(validStart) == 1 && validEnd.compareTo(endDate) == 1){
                unPayPrice = 0;
                discountPrice = thisFee;
                log.info("[优惠券-按天优免全免] 车牌号{}.优惠{},优惠之后{}", queryOrderFeeResponse.getPlateNum(), discountPrice,unPayPrice);
            }else{
                //计费结束时间如果在优惠有效期之后，并且车辆是在有效期结束之前进的场，则计算有效期结束后的费用，即计费开始时间为有效期结束时间
                if (endDate.compareTo(validEnd) == 1 && validEnd.compareTo(startDate) == 1){
                    int startTime = (int)(validEnd.getTime()/1000);
                    float newFee = chargeFee(orderInfo.getParkId(), Math.toIntExact(billId), startTime, queryOrderFeeResponse.getQueryTime().intValue(), 0, null, orderInfo.getCarType(), false, 0, null, null, orderInfo.getSwitchTime(), parkConfig.getIsnotgetsmallchange());
                    unPayPrice = newFee - discountPrice;
                    discountPrice = thisFee - unPayPrice;
                    log.info("[优惠券-按天优免部分计费] 车牌号{}.优惠{},优惠之后{}",queryOrderFeeResponse.getPlateNum(),discountPrice,unPayPrice);
                }
            }
        }
        if (orderDiscounts != null && orderDiscounts.size() > 0) {
            //是否全免
            if (hasDiscountFree(orderDiscounts)) {
                unPayPrice = 0;
                discountPrice = thisFee;
                log.info("[优惠券-全免] 车牌号{}.优惠{},优惠之后{}",queryOrderFeeResponse.getPlateNum(),discountPrice,unPayPrice);
            } else {
                //获取折扣优惠
                float discountRateNum = getDiscount(orderDiscounts, DiscountTypeEnum.折扣.getType());
                log.info("[优惠券-折扣优惠] 车牌号{}.折扣{}", queryOrderFeeResponse.getPlateNum(), discountRateNum);

                /**
                 * 有折扣优惠时
                 */
                if (discountRateNum > 0) {
                    unPayPrice = unPayPrice * discountRateNum * 0.1f;
                    if (unPayPrice <= 0) {
                        discountPrice = thisFee;
                    } else {
                        discountPrice = thisFee - unPayPrice;
                    }
                }
            }
        }

        if (discountPrice > thisFee){
            discountPrice = thisFee;
        }
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(thisFee - discountPrice));
    }

    /**
     * 获取收费的状态
     * @param paidAmount
     * @param unPayPrice
     * @param discountPrice
     * @param totalAmount
     * @return
     */
    protected Integer getFeeStatus(Float paidAmount, Float unPayPrice, Float discountPrice, Float discountAmount, Float totalAmount) {
        log.info("判断费用状态参数：{}，{}，{}，{}，{}", paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount);
        if (totalAmount == 0) {
            return 1; // 免费时长内无需缴费
        }
        if (discountAmount.equals(totalAmount)){
            return  3; // 已缴费未超时
        }
        if ((unPayPrice > 0 || discountPrice >= totalAmount) && paidAmount == 0 && discountAmount == 0) {
            return  2; // 初次缴费
        }
        if (unPayPrice == 0 && paidAmount > 0) {
            return  3; // 已缴费未超时
        }
        if (unPayPrice > 0 && (paidAmount > 0 || discountAmount > 0)) {
            return  4; // 已缴费已超时
        }
        if (unPayPrice > 0){
            return  2; // 初次缴费
        }else{
            return 1; // 免费时长内无需缴费
        }
    }

    /**
     * 根据类型获取优惠总和
     * @param orderDiscounts
     * @return
     */
    protected float getDiscount(List<OrderDiscount> orderDiscounts, Integer disType){
        float fee = 0;
        for (OrderDiscount orderDiscount : orderDiscounts){
            if (orderDiscount.getType().equals(disType)){
                fee += ToolsUtil.parseFloat(orderDiscount.getAmount());
            }
        }
        return fee;
    }

    /**
     * 查询是否有全免优惠
     * @param orderDiscounts
     * @return
     */
    protected boolean hasDiscountFree(List<OrderDiscount> orderDiscounts){
        for (OrderDiscount orderDiscount : orderDiscounts){
            if (orderDiscount.getType().equals(DiscountTypeEnum.全免.getType())){
                return true;
            }
        }
        return false;
    }

    /**
     * 获取优惠总分钟数
     * @param orderDiscounts
     * @return
     */
    protected Integer getDiscountMinutes(List<OrderDiscount> orderDiscounts){
        Integer minutes = 0;
        for (OrderDiscount orderDiscount : orderDiscounts){
            if (orderDiscount.getType().equals(DiscountTypeEnum.减免时间.getType())){
                minutes += ToolsUtil.parseInt(orderDiscount.getAmount());
            }
        }
        return minutes;
    }

    /**
     * 汇总已支付费用
     * @param orderNum
     * @param parkId
     * @return
     */
    protected OrderSumFeeDto getPaidFee(String orderNum, Long parkId){
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(parkId);
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(PayStatusConstants.PAID);
        OrderSumFeeDto orderSumFeeDto = orderPayDao.sumFee(orderPay);
        return orderSumFeeDto;
    }

    /**
     * 是否有出口缴费
     * @param orderNum
     * @return
     */
    protected boolean hasExitPay(String orderNum){
        List<OrderPay> orderPays = orderPayDao.selectByOrderNum(orderNum);
        if (orderPays != null && orderPays.size() > 0){
            for (OrderPay orderPay1 : orderPays){
                String channelId = orderPay1.getChannelId();
                if (channelId != null){
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 设置基础参数
     * @param orderInfo
     * @param queryOrderFeeResponse
     * @param freeTimeAfterPay
     * @param feeDto
     * @param parkName
     */
    protected void setBasePara(OrderInfo orderInfo, QueryOrderFeeResponse queryOrderFeeResponse, Long parkTime, int freeTimeAfterPay, OrderSumFeeDto feeDto, String parkName, Long queryTime) {
        if (feeDto == null) {
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(0));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(0));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0));
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(0));
        } else {
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(feeDto.getPaidPrice()));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(feeDto.getDiscountPrice()));
            queryOrderFeeResponse.setUnpayPrice(FORMAT.format(0));
            queryOrderFeeResponse.setDiscountPrice(FORMAT.format(0));
            queryOrderFeeResponse.setTotalAmount(FORMAT.format(feeDto.getTotalPrice()));
            queryOrderFeeResponse.setPayTime(feeDto.getLastPayTime());
        }

        queryOrderFeeResponse.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeResponse.setPlateNum(orderInfo.getPlateNum());
        queryOrderFeeResponse.setEnterTime(orderInfo.getEnterTime());
        queryOrderFeeResponse.setQueryTime(queryTime == null ? DateTools.unixTimestamp() : queryTime);
        queryOrderFeeResponse.setParkTime(parkTime);
        queryOrderFeeResponse.setParkName(parkName);
        queryOrderFeeResponse.setFreeTime((long) (freeTimeAfterPay));
        queryOrderFeeResponse.setCarType(orderInfo.getCarType());
    }

    /**
     * 计算费用接口
     */
    /**
     * 计费
     * @param parkId
     * @param billId
     * @param startTime
     * @param tmExit
     * @param discountMinutes
     * @param carType
     * @param isnotgetsmallchange
     * @return
     */
    protected float chargeFee(Long parkId, Integer billId, int startTime, int tmExit, int discountMinutes, OrderSumFeeDto feeDto, Integer carType, boolean isCsMonthCarFee, int csFeeType, String csStartTime, String csEndTime, Long csSwitchTime, Integer isnotgetsmallchange) {
        return chargeFee(parkId, billId, startTime, tmExit, discountMinutes, feeDto, carType, isCsMonthCarFee, csFeeType, csStartTime, csEndTime, csSwitchTime, isnotgetsmallchange, true);
    }
    protected float chargeFee(Long parkId, Integer billId, int startTime, int tmExit, int discountMinutes, OrderSumFeeDto feeDto, Integer carType, boolean isCsMonthCarFee, int csFeeType, String csStartTime, String csEndTime, Long csSwitchTime, Integer isnotgetsmallchange, boolean isUseFreetime) {

        int chargeFlag = feeDto != null ? 1 : 0;
        //调取so查询费用
        Clibrary instantce = Clibrary.INSTANTCE;
        String feeSN = UUIDTools.generateShortUuid();
        String dbserver = jdbcProperties.getHost();
        String username = jdbcProperties.getUsername();
        String password = jdbcProperties.getPassword();
        log.debug("dbserver:{}, username:{}, password:{}", dbserver, username, password);
        log.info("[缴费查询] feeSN：{}，调用so获取费用参数：startTime:{},tmExit:{},discountMinutes:{},chargeFlag:{},carType:{},parkId:{},{},{},{},{},{}",
                feeSN, startTime, tmExit, discountMinutes, chargeFlag, carType, parkId, csStartTime, csEndTime, csFeeType,csSwitchTime,isUseFreetime ? 0 : 1);
        long before = System.currentTimeMillis();
        float fee;
        try{
            if (isCsMonthCarFee){
                fee = instantce.chargeinterface_time_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(),billId, dbserver, username, password, csStartTime, csEndTime, csFeeType, ToolsUtil.parseInt(csSwitchTime), isUseFreetime ? 0 : 1);
                if (fee < 0){
                    fee = instantce.chargeinterface_time_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(),billId, dbserver, username, password, csStartTime, csEndTime, csFeeType, ToolsUtil.parseInt(csSwitchTime), isUseFreetime ? 0 : 1);
                    log.info("[缴费查询] feeSN：{}，第一次计费失败，二次计费结果：{}", feeSN, fee);
                }
                log.info("[缴费查询] feeSN：{}，错时车调用so获取费用：{}元",feeSN, fee);
            }else {
                fee = instantce.chargeinterface_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(),billId, dbserver, username, password, isUseFreetime ? 0 : 1);
                if (fee < 0){
                    fee = instantce.chargeinterface_db_freetime(startTime, tmExit, discountMinutes, chargeFlag, carType, parkId.intValue(),billId,dbserver, username, password, isUseFreetime ? 0 : 1);
                    log.info("[缴费查询] feeSN：{}，第一次计费失败，二次计费结果：{}", feeSN, fee);
                }
                log.info("[缴费查询] feeSN：{}，调用so获取费用：{}元",feeSN, fee);
            }
        }finally {
            long elapsedTime = System.currentTimeMillis() - before;
            if (elapsedTime > 2000){
                log.warn("[缴费查询] feeSN：{}，查询时长为：{}毫秒", feeSN, elapsedTime);
            }
        }
        if (fee < 0){
            log.info("[缴费查询] feeSN：{}，调用so获取费用失败", feeSN);
            throw new ResponseBodyException(CodeConstants.ERROR_3001, "so计费失败");
        }else {
            BigDecimal bg = new BigDecimal(fee);
            fee = bg.setScale(2, BigDecimal.ROUND_HALF_UP).floatValue();
            log.info("[缴费查询] feeSN：{}，so计费后再四舍五入取两位小数后为{}元", feeSN, fee);
        }
        if (isnotgetsmallchange != null && isnotgetsmallchange == 1){
            float ys = fee % 1;
            if (ys >= 0.5){
                fee = ((int) fee) + 0.5F;
            }else{
                fee = (int) fee;
            }
        }
        return fee;
    }
}
