package com.icetech.park.service.queryfee.chain;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.city.common.domain.entity.common.Coupon;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.park.service.charge.ChargeServiceImpl;
import com.icetech.park.service.queryfee.DiscountOverHandle;
import com.icetech.fee.dao.merchant.DiscountDayDao;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.park.service.discount.ParkDiscountUserchargeService;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.park.service.queryfee.QueryFeeChainAbstract;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;

@Slf4j
@Service
public class DiscountFeeHandleChain extends QueryFeeChainAbstract {

    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private DiscountDayDao discountDayDao;
    @Autowired
    private DiscountOverHandle discountOverHandle;
    @Autowired
    private ParkDiscountUserchargeService parkDiscountUserchargeService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ChargeServiceImpl chargeService;
    @Autowired
    private ParkService parkService;
    //未使用状态
    private static final Integer STATUS = 0;
    //下一个责任类
    private QueryFeeChainAbstract nextChain;
    @Autowired
    public DiscountFeeHandleChain(AuthFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(FeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak()) {
            if (nextChain != null) {
                return nextChain.queryFee(feeParamHolder);
            }
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(FeeParamHolder feeParamHolder) {

        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();

        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        //设置基本参数
        setBasePara(orderInfo, queryOrderFeeResponse, feeParamHolder.getParkTime(),
                parkConfig.getIsfreeAfterpay(15), park.getParkName(), feeParamHolder.getQueryTime());

        //设置费用信息
        setQueryFeeInfo(feeParamHolder, queryOrderFeeResponse, park.getId(), orderInfo.getCarType());

        feeParamHolder.setQueryOrderFeeResponse(queryOrderFeeResponse);
        return queryOrderFeeResponse;
    }

    /**
     * 设置费用信息
     * @param feeParamHolder
     * @param queryOrderFeeResponse
     * @param parkId
     */
    private void setQueryFeeInfo(FeeParamHolder feeParamHolder, QueryOrderFeeResponse queryOrderFeeResponse,
                                                  Long parkId, int carType) {
        OrderSumFeeDto orderSumFeeDto = feeParamHolder.getOrderSumFeeDto();
        VipType vipType = feeParamHolder.getVipType();
        float thisFee = feeParamHolder.getThisFee();

        float totalPrice = orderSumFeeDto != null ? orderSumFeeDto.getTotalPrice() : 0;
        ParkChargeconfig parkChargeconfig = feeParamHolder.getParkChargeConfig();
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        //总应收
        float totalAmount = totalPrice + thisFee;
        //VIP优惠处理
        float unPayPrice = vipDiscountHandle(feeParamHolder, parkId, orderSumFeeDto,
                vipType, thisFee, parkChargeconfig.getId(), orderInfo);
        //VIP优惠金额
        float vipDiscountPrice = thisFee - unPayPrice;
        //优惠券处理
        unPayPrice = couponHandle(feeParamHolder, parkId, orderSumFeeDto, unPayPrice,
                parkChargeconfig, orderInfo, unPayPrice,queryOrderFeeResponse);
        //本次优惠
        float discountPrice = thisFee - unPayPrice;
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();
        if (feeDto == null){
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(0));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(0));
        }else{
            queryOrderFeeResponse.setPaidAmount(FORMAT.format(feeDto.getPaidPrice()));
            queryOrderFeeResponse.setDiscountAmount(FORMAT.format(feeDto.getDiscountPrice()));
            //此处的payTime时间就是下单时间
            queryOrderFeeResponse.setPayTime(feeDto.getLastOrderTime() == null ? feeDto.getLastPayTime() : feeDto.getLastOrderTime());
        }
        Float paidAmount = Float.parseFloat(queryOrderFeeResponse.getPaidAmount());
        Float discountAmount = Float.parseFloat(queryOrderFeeResponse.getDiscountAmount());
        Integer status = getFeeStatus(paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount);
        queryOrderFeeResponse.setStatus(status);
        queryOrderFeeResponse.setDiscountPrice(FORMAT.format(discountPrice));
        queryOrderFeeResponse.setUnpayPrice(FORMAT.format(unPayPrice));
        queryOrderFeeResponse.setTotalAmount(FORMAT.format(totalAmount));
        if (vipDiscountPrice > 0) {
            queryOrderFeeResponse.setVipDiscountPrice(FORMAT.format(vipDiscountPrice));
            OrderPayDiscount.VipCouponsInfo vipCouponsInfo = new OrderPayDiscount.VipCouponsInfo();
            vipCouponsInfo.setDiscountType(vipType.getType().toString());
            vipCouponsInfo.setTypeId(vipType.getId().toString());
            vipCouponsInfo.setDiscountPrice(BigDecimal.valueOf(vipDiscountPrice));
            redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(),
                    OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc(), vipCouponsInfo, 60*60*24);
        }
    }

    private float couponHandle(FeeParamHolder feeParamHolder, Long parkId, OrderSumFeeDto orderSumFeeDto, float thisFee,
                               ParkChargeconfig parkChargeconfig, OrderInfo orderInfo, float unPayPrice,QueryOrderFeeResponse queryOrderFeeResponse) {
        if (unPayPrice <= 0){
            return 0;
        }
        //查询优惠列表
        List<OrderDiscount> orderDiscounts = orderDiscountDao.selectByOrderNum(orderInfo.getOrderNum(), STATUS);

        if (CollectionUtils.isEmpty(orderDiscounts)) {
            orderDiscounts = Lists.newArrayList();
            log.debug("[叠加优惠] 暂无优惠信息 orderNum {}", orderInfo.getOrderNum());
            //是否有按天优免
            DiscountDay discountDay = discountDayDao.selectLastByPlateNum(orderInfo.getPlateNum(), parkId);
            if (discountDay != null){
                OrderDiscount orderDiscount = orderDiscountDao.selectOne(Wrappers.lambdaQuery(OrderDiscount.class)
                        .eq(OrderDiscount::getDiscountNo, discountDay.getDiscountNo())
                        .eq(OrderDiscount::getDelFlag,0)
                        .last(SqlConstant.LIMIT_ONE));
                if (Objects.nonNull(orderDiscount)){
                    orderDiscounts.add(orderDiscount);
                }
            }else {
                //没有优惠信息
                return unPayPrice;
            }
        }
        log.debug("[叠加优惠] 获取优惠信息 orderDiscounts {}", JsonUtils.toString(orderDiscounts));
        //获取车场优惠配置
        ParkDiscountUsercharge parkDiscountUsercharge = parkDiscountUserchargeService.getParkDiscountUserchargeByParkId(parkId);
        if (Objects.isNull(parkDiscountUsercharge)){
            // 设置默认值
            parkDiscountUsercharge = new ParkDiscountUsercharge();
            parkDiscountUsercharge.setParkId(parkId);
            parkDiscountUsercharge.setPlateGetCoupons(1);
            parkDiscountUsercharge.setSupportStackeUsage(2);
            parkDiscountUsercharge.setThirdpartyStackeUsage(1);
            parkDiscountUsercharge.setUserMultipleTimes(2);
        }
        //判断当前订单是否已经使用过优惠券
        List<OrderDiscount> orderDiscountsUsed = orderDiscountDao.selectList(
                Wrappers.lambdaQuery(OrderDiscount.class)
                        .eq(OrderDiscount::getOrderNum, orderInfo.getOrderNum())
                        .eq(OrderDiscount::getStatus,1)
                        .eq(OrderDiscount::getFrom, 1));
        if (parkDiscountUsercharge.getUserMultipleTimes() == 1 && CollectionUtils.isNotEmpty(orderDiscountsUsed)){
            log.info("[订单已经使用过优惠不能继续使用] orderNum {}",orderInfo.getOrderNum());
            return unPayPrice;
        }
        //叠加优惠
        DiscountOverHandle.DiscountInfo discount = discountOverHandle.getDiscount(feeParamHolder, parkChargeconfig, orderInfo,
                orderSumFeeDto, parkDiscountUsercharge, orderDiscounts, queryOrderFeeResponse.getParkTime(),
                BigDecimal.valueOf(unPayPrice), BigDecimal.valueOf(thisFee),Boolean.FALSE);
        BigDecimal discountPrice = discount.getDiscountPrice();
        unPayPrice = unPayPrice - discountPrice.floatValue();
        if (unPayPrice < 0) {
            unPayPrice = 0;
        }
        //标记本次计费使用的优惠券
        if (CollectionUtils.isNotEmpty(discount.getDiscountNos())){
            redisUtils.set(RedisDiscountKeyConstant.DISCOUNT_USE_PRE + parkId + ":" + orderInfo.getOrderNum(),
                    StrUtil.join(",",discount.getDiscountNos()),60*60*24);
        }
        log.info("[优惠券-标准优惠] 车牌号[{}], 优惠[{}],优惠之后[{}]", orderInfo.getPlateNum(), discountPrice, unPayPrice);

        if (discount.getMerchantDiscountPrice() != null) {
            queryOrderFeeResponse.setMerchantDiscountPrice(FORMAT.format(discount.getMerchantDiscountPrice()));
            redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(),
                    OrderPayDiscount.DiscountSourceEnum.MERCHANT_COUPONS.getDesc(), discount.getMerchantCouponsInfo(), 60*60*24);
        }
        if (discount.getThirdDiscountPrice() != null) {
            queryOrderFeeResponse.setThirdDiscountPrice(FORMAT.format(discount.getThirdDiscountPrice()));
            redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + parkId + ":" + orderInfo.getOrderNum(),
                    OrderPayDiscount.DiscountSourceEnum.THIRD_COUPONS.getDesc(), discount.getThirdCouponsInfo(), 60*60*24);
        }
        return unPayPrice;
    }
    private float vipDiscountHandle(FeeParamHolder feeParamHolder, Long parkId,
                                    OrderSumFeeDto orderSumFeeDto, VipType vipType,
                                    float thisFee, Integer billId, OrderInfo orderInfo) {
        if (vipType == null) {
            return thisFee;
        }
        float vipDiscount = 0;
        Integer type = vipType.getType();
        //全免
        if (DiscountTypeEnum.全免.getType().equals(type)) {
            vipDiscount = thisFee;
        }
        //减免金额
        if (DiscountTypeEnum.减免金额.getType().equals(type)) {
            vipDiscount = NumberUtils.toFloat(vipType.getAmount());
        }
        //减免时间(转换成金额)
        if (DiscountTypeEnum.减免时间.getType().equals(type)) {
            int vipMinutesDiscount = NumberUtils.toInt(vipType.getAmount());
            if (vipMinutesDiscount > 0) {
                vipDiscount = thisFee - chargeFee(feeParamHolder, parkId, billId,
                        feeParamHolder.getStartTime().intValue(), feeParamHolder.getEndTime().intValue(),
                        vipMinutesDiscount, orderSumFeeDto != null, orderInfo.getCarType(),
                        feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(),
                        feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(),
                        feeParamHolder.isUseFreetime());
            }
        }
        //减免折扣
        if (DiscountTypeEnum.折扣.getType().equals(type)) {
            //计费-减免折扣金额;
            float vipRateNum = NumberUtils.toFloat(vipType.getAmount());
            vipDiscount = BigDecimal.valueOf(thisFee)
                    .subtract(BigDecimal.valueOf(thisFee)
                            .multiply(BigDecimal.valueOf(vipRateNum))
                            .multiply(BigDecimal.valueOf(0.1f)))
                    .setScale(2, BigDecimal.ROUND_HALF_UP)
                    .floatValue();
        }

        float unPayPrice = thisFee - vipDiscount;
        if (unPayPrice < 0){
            unPayPrice = 0;
        }
        log.info("[VIP车辆计费优惠] 车牌号[{}], 优惠[{}],优惠之后[{}]", orderInfo.getPlateNum(), vipDiscount, unPayPrice);
        return unPayPrice;
    }

    /**
     * 计算实际优惠金额
     * @param orderInfo
     * @param coupon
     * @return
     */
    public BigDecimal calcDiscAmount(OrderInfo orderInfo, Coupon coupon) {
        return calcDiscAmount(orderInfo, null, null, coupon);
    }

    /**
     * 计算实际优惠金额
     * @param orderInfo
     * @param park
     * @param parkConfig
     * @param coupon
     * @return
     */
    public BigDecimal calcDiscAmount(OrderInfo orderInfo, @Nullable Park park, @Nullable ParkConfig parkConfig, Coupon coupon) {
        log.debug("通停优惠计算开始|{}|{}|{}|{}", orderInfo.getOrderNum(), orderInfo.getPlateNum(), coupon.getCouponType(), coupon.getCouponMsg());
        BigDecimal unpaidAmount = new BigDecimal(orderInfo.getNeedPrice());
        if (unpaidAmount.compareTo(BigDecimal.ZERO) <= 0) return BigDecimal.ZERO;
        if (Coupon.COUPON_TYPE_AMOUNT.equals(coupon.getCouponType())) { // 取未支付金额与优惠金额较小值为实际优惠金额
            return unpaidAmount.compareTo(coupon.getCouponMsg()) > 0 ? coupon.getCouponMsg() : unpaidAmount;
        }
        if (Coupon.COUPON_TYPE_ALL.equals(coupon.getCouponType())) {
            return unpaidAmount;
        }
        int freeMinutes = coupon.getCouponMsg().intValue();
        QueryOrderFeeRequest queryFeeRequest = new QueryOrderFeeRequest();
        queryFeeRequest.setOrderNum(orderInfo.getOrderNum());
        queryFeeRequest.setWithNotPay(Boolean.FALSE);
        if (park == null) {
            ObjectResponse<Park> parkResp = parkService.findByParkId(orderInfo.getParkId());
            ObjectResponse.notError(parkResp);
            park = parkResp.getData();
        }
        if (parkConfig == null){
            ObjectResponse<ParkConfig> parkConfigResp = parkService.getParkConfig(orderInfo.getParkId());
            ObjectResponse.notError(parkConfigResp);
            parkConfig = parkConfigResp.getData();
        }
        FeeParamHolder feeParamHolder = new FeeParamHolder(queryFeeRequest, orderInfo, parkConfig, park);
        feeParamHolder.setStartTime(orderInfo.getEnterTime());
        ParkChargeconfig parkChargeconfig = chargeService.getParkChargeConfigByPlateColor(orderInfo.getRegionId(), orderInfo.getOrderNum(),
                orderInfo.getPlateNum(), park.getId());
        feeParamHolder.putParkChargeConfig(parkChargeconfig.getId(), parkChargeconfig);
        float discFeeCal = chargeFee(feeParamHolder, orderInfo.getParkId(), parkChargeconfig.getId(),
                feeParamHolder.getStartTime().intValue(), feeParamHolder.getEndTime().intValue(),
                freeMinutes, false,
                orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(), feeParamHolder.getCsFeeType(),
                feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(), feeParamHolder.getCsSwitchTime(),
                feeParamHolder.isUseFreetime());
        if (discFeeCal < 0) discFeeCal = 0;
        BigDecimal discAmt = NumberUtils.decimalSubtract(orderInfo.getNeedPrice(), discFeeCal);
        log.debug("通停优惠计算结束|{}|{}", discFeeCal, discAmt);
        return discAmt;
    }
}
