package com.icetech.park.service.queryfee.chain;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.domain.dto.ChargeConfigDTO;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.order.SumPayByOrderNumDto;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateUtils;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.queryfee.QueryFeeChainAbstract;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ComputeFeeHandleChain extends QueryFeeChainAbstract {

    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private ChargeService chargeService;
    //最大收费判断，免费时的返回值
    private static final BigDecimal FREE_VALUE = BigDecimal.ZERO;
    //下一个责任类
    private QueryFeeChainAbstract nextChain;

    @Autowired
    private VipRegionService vipRegionService;

    @Autowired
    private ThirdInfoService thirdInfoService;

    @Autowired
    private OrderCarInfoDao orderCarInfoDao;

    public static final Long ONE_DAY_SECONDS = 24L * 60L * 60L;

    public static final ZoneId UTC8 = ZoneId.of("+8");

    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(UTC8);


    @Autowired
    public ComputeFeeHandleChain(DiscountFeeHandleChain nextChain) {
        this.nextChain = nextChain;
    }

    @Override
    public QueryOrderFeeResponse queryFee(FeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak()) {
            if (nextChain != null) {
                return nextChain.queryFee(feeParamHolder);
            }
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(FeeParamHolder feeParamHolder) {
        OrderInfo orderInfo = feeParamHolder.getOrderInfo();
        ParkConfig parkConfig = feeParamHolder.getParkConfig();
        Park park = feeParamHolder.getPark();
        QueryOrderFeeRequest queryOrderFeeRequest = feeParamHolder.getQueryOrderFeeRequest();
        Long startTime = feeParamHolder.getStartTime();
        Long endTime = feeParamHolder.getEndTime();
        Long parkTime = feeParamHolder.getParkTime();
        Long useParkTime = parkTime;
        Integer freeTimeAfterPay = parkConfig.getIsfreeAfterpay(15);

        Long parkId = park.getId();

        boolean isVipCar = false;
        //如果有null的计费规则，则重新获取临时车计费规则，否则使用list中的月卡计费规则
        Integer billId = CollectionUtils.isEmpty(feeParamHolder.getBillIdList()) || feeParamHolder.getBillIdList().stream().anyMatch(Objects::isNull)
                ? null : feeParamHolder.getBillIdList().stream().filter(Objects::nonNull).findFirst().orElse(null) ;
        VipType vipType = null;
        //判断入场的时候是否为VIP车辆
        if(PlateTypeEnum.VIP车辆.getType().equals(orderInfo.getType())){
            //获取该车辆最近的VIP配置信息
            ObjectResponse<VipType> recentVipCar = vipCarService.getRecentVipCar(parkId, orderInfo.getPlateNum(), orderInfo.getRegionId());
            if (ObjectResponse.isSuccess(recentVipCar)){
                isVipCar = true;
                vipType = recentVipCar.getData();
                //获取vip计费规则
                VipRegion vipRegion = vipRegionService.getOneByVipTypeIdAndRegionId(recentVipCar.getData().getId(), orderInfo.getRegionId());
                if (vipRegion != null && vipRegion.getBillId() != null) {
                    billId = vipRegion.getBillId();
                }
            }
        }else {
            //出场判断是否为VIP车辆
            ObjectResponse<VipType> validVipCar = vipCarService.getValidVipCar(parkId, orderInfo.getPlateNum(), orderInfo.getRegionId());
            if (ObjectResponse.isSuccess(validVipCar)){
                isVipCar = true;
                vipType = validVipCar.getData();
                //获取vip计费规则
                VipRegion vipRegion = vipRegionService.getOneByVipTypeIdAndRegionId(validVipCar.getData().getId(), orderInfo.getRegionId());
                if (vipRegion != null && vipRegion.getBillId() != null) {
                    billId = vipRegion.getBillId();
                }
            }
        }

        ParkChargeconfig parkChargeconfig;
        Long regionId = null;
        //根据车牌颜色获取计费规则
        if (billId == null){
            if (queryOrderFeeRequest.getChannelId() != null){
                ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceByCode(queryOrderFeeRequest.getChannelId()).getData();
                if (parkInoutdevice == null) {
                    throw new ResponseBodyException(CodeConstants.ERROR_3001, "无效的通道编号");
                }
                regionId = parkInoutdevice.getRegionId() == null ? null : parkInoutdevice.getRegionId();
            }
            parkChargeconfig = chargeService.getParkChargeConfigByPlateColor(regionId, orderInfo.getOrderNum(),
                    orderInfo.getPlateNum(), park.getId());
            if (Objects.isNull(parkChargeconfig)) {
                log.warn("[查费-计算模块] 车场未配置默认的计费规则，parkId：{}", parkId);
                throw new ResponseBodyException(CodeConstants.ERROR_3001, "未配置默认计费规则");
            }
            billId = parkChargeconfig.getId();
        }else{
            parkChargeconfig = parkChargeconfigDao.selectByPrimaryKey(billId);
            AssertTools.notNull(parkChargeconfig, CodeConstants.ERROR_3001, "vip计费规则数据不完整");
        }
        feeParamHolder.putParkChargeConfig(billId, parkChargeconfig);

        ChargeConfigDTO chargeConfigDTO = parkService.getChargeByBillId(parkChargeconfig, orderInfo.getCarType());
        //剩余最大收费金额
        BigDecimal surplusfee = maxFee(feeParamHolder, chargeConfigDTO, orderInfo, parkTime);
        //已经达到最大配置限额直接放行
        if (surplusfee != null) {
            if(new BigDecimal(0).compareTo(surplusfee) == 0) {
                QueryOrderFeeResponse freeRet = getFreeRet(orderInfo, feeParamHolder.getQueryTime(), parkTime, freeTimeAfterPay, park.getParkName());
                feeParamHolder.setBreak(true);
                return freeRet;
            }
            if(surplusfee.compareTo(BigDecimal.valueOf(0)) > 0) {
                feeParamHolder.setSurplusfee(surplusfee);
            }
        }

        //免费停车时长(秒)
        Integer isFreetimeOnce = chargeConfigDTO.getIsFreetimeOnce();
        int freeTime = chargeConfigDTO.getFreeTime() * 60;
        // 计费规则中免费时间济南计费使用
        Long configFreeTime = chargeConfigDTO.getFreeTime() * 60L;
        boolean isUseFreetime = true;
        //查询已缴费汇总信息
        OrderSumFeeDto feeDto = feeParamHolder.getOrderSumFeeDto();

        //如果是海大的第三方配置 并且 启用了穿行收费且出场车辆不在指定出入口进出时 不计入免费时长
//        if (Objects.nonNull(thirdInfoService.selectHaiDaChuanXIng(park.getId()))) {
//            log.info("海大穿行配置配置车场 车牌 {}",queryOrderFeeRequest.getPlateNum());
//            if (queryOrderFeeRequest.getChannelId() != null && PlateTypeEnum.临时车.getType().equals(orderInfo.getType())){
//                ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceByCode(queryOrderFeeRequest.getChannelId()).getData();
//                log.info("海大穿行配置启用通道配置 {} {}",parkInoutdevice,queryOrderFeeRequest.getPlateNum());
//                //启用了穿行收费,并且出口关联的入口不是指定入口时 不享受免费时长
//                if (parkInoutdevice.getIsSupportTralrestrictions() == 1 && !parkInoutdevice.getEnjoyFreetimeExitwaycodes().contains(orderInfo.getEnterChannelId())){
//                    log.info("海大穿行配置未从指定入口驶入不享受免费时长 {} {}",parkInoutdevice,queryOrderFeeRequest.getPlateNum());
//                    freeTime = 0;
//                    isUseFreetime = false;
//                }else {
//                    log.info("海大穿行配置从指定入口驶入 享受免费时长 {} {}",parkInoutdevice,queryOrderFeeRequest.getPlateNum());
//                }
//            }
//        }

        if (freeTime > 0 && isFreetimeOnce != null) {
            if (isFreetimeOnce < 0) {
                isUseFreetime = true;
            } else if (isFreetimeOnce == 0) {    // 无免费次数
                freeTime = 0;
                isUseFreetime = false;
            } else {
                LocalDate today = LocalDate.now();
                long begin = DateUtils.toEpochSecond(today.atStartOfDay());
                long end = DateUtils.toEpochSecond(today.plusDays(1).atStartOfDay()) - 1;
                int count = orderInfoDao.countEnexTimesByEnterTime(parkId, orderInfo.getPlateNum(), begin, end);
                log.debug("[查费-计算模块] 当日免费时长使用次数判定|{}|{}", count, isFreetimeOnce);
                if (count > isFreetimeOnce) {   // 入场次数大于限制次数
                    log.info("[查费-计算模块] 当日免费时长使用次数已用完|{}|{}|{}", orderInfo.getPlateNum(), count, isFreetimeOnce);
                    freeTime = 0;
                    isUseFreetime = false;
                } else {
                    isUseFreetime = true;
                }
            }
        }


        //已支付标识
        boolean isPaid = feeDto != null;
        //超时计费起始时间1末次缴费时间 2车辆入场时间
        Integer overtimeBillType = parkConfig.getOvertimeBillType();
        //缴费后超时时间
        long timeoutTime = 0;
        if (isPaid){
            Long lastOrderTime = feeDto.getLastOrderTime();
            if (lastOrderTime == null){
                lastOrderTime = feeDto.getLastPayTime();
            }
            timeoutTime = endTime - lastOrderTime;
            log.info("[查费-计算模块] 超时时长为[{}]秒", timeoutTime);
            if (overtimeBillType == 1){
                startTime = lastOrderTime;
            }else if (isVipCar && overtimeBillType == 2){
                //VIP车，超时缴费时，按入场时间计费，再减去已算费金额，就是需补缴金额
                //这种情况VIP只能在场内使用 不能超时缴费使用
                vipType = null;
            }
        }

        //已产生的应缴费用，不含本次应缴费
        float totalPrice = isPaid ? feeDto.getTotalPrice() : 0;
        //本次应缴费，默认为0
        float thisFee = 0;
        //首次缴费，停车时长大于免费时长
        boolean firstPay = parkTime > freeTime && timeoutTime == 0;
        //二次缴费超时时长大于缴费后预留时长
        boolean secondPay = timeoutTime > 0 && timeoutTime > freeTimeAfterPay * 60;
        if (firstPay || secondPay) {
            List<BaseFeeParamHolder.ExtraComputeFeePara> computeFeeParaList = feeParamHolder.getExtraComputeFeeParaList();
            if (!feeParamHolder.isMonthCarFee() && CollectionUtils.isEmpty(computeFeeParaList))
                computeFeeParaList = resolveHolsFeeParams(feeParamHolder.getOrderInfo(), startTime, endTime);
            if (CollectionUtils.isEmpty(computeFeeParaList)) {
                // 济南新能源计费处理
                Boolean jiNanFee = isJiNanFee(parkConfig, orderInfo.getOrderNum(), useParkTime, configFreeTime);
                if (jiNanFee) {
                    thisFee = jiNanFee(parkConfig, startTime, parkId, orderInfo, useParkTime, configFreeTime, endTime, feeParamHolder, billId, isPaid);
                }else {
                    thisFee = chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(),
                            0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                            feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                            feeParamHolder.getCsSwitchTime(), isUseFreetime);
                }
            } else {
                boolean currentIsUseFreetime = isUseFreetime;
                for (BaseFeeParamHolder.ExtraComputeFeePara touComputeFeePara : computeFeeParaList) {
                    float fee = chargeFee(feeParamHolder, parkId, touComputeFeePara.getBillId() == null ? billId : touComputeFeePara.getBillId(),
                            touComputeFeePara.getStartTime().intValue(), touComputeFeePara.getEndTime().intValue(),
                            0, isPaid, orderInfo.getCarType(), touComputeFeePara.isCsMonthCarFee(),
                            touComputeFeePara.getCsFeeType(), touComputeFeePara.getCsStartTime(), touComputeFeePara.getCsEndTime(),
                            touComputeFeePara.getCsSwitchTime(), currentIsUseFreetime);
                    thisFee += fee;
                    log.info("[查费-计算模块] 车牌号[{}], 参数[{}], 当前分段金额[{}], 累加金额[{}]", orderInfo.getPlateNum(), touComputeFeePara, fee, thisFee);
                    currentIsUseFreetime = false;
                }
            }
            log.info("[查费-计算模块] 车牌号[{}], 应收金额[{}]", orderInfo.getPlateNum(), thisFee);

            //超时缴费时，按入场时间计费，再减去已算费金额，就是需补缴金额
            if (isPaid && overtimeBillType == 2){
                thisFee = thisFee - totalPrice;
                log.info("[查费-计算模块] 超时缴费车牌号[{}], 减去已算费金额后应缴[{}]",
                        orderInfo.getPlateNum(), thisFee);
            }
        }
        feeParamHolder.setThisFee(thisFee);
        feeParamHolder.setUseFreetime(isUseFreetime);
        feeParamHolder.setStartTime(startTime);
        feeParamHolder.setVipType(vipType);

        return feeParamHolder.getQueryOrderFeeResponse();
    }

    /**
     *
     * @param chargeConfigDTO
     * @param orderInfo
     * @param parkTime
     * @return 0:已缴过最大小费，此单免费; null: 未使用最大收费; 大于0时：最大收费剩余金额
     */
    private BigDecimal maxFee(FeeParamHolder feeParamHolder, ChargeConfigDTO chargeConfigDTO,
                              OrderInfo orderInfo, long parkTime){
        log.info("[查费-计算模块] 最大缴费逻辑判断, 车牌号[{}], 计费规则配置[{}]", orderInfo.getPlateNum(), chargeConfigDTO);
        if (chargeConfigDTO == null) {
            return null;
        }
        if(Integer.valueOf(1).equals(chargeConfigDTO.getDaynightmaxfeeusing())
                && Objects.nonNull(chargeConfigDTO.getDaynightmaxfee())) {
            return isFee(feeParamHolder, orderInfo, chargeConfigDTO, parkTime);
        }
        return null;
    }

    /**
     * 订单是否达到最大限额
     * @param orderInfo
     * @param feeParamHolder
     * @param chargeConfigDTO
     * @param parkTime
     * @return
     */
    private BigDecimal isFee(FeeParamHolder feeParamHolder, OrderInfo orderInfo,
                             ChargeConfigDTO chargeConfigDTO, long parkTime){
        Integer billId = chargeConfigDTO.getBillId();
        Integer maxFeeType = chargeConfigDTO.getMaxFeeType();
        Integer countType = chargeConfigDTO.getCountType();
        Date startDate = new Date(feeParamHolder.getStartTime() * 1000);
        Date endDate = new Date(feeParamHolder.getEndTime() * 1000);

        Calendar calendar = Calendar.getInstance();
        //单天单次
        if (maxFeeType == null || maxFeeType == 1) {
            long diffDays = getDiffDays(startDate, endDate);
            //最大收费
            float maxFee = chargeConfigDTO.getDaynightmaxfee() * (diffDays == 0 ? 1 : diffDays);
            calendar.setTime(endDate);
            calendar.set(Calendar.HOUR_OF_DAY, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
            calendar.set(Calendar.MILLISECOND, 0);
            Date dayStart = calendar.getTime();
            long time = dayStart.getTime() / 1000;
            if (time > orderInfo.getEnterTime()) {
                return null;
            }
            //入场时间
            Long enterTime = orderInfo.getEnterTime();
            BigDecimal paidPrice = orderPayDao.sumPalteProOrderPay(orderInfo.getParkId(),
                    orderInfo.getPlateNum(), enterTime);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[查费-计算模块] 无需缴费车辆超过单次最大缴费额度，车牌号：{}，场内已缴费:{},最大缴费额度：{}",
                        orderInfo.getPlateNum(), paidPrice, maxFee);
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            //剩余金额
            return max.subtract(paidPrice);
        }
        //单天多次
        if (maxFeeType == 2) {
            long diffDays = getDiffDays(startDate, endDate);
            //最大收费
            float maxFee = chargeConfigDTO.getDaynightmaxfee() * (diffDays == 0 ? 1 : diffDays);
            if (Integer.valueOf(1).equals(countType)) {
                calendar.setTime(startDate);
            } else if (Integer.valueOf(2).equals(countType)) {
                calendar.setTime(endDate);
            } else {
                calendar.setTime(startDate);
            }
            calendar.set(Calendar.HOUR_OF_DAY, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
            calendar.set(Calendar.MILLISECOND, 0);
            Date dayStart = calendar.getTime();
            BigDecimal paidPrice = getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, dayStart, maxFee);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[查费-计算模块] 无需缴费车辆超过单天最大缴费额度，车牌号：{}，当天已缴费:{},最大缴费额度：{}",
                        orderInfo.getPlateNum(), paidPrice, maxFee);
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            //剩余金额
            return max.subtract(paidPrice);
        }
        //24小时内
        if (maxFeeType == 3) {
            //停车天数：小于1天时按1天；parkTime为0时，停车0天
            long diffDays = parkTime / (24 * 3600) + ((parkTime % (24 * 3600) > 0) ? 1 : 0);
            //最大收费
            float maxFee = chargeConfigDTO.getDaynightmaxfee() * (diffDays == 0 ? 1 : diffDays);
            if (Objects.nonNull(countType) && countType == 3) {
                Date enterDate = new Date(orderInfo.getEnterTime() * 1000);
                calendar.setTime(enterDate);
                calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 24);
                Date btime = calendar.getTime();
                BigDecimal maxFeePara = getMaxFeePara(feeParamHolder, orderInfo, billId, endDate, btime, chargeConfigDTO.getDaynightmaxfee());
                if (maxFeePara == null) {
                    return maxFeePara;
                }
                log.info("[新版本24小时按入场最大收费] 当前订单最大收费[{}], 24小时最大收费{}", maxFee, maxFeePara);
                return maxFeePara.compareTo(new BigDecimal(maxFee)) > 0 ? new BigDecimal(maxFee) : maxFeePara;
            }
            BigDecimal paidPrice = BigDecimal.ZERO;
            if (Objects.nonNull(countType) && countType == 1) {
                Date enterDate = new Date(orderInfo.getEnterTime() * 1000);
                calendar.setTime(enterDate);
                calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 24);
                Date btime = calendar.getTime();
                paidPrice = getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, btime, maxFee);
            } else if (Objects.nonNull(countType) && countType == 2) {
                calendar.setTime(endDate);
                calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 24);
                Date btime = calendar.getTime();
                paidPrice = getPaidFeeForMaxFee(feeParamHolder, orderInfo, billId, endDate, btime, maxFee);
            }
            log.info("[查费-计算模块] 24小时已支付金额[{}]", paidPrice);
            if (paidPrice.floatValue() >= maxFee) {
                log.info("[查费-计算模块] 无需缴费车辆超过24小时最大缴费额度，车牌号：{}，24小时内已缴费:{},最大缴费额度：{}",
                        orderInfo.getPlateNum(), paidPrice, maxFee);
                return FREE_VALUE;
            }
            BigDecimal max = new BigDecimal(Float.toString(maxFee));
            return max.subtract(paidPrice);
        }
        return null;
    }

    private BigDecimal getPaidFeeForMaxFee(FeeParamHolder feeParamHolder, OrderInfo orderInfo, Integer billId,
                                           Date endDate, Date beginTime, float maxFee) {
        BigDecimal paidPrice = BigDecimal.ZERO;
        List<SumPayByOrderNumDto> sumPayByOrderNumDtos = orderPayDao.sumPaidPriceByPlateNum(
                orderInfo.getParkId(), orderInfo.getPlateNum(), beginTime.getTime() / 1000, endDate.getTime() / 1000);
        if (CollectionUtils.isEmpty(sumPayByOrderNumDtos)) {
            return paidPrice;
        }
        log.info("[查费-计算模块] 获取近24小时已收费用, 24小时范围内支付记录[{}]", sumPayByOrderNumDtos);
        //最早入场记录的支付记录
        SumPayByOrderNumDto sumPayByOrderNumDto = sumPayByOrderNumDtos.get(0);
        Long enterTime = sumPayByOrderNumDto.getEnterTime();

        double paidPriceSum = sumPayByOrderNumDtos.stream().collect(
                Collectors.summarizingDouble(orderNumPay -> orderNumPay.getPaidPrice().doubleValue())).getSum();
        //如果最早入场在定长时间段
        if (enterTime >= beginTime.getTime() / 1000) {
            paidPrice = new BigDecimal(paidPriceSum);
            log.info("[查费-计算模块] 获取近24小时已收费用, 最早支付订单的入场时间在24小时范围内,实收总金额为[{}]", paidPriceSum);
        } else {
            log.info("[查费-计算模块] 获取近24小时已收费用, 最早支付订单的入场时间在24小时范围外,开始计算范围内的实收,plateNum[{}]", orderInfo.getPlateNum());
            if (new BigDecimal(paidPriceSum).subtract(sumPayByOrderNumDto.getPaidPrice()).compareTo(new BigDecimal(maxFee)) >= 0
                    || sumPayByOrderNumDto.getPaidPrice().compareTo(new BigDecimal(0)) == 0) {
                paidPrice = new BigDecimal(paidPriceSum);
                log.info("[查费-计算模块] 获取近24小时已收费用, 总实收减跨时间点订单的实收后仍然大于等于最大收费,或订单实时为0,实收总金额为[{}]", paidPriceSum);
            } else {
                //计算从入场到定长时间点的费用
                float prefixFee = chargeFee(feeParamHolder, orderInfo.getParkId(), billId, enterTime.intValue(), (int) (beginTime.getTime() / 1000),
                        0, false, orderInfo.getCarType(), false, 0,
                        null, null, null, true);
                //计算从入场到定长时间点的费用
                float totalFee = chargeFee(feeParamHolder, orderInfo.getParkId(), billId, enterTime.intValue(), sumPayByOrderNumDto.getExitTime().intValue(),
                        0, false, orderInfo.getCarType(), false, 0,
                        null, null, null, true);
                BigDecimal paidPriceBd = sumPayByOrderNumDto.getPaidPrice();
                BigDecimal suffixFee = BigDecimal.valueOf(totalFee).subtract(new BigDecimal(prefixFee));

                if (suffixFee.compareTo(new BigDecimal(0)) < 0) {
                    suffixFee = new BigDecimal(0);
                }
                paidPrice = new BigDecimal(paidPriceSum).subtract(paidPriceBd).add(suffixFee);
                if (paidPrice.compareTo(new BigDecimal(paidPriceSum)) > 0) {
                    log.info("应收{}大于实收{}时，以实收为准", paidPrice, paidPriceSum);
                    paidPrice = new BigDecimal(paidPriceSum);
                }
            }
        }
        return paidPrice;
    }

    public static long getDiffDays(Date start, Date end) {
        LocalDate startTime = LocalDateTime.ofInstant(start.toInstant(), ZoneOffset.of("+8")).toLocalDate();
        LocalDate endTime = LocalDateTime.ofInstant(end.toInstant(), ZoneOffset.of("+8")).toLocalDate();
        if (startTime.isAfter(endTime)) {
            return 0;
        }
        if (startTime.isEqual(endTime)) {
            return 0;
        }
        return endTime.toEpochDay() - startTime.toEpochDay() + 1;
    }

    // 时间戳转换为 LocalDateTime
    public static LocalDateTime convertTimestampToLocalDateTime(Long timestamp) {
        return LocalDateTime.ofEpochSecond(timestamp, 0, ZoneOffset.ofHours(8));
    }

    public static long calculateTimeDifferenceInSeconds(LocalDateTime start, LocalDateTime end) {
        Duration duration = Duration.between(start, end);
        // 返回差异的秒数
        return duration.getSeconds();
    }
    private Boolean isJiNanFee(ParkConfig parkConfig, String orderNum, Long useParkTime, Long configFreeTime)  {
        if (parkConfig.getNewEnergyChargeFlag() == null || parkConfig.getNewEnergyChargeFlag() == 0) {
            return false;
        }
        if (parkConfig.getNewEnergyVehiclesDiscountMinutes() == null || parkConfig.getNewEnergyVehiclesDiscountMinutes() <=0) {
            log.info("[济南新能源计费]新能源首停优惠时长(分钟)-济南使用:{}", parkConfig.getNewEnergyChargeFlag());
            return false;
        }
        OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderNum);
        if (carInfo == null) {
            log.info("[济南新能源计费]获取进出场订单明细为空走默认计费,订单号: {}", orderNum);
            return false;
        }
        String plateColor = carInfo.getPlateColor();
        log.info("[济南新能源计费]获取进出场订单明细获取到的车牌颜色为: {}", plateColor);
        if (StringUtils.isEmpty(plateColor) || !plateColor.contains("绿")) {
            return false;
        }
        if (useParkTime <= configFreeTime) {
            log.info("[济南新能源计费]停车时长:{},小于计费规则中免费时长:{},走默认计费", useParkTime, configFreeTime);
            return false;
        }
        return true;
    }


    private Float getNoOrderFee(Long startTime, Long useParkTime, Long configFreeTime, Long endTime, Integer discountTotalMinute, FeeParamHolder feeParamHolder, Long parkId, Integer billId, boolean isPaid, OrderInfo orderInfo) {
        Float soFee = 0.0f;
        Float oneDayFee = null;
        Long cycleStart = startTime;
        Long cycleEnd = cycleStart + ONE_DAY_SECONDS;
        while (useParkTime > 0) {
            long minTime = Math.min(useParkTime, cycleEnd - cycleStart);
            // 说明跨天了
            if (minTime != useParkTime) {
                if (oneDayFee == null) {
                    Float dayFee = chargeFee(feeParamHolder, parkId, billId, cycleStart.intValue(), cycleEnd.intValue(),
                            discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                            feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                            feeParamHolder.getCsSwitchTime(), false);
                    log.info("[济南新能源计费]没有历史订单,停车时长跨天,调用so计费一整天费用:{}", dayFee);
                    oneDayFee = dayFee;
                    soFee += oneDayFee;
                }else {
                    soFee += oneDayFee;
                    log.info("[济南新能源计费]没有历史订单,停车时长跨天继续跨天不调用so直接累加上次费用:{},当前费用:{}", oneDayFee, soFee);
                }
            }else {
                if (oneDayFee != null && useParkTime <= configFreeTime) {
                    Float currentFee = chargeFee(feeParamHolder, parkId, billId, cycleStart.intValue(), endTime.intValue(),
                            0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                            feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                            feeParamHolder.getCsSwitchTime(), true);
                    soFee += currentFee;
                    log.info("[济南新能源计费]没有历史订单,停车时跨天,最后一段小于免费停车时长直接调用so计费结果:{},当前费用:{}", currentFee, soFee);
                } else {
                    Float currentFee = chargeFee(feeParamHolder, parkId, billId, cycleStart.intValue(), endTime.intValue(),
                            discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                            feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                            feeParamHolder.getCsSwitchTime(), false);
                    soFee += currentFee;
                    log.info("[济南新能源计费]没有历史订单,停车时不不跨天,直接调用so计费结果:{},当前费用:{}", currentFee, soFee);
                }
            }
            useParkTime -= minTime;
            cycleStart = cycleEnd;
            cycleEnd += ONE_DAY_SECONDS;
        }
        return soFee;
    }
    public Float jiNanFee(ParkConfig parkConfig, Long startTime, Long parkId, OrderInfo orderInfo, Long useParkTime, Long configFreeTime, Long endTime, FeeParamHolder feeParamHolder, Integer billId, boolean isPaid) {
        // 计费金额
        Float soFee = 0.0f;
        // 高级配置中配置优惠两小时时长
        Integer discountTotalMinute = parkConfig.getNewEnergyVehiclesDiscountMinutes();
        // 当前入场时间减一天
        Long beforeEnterTime = startTime - ONE_DAY_SECONDS;
        // 查询前一天正常离场订单
        LambdaQueryWrapper<OrderInfo> orderQueryWrapper = Wrappers.lambdaQuery(OrderInfo.class)
                .eq(OrderInfo::getParkId, parkId)
                .eq(OrderInfo::getPlateNum, orderInfo.getPlateNum())
                .ge(OrderInfo::getExitTime, beforeEnterTime)
                .lt(OrderInfo::getExitTime, startTime)
                .eq(OrderInfo::getServiceStatus, 2)
                .orderByAsc(OrderInfo::getEnterTime);
        List<OrderInfo> beforeOrders = orderInfoDao.selectList(orderQueryWrapper);
        if (CollectionUtils.isEmpty(beforeOrders)) {
            log.info("[济南新能源计费]没有历史订单直接计费");
            Float noOrderFee = getNoOrderFee(startTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
            log.info("[济南新能源计费]没有历史订单,计费结果:{}", noOrderFee);
            soFee += noOrderFee;
            log.info("[济南新能源计费]没有历史订单,最终计费结果:{}", soFee);
            return soFee;
        }
        Optional<OrderInfo> orderOption = beforeOrders.stream()
                .filter(beforeOrder -> (beforeOrder.getExitTime() - beforeOrder.getEnterTime()) > configFreeTime)
                .findFirst();
        if (!orderOption.isPresent()) {
            log.info("[济南新能源计费]没有历史订单直接计费");
            Float noOrderFee = getNoOrderFee(startTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
            log.info("[济南新能源计费]没有历史订单,计费结果:{}", noOrderFee);
            soFee += noOrderFee;
            log.info("[济南新能源计费]没有历史订单,最终计费结果:{}", soFee);
            return soFee;
        }
        OrderInfo lastOrder = orderOption.get();
        Long lastEnterTime = lastOrder.getEnterTime();
        Long lastExitTime = lastOrder.getExitTime();
        String lastEnterDateTimeFormat = DateUtil.formatDateTime(new Date(lastEnterTime * 1000));
        String lastExitDateTimeFormat = DateUtil.formatDateTime(new Date(lastExitTime * 1000));
        log.info("[济南新能源计费]前一次停车已享受优惠,上次停车入场时间: {},上次离场时间:{}",lastEnterDateTimeFormat , lastExitDateTimeFormat);

        String currentStartDateTimeFormat = DateUtil.formatDateTime(new Date(startTime * 1000));
        String currentExitDateTimeFormat = DateUtil.formatDateTime(new Date(endTime * 1000));
        log.info("[济南新能源计费]前一次停车已享受优惠,本次停车入场时间: {},本次离场时间:{},停车时长:{}", currentStartDateTimeFormat, currentExitDateTimeFormat, useParkTime);
        Long discountEnd = lastEnterTime + ONE_DAY_SECONDS;
        String discountEndFormat = DateUtil.formatDateTime(new Date(discountEnd * 1000));
        log.info("[济南新能源计费]前一次停车入场时间:{},前一次停车离场时间:{},当次入场时间:{},当次离场时间:{},加1天计算下次优惠结束时间:{}",
                lastEnterDateTimeFormat, lastExitDateTimeFormat,currentStartDateTimeFormat, currentExitDateTimeFormat, discountEndFormat);
        if (startTime < discountEnd) {
            log.info("[济南新能源计费]当次停车在前一次停车优惠内,当次入场时间: {}, 上次优惠截止时间: {}", currentStartDateTimeFormat, discountEndFormat);
            if (endTime <= discountEnd) {
                soFee += chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(),
                        0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                        feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                        feeParamHolder.getCsSwitchTime(), false);
                log.info("[济南新能源计费]离场时间:{},在上次优惠时间内:{},所以没有优惠,直接调用so计费为:{}", currentExitDateTimeFormat, discountEndFormat, soFee);
            } else {
                Long firstFeeTime = discountEnd - startTime;
                useParkTime -= firstFeeTime;
                soFee += chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), discountEnd.intValue(),
                        0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                        feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                        feeParamHolder.getCsSwitchTime(), false);
                log.info("[济南新能源计费]当次停车在前一次停车优惠内,需要收费的时间是:{},{},停车时长为:{},减去计费这段时间后剩余停车时长:{},这段停车调用so计费为:{}", currentStartDateTimeFormat, discountEndFormat, firstFeeTime, useParkTime, soFee);
                Float noOrderFee = getNoOrderFee(discountEnd, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                log.info("[济南新能源计费]当次停车在前一次停车优惠内,剩下的计费金额:{},", noOrderFee);
                soFee += noOrderFee;
                log.info("[济南新能源计费]没有历史订单,最终计费结果:{}", soFee);
            }
        } else {
            LocalDateTime lastExitDateTime = convertTimestampToLocalDateTime(lastExitTime);
            LocalDateTime lastEnterDateTime = convertTimestampToLocalDateTime(lastEnterTime);
            LocalDateTime currentStart = LocalDateTime.of(lastExitDateTime.toLocalDate(), lastEnterDateTime.toLocalTime());
            Long translationTime = currentStart.toEpochSecond(ZoneOffset.of("+8"));
            String translationTimFormat = DateUtil.formatDateTime(new Date(translationTime * 1000));
            if (translationTime.equals(lastEnterTime)) {
                log.info("[济南新能源计费]存在跨天,上一次停车入场时间:{},上一次停车离场时间:{},当次入场时间:{},当次离场时间:{},根据上一次入场时间平移计算下次优惠时间为:{}",
                        lastEnterDateTimeFormat, lastExitDateTimeFormat,currentStartDateTimeFormat, currentExitDateTimeFormat, translationTimFormat);
                if (startTime > translationTime) {
                    log.info("[济南新能源计费]存在跨天,使用优惠不重叠直接计费");
                    Float noOrderFee = getNoOrderFee(startTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                    log.info("[济南新能源计费]存在跨天,使用优惠不重叠直接计费,计费结果:{}", noOrderFee);
                    soFee += noOrderFee;
                    log.info("[济南新能源计费]存在跨天,使用优惠不重叠直接计费,最终计费结果:{}", soFee);
                    return soFee;
                }
            }
            log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次入场时间:{}, 上次离场时间: {}", lastEnterDateTimeFormat, lastExitDateTimeFormat);
            log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次入场时间:{}, 上次离场时间: {},上次截止优惠时间:{}", lastEnterDateTime, lastExitDateTime, translationTimFormat);
            if (translationTime < lastExitTime){
                long lastParkTime = calculateTimeDifferenceInSeconds(currentStart, lastExitDateTime);
                if (lastParkTime > configFreeTime) {
                    log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了当次优惠");
                    LocalDateTime nextDateTime = currentStart.plusDays(1);
                    String nextDateTimeFormat = nextDateTime.format(DATE_TIME_FORMATTER);
                    log.info("[济南新能源计费]当次停车存在跨天计算优惠情况, 上次停车使用了当次优惠,下次使用优惠开始时间: {}", nextDateTimeFormat);
                    Long nextStartTime = nextDateTime.toEpochSecond(ZoneOffset.of("+8"));
                    if (endTime <= nextStartTime) {
                        soFee = chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(),
                                0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                                feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                                feeParamHolder.getCsSwitchTime(), false);
                        log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了当次优惠,当次离场时间: {} 在下次优惠时间内:{}, 所以不优惠,so计费为:{}", currentExitDateTimeFormat, nextDateTimeFormat, soFee);
                    } else {
                        Long firstFeeTime = nextStartTime - startTime;
                        Long firstFeeEndTime = startTime + firstFeeTime;
                        useParkTime = useParkTime - firstFeeTime;
                        // 第一段收费
                        soFee += chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), nextStartTime.intValue(),
                                0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                                feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                                feeParamHolder.getCsSwitchTime(), false);
                        log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了当次优惠,所以不优惠,第一段计费开始时间:{},结束时间:{},停车时长:{}秒,单独第一段调用so计费为:{}",
                                currentStartDateTimeFormat, convertTimestampToLocalDateTime(firstFeeEndTime).format(DATE_TIME_FORMATTER), firstFeeTime, soFee);
                        Float noOrderFee = getNoOrderFee(nextStartTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                        log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了当次优惠,第调用so计费为:{}", noOrderFee);
                        soFee += noOrderFee;
                        log.info("[济南新能源计费]有历史订单,最终计费结果:{}", soFee);
                    }
                } else {
                    log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车不足半小时不占用优惠时间长");
                    LocalDateTime nextDateTime = currentStart.plusDays(1);
                    String nextDateTimeFormat = nextDateTime.format(DATE_TIME_FORMATTER);
                    log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车不足半小时不占用优惠时间长,下次优惠时间:{}", nextDateTimeFormat);
                    Long nextStartTime = nextDateTime.toEpochSecond(ZoneOffset.of("+8"));
                    // 第一段直接计费
                    if (endTime <= nextStartTime) {
                        soFee += chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(),
                                discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                                feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                                feeParamHolder.getCsSwitchTime(), false);
                        log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车不足半小时不占用优惠时间长,直接计费开始时间:{}, 结束时间:{},so费用:{}", currentStartDateTimeFormat, currentExitDateTimeFormat, soFee);
                    } else {
                        // 第一段直接计费
                        soFee += chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), nextStartTime.intValue(),
                                discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                                feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                                feeParamHolder.getCsSwitchTime(), false);
                        log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车不足半小时不占用优惠时间长,直接计费开始时间:{}, 下次优惠截止时间:{},so费用:{}", currentStartDateTimeFormat, nextDateTimeFormat, soFee);
                        useParkTime = useParkTime - (nextStartTime - startTime);
                        Float noOrderFee = getNoOrderFee(nextStartTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                        log.info("[济南新能源计费]有历史订单,剩下计费结果:{}", noOrderFee);
                        soFee += noOrderFee;
                        log.info("[济南新能源计费]有历史订单,最终计费结果:{}", soFee);
                    }
                }
            } else {
                long lastParkTime = calculateTimeDifferenceInSeconds(lastExitDateTime, currentStart);
                log.info("[济南新能源计费]有历史订单跨天，优惠时间:{}，小于上次离场订单时间:{}, 这段时长:{}", translationTimFormat, lastExitDateTimeFormat, lastParkTime);
                if (lastParkTime <= configFreeTime) {
                    log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了免费时长,但是不算上次优惠");
                    LocalDateTime nextDateTime = currentStart.plusDays(1);
                    String nextDateTimeFormat = nextDateTime.format(DATE_TIME_FORMATTER);
                    log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了免费时长,到：{}继续使用时长", nextDateTimeFormat);
                    Float noOrderFee = getNoOrderFee(startTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                    log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了免费时长,计费结果{}", noOrderFee);
                    soFee += noOrderFee;
                    log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了免费时长,最终计费结果{}", soFee);
                } else {
                    if (startTime >= translationTime) {
                        log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,本次停车在上次优惠之外直接so计费");
                        soFee = chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(),
                                discountTotalMinute, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                                feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                                feeParamHolder.getCsSwitchTime(), false);
                    } else {
                        log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了当次优惠");
                        if (startTime < translationTime) {
                            Long currentStartTime = currentStart.toEpochSecond(ZoneOffset.of("+8"));
                            Long firstTime = currentStartTime - startTime;
                            useParkTime = useParkTime - firstTime;
                            soFee += chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), currentStartTime.intValue(),
                                    0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                                    feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                                    feeParamHolder.getCsSwitchTime(), false);
                            log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,入场时间:{},在下次优惠时间:{}之前,这段时间:{}需要单独计费,计费结果:{}", currentStartDateTimeFormat, translationTimFormat, firstTime, soFee);
                            Float noOrderFee = getNoOrderFee(currentStartTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                            log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,剩下计费结果:{}", noOrderFee);
                            soFee += noOrderFee;
                            log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,最终计费结果:{}", soFee);
                        } else {
                            LocalDateTime nextDateTime = currentStart.plusDays(1);
                            String nextDateTimeFormat = nextDateTime.format(DATE_TIME_FORMATTER);
                            log.info("[济南新能源计费]当次停车存在跨天计算优惠情况, 上次停车使用了当次优惠,下次使用优惠开始时间: {}", nextDateTimeFormat);
                            Long nextStartTime = nextDateTime.toEpochSecond(ZoneOffset.of("+8"));
                            if (endTime <= nextStartTime) {
                                soFee = chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), endTime.intValue(),
                                        0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                                        feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                                        feeParamHolder.getCsSwitchTime(), false);
                                log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了当次优惠,当次离场时间: {} 在下次优惠时间内:{}, 所以不优惠,so计费为:{}", currentExitDateTimeFormat, nextDateTimeFormat, soFee);
                            } else {
                                Long firstFeeTime = nextStartTime - startTime;
                                Long firstFeeEndTime = startTime + firstFeeTime;
                                useParkTime = useParkTime - firstFeeTime;
                                // 第一段接收费
                                soFee += chargeFee(feeParamHolder, parkId, billId, startTime.intValue(), firstFeeEndTime.intValue(),
                                        0, isPaid, orderInfo.getCarType(), feeParamHolder.isCsMonthCarFee(),
                                        feeParamHolder.getCsFeeType(), feeParamHolder.getCsStartTime(), feeParamHolder.getCsEndTime(),
                                        feeParamHolder.getCsSwitchTime(), false);
                                log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了当次优惠,所以不优惠,第一段计费开始时间:{},结束时间:{},停车时长:{}秒,单独第一段调用so计费为:{}",
                                        currentStartDateTimeFormat, convertTimestampToLocalDateTime(firstFeeEndTime).format(DATE_TIME_FORMATTER), firstFeeTime, soFee);
                                Float noOrderFee = getNoOrderFee(nextStartTime, useParkTime, configFreeTime, endTime, discountTotalMinute, feeParamHolder, parkId, billId, isPaid, orderInfo);
                                log.info("[济南新能源计费]当次停车存在跨天计算优惠情况,上次停车使用了当次优惠,调用so计费为:{}", noOrderFee);
                                soFee += noOrderFee;
                                log.info("[济南新能源计费]有历史订单,最终计费结果:{}", soFee);
                            }
                        }
                    }
                }
            }
        }
        return soFee;
    }
}
