package com.icetech.park.service.queryfee.chain;

import com.icetech.order.dao.OrderAuthDao;
import com.icetech.order.domain.entity.OrderAuthInfo;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.basics.service.charge.FeeParamHolder;
import com.icetech.park.service.queryfee.QueryFeeChainAbstract;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Slf4j
@Service
public class AuthFeeHandleChain extends QueryFeeChainAbstract {

    @Autowired
    private OrderAuthDao orderAuthDao;
    //下一个责任类
    private QueryFeeChainAbstract nextChain;

    @Override
    public QueryOrderFeeResponse queryFee(FeeParamHolder feeParamHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = queryFeeObject(feeParamHolder);
        if (!feeParamHolder.isBreak()) {
            if (nextChain != null) {
                return nextChain.queryFee(feeParamHolder);
            }
        }
        return queryOrderFeeResponse;
    }

    public QueryOrderFeeResponse queryFeeObject(FeeParamHolder feeParamHolder) {

        BigDecimal surplusfee = feeParamHolder.getSurplusfee();

        QueryOrderFeeResponse queryOrderFeeResponse = feeParamHolder.getQueryOrderFeeResponse();

        String unpayPrice = queryOrderFeeResponse.getUnpayPrice();

        float aFloat = Float.parseFloat(unpayPrice);
        boolean isResetStatus = false;
        //应收如果大于剩余额度, 减去剩余额度后就是应收金额
        if(surplusfee != null && aFloat > surplusfee.floatValue()){
            isResetStatus = true;
            float totalAmountF = NumberUtils.toFloat(queryOrderFeeResponse.getTotalAmount());
            queryOrderFeeResponse.setUnpayPrice(String.valueOf(surplusfee));
            queryOrderFeeResponse.setTotalAmount(String.valueOf(totalAmountF - (aFloat - surplusfee.floatValue())));
            log.info("[查费-修改费用模块] 最大收费逻辑处理后待缴费[{}]", queryOrderFeeResponse.getUnpayPrice());
        }

        //判断有没有授权修改需缴费，如果有修改，则设置新的需缴费
        OrderAuthInfo orderAuthInfo = orderAuthDao.selectByOrderNum(queryOrderFeeResponse.getOrderNum(), 1);
        if (orderAuthInfo != null && orderAuthInfo.getAuthStatus().equals(1)){
            isResetStatus = true;
            log.info("[查费-修改费用模块]订单号[{}]有授权过修改金额, before[{}], after[{}]",
                    queryOrderFeeResponse.getOrderNum(),
                    queryOrderFeeResponse.getUnpayPrice(),
                    orderAuthInfo.getUpPrice());
            float upPrice = NumberUtils.toFloat(orderAuthInfo.getUpPrice());
            float totalAmount = NumberUtils.toFloat(queryOrderFeeResponse.getTotalAmount());
            queryOrderFeeResponse.setTotalAmount(String.valueOf(totalAmount-(aFloat-upPrice)));
            queryOrderFeeResponse.setUnpayPrice(orderAuthInfo.getUpPrice());
        }
        if (isResetStatus) {
            Float totalAmount = NumberUtils.toFloat(queryOrderFeeResponse.getTotalAmount());
            Float paidAmount = Float.parseFloat(queryOrderFeeResponse.getPaidAmount());
            Float discountAmount = Float.parseFloat(queryOrderFeeResponse.getDiscountAmount());
            Float unPayPrice = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
            Float discountPrice = Float.parseFloat(queryOrderFeeResponse.getDiscountPrice());
            Integer status = getFeeStatus(paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount);
            queryOrderFeeResponse.setStatus(status);
        }
        return queryOrderFeeResponse;
    }

}
