package com.icetech.park.service.queryfee;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.park.service.charge.ChargeServiceImpl;
import com.icetech.basics.utils.SpringUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * 场中场计费参数
 * @author fangct
 */
@Getter
@Setter
@ToString
public class MultipleAreaFeeParamHolder extends BaseFeeParamHolder {

    /**
     * 是否跳过当前责任链
     */
    protected boolean isOutContinue;
    protected boolean isInnerContinue;
    protected Long outParkTime;
    protected Long innerParkTime;
    //大场剩余VIP优惠金额
    protected float surplusVipPrice;
    //大场剩余VIP优惠分钟
    protected int surplusVipTime;
    //进停车场的区域ID
    protected Long regionId;
    //是否有出口缴费
    protected Boolean hasExitPay;
    //内场使用优惠券
    protected boolean isInnerUseDiscount;
    //内场使用VIP所有优惠
    protected boolean isInnerUseAllVipDiscount = true;
    protected QueryOrderFeeResponse innerQueryOrderFeeResponse;
    protected boolean isInnerCsMonthCarFee;
    protected int innerCsFeeType;
    protected String innerCsStartTime, innerCsEndTime;
    protected Long innerCsSwitchTime;
    protected Long innerStartTime;
    protected Long innerEndTime;
    protected ParkChargeconfig innerParkChargeconfig;
    protected float innerThisFee;
    protected VipType innerVipType;
    protected String innerSChargeConfigCfg;
    //外场计费结束时间
    protected Long outEndTime;
    protected Integer innerVipBillId;
    protected OrderPayDao orderPayDao;

    public MultipleAreaFeeParamHolder(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, ParkConfig parkConfig, Park park) {
        this.queryOrderFeeRequest = queryOrderFeeRequest;
        this.orderInfo = orderInfo;
        this.park = park;
        this.parkConfig = parkConfig;
        if (queryOrderFeeRequest.getExitTime() != null) {
            this.queryTime = queryOrderFeeRequest.getExitTime();
        } else if (orderInfo.getExitTime() != null) {
            this.queryTime = orderInfo.getExitTime();
        } else {
            this.queryTime = DateTools.unixTimestamp();
        }
        this.endTime = queryTime;

        this.chargeService = SpringUtils.getBean(ChargeServiceImpl.class);
        this.orderPayDao = SpringUtils.getBean(OrderPayDao.class);
        this.parkChargeconfigDao = SpringUtils.getBean(ParkChargeconfigDao.class);
    }

    /**
     * 是否有出口缴费
     * @param orderNum 订单号
     * @return 是否有出口缴费
     */
    public boolean hasExitPay(String orderNum){
        if (this.hasExitPay != null) {
            return this.hasExitPay;
        }
        List<OrderPay> orderPays = orderPayDao.selectByOrderNum(orderNum);
        if (orderPays != null && orderPays.size() > 0){
            for (OrderPay orderPay1 : orderPays){
                String channelId = orderPay1.getChannelId();
                if (channelId != null){
                    this.hasExitPay = true;
                    return true;
                }
            }
        }
        this.hasExitPay = false;
        return false;
    }
}
