package com.icetech.park.service.queryfee;

import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class MonthTypeDto {
    /**
     * 月卡类型
     */
    private MonthTypeEnum monthTypeEnum;
    /**
     * 是否区分工作日非工作日,0:不区分 1：区分 默认为0
     */
    private Integer diffWorkday;
    /**
     * 非工作日收费类型，1：全天免费，2：全天临时车收费
     */
    private Integer notWorkdayCharge;
    /**
     * 月卡类型，1：全天月卡，2：错时月卡
     */
    private int cardType;
    /**
     * 是否多位多车
     */
    private boolean isAbCard;
    /**
     * 1：多位多车的A车，2：多位多车B车
     */
    private int abCarType;
    /**
     * 当前生效月卡信息
     */
    private MonthInfo currMonthInfo;
    /**
     * 过期月卡信息
     */
    private MonthInfo timedOutMonthInfo;
    /**
     * 当前生效月卡产品
     */
    private MonthProduct currMonthProduct;
    /**
     * 过期月卡产品
     */
    private MonthProduct timedOutMonthProduct;
}
