package com.icetech.park.service.queryfee;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.dao.park.RegionChargeconfigDao;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.charge.BaseFeeParamHolder;
import com.icetech.basics.service.other.NotWorkDayService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.dao.OrderTagsDao;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.park.service.monthcar.MonthCarServiceBase;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
@RefreshScope
@Slf4j
public class MonthFeeHandle {
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Autowired
    private MonthProductDao monthProductDao;
    @Resource
    private MonthPlateDao monthPlateDao;
    @Autowired
    private OrderTagsDao orderTagsDao;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private MonthRegionDao monthRegionDao;
    @Autowired
    private NotWorkDayService notWorkDayService;
    @Autowired
    private RegionChargeconfigDao regionChargeconfigDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    /**
     * 按月卡计费规则的条件：月卡过期天数限制
     */
    @Value("${monthcard.expire.days:999}")
    private Integer monthCardExpireDays;

    //月卡超时类型值
    private static final Integer TIMEOUT_CARD = 4;

    /**
     * 获取月卡详情
     * @param orderInfo 主订单信息
     * @param innerOrderSonInfo 子订单信息
     * @return 月卡详情
     */
    public MonthFeeDto getMonthFeeParamOutArea(BaseFeeParamHolder feeParamHolder, Long parkId,
                                        OrderInfo orderInfo, long startTime, long endTime, ParkConfig parkConfig, OrderSonInfo innerOrderSonInfo) {
        Long regionId = orderInfo.getRegionId();
        MonthFeeDto monthFeeDto = null;
        //判断月卡类型
        MonthTypeDto monthTypeDto = getMonthTypeDto(parkId, orderInfo, startTime, endTime, parkConfig, regionId, 2);
        if (monthTypeDto.getMonthTypeEnum() != null) {
            log.info("月卡判断结果[{}]", monthTypeDto);
            feeParamHolder.setMonthCarFee(true);
            MonthInfo monthInfoRet = monthTypeDto.getCurrMonthInfo() != null ? monthTypeDto.getCurrMonthInfo() : monthTypeDto.getTimedOutMonthInfo();
            //不区分工作日非工作日月卡
            monthFeeDto = noDiffWorkday(feeParamHolder, orderInfo, parkConfig, startTime, endTime, monthTypeDto, monthInfoRet, 1);
        }
        return null;
    }
    /**
     * 获取月卡详情
     * @param multipleAreaType 多区域类型，0：非场中场，1：外区域，2：内区域
     * @return 月卡详情
     */
    public MonthFeeDto getMonthFeeParam(BaseFeeParamHolder feeParamHolder, Long parkId,
                                        OrderInfo orderInfo, long startTime, long endTime, ParkConfig parkConfig, int multipleAreaType) {
        Long regionId = orderInfo.getRegionId();
        //判断月卡类型
        MonthTypeDto monthTypeDto = getMonthTypeDto(parkId, orderInfo, startTime, endTime, parkConfig, regionId, multipleAreaType);
        if (monthTypeDto.getMonthTypeEnum() != null) {
            log.info("月卡判断结果[{}]", monthTypeDto);
            feeParamHolder.setMonthCarFee(true);
            MonthInfo monthInfoRet = monthTypeDto.getCurrMonthInfo() != null ? monthTypeDto.getCurrMonthInfo() : monthTypeDto.getTimedOutMonthInfo();
            if (Integer.valueOf(1).equals(monthTypeDto.getDiffWorkday())) {
                //区分工作日非工作日月卡
                OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
                if (Integer.valueOf(1).equals(multipleAreaType) && innerOrderSonInfo != null
                        && innerOrderSonInfo.getEnterTime() != null && innerOrderSonInfo.getExitTime() != null
                        && !innerOrderSonInfo.getEnterTime().equals(innerOrderSonInfo.getExitTime())) {
                    return outAreaDiffWorkday(feeParamHolder, orderInfo, parkConfig, startTime, endTime, monthTypeDto, monthInfoRet);
                }
                //区分工作日非工作日月卡
                return diffWorkday(feeParamHolder, orderInfo, parkConfig, startTime, endTime, monthTypeDto, monthInfoRet);
            } else {
                //不区分工作日非工作日月卡
                return noDiffWorkday(feeParamHolder, orderInfo, parkConfig, startTime, endTime, monthTypeDto, monthInfoRet, multipleAreaType);
            }
        }
        return null;
    }

    private MonthFeeDto noDiffWorkday(BaseFeeParamHolder feeParamHolder, OrderInfo orderInfo, ParkConfig parkConfig,
                                      long startTime, long endTime, MonthTypeDto monthTypeDto, MonthInfo monthInfoRet, int multipleAreaType) {
        //当前区域的计费时段集合
        List<BaseFeeParamHolder.ExtraComputeFeePara> currFeeParaList = new ArrayList<>();
        Long csSwitchTime = null;
        boolean isCsMonthCarFee = false;
        int csFeeType = 0;
        String csStartTime = null;
        String csEndTime = null;
        long newStartTime = startTime;
        long newEndTime = endTime;
        switch (monthTypeDto.getMonthTypeEnum()) {
            case FULL_MONTH:
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {//全天月卡
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                    //B车
                    if (orderInfo.getSwitchTime() != null) {
                        newEndTime = orderInfo.getSwitchTime();
                    }
                } else {//错时月卡
                    MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                    if (monthProduct == null) {
                        monthProduct = monthTypeDto.getTimedOutMonthProduct();
                    }
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        isCsMonthCarFee = true;
                        csStartTime = monthProduct.getStartTime().toString();
                        csEndTime = monthProduct.getEndTime().toString();
                    } else {
                        //B车
                        if (orderInfo.getSwitchTime() != null) {
                            isCsMonthCarFee = true;
                            csStartTime = monthProduct.getStartTime().toString();
                            csEndTime = monthProduct.getEndTime().toString();
                            csSwitchTime = orderInfo.getSwitchTime();
                            csFeeType = 2;
                        }
                    }
                }
                break;
            case IN_PARK_START:
                MonthInfo monthInfo = monthTypeDto.getCurrMonthInfo();
                //场内办月卡
                int inParkRenewType = NumberUtils.toPrimitive(parkConfig.getInparkRenewType(), 1);
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {//全天月卡
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        if (inParkRenewType == 1) {
                            newEndTime = monthInfo.getStartTime().getTime() / 1000;
                        } else {
                            log.info("场内办月卡，临时车部分不收费，车牌号：{}", orderInfo.getPlateNum());
                            return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                        }
                    } else {
                        //B车
                        if (orderInfo.getSwitchTime() != null) {
                            newEndTime = orderInfo.getSwitchTime();
                        }
                    }
                } else {//错时月卡
                    MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        if (inParkRenewType == 1) {
                            //收取临时车全天费用和月卡车错时时间段外费用
                            isCsMonthCarFee = true;
                            csStartTime = monthProduct.getStartTime().toString();
                            csEndTime = monthProduct.getEndTime().toString();
                            csSwitchTime = monthInfo.getStartTime().getTime() / 1000;
                            csFeeType = 2;
                        } else {
                            isCsMonthCarFee = true;
                            csStartTime = monthProduct.getStartTime().toString();
                            csEndTime = monthProduct.getEndTime().toString();
                        }
                    } else {
                        //B车
                        if (orderInfo.getSwitchTime() != null) {
                            isCsMonthCarFee = true;
                            csStartTime = monthProduct.getStartTime().toString();
                            csEndTime = monthProduct.getEndTime().toString();
                            csSwitchTime = orderInfo.getSwitchTime();
                            csFeeType = 2;
                        }
                    }
                }
                break;
            case TEMP_MIDDLE:
                MonthInfo currMonthInfo = monthTypeDto.getCurrMonthInfo();
                MonthInfo timeoutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                int timeoutRenewType = NumberUtils.toPrimitive(parkConfig.getTimeoutRenewType(), 1);
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {//全天月卡
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        if (timeoutRenewType == 1) {
                            newStartTime = completeConvert(timeoutMonthInfo.getEndTime()) + 1;
                            newEndTime = currMonthInfo.getStartTime().getTime() / 1000;
                        } else {
                            //免费
                            log.info("场内过期后再续费，中间有临时车空档期不收费，车牌号：{}", orderInfo.getPlateNum());
                            return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                        }
                    } else {
                        //B车
                        if (orderInfo.getSwitchTime() != null) {
                            newEndTime = orderInfo.getSwitchTime();
                        }
                    }
                } else {//错时月卡
                    MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        if (timeoutRenewType == 1) {
                            //收取入场到第一个月卡过期时间错时时间外费用 + 从第一个月卡过期时间到出场时间的错时时间外费用
                            isCsMonthCarFee = true;
                            csStartTime = monthProduct.getStartTime().toString();
                            csEndTime = monthProduct.getEndTime().toString();
                            //csSwitchTime = currMonthInfo.getStartTime().getTime() / 1000;
                            //csFeeType = 2;
                            long newStartTime2 = completeConvert(timeoutMonthInfo.getEndTime()) + 1;
                            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .startTime(startTime)
                                    .endTime(newStartTime2)
                                    .isCsMonthCarFee(true)
                                    .csStartTime(monthProduct.getStartTime().toString())
                                    .csEndTime(monthProduct.getEndTime().toString()).build();
                            currFeeParaList.add(feePara);
                            BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .startTime(newStartTime2)
                                    .endTime(endTime)
                                    .isCsMonthCarFee(true)
                                    .csStartTime(monthProduct.getStartTime().toString())
                                    .csEndTime(monthProduct.getEndTime().toString())
                                    .csSwitchTime(currMonthInfo.getStartTime().getTime() / 1000)
                                    .csFeeType(2).build();
                            currFeeParaList.add(feePara2);
                        } else {
                            isCsMonthCarFee = true;
                            csStartTime = monthProduct.getStartTime().toString();
                            csEndTime = monthProduct.getEndTime().toString();
                        }
                    } else {
                        //B车
                        if (orderInfo.getSwitchTime() != null) {
                            isCsMonthCarFee = true;
                            csStartTime = monthProduct.getStartTime().toString();
                            csEndTime = monthProduct.getEndTime().toString();
                            csSwitchTime = orderInfo.getSwitchTime();
                            csFeeType = 2;
                        }
                    }
                }
                break;
            case TIMEOUT_IN_PARK:
                MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {//全天月卡
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        newStartTime = completeConvert(timedOutMonthInfo.getEndTime()) + 1;
                    } else {
                        //B车
                        if (orderInfo.getSwitchTime() != null) {
                            newEndTime = orderInfo.getSwitchTime();
                        }
                    }
                } else {//错时月卡
                    MonthProduct monthProduct = monthTypeDto.getTimedOutMonthProduct();
                    if (!monthTypeDto.isAbCard() || monthTypeDto.getAbCarType() == 1) {
                        //收取临时车全天费用和月卡车错时时间段外费用
                        isCsMonthCarFee = true;
                        csStartTime = monthProduct.getStartTime().toString();
                        csEndTime = monthProduct.getEndTime().toString();
                        csSwitchTime = completeConvert(timedOutMonthInfo.getEndTime());
                        csFeeType = 1;
                    } else {
                        //B车
                        if (orderInfo.getSwitchTime() != null) {
                            //收取入场时间到切换时间全天费用+月卡生效期错时时间段外费用+过期时间段全天的费用
                            isCsMonthCarFee = true;
                            csStartTime = monthProduct.getStartTime().toString();
                            csEndTime = monthProduct.getEndTime().toString();
                            //csSwitchTime = orderInfo.getSwitchTime();
                            //csFeeType = 2;
                            long newEndTime2 = completeConvert(timedOutMonthInfo.getEndTime()) + 1;
                            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .isCsMonthCarFee(true)
                                    .startTime(startTime)
                                    .endTime(newEndTime2)
                                    .csStartTime(monthProduct.getStartTime().toString())
                                    .csEndTime(monthProduct.getEndTime().toString())
                                    .csSwitchTime(orderInfo.getSwitchTime())
                                    .csFeeType(2).build();
                            currFeeParaList.add(feePara);
                            BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .startTime(newEndTime2)
                                    .endTime(endTime).build();
                            currFeeParaList.add(feePara2);
                        }
                    }
                }
                break;
            case MONTH_MIDDLE:
                timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                long newStartTime2 = completeConvert(timedOutMonthInfo.getEndTime()) + 1;
                long newEndTime2 = timedOutMonthInfo.getStartTime().getTime()/1000;
                inParkRenewType = NumberUtils.toPrimitive(parkConfig.getInparkRenewType(), 1);
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    //全天月卡
                    if (monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 && orderInfo.getSwitchTime() != null) {
                        if (inParkRenewType == 1) {
                            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .startTime(startTime)
                                    .endTime(orderInfo.getSwitchTime()).build();
                            currFeeParaList.add(feePara);
                            log.info("计费从入场到AB车切换时间的时间段, {}, {}", startTime, newEndTime2);
                        } else {
                            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .startTime(newEndTime2)
                                    .endTime(orderInfo.getSwitchTime()).build();
                            currFeeParaList.add(feePara);
                            log.info("计费从月卡生效时间到AB车切换时间的时间段, {}, {}", startTime, newEndTime2);
                        }
                    } else {
                        if (inParkRenewType == 1) {
                            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .startTime(startTime)
                                    .endTime(newEndTime2).build();
                            currFeeParaList.add(feePara);
                            log.info("计费从入场到月卡生效时间的时间段, {}, {}", startTime, newEndTime2);
                        }
                    }
                } else {
                    //错时月卡
                    MonthProduct monthProduct = monthTypeDto.getTimedOutMonthProduct();
                    if (inParkRenewType == 2) {
                        newStartTime = newEndTime2;
                    } else {
                        newStartTime = startTime;
                    }
                    if (monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 && orderInfo.getSwitchTime() != null) {
                        long switchTime = orderInfo.getSwitchTime();
                        BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                .isCsMonthCarFee(true)
                                .startTime(newStartTime)
                                .endTime(newStartTime2)
                                .csStartTime(monthProduct.getStartTime().toString())
                                .csEndTime(monthProduct.getEndTime().toString())
                                .csSwitchTime(switchTime)
                                .csFeeType(2).build();
                        currFeeParaList.add(feePara);
                        log.info("计费从入场到错时月卡AB车切换时间的时间段, {}, {}, {}", newStartTime, newStartTime2, switchTime);
                    } else {
                        if (inParkRenewType == 1) {
                            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .isCsMonthCarFee(true)
                                    .startTime(startTime)
                                    .endTime(newStartTime2)
                                    .csStartTime(monthProduct.getStartTime().toString())
                                    .csEndTime(monthProduct.getEndTime().toString())
                                    .csSwitchTime(newEndTime2)
                                    .csFeeType(2).build();
                            currFeeParaList.add(feePara);
                            log.info("计费从入场到错时月卡结束的时间段, {}, {}, {}", startTime, newStartTime2, newEndTime2);
                        } else {
                            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .isCsMonthCarFee(true)
                                    .startTime(startTime)
                                    .endTime(newStartTime2)
                                    .csStartTime(monthProduct.getStartTime().toString())
                                    .csEndTime(monthProduct.getEndTime().toString()).build();
                            currFeeParaList.add(feePara);
                            log.info("计费从入场到错时月卡结束的时间段, {}, {}", startTime, newStartTime2);
                        }
                    }
                }
                //从月卡过期到离场时间的费用
                BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .startTime(newStartTime2)
                        .endTime(endTime).build();
                currFeeParaList.add(feePara2);
                log.info("计费从月卡过期到离场的时间段, {}, {}", newStartTime2, endTime);
                break;
            default:
                break;
        }
        //查询并设置月卡计费规则
        Integer billId = queryMonthBillId(feeParamHolder.getQueryOrderFeeRequest(), orderInfo, monthTypeDto);
        Set<Integer> billIdList = new LinkedHashSet<>();
        billIdList.add(billId);

        if (billId != null) {
            //将错时月卡和临时车部分单独设置计费规则
            splitExtraComputeFeePara(currFeeParaList, billId, csFeeType, newStartTime, csSwitchTime, csStartTime, csEndTime, newEndTime, billIdList);
            log.info("分离月卡和临时时段后的计费时间段为[{}]", currFeeParaList);
        }
        feeParamHolder.addAllExtraFeePara(currFeeParaList);
        return MonthFeeDto.builder()
                .isMonthRet(false)
                .newStartTime(newStartTime)
                .newEndTime(newEndTime)
                .csFeeType(csFeeType)
                .isCsMonthCarFee(isCsMonthCarFee)
                .csStartTime(csStartTime)
                .csEndTime(csEndTime)
                .csSwitchTime(csSwitchTime)
                .billIdList(billIdList)
                .monthInfo(monthInfoRet).build();
    }

    private static void splitExtraComputeFeePara(List<BaseFeeParamHolder.ExtraComputeFeePara> currFeeParaList,
                                                 Integer billId, int csFeeType, Long newStartTime, Long csSwitchTime,
                                                 String csStartTime, String csEndTime, Long newEndTime, Set<Integer> billIdList) {
        List<BaseFeeParamHolder.ExtraComputeFeePara> addList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(currFeeParaList)) {
            for (BaseFeeParamHolder.ExtraComputeFeePara extraComputeFeePara : currFeeParaList) {
                extraComputeFeePara.setBillId(billId);
                if (extraComputeFeePara.getCsFeeType() == 1) {
                    //月卡过期时间
                    Long csSwitchTime1 = extraComputeFeePara.getCsSwitchTime();
                    Long endTime = extraComputeFeePara.getEndTime();
                    extraComputeFeePara.setCsFeeType(0);
                    extraComputeFeePara.setCsSwitchTime(null);
                    extraComputeFeePara.setEndTime(csSwitchTime1);

                    //为了区分不同计费规则，新增临时车部分计费
                    BaseFeeParamHolder.ExtraComputeFeePara feeParaTemp = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                            .startTime(csSwitchTime1)
                            .endTime(endTime).build();
                    addList.add(feeParaTemp);
                    //默认计费，后续代码填充
                    billIdList.add(null);
                } else if (extraComputeFeePara.getCsFeeType() == 2) {
                    //月卡开始时间
                    Long csSwitchTime1 = extraComputeFeePara.getCsSwitchTime();
                    Long startTime = extraComputeFeePara.getStartTime();
                    extraComputeFeePara.setCsFeeType(0);
                    extraComputeFeePara.setCsSwitchTime(null);
                    extraComputeFeePara.setStartTime(csSwitchTime1);

                    //为了区分不同计费规则，新增临时车部分计费
                    BaseFeeParamHolder.ExtraComputeFeePara feeParaTemp = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                            .startTime(startTime)
                            .endTime(csSwitchTime1).build();
                    addList.add(feeParaTemp);
                    //默认计费，后续代码填充
                    billIdList.add(null);
                }
            }
        } else {
            if (csFeeType == 1) {
                BaseFeeParamHolder.ExtraComputeFeePara feeParaMonth = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .billId(billId)
                        .isCsMonthCarFee(true)
                        .startTime(newStartTime)
                        .endTime(csSwitchTime)
                        .csStartTime(csStartTime)
                        .csEndTime(csEndTime).build();
                addList.add(feeParaMonth);

                BaseFeeParamHolder.ExtraComputeFeePara feeParaTemp = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .startTime(csSwitchTime)
                        .endTime(newEndTime).build();
                addList.add(feeParaTemp);
                //默认计费，后续代码填充
                billIdList.add(null);
            } else if (csFeeType == 2) {
                BaseFeeParamHolder.ExtraComputeFeePara feeParaMonth = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .billId(billId)
                        .isCsMonthCarFee(true)
                        .startTime(csSwitchTime)
                        .endTime(newEndTime)
                        .csStartTime(csStartTime)
                        .csEndTime(csEndTime).build();
                addList.add(feeParaMonth);

                BaseFeeParamHolder.ExtraComputeFeePara feeParaTemp = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .startTime(newStartTime)
                        .endTime(csSwitchTime).build();
                addList.add(feeParaTemp);
                //默认计费，后续代码填充
                billIdList.add(null);
            }
        }
        if (!addList.isEmpty()) {
            currFeeParaList.addAll(addList);
        }
    }

    private Integer queryMonthBillId(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, MonthTypeDto monthTypeDto) {
        int ruleType = 0;
        //全天月卡，需要计费时读取月卡计费规则
        if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
            if (MonthTypeEnum.IN_PARK_START.equals(monthTypeDto.getMonthTypeEnum())) {
                return null;
            }
            if (MonthTypeEnum.TIMEOUT.equals(monthTypeDto.getMonthTypeEnum())) {
                MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                if (timedOutMonthInfo != null && DateTools.differentDays(timedOutMonthInfo.getEndTime(), new Date()) >= monthCardExpireDays) {
                    return null;
                }
            }
            ruleType = 5;
        } else {
            if (MonthTypeEnum.TIMEOUT.equals(monthTypeDto.getMonthTypeEnum())) {
                return null;
            }
            ruleType = 8;
        }
        Long regionId = orderInfo.getRegionId();
        if (regionId == null) {
            if (queryOrderFeeRequest.getChannelId() != null) {
                ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceByCode(queryOrderFeeRequest.getChannelId()).getData();
                if (parkInoutdevice == null) {
                    throw new ResponseBodyException(CodeConstants.ERROR_3001, "无效的通道编号");
                }
                regionId = parkInoutdevice.getRegionId() == null ? null : parkInoutdevice.getRegionId();
            } else {
                ParkRegion parkRegion = parkRegionDao.selectOutByParkid(orderInfo.getParkId());
                regionId = parkRegion == null ? null : parkRegion.getId();
            }
        }
        RegionChargeconfig regionChargeConfig = regionChargeconfigDao.getRegionChargeconfig(orderInfo.getParkId(), regionId, ruleType);
        if (regionChargeConfig != null && Integer.valueOf(1).equals(regionChargeConfig.getEnabled())) {
            ParkChargeconfig parkChargeconfig = parkChargeconfigDao.selectByParkIdAndBillCode(orderInfo.getParkId(),
                    regionChargeConfig.getBilltypecode());
            if (parkChargeconfig != null) {
                log.info("使用月卡车计费规则，orderNum：{}，parkChargeconfig：{}", orderInfo.getOrderNum(), parkChargeconfig);
                return parkChargeconfig.getId();
            }
        }
        return null;
    }

    private MonthFeeDto diffWorkday(BaseFeeParamHolder feeParamHolder, OrderInfo orderInfo, ParkConfig parkConfig,
                                      long startTime, long endTime, MonthTypeDto monthTypeDto, MonthInfo monthInfoRet) {
        Long csSwitchTime = null;
        boolean isCsMonthCarFee = false;
        int csFeeType = 0;
        String csStartTime = null;
        String csEndTime = null;
        Long newStartTime = null;
        Long newEndTime = null;
        long firstPartStart = startTime;
        Long switchTime = monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 ? orderInfo.getSwitchTime() : null;
        //切换时间不在开始和结束之间时，当作没有切换时间
        if (switchTime != null && (switchTime <= startTime || switchTime >= endTime)) {
            switchTime = null;
        }
        //切换时间前的停车时长
        long beforeSwitchParkTime = 0;
        switch (monthTypeDto.getMonthTypeEnum()) {
            case FULL_MONTH:
                //标记是否有其他计费
                boolean otherFee = false;
                if (switchTime != null) {
                    firstPartStart = switchTime;
                    BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                            .startTime(startTime)
                            .endTime(switchTime).build();
                    feeParamHolder.addExtraFeePara(feePara);
                    otherFee = true;
                }
                //工作日全天月卡
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    //切换时间后的时长按月卡，需要区分工作日和非工作日
                    ParkTimeDetail parkTimeDetail = getParkTimeDetail(firstPartStart, endTime);
                    int parkTimeType = parkTimeDetail.getType();
                    //因为全天月卡，隐含工作日免费，只在工作日停车或者非工作日停车配置免费时
                    if (parkTimeType == 1 || NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 1) {
                        if (!otherFee) {
                            return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                        }
                    } else {
                        //因为全天月卡，隐含工作日免费，只在工作日停车或者非工作日停车配置免费时
                        if ((parkTimeType == 2 || parkTimeType == 3)
                                && NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 2) {
                            BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .startTime(parkTimeDetail.getNotWorkDayStartTime())
                                    .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                            feeParamHolder.addExtraFeePara(feePara2);
                        }
                    }
                } else {
                    //错时月卡
                    MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                    if (monthProduct == null) {
                        monthProduct = monthTypeDto.getTimedOutMonthProduct();
                    }
                    boolean isMonth = addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, endTime, monthTypeDto, monthProduct);
                    if (isMonth && !otherFee) {
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                }
                break;
            case IN_PARK_START:
                //标记是否有其他计费
                otherFee = false;
                //场内办月卡
                MonthInfo monthInfo = monthTypeDto.getCurrMonthInfo();
                int inParkRenewType = NumberUtils.toPrimitive(parkConfig.getInparkRenewType(), 1);
                //不是错时月卡、办卡前不收费并且全天月卡时，按月卡处理
                if (switchTime == null && inParkRenewType == 2
                        && Integer.valueOf(1).equals(monthTypeDto.getCardType())
                        && NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 1) {
                    return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                }
                //临时车部分计费
                if (inParkRenewType == 1) {
                    firstPartStart = monthInfo.getStartTime().getTime() / 1000;
                    if (switchTime != null) {
                        firstPartStart = switchTime;
                        beforeSwitchParkTime = switchTime - monthInfo.getStartTime().getTime() / 1000;
                    }
                    BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                            .startTime(startTime)
                            .endTime(monthInfo.getStartTime().getTime() / 1000 + beforeSwitchParkTime).build();
                    feeParamHolder.addExtraFeePara(feePara);
                    otherFee = true;
                }
                //月卡车不收费时，B车有切换时间时，切换时间前的也按月卡车
                //工作日全天月卡
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    //月卡停车时长部分需要区分工作日和非工作日
                    ParkTimeDetail parkTimeDetail = getParkTimeDetail(firstPartStart, endTime);
                    //只包含工作日或非工作日免费费时
                    if (parkTimeDetail.getType() == 1 || NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 1) {
                        if (!otherFee) {
                            return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                        }
                    } else {
                        //非工作日收费时
                        BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                .startTime(parkTimeDetail.getNotWorkDayStartTime())
                                .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                        feeParamHolder.addExtraFeePara(feePara);
                    }
                } else {//错时月卡
                    MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                    boolean isMonth = addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, endTime, monthTypeDto, monthProduct);
                    if (isMonth && !otherFee) {
                        return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                    }
                }
                break;
            case TEMP_MIDDLE:
                MonthInfo currMonthInfo = monthTypeDto.getCurrMonthInfo();
                MonthInfo timeoutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                int timeoutRenewType = NumberUtils.toPrimitive(parkConfig.getTimeoutRenewType(), 1);
                long secondPartStart = currMonthInfo.getStartTime().getTime() / 1000;
                if (switchTime != null) {
                    //切换发生在过期月卡上
                    if (switchTime < timeoutMonthInfo.getEndTime().getTime() / 1000) {
                        firstPartStart = switchTime;
                        beforeSwitchParkTime = switchTime - startTime;
                    } else {
                        //切换发生在当前生效月卡上
                        if (switchTime > currMonthInfo.getStartTime().getTime() / 1000) {
                            secondPartStart = switchTime;
                            beforeSwitchParkTime = switchTime - currMonthInfo.getStartTime().getTime() / 1000;
                        }
                    }
                }
                //工作日全天月卡
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    if (timeoutRenewType == 1) {
                        //前面停车部分按月卡收费
                        //过期月卡区分工作日和非工作日
                        MonthProduct timedOutMonthProduct = monthTypeDto.getTimedOutMonthProduct();
                        if (NumberUtils.toPrimitive(timedOutMonthProduct.getDiffWorkday()) == 1) {
                            ParkTimeDetail parkTimeDetail = getParkTimeDetail(firstPartStart, completeConvert(timeoutMonthInfo.getEndTime()) + 1);
                            if ((parkTimeDetail.getType() == 2 || parkTimeDetail.getType() == 3)
                                    && NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 2) {
                                BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                        .startTime(parkTimeDetail.getNotWorkDayStartTime())
                                        .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                                feeParamHolder.addExtraFeePara(feePara2);
                            }
                        }

                        //中间临时车部分按临时车收费，如果有切换时长，再加上最开始停车的临时车时间段
                        BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                .endTime(currMonthInfo.getStartTime().getTime() / 1000 + beforeSwitchParkTime).build();
                        feeParamHolder.addExtraFeePara(feePara);

                        //后面停车部分按月卡收费
                        ParkTimeDetail parkTimeDetail = getParkTimeDetail(secondPartStart, endTime);
                        if ((parkTimeDetail.getType() == 2 || parkTimeDetail.getType() == 3)
                                && NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 2) {
                            BaseFeeParamHolder.ExtraComputeFeePara feePara3 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                    .startTime(parkTimeDetail.getNotWorkDayStartTime())
                                    .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                            feeParamHolder.addExtraFeePara(feePara3);
                        }
                    } else {
                        ParkTimeDetail parkTimeDetail = getParkTimeDetail(startTime, endTime);
                        if (parkTimeDetail.getType() == 1 || NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 1) {
                            //免费
                            log.info("场内过期后再续费，中间有临时车空档期不收费，车牌号：{}", orderInfo.getPlateNum());
                            return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                        }
                        BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                .startTime(parkTimeDetail.getNotWorkDayStartTime())
                                .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                        feeParamHolder.addExtraFeePara(feePara2);
                    }

                } else {//错时月卡
                    MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                    MonthProduct timedOutMonthProduct = monthTypeDto.getTimedOutMonthProduct();
                    if (timeoutRenewType == 1) {
                        //收取入场到第一个月卡过期时间错时时间外费用
                        if (NumberUtils.toPrimitive(timedOutMonthProduct.getDiffWorkday()) == 1) {
                            addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, completeConvert(timeoutMonthInfo.getEndTime()) + 1, monthTypeDto, timedOutMonthProduct);
                        }

                        //中间临时车部分按临时车收费，如果有切换时长，再加上最开始停车的临时车时间段
                        BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                .endTime(currMonthInfo.getStartTime().getTime() / 1000 + beforeSwitchParkTime).build();
                        feeParamHolder.addExtraFeePara(feePara2);

                        //收第二个月卡期间的费用
                        addCsWorkDayAndNotFeePara(feeParamHolder, secondPartStart, endTime, monthTypeDto, timedOutMonthProduct);
                    } else {
                        boolean isMonth = addCsWorkDayAndNotFeePara(feeParamHolder, startTime, endTime, monthTypeDto, monthProduct);
                        if (isMonth) {
                            return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
                        }
                    }
                }
                break;
            case TIMEOUT_IN_PARK:
                MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();

                //切换时间前的停车时长
                long beforeSwitchParkTime2 = 0;
                if (switchTime != null) {
                    //切换发生在过期月卡上
                    firstPartStart = switchTime;
                    beforeSwitchParkTime2 = switchTime - startTime;
                }
                //过期后的临时车部分计费，有切换时间的，加上切换时间前的临时车部分
                BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .startTime(completeConvert(timedOutMonthInfo.getEndTime()) + 1)
                        .endTime(endTime + beforeSwitchParkTime2).build();
                feeParamHolder.addExtraFeePara(feePara);

                //工作日全天月卡
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    ParkTimeDetail parkTimeDetail = getParkTimeDetail(firstPartStart, completeConvert(timedOutMonthInfo.getEndTime()) + 1);
                    if ((parkTimeDetail.getType() == 2 || parkTimeDetail.getType() == 3)
                            && NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 2) {
                        BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                .startTime(parkTimeDetail.getNotWorkDayStartTime())
                                .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                        feeParamHolder.addExtraFeePara(feePara2);
                    }
                } else {
                    //错时月卡
                    MonthProduct monthProduct = monthTypeDto.getTimedOutMonthProduct();
                    addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, completeConvert(timedOutMonthInfo.getEndTime()) + 1,
                            monthTypeDto, monthProduct);
                }
                break;
            case MONTH_MIDDLE:
                timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                inParkRenewType = NumberUtils.toPrimitive(parkConfig.getInparkRenewType(), 1);
                long newStartTime2 = completeConvert(timedOutMonthInfo.getEndTime()) + 1;
                long newEndTime2 = timedOutMonthInfo.getStartTime().getTime()/1000;
                //前面临时车部分的停车时长
                long beforeTempParkTime = newEndTime2 - startTime;
                if (inParkRenewType == 2) {
                    beforeTempParkTime = 0;
                }
                if (monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 && switchTime != null) {
                    //切换发生在过期月卡上
                    firstPartStart = switchTime;
                    if (inParkRenewType == 2) {
                        beforeTempParkTime = switchTime - newEndTime2;
                    } else {
                        beforeTempParkTime = switchTime - startTime;
                    }
                }
                //过期后的临时车部分计费，有切换时间的，加上切换时间前的临时车部分
                feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .startTime(newStartTime2)
                        .endTime(endTime + beforeTempParkTime).build();
                feeParamHolder.addExtraFeePara(feePara);
                log.info("计费从月卡过期到离场(+前面临时车部分)的时间段, {}, {}, {}", newStartTime2, endTime, beforeTempParkTime);

                //工作日全天月卡
                if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                    ParkTimeDetail parkTimeDetail = getParkTimeDetail(firstPartStart, newStartTime2);
                    if ((parkTimeDetail.getType() == 2 || parkTimeDetail.getType() == 3)
                            && NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 2) {
                        BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                                .startTime(parkTimeDetail.getNotWorkDayStartTime())
                                .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                        feeParamHolder.addExtraFeePara(feePara2);
                    }
                } else {
                    //错时月卡
                    MonthProduct monthProduct = monthTypeDto.getTimedOutMonthProduct();
                    addCsWorkDayAndNotFeePara(feeParamHolder, firstPartStart, newStartTime2,
                            monthTypeDto, monthProduct);
                }
                break;
            default:
                break;
        }
        return MonthFeeDto.builder()
                .isMonthRet(false)
                .newStartTime(newStartTime)
                .newEndTime(newEndTime)
                .csFeeType(csFeeType)
                .isCsMonthCarFee(isCsMonthCarFee)
                .csStartTime(csStartTime)
                .csEndTime(csEndTime)
                .csSwitchTime(csSwitchTime)
                .monthInfo(monthInfoRet).build();
    }
    private MonthFeeDto outAreaDiffWorkday(BaseFeeParamHolder feeParamHolder, OrderInfo orderInfo, ParkConfig parkConfig,
                                      long startTime, long endTime, MonthTypeDto monthTypeDto, MonthInfo monthInfoRet) {
        Long csSwitchTime = null;
        boolean isCsMonthCarFee = false;
        int csFeeType = 0;
        String csStartTime = null;
        String csEndTime = null;
        Long newStartTime = null;
        Long newEndTime = null;
        Long switchTime = monthTypeDto.isAbCard() && monthTypeDto.getAbCarType() == 2 ? orderInfo.getSwitchTime() : null;
        OrderSonInfo innerOrderSonInfo = feeParamHolder.getInnerOrderSonInfo();
        Long innerAreaEnterTime = innerOrderSonInfo.getEnterTime();
        Long innerAreaExitTime = innerOrderSonInfo.getExitTime();
        List<ParkTimeCompose> list = new ArrayList<>();
        if (switchTime == null) {
            switch (monthTypeDto.getMonthTypeEnum()) {
                case FULL_MONTH:
                    twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                    break;
                case IN_PARK_START:
                    MonthInfo monthInfo = monthTypeDto.getCurrMonthInfo();
                    int inParkRenewType = NumberUtils.toPrimitive(parkConfig.getInparkRenewType(), 1);
                    if (inParkRenewType == 1) {
                        handleParkTimeComposeWithSwitchTime(startTime, endTime, innerAreaEnterTime, innerAreaExitTime,
                                monthInfo.getStartTime().getTime() / 1000, list);
                    } else {
                        twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                    }
                    break;
                case TEMP_MIDDLE:
                    MonthInfo currMonthInfo = monthTypeDto.getCurrMonthInfo();
                    MonthInfo timeoutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                    int timeoutRenewType = NumberUtils.toPrimitive(parkConfig.getTimeoutRenewType(), 1);
                    long secondPartStart = currMonthInfo.getStartTime().getTime() / 1000;
                    if (timeoutRenewType == 1) {
                        //前面停车部分按月卡收费
                        //在入小场前发生了过期和续费
                        if (currMonthInfo.getStartTime().getTime() / 1000 < innerAreaEnterTime) {
                            ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                    .startTime(startTime)
                                    .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .type(2).build();
                            list.add(monthCarParkTime5);
                            ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder()
                                    .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .endTime(currMonthInfo.getStartTime().getTime() / 1000)
                                    .type(1).build();
                            list.add(monthCarParkTime6);
                            ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder()
                                    .startTime(currMonthInfo.getStartTime().getTime() / 1000)
                                    .endTime(innerAreaEnterTime)
                                    .type(2).build();
                            list.add(monthCarParkTime7);
                            ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                    .startTime(innerAreaExitTime)
                                    .endTime(endTime)
                                    .type(2).build();
                            list.add(monthCarParkTime8);
                        }
                        //在入小场后出小场前发生了过期和续费
                        if (secondPartStart > innerAreaEnterTime && secondPartStart < innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 > innerAreaEnterTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < innerAreaExitTime) {
                            twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                        }
                        //在出小场后出大场前发生了过期和续费
                        if (secondPartStart > innerAreaExitTime && secondPartStart < endTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 > innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < endTime) {
                            ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                    .startTime(startTime)
                                    .endTime(innerAreaEnterTime)
                                    .type(2).build();
                            list.add(monthCarParkTime5);
                            ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder()
                                    .startTime(innerAreaExitTime)
                                    .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .type(2).build();
                            list.add(monthCarParkTime6);
                            ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder()
                                    .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .endTime(secondPartStart)
                                    .type(1).build();
                            list.add(monthCarParkTime7);
                            ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                    .startTime(secondPartStart)
                                    .endTime(endTime)
                                    .type(2).build();
                            list.add(monthCarParkTime8);
                        }
                        //超时发生在入小场前，续费发生在入小场后 出小场前
                        if (secondPartStart > innerAreaEnterTime && secondPartStart < innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < innerAreaEnterTime) {
                            ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                    .startTime(startTime)
                                    .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .type(2).build();
                            list.add(monthCarParkTime5);
                            ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder()
                                    .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .endTime(innerAreaEnterTime)
                                    .type(1).build();
                            list.add(monthCarParkTime6);
                            ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                    .startTime(innerAreaExitTime)
                                    .endTime(endTime)
                                    .type(2).build();
                            list.add(monthCarParkTime8);
                        }
                        //超时发生在入小场前，续费发生在出小场后
                        if (secondPartStart > innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < innerAreaEnterTime) {
                            ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                    .startTime(startTime)
                                    .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .type(2).build();
                            list.add(monthCarParkTime5);
                            ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder()
                                    .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .endTime(innerAreaEnterTime)
                                    .type(1).build();
                            list.add(monthCarParkTime6);
                            ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                    .startTime(innerAreaExitTime)
                                    .endTime(secondPartStart)
                                    .type(1).build();
                            list.add(monthCarParkTime8);
                            ParkTimeCompose monthCarParkTime9 = ParkTimeCompose.builder()
                                    .startTime(secondPartStart)
                                    .endTime(endTime)
                                    .type(2).build();
                            list.add(monthCarParkTime9);
                        }
                        //超时发生在入小场后，续费发生在出小场后
                        if (secondPartStart > innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < innerAreaEnterTime) {
                            ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                    .startTime(startTime)
                                    .endTime(innerAreaEnterTime)
                                    .type(2).build();
                            list.add(monthCarParkTime5);
                            ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder()
                                    .startTime(innerAreaExitTime)
                                    .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .type(2).build();
                            list.add(monthCarParkTime6);
                            ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                    .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                    .endTime(secondPartStart)
                                    .type(1).build();
                            list.add(monthCarParkTime8);
                            ParkTimeCompose monthCarParkTime9 = ParkTimeCompose.builder()
                                    .startTime(secondPartStart)
                                    .endTime(endTime)
                                    .type(2).build();
                            list.add(monthCarParkTime9);
                        }
                    } else {
                        twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                    }
                    break;
                case TIMEOUT_IN_PARK:
                    MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                    //前面停车部分按月卡收费
                    //在入小场前发生了过期
                    if (completeConvert(timedOutMonthInfo.getEndTime()) + 1 < innerAreaEnterTime) {
                        ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                .startTime(startTime)
                                .endTime(completeConvert(timedOutMonthInfo.getEndTime()) + 1)
                                .type(2).build();
                        list.add(monthCarParkTime5);
                        ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder()
                                .startTime(completeConvert(timedOutMonthInfo.getEndTime()) + 1)
                                .endTime(innerAreaEnterTime)
                                .type(1).build();
                        list.add(monthCarParkTime6);
                        ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                .startTime(innerAreaExitTime)
                                .endTime(endTime)
                                .type(1).build();
                        list.add(monthCarParkTime8);
                    }
                    //在入小场后出小场前发生了过期
                    if (completeConvert(timedOutMonthInfo.getEndTime()) + 1 > innerAreaEnterTime
                            && completeConvert(timedOutMonthInfo.getEndTime()) + 1 < innerAreaExitTime) {
                        ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                .startTime(startTime)
                                .endTime(innerAreaEnterTime)
                                .type(2).build();
                        list.add(monthCarParkTime5);
                        ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                .startTime(innerAreaExitTime)
                                .endTime(endTime)
                                .type(1).build();
                        list.add(monthCarParkTime8);
                    }
                    //在出小场后出大场前发生了过期
                    if (completeConvert(timedOutMonthInfo.getEndTime()) + 1 > innerAreaExitTime
                            && completeConvert(timedOutMonthInfo.getEndTime()) + 1 < endTime) {
                        ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                .startTime(startTime)
                                .endTime(innerAreaEnterTime)
                                .type(2).build();
                        list.add(monthCarParkTime5);
                        ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder()
                                .startTime(innerAreaExitTime)
                                .endTime(completeConvert(timedOutMonthInfo.getEndTime()) + 1)
                                .type(2).build();
                        list.add(monthCarParkTime6);
                        ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder()
                                .startTime(completeConvert(timedOutMonthInfo.getEndTime()) + 1)
                                .endTime(endTime)
                                .type(1).build();
                        list.add(monthCarParkTime7);
                    }
                    break;
                default:
                    break;
            }
        } else {
            switch (monthTypeDto.getMonthTypeEnum()) {
                case FULL_MONTH:
                case IN_PARK_START:
                    handleParkTimeComposeWithSwitchTime(startTime, endTime, innerAreaEnterTime, innerAreaExitTime,
                            switchTime, list);
                    break;
                case TEMP_MIDDLE:
                    MonthInfo currMonthInfo = monthTypeDto.getCurrMonthInfo();
                    MonthInfo timeoutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                    int timeoutRenewType = NumberUtils.toPrimitive(parkConfig.getTimeoutRenewType(), 1);
                    long secondPartStart = currMonthInfo.getStartTime().getTime() / 1000;
                    if (timeoutRenewType == 1) {
                        //前面停车部分按月卡收费
                        //在入小场前发生了过期和续费并且切换时间在入小场前
                        if (currMonthInfo.getStartTime().getTime() / 1000 < innerAreaEnterTime) {
                            //在过期月卡期间切换
                            if (switchTime < completeConvert(timeoutMonthInfo.getEndTime()) + 1) {
                                ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(switchTime)
                                        .type(1).build();
                                list.add(monthCarParkTime5);
                                ParkTimeCompose monthCarParkTime6 = ParkTimeCompose.builder()
                                        .startTime(switchTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(monthCarParkTime6);
                                ParkTimeCompose monthCarParkTime0 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(currMonthInfo.getStartTime().getTime() / 1000)
                                        .type(1).build();
                                list.add(monthCarParkTime0);
                                ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder()
                                        .startTime(currMonthInfo.getStartTime().getTime() / 1000)
                                        .endTime(innerAreaEnterTime)
                                        .type(2).build();
                                list.add(monthCarParkTime7);
                                ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(monthCarParkTime8);
                            } else {
                                //在后一个月卡切换
                                ParkTimeCompose monthCarParkTime5 = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(monthCarParkTime5);
                                ParkTimeCompose monthCarParkTime0 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(currMonthInfo.getStartTime().getTime() / 1000)
                                        .type(1).build();
                                list.add(monthCarParkTime0);
                                //在入小场前切换
                                if (switchTime < innerAreaEnterTime) {
                                    ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder()
                                            .startTime(currMonthInfo.getStartTime().getTime() / 1000)
                                            .endTime(switchTime)
                                            .type(1).build();
                                    list.add(monthCarParkTime7);
                                    ParkTimeCompose monthCarParkTime9 = ParkTimeCompose.builder()
                                            .startTime(switchTime)
                                            .endTime(innerAreaEnterTime)
                                            .type(2).build();
                                    list.add(monthCarParkTime9);
                                    ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                            .startTime(innerAreaExitTime)
                                            .endTime(endTime)
                                            .type(2).build();
                                    list.add(monthCarParkTime8);
                                } else if (switchTime < innerAreaExitTime) {
                                    //在出小场前切换
                                    ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder()
                                            .startTime(currMonthInfo.getStartTime().getTime() / 1000)
                                            .endTime(innerAreaEnterTime)
                                            .type(1).build();
                                    list.add(monthCarParkTime7);
                                    ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                            .startTime(innerAreaExitTime)
                                            .endTime(endTime)
                                            .type(2).build();
                                    list.add(monthCarParkTime8);
                                } else if (switchTime < endTime) {
                                    //在出小场后切换
                                    ParkTimeCompose monthCarParkTime7 = ParkTimeCompose.builder()
                                            .startTime(currMonthInfo.getStartTime().getTime() / 1000)
                                            .endTime(innerAreaEnterTime)
                                            .type(1).build();
                                    list.add(monthCarParkTime7);
                                    ParkTimeCompose monthCarParkTime8 = ParkTimeCompose.builder()
                                            .startTime(innerAreaExitTime)
                                            .endTime(switchTime)
                                            .type(1).build();
                                    list.add(monthCarParkTime8);
                                    ParkTimeCompose monthCarParkTime9 = ParkTimeCompose.builder()
                                            .startTime(switchTime)
                                            .endTime(endTime)
                                            .type(2).build();
                                    list.add(monthCarParkTime9);
                                }
                            }
                        }
                        //在入小场后出小场前发生了过期和续费
                        if (secondPartStart > innerAreaEnterTime && secondPartStart < innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 > innerAreaEnterTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < innerAreaExitTime) {
                            //在前一个月卡切换
                            //在入小场前切换
                            if (switchTime < innerAreaEnterTime) {
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(switchTime)
                                        .type(1).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder()
                                        .startTime(switchTime)
                                        .endTime(innerAreaEnterTime)
                                        .type(2).build();
                                list.add(parkTimeCompose2);
                                ParkTimeCompose parkTimeCompose3 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose3);
                            } else if (switchTime < innerAreaExitTime) {
                                //在后一个月卡切换
                                //在入小场后出小场前切换
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(innerAreaEnterTime)
                                        .type(1).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose3 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose3);
                            } else if (switchTime < endTime) {
                                //在后一个月卡切换
                                //在出小场后切换
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(innerAreaEnterTime)
                                        .type(1).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(switchTime)
                                        .type(1).build();
                                list.add(parkTimeCompose2);
                                ParkTimeCompose parkTimeCompose3 = ParkTimeCompose.builder()
                                        .startTime(switchTime)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose3);
                            }
                        }
                        //在出小场后出大场前发生了过期和续费
                        if (secondPartStart > innerAreaExitTime && secondPartStart < endTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 > innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < endTime) {
                            //在前一个月卡切换
                            //在入小场前切换
                            if (switchTime < innerAreaEnterTime) {
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(switchTime)
                                        .type(1).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder()
                                        .startTime(switchTime)
                                        .endTime(innerAreaEnterTime)
                                        .type(2).build();
                                list.add(parkTimeCompose2);
                                ParkTimeCompose parkTimeCompose3 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(parkTimeCompose3);
                                ParkTimeCompose parkTimeCompose4 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(secondPartStart)
                                        .type(1).build();
                                list.add(parkTimeCompose4);
                                ParkTimeCompose parkTimeCompose5 = ParkTimeCompose.builder()
                                        .startTime(secondPartStart)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose5);
                            } else if (switchTime < innerAreaExitTime) {
                                //在入小场后出小场前切换
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(innerAreaEnterTime)
                                        .type(1).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose3 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(parkTimeCompose3);
                                ParkTimeCompose parkTimeCompose4 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(secondPartStart)
                                        .type(1).build();
                                list.add(parkTimeCompose4);
                                ParkTimeCompose parkTimeCompose5 = ParkTimeCompose.builder()
                                        .startTime(secondPartStart)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose5);
                            } else if (switchTime < completeConvert(timeoutMonthInfo.getEndTime()) + 1) {
                                //在过期月卡过期前切换
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(innerAreaEnterTime)
                                        .type(1).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(switchTime)
                                        .type(1).build();
                                list.add(parkTimeCompose2);
                                ParkTimeCompose parkTimeCompose4 = ParkTimeCompose.builder()
                                        .startTime(switchTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(parkTimeCompose4);
                                ParkTimeCompose parkTimeCompose6 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(secondPartStart)
                                        .type(1).build();
                                list.add(parkTimeCompose6);
                                ParkTimeCompose parkTimeCompose5 = ParkTimeCompose.builder()
                                        .startTime(secondPartStart)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose5);
                            } else if (switchTime < endTime) {
                                //在后一个月卡，出大场前切换
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(innerAreaEnterTime)
                                        .type(2).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(parkTimeCompose2);
                                ParkTimeCompose parkTimeCompose6 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(secondPartStart)
                                        .type(1).build();
                                list.add(parkTimeCompose6);
                                ParkTimeCompose parkTimeCompose5 = ParkTimeCompose.builder()
                                        .startTime(secondPartStart)
                                        .endTime(switchTime)
                                        .type(1).build();
                                list.add(parkTimeCompose5);
                                ParkTimeCompose parkTimeCompose7 = ParkTimeCompose.builder()
                                        .startTime(switchTime)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose7);
                            }
                        }
                        //过期发生在入小场前，续费发生在入小场后 出小场前
                        if (secondPartStart > innerAreaEnterTime && secondPartStart < innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < innerAreaEnterTime) {
                            //在前一个月卡切换
                            //在入小场前切换
                            if (switchTime < completeConvert(timeoutMonthInfo.getEndTime()) + 1) {
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(switchTime)
                                        .type(1).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder()
                                        .startTime(switchTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(parkTimeCompose2);
                                ParkTimeCompose parkTimeCompose3 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(innerAreaEnterTime)
                                        .type(1).build();
                                list.add(parkTimeCompose3);
                                ParkTimeCompose parkTimeCompose5 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose5);
                            } else if (switchTime < innerAreaExitTime) {
                                //在入小场后出小场前切换
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose3 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(innerAreaEnterTime)
                                        .type(1).build();
                                list.add(parkTimeCompose3);
                                ParkTimeCompose parkTimeCompose5 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose5);
                            } else if (switchTime < endTime) {
                                //在出大场前切换
                                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                                        .startTime(startTime)
                                        .endTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .type(2).build();
                                list.add(parkTimeCompose);
                                ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder()
                                        .startTime(completeConvert(timeoutMonthInfo.getEndTime()) + 1)
                                        .endTime(innerAreaEnterTime)
                                        .type(1).build();
                                list.add(parkTimeCompose2);
                                ParkTimeCompose parkTimeCompose4 = ParkTimeCompose.builder()
                                        .startTime(innerAreaExitTime)
                                        .endTime(switchTime)
                                        .type(1).build();
                                list.add(parkTimeCompose4);
                                ParkTimeCompose parkTimeCompose5 = ParkTimeCompose.builder()
                                        .startTime(switchTime)
                                        .endTime(endTime)
                                        .type(2).build();
                                list.add(parkTimeCompose5);
                            }
                        }
                        //过期发生在入小场前，续费发生在出小场后
                        if (secondPartStart > innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < innerAreaEnterTime) {
                            //在入小场前切换
                            if (switchTime < completeConvert(timeoutMonthInfo.getEndTime()) + 1) {

                            } else if (switchTime < endTime) {
                                //在出大场前切换

                            }
                        }
                        //过期发生在入小场后，续费发生在出小场后
                        if (secondPartStart > innerAreaExitTime
                                && completeConvert(timeoutMonthInfo.getEndTime()) + 1 < innerAreaEnterTime) {
                            //在入小场前切换
                            if (switchTime < innerAreaEnterTime) {

                            } else if (switchTime < completeConvert(timeoutMonthInfo.getEndTime()) + 1) {
                                //在过期前切换

                            } else if (switchTime < endTime) {
                                //在出大场前切换

                            }
                        }
                    } else {
                        twoPartMonthCar(startTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
                    }
                    break;
                case TIMEOUT_IN_PARK:
                    MonthInfo timedOutMonthInfo = monthTypeDto.getTimedOutMonthInfo();
                    //前面停车部分按月卡收费
                    //在入小场前发生了过期
                    if (completeConvert(timedOutMonthInfo.getEndTime()) + 1 < innerAreaEnterTime) {

                    }
                    //在入小场后出小场前发生了过期
                    if (completeConvert(timedOutMonthInfo.getEndTime()) + 1 > innerAreaEnterTime
                            && completeConvert(timedOutMonthInfo.getEndTime()) + 1 < innerAreaExitTime) {

                    }
                    //在出小场后出大场前发生了过期
                    if (completeConvert(timedOutMonthInfo.getEndTime()) + 1 > innerAreaExitTime
                            && completeConvert(timedOutMonthInfo.getEndTime()) + 1 < endTime) {

                    }
                    break;
                default:
                    break;
            }
        }
        //临时车总停车时长
        long tempCarParkTimeSum = list.stream().filter(ptc -> ptc.getType() == 1).mapToLong(ptc -> ptc.getEndTime() - ptc.getStartTime()).sum();
        if (tempCarParkTimeSum > 0) {
            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                    .startTime(startTime)
                    .endTime(startTime + tempCarParkTimeSum).build();
            feeParamHolder.addExtraFeePara(feePara);
        }

        boolean isMonthRet = false;
        //月卡车总停车时长
        List<ParkTimeCompose> monthCarParkTimeList = list.stream().filter(ptc -> ptc.getType() == 2).collect(Collectors.toList());
        for (int i = 0; i < monthCarParkTimeList.size(); i++) {
            boolean thisIsMonthRet = false;
            ParkTimeCompose parkTimeCompose = list.get(i);
            //工作日全天月卡
            if (Integer.valueOf(1).equals(monthTypeDto.getCardType())) {
                //切换时间后的时长按月卡，需要区分工作日和非工作日
                ParkTimeDetail parkTimeDetail = getParkTimeDetail(parkTimeCompose.getStartTime(), parkTimeCompose.getEndTime());
                int parkTimeType = parkTimeDetail.getType();
                //因为全天月卡，隐含工作日免费，只在工作日停车或者非工作日停车配置免费时
                if (parkTimeType == 1 || NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 1) {
                    //每次循环都是月卡时，则直接返回
                    if (!isMonthRet) {
                        isMonthRet = true;
                    }
                    thisIsMonthRet = true;
                }
                //因为全天月卡，隐含工作日免费，只在工作日停车或者非工作日停车配置免费时
                if ((parkTimeType == 2 || parkTimeType == 3)
                        && NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 2) {
                    BaseFeeParamHolder.ExtraComputeFeePara feePara2 = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                            .startTime(parkTimeDetail.getNotWorkDayStartTime())
                            .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                    feeParamHolder.addExtraFeePara(feePara2);
                }
            } else {
                //错时月卡
                MonthProduct monthProduct = monthTypeDto.getCurrMonthProduct();
                if (monthProduct == null) {
                    monthProduct = monthTypeDto.getTimedOutMonthProduct();
                }
                addCsWorkDayAndNotFeePara(feeParamHolder, parkTimeCompose.getStartTime(), parkTimeCompose.getEndTime(), monthTypeDto, monthProduct);
            }
            isMonthRet = isMonthRet && thisIsMonthRet;
        }
        if (tempCarParkTimeSum == 0 && isMonthRet) {
            return MonthFeeDto.builder().isMonthRet(true).monthInfo(monthInfoRet).build();
        }
        return MonthFeeDto.builder()
                .isMonthRet(false)
                .newStartTime(newStartTime)
                .newEndTime(newEndTime)
                .csFeeType(csFeeType)
                .isCsMonthCarFee(isCsMonthCarFee)
                .csStartTime(csStartTime)
                .csEndTime(csEndTime)
                .csSwitchTime(csSwitchTime)
                .monthInfo(monthInfoRet).build();
    }

    private void twoPartMonthCar(long startTime, long endTime, Long innerAreaEnterTime, Long innerAreaExitTime, List<ParkTimeCompose> list) {
        ParkTimeCompose monthCarParkTime = ParkTimeCompose.builder()
                .startTime(startTime)
                .endTime(innerAreaEnterTime)
                .type(2).build();
        list.add(monthCarParkTime);
        ParkTimeCompose monthCarParkTime2 = ParkTimeCompose.builder()
                .startTime(innerAreaExitTime)
                .endTime(endTime)
                .type(2).build();
        list.add(monthCarParkTime2);
    }

    private void handleParkTimeComposeWithSwitchTime(long startTime, long endTime, long innerAreaEnterTime, long innerAreaExitTime,
                                       long switchTime, List<ParkTimeCompose> list) {
        if (switchTime > innerAreaEnterTime && switchTime < innerAreaExitTime) {
            ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                    .startTime(startTime)
                    .endTime(innerAreaEnterTime)
                    .type(1).build();
            list.add(parkTimeCompose);
            ParkTimeCompose parkTimeCompose2 = ParkTimeCompose.builder()
                    .startTime(innerAreaExitTime)
                    .endTime(endTime)
                    .type(2).build();
            list.add(parkTimeCompose2);
        } else {
            //前半部分计费
            if (switchTime > startTime && switchTime < innerAreaEnterTime) {
                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                        .startTime(startTime)
                        .endTime(switchTime)
                        .type(1).build();
                list.add(parkTimeCompose);
                twoPartMonthCar(switchTime, endTime, innerAreaEnterTime, innerAreaExitTime, list);
            }
            //后半部分计费
            if (switchTime > innerAreaExitTime && switchTime < endTime) {
                //入大场到入小场时间 + 出小场时间到切换时间
                ParkTimeCompose parkTimeCompose = ParkTimeCompose.builder()
                        .startTime(startTime)
                        .endTime(innerAreaEnterTime + (switchTime - innerAreaExitTime))
                        .type(1).build();
                list.add(parkTimeCompose);
                ParkTimeCompose monthCarParkTime2 = ParkTimeCompose.builder()
                        .startTime(switchTime)
                        .endTime(endTime)
                        .type(2).build();
                list.add(monthCarParkTime2);
            }
        }
    }

    private ParkTimeDetail getParkTimeDetail(long startTime, long endTime, Long innerAreaEnterTime, Long innerAreaExitTime) {
        //切换时间在后半段
        if (startTime >= innerAreaExitTime) {
            return getParkTimeDetail(startTime, endTime);
        }
        ParkTimeDetail parkTimeDetail = new ParkTimeDetail();
        LocalDateTime startDateTime = LocalDateTime.ofEpochSecond(startTime, 0, ZoneOffset.ofHours(8));
        LocalDateTime endDateTime = LocalDateTime.ofEpochSecond(endTime, 0, ZoneOffset.ofHours(8));
        LocalDateTime innerAreaStartDateTime = LocalDateTime.ofEpochSecond(innerAreaEnterTime, 0, ZoneOffset.ofHours(8));
        LocalDateTime innerAreaEndDateTime = LocalDateTime.ofEpochSecond(innerAreaExitTime, 0, ZoneOffset.ofHours(8));
        List<String> notDays = notWorkDayService.queryNotDays(startDateTime.getYear());
        //跨年时也要查结束时间年的非工作日
        if (startDateTime.getYear() != endDateTime.getYear()) {
            notDays.addAll(notWorkDayService.queryNotDays(endDateTime.getYear()));
        }
        boolean hasNotWorkDay = false;
        boolean hasWorkDay = false;
        //工作日停车时长累加
        long notWorkDayParkTime = 0L;
        //循环遍历每一天，拆分工作日和非工作日的停车时长
        while (startDateTime.compareTo(innerAreaStartDateTime) <= 0) {
            long currStartTime = startDateTime.toEpochSecond(ZoneOffset.ofHours(8));
            //当前天的停车结束时间
            LocalDateTime currDayEndDateTime = startDateTime.plusDays(1).withHour(0).withMinute(0).withSecond(0);
            if (currDayEndDateTime.compareTo(innerAreaStartDateTime) > 0) {
                currDayEndDateTime = innerAreaStartDateTime;
            }
            if (currDayEndDateTime.compareTo(innerAreaStartDateTime) > 0) {
                currDayEndDateTime = innerAreaStartDateTime;
            }
            if (notDays.contains(startDateTime.format(FORMATTER))) {
                //非工作日
                if (!hasNotWorkDay) {
                    parkTimeDetail.setNotWorkDayStartTime(currStartTime);
                }
                notWorkDayParkTime += currDayEndDateTime.toEpochSecond(ZoneOffset.ofHours(8)) - startDateTime.toEpochSecond(ZoneOffset.ofHours(8));
                hasNotWorkDay = true;
            } else {
                //工作日
                if (!hasWorkDay) {
                    parkTimeDetail.setWorkDayStartTime(currStartTime);
                }
                hasWorkDay = true;
            }
            startDateTime = startDateTime.plusDays(1).withHour(0).withMinute(0).withSecond(0);
        }
        //循环遍历每一天，拆分工作日和非工作日的停车时长
        while (innerAreaEndDateTime.compareTo(endDateTime) <= 0) {
            long currStartTime = innerAreaEndDateTime.toEpochSecond(ZoneOffset.ofHours(8));
            //当前天的停车结束时间
            LocalDateTime currDayEndDateTime = innerAreaEndDateTime.plusDays(1).withHour(0).withMinute(0).withSecond(0);
            if (currDayEndDateTime.compareTo(endDateTime) > 0) {
                currDayEndDateTime = endDateTime;
            }
            if (currDayEndDateTime.compareTo(endDateTime) > 0) {
                currDayEndDateTime = endDateTime;
            }
            if (notDays.contains(innerAreaEndDateTime.format(FORMATTER))) {
                //非工作日
                if (!hasNotWorkDay) {
                    parkTimeDetail.setNotWorkDayStartTime(currStartTime);
                }
                notWorkDayParkTime += currDayEndDateTime.toEpochSecond(ZoneOffset.ofHours(8)) - innerAreaEndDateTime.toEpochSecond(ZoneOffset.ofHours(8));
                hasNotWorkDay = true;
            } else {
                //工作日
                if (!hasWorkDay) {
                    parkTimeDetail.setWorkDayStartTime(currStartTime);
                }
                hasWorkDay = true;
            }
            innerAreaEndDateTime = innerAreaEndDateTime.plusDays(1).withHour(0).withMinute(0).withSecond(0);
        }
        if (hasWorkDay && hasNotWorkDay) {
            parkTimeDetail.setType(3);
        } else {
            if (hasWorkDay) {
                parkTimeDetail.setType(1);
            }
            if (hasNotWorkDay) {
                parkTimeDetail.setType(2);
            }
        }
        parkTimeDetail.setNotWorkDayParkTime(notWorkDayParkTime);
        parkTimeDetail.setWorkDayParkTime((innerAreaEnterTime - startTime) + (endTime - innerAreaExitTime) - notWorkDayParkTime);
        log.info("外区工作日非工作日情况:{}", parkTimeDetail);
        return parkTimeDetail;
    }

    /**
     * 错时月卡工作日非工作日计费参数设置
     * @param feeParamHolder 参数
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param monthTypeDto 参数
     * @param monthProduct 套餐信息
     */
    private boolean addCsWorkDayAndNotFeePara(BaseFeeParamHolder feeParamHolder, long startTime, long endTime,
                                           MonthTypeDto monthTypeDto, MonthProduct monthProduct) {
        ParkTimeDetail parkTimeDetail = getParkTimeDetail(startTime, endTime);
        if (NumberUtils.toPrimitive(monthTypeDto.getNotWorkdayCharge()) == 1) {
            if (parkTimeDetail.getType() == 2) {
                return true;
            }
            //工作日收费
            BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                    .startTime(parkTimeDetail.getWorkDayStartTime())
                    .endTime(parkTimeDetail.getWorkDayStartTime() + parkTimeDetail.getWorkDayParkTime())
                    .isCsMonthCarFee(true)
                    .csStartTime(monthProduct.getStartTime().toString())
                    .csEndTime(monthProduct.getEndTime().toString()).build();
            feeParamHolder.addExtraFeePara(feePara);
        } else {
            //工作日收费
            if (parkTimeDetail.getType() == 1 || parkTimeDetail.getType() == 3) {
                BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .startTime(parkTimeDetail.getWorkDayStartTime())
                        .endTime(parkTimeDetail.getWorkDayStartTime() + parkTimeDetail.getWorkDayParkTime())
                        .isCsMonthCarFee(true)
                        .csStartTime(monthProduct.getStartTime().toString())
                        .csEndTime(monthProduct.getEndTime().toString()).build();
                feeParamHolder.addExtraFeePara(feePara);
            }
            //非工作日收费
            if (parkTimeDetail.getType() == 2 || parkTimeDetail.getType() == 3) {
                BaseFeeParamHolder.ExtraComputeFeePara feePara = BaseFeeParamHolder.ExtraComputeFeePara.builder()
                        .startTime(parkTimeDetail.getNotWorkDayStartTime())
                        .endTime(parkTimeDetail.getNotWorkDayStartTime() + parkTimeDetail.getNotWorkDayParkTime()).build();
                feeParamHolder.addExtraFeePara(feePara);
            }
        }
        return false;
    }

    /**
     * 判断月卡类型
     * @param parkId 车场ID
     * @param orderInfo 订单信息
     * @param startTime 计费开始时间
     * @param endTime 计费结束时间
     * @param parkConfig 高级配置
     * @param multipleAreaType 多区域类型，0：非场中场，1：外区域，2：内区域
     * @return 月卡类型
     */
    public MonthTypeDto getMonthTypeDto(Long parkId, OrderInfo orderInfo, long startTime, long endTime,
                                        ParkConfig parkConfig, Long regionId, Integer multipleAreaType) {
        MonthTypeDto monthTypeDto = new MonthTypeDto();
        MonthInfo monthInfo = monthCarService.findMonthInfo(parkId, orderInfo.getPlateNum(), regionId, MonthCarServiceBase.VALID_CARD);
        if (monthInfo != null) {
            MonthProduct monthProduct = monthProductDao.selectById(monthInfo.getProductId());
            monthTypeDto.setCurrMonthInfo(monthInfo);
            monthTypeDto.setCurrMonthProduct(monthProduct);
            monthTypeDto.setCardType(monthProduct.getCardType());
            monthTypeDto.setDiffWorkday(monthProduct.getDiffWorkday());
            monthTypeDto.setNotWorkdayCharge(monthProduct.getNotWorkdayCharge());

            Date validateStartTime = monthInfo.getStartTime();
            Date validateEndTime = monthInfo.getEndTime();
            boolean fullMonthCard = isFullMonthCard(startTime, endTime, validateStartTime, validateEndTime);
            if (fullMonthCard) {
                monthTypeDto.setMonthTypeEnum(MonthTypeEnum.FULL_MONTH);
            } else if (isInParkStart(startTime, endTime, monthInfo)){
                //当前月卡生效时间大于入场时间 或 结束时间小于离场时间(不成立)，查询上个过期月卡
                MonthInfo timeoutMonthInfo = monthCarService.findMonthInfo(parkId, orderInfo.getPlateNum(), regionId, TIMEOUT_CARD);
                if (timeoutMonthInfo != null) {
                    if (isTimeOutInPark(startTime, endTime, timeoutMonthInfo)) {
                        int days = DateTools.differentDays(timeoutMonthInfo.getEndTime(), monthInfo.getStartTime());
                        if (days <= 1) {
                            monthTypeDto.setMonthTypeEnum(MonthTypeEnum.FULL_MONTH);
                            log.info("连续续费, 全部时长为月卡, 车牌号[{}]", orderInfo.getPlateNum());
                        } else {
                            monthTypeDto.setMonthTypeEnum(MonthTypeEnum.TEMP_MIDDLE);
                            monthTypeDto.setTimedOutMonthInfo(timeoutMonthInfo);
                            MonthProduct timedOutMonthProduct = monthProductDao.selectById(timeoutMonthInfo.getProductId());
                            monthTypeDto.setTimedOutMonthProduct(timedOutMonthProduct);
                        }
                    } else {
                        monthTypeDto.setMonthTypeEnum(MonthTypeEnum.IN_PARK_START);
                    }
                } else {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.IN_PARK_START);
                }
            } else {
                log.warn("理论上不会存在此情况, month[{}], orderInfo[{}]", monthInfo, orderInfo);
            }
        } else {
            monthInfo = monthCarService.findMonthInfo(parkId, orderInfo.getPlateNum(), regionId, TIMEOUT_CARD);
            if (monthInfo == null) {
                return monthTypeDto;
            }
            monthTypeDto.setTimedOutMonthInfo(monthInfo);
            MonthProduct monthProduct = monthProductDao.selectById(monthInfo.getProductId());
            monthTypeDto.setTimedOutMonthProduct(monthProduct);
            monthTypeDto.setCardType(monthProduct.getCardType());
            //优先判断过期卡按月卡车处理
            expireMonthCard(parkConfig, monthTypeDto, monthInfo, monthProduct);
            if(isInParkStartAndTimeOut(startTime, endTime, monthInfo)) {
                if (MonthTypeEnum.FULL_MONTH.equals(monthTypeDto.getMonthTypeEnum())) {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.IN_PARK_START);
                    monthTypeDto.setCurrMonthInfo(monthInfo);
                    monthTypeDto.setCurrMonthProduct(monthTypeDto.getTimedOutMonthProduct());
                } else {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.MONTH_MIDDLE);
                    monthTypeDto.setDiffWorkday(monthProduct.getDiffWorkday());
                    monthTypeDto.setNotWorkdayCharge(monthProduct.getNotWorkdayCharge());

                }
            }
            if (monthTypeDto.getMonthTypeEnum() == null) {
                if (isTimeOutInPark(startTime, endTime, monthInfo)) {
                    //场内过期
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.TIMEOUT_IN_PARK);
                    monthTypeDto.setDiffWorkday(monthProduct.getDiffWorkday());
                    monthTypeDto.setNotWorkdayCharge(monthProduct.getNotWorkdayCharge());
                } else {
                    monthTypeDto.setMonthTypeEnum(MonthTypeEnum.TIMEOUT);
                }
            }
        }

        if (monthTypeDto.getMonthTypeEnum() != null) {
            if (orderInfo.getSwitchTime() != null) {
                monthTypeDto.setAbCard(true);
                monthTypeDto.setAbCarType(2);
            } else {
                //如果车牌个数和车位个数不相等，并且车牌个数小于车位个数时，定义为多位多车
                List<String> plateNumList = monthPlateDao.selectByMonthId(monthInfo.getId());
                boolean abCar = isAbCar(monthInfo.getPlotCount(), plateNumList);
                monthTypeDto.setAbCard(abCar);
                if (abCar) {
                    monthTypeDto.setAbCarType(1);
                    if (PlateTypeEnum.临时车.getType().equals(orderInfo.getType())) {
                        if (MonthTypeEnum.IN_PARK_START.equals(monthTypeDto.getMonthTypeEnum())) {
                            //获取开卡后进场（按月卡处理，因为在场车辆都是临时车）或离场（办卡后第一辆出场的车辆按A车）的订单数量，
                            // 如果超过购买车位数，当前订单就按B车计费
                            int alreadyExitOrders = getAlreadyExitOrders(parkId, regionId, multipleAreaType, monthInfo, plateNumList);
                            if (alreadyExitOrders >= monthInfo.getPlotCount()) {
                                monthTypeDto.setAbCarType(2);
                            }
                        } else {
                            OrderTags orderTags = orderTagsDao.selectByOrderNum(orderInfo.getOrderNum(), 1, regionId);
                            if (orderTags != null) {
                                monthTypeDto.setAbCarType(2);
                            }
                        }
                    }
                }
            }
        }
        return monthTypeDto;
    }

    /**
     * 过期月卡是否按月卡处理
     * @param parkConfig 高级配置
     * @param monthTypeDto 返回对象
     * @param monthInfo 月卡信息
     * @param monthProduct 套餐信息
     */
    private void expireMonthCard(ParkConfig parkConfig, MonthTypeDto monthTypeDto, MonthInfo monthInfo, MonthProduct monthProduct) {
        //根据屏显的过期月卡配置判断是否可以作为月卡车
        Integer expireMcDays = parkConfig.getExpireMcDays();
        //过期卡车辆按月卡车处理,1是0否
        Integer expireMc = parkConfig.getIsExpireMc();
        if (expireMcDays != null && expireMcDays > 0 && expireMc != null && expireMc == 1) {
            //过期天数
            int differentDays = DateTools.differentDays(monthInfo.getEndTime(), new Date());
            if (differentDays <= expireMcDays) {
                monthTypeDto.setMonthTypeEnum(MonthTypeEnum.FULL_MONTH);
                monthTypeDto.setDiffWorkday(monthProduct.getDiffWorkday());
                monthTypeDto.setNotWorkdayCharge(monthProduct.getNotWorkdayCharge());
            }
        }
    }

    public MonthInfo getMonthInfo(Long parkId, String plateNum, Long regionId, ParkConfig parkConfig) {
        //月卡区域
        MonthInfo monthInfo = monthCarService.findMonthInfo(parkId, plateNum, regionId, MonthCarServiceBase.VALID_CARD);
        if (monthInfo != null) {
            return monthInfo;
        } else {
            monthInfo = monthCarService.findMonthInfo(parkId, plateNum, regionId, MonthCarServiceBase.TIMEOUT_CARD);
            if (monthInfo == null) {
                return null;
            }
            //根据屏显的过期月卡配置判断是否可以作为月卡车
            Integer expireMcDays = parkConfig.getExpireMcDays();
            //过期卡车辆按月卡车处理,1是0否
            Integer expireMc = parkConfig.getIsExpireMc();
            if (expireMcDays != null && expireMcDays > 0 && expireMc != null && expireMc == 1) {
                //过期天数
                int differentDays = DateTools.differentDays(monthInfo.getEndTime(), new Date());
                if (differentDays <= expireMcDays) {
                    return monthInfo;
                }
            }
        }
        return null;
    }
    private int getAlreadyExitOrders(Long parkId, Long regionId, Integer multipleAreaType, MonthInfo monthInfo, List<String> plateNumList) {
        if (Integer.valueOf(1).equals(multipleAreaType) || Integer.valueOf(2).equals(multipleAreaType)) {
            List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfo.getId());
            if (CollectionUtils.isNotEmpty(monthRegions)) {
                MonthRegion parkRegion = monthRegions.stream()
                        .filter(mr -> NumberUtils.toPrimitive(mr.getRegionId()) == 0)
                        .findFirst().orElse(null);
                if (parkRegion == null) {
                    int orderSonCount = orderSonInfoDao.countExitRecordsFromStartTime(parkId, plateNumList, regionId,
                            monthInfo.getStartTime().getTime() / 1000);
                    int orderCount = orderInfoDao.countMultipleAreaExitRecordsFromStartTime(parkId, plateNumList, regionId,
                            monthInfo.getStartTime().getTime() / 1000);
                    return orderCount + orderSonCount;
                }
            }
        }
        return orderInfoDao.countExitRecordsFromStartTime(parkId, monthInfo.getStartTime().getTime() / 1000, plateNumList);
    }

    public boolean isTimeOutInPark(Long startTime, Long endTime, MonthInfo monthInfo) {
        return monthInfo.getStartTime().getTime() / 1000 <= startTime
                && completeConvert(monthInfo.getEndTime()) > startTime
                && completeConvert(monthInfo.getEndTime()) < endTime;
    }

    /**
     * 场内办卡并且场内过期
     */
    public boolean isInParkStartAndTimeOut(Long startTime, Long endTime, MonthInfo monthInfo) {
        boolean inParkStart = isInParkStart(startTime, endTime, monthInfo);
        boolean timeOutInPark = completeConvert(monthInfo.getEndTime()) > startTime
                && completeConvert(monthInfo.getEndTime()) < endTime;
        return inParkStart && timeOutInPark;
    }

    /**
     * 场内生效月卡
     * @param startTime 入场时间
     * @param endTime 离场时间
     * @param monthInfo 月卡信息
     * @return 场内生效月卡
     */
    public boolean isInParkStart(Long startTime, Long endTime, MonthInfo monthInfo) {
        return monthInfo.getStartTime().getTime() / 1000 > startTime
                && monthInfo.getStartTime().getTime() / 1000 <= endTime;
    }

    /**
     * 场内生效月卡
     * @param startTime 入场时间
     * @param endTime 离场时间
     * @param validateStartTime 生效月卡开始时间
     * @param validateEndTime 生效月卡结束时间
     * @return 有效期内进出场
     */
    public boolean isFullMonthCard(Long startTime, Long endTime, Date validateStartTime, Date validateEndTime) {
        if (startTime == null || endTime == null || validateStartTime == null || validateEndTime == null) {
            return false;
        }
        long validateEndTimeLong = validateEndTime.getTime() / 1000 + (24 * 3600) - 1;
        return validateStartTime.getTime() / 1000 <= startTime
                && validateEndTimeLong >= endTime;
    }

    /**
     * 判断是否AB车
     *
     * @param plotCount 车位个数
     * @param plateNumList 车牌列表
     * @return AB车
     */
    private boolean isAbCar(int plotCount, List<String> plateNumList) {
        int plateCount = plateNumList.size();
        //如果车牌个数和车位个数不相等，并且车牌个数大于车位个数时，定义为多位多车
        return plateCount > plotCount;
    }

    private long completeConvert(Date date) {
        if (date == null) {
            return 0;
        }
        return date.getTime() / 1000 + (24 * 3600) - 1;
    }

    @Getter
    @Setter
    @ToString
    public static class ParkTimeDetail {
        /**
         * 停车时长的工作日类型，1：只包含工作日，2：只包含非工作日，3：既包含工作日又包含非工作日
         */
        private int type;
        /**
         * 工作日开始时间
         */
        private Long workDayStartTime;
        /**
         * 工作日停车时长
         */
        private Long workDayParkTime;
        /**
         * 非工作日开始时间
         */
        private Long notWorkDayStartTime;
        /**
         * 非工作日停车时长
         */
        private Long notWorkDayParkTime;
    }
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.of("+8"));

    /**
     * 分析停车时长包含工作日非工作日的情况
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return 停车时长包含工作日非工作日的情况
     */
    private ParkTimeDetail getParkTimeDetail(long startTime, long endTime) {
        ParkTimeDetail parkTimeDetail = new ParkTimeDetail();
        LocalDateTime startDateTime = LocalDateTime.ofEpochSecond(startTime, 0, ZoneOffset.ofHours(8));
        LocalDateTime endDateTime = LocalDateTime.ofEpochSecond(endTime, 0, ZoneOffset.ofHours(8));
        List<String> notDays = notWorkDayService.queryNotDays(startDateTime.getYear());
        //跨年时也要查结束时间年的非工作日
        if (startDateTime.getYear() != endDateTime.getYear()) {
            notDays.addAll(notWorkDayService.queryNotDays(endDateTime.getYear()));
        }
        boolean hasNotWorkDay = false;
        boolean hasWorkDay = false;
        //工作日停车时长累加
        long notWorkDayParkTime = 0L;
        //循环遍历每一天，拆分工作日和非工作日的停车时长
        while (startDateTime.compareTo(endDateTime) <= 0) {
            long currStartTime = startDateTime.toEpochSecond(ZoneOffset.ofHours(8));
            //当前天的停车结束时间
            LocalDateTime currDayEndDateTime = startDateTime.plusDays(1).withHour(0).withMinute(0).withSecond(0);
            if (currDayEndDateTime.compareTo(endDateTime) > 0) {
                currDayEndDateTime = endDateTime;
            }
            if (currDayEndDateTime.compareTo(endDateTime) > 0) {
                currDayEndDateTime = endDateTime;
            }
            if (notDays.contains(startDateTime.format(FORMATTER))) {
                //非工作日
                if (!hasNotWorkDay) {
                    parkTimeDetail.setNotWorkDayStartTime(currStartTime);
                }
                notWorkDayParkTime += currDayEndDateTime.toEpochSecond(ZoneOffset.ofHours(8)) - startDateTime.toEpochSecond(ZoneOffset.ofHours(8));
                hasNotWorkDay = true;
            } else {
                //工作日
                if (!hasWorkDay) {
                    parkTimeDetail.setWorkDayStartTime(currStartTime);
                }
                hasWorkDay = true;
            }
            startDateTime = startDateTime.plusDays(1).withHour(0).withMinute(0).withSecond(0);
        }
        if (hasWorkDay && hasNotWorkDay) {
            parkTimeDetail.setType(3);
        } else {
            if (hasWorkDay) {
                parkTimeDetail.setType(1);
            }
            if (hasNotWorkDay) {
                parkTimeDetail.setType(2);
            }
        }
        parkTimeDetail.setNotWorkDayParkTime(notWorkDayParkTime);
        parkTimeDetail.setWorkDayParkTime(endTime - startTime - notWorkDayParkTime);
        log.info("工作日非工作日情况:{}", parkTimeDetail);
        return parkTimeDetail;
    }

    /**
     * 停车时间构成
     */
    @Setter
    @Getter
    @ToString
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ParkTimeCompose {
        /**
         * 停车时间段车辆类型，1 临时车，2 月卡车
         */
        private int type;
        /**
         * 当前车辆类型的开始时间
         */
        private long startTime;
        /**
         * 当前车辆类型的结束时间
         */
        private long endTime;
    }

}
