package com.icetech.park.service.parkvip.impl;

import com.icetech.park.dao.parkvip.VipProductRuleMapper;
import com.icetech.cloudcenter.domain.parkvip.VipProductRule;
import com.icetech.park.service.parkvip.VipProductRuleService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 会员套餐规则 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Service
public class VipProductRuleServiceImpl extends BaseServiceImpl<VipProductRuleMapper, VipProductRule> implements VipProductRuleService {

    /**
     * Description: 根据ID查询 会员套餐规则对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return VipProductRule
     */
    @Override
    public VipProductRule getVipProductRuleById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  会员套餐规则对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addVipProductRule (VipProductRule entity) {
        return save(entity);
    }

    /**
     * Description: 修改 会员套餐规则对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyVipProductRule (VipProductRule entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  会员套餐规则对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeVipProductRuleById (Long id) {
        return removeById(id);
    }

}
